/*
 * search.java
 *
 * Simple command line program to search the lucene index.
 * Run like: java -classpath $CLASSPATH:<path-to-gberg>/java Search <index directory>
 * where the index directory is the index/idx folder.
 *
 * Copyright 2003 The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


import java.io.IOException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.File;

//import org.apache.lucene.analysis.Analyzer;
//import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
//import org.apache.lucene.search.Hits;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.Version;

public class Search  {

    public static void main (String args[]) {
	
	if (args.length == 0) {
	    System.out.println("Usage: Search <index directory>");
	    return;
	}
        try {

	  Directory indexdir_dir = FSDirectory.open(new File(args[0]));
	  IndexReader reader = DirectoryReader.open(indexdir_dir);
	  IndexSearcher searcher = new IndexSearcher(reader);

	  BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
	  System.out.println("Type .q to quit");
	  while (true) {
	    System.out.print("Query: ");
	    String line = in.readLine();
	    line.trim();
	    if (line.equals(".q"))
	      break;
		
	    Term term = new Term("content",line);
		
	    Query query = new TermQuery(term);
	    System.out.println("Searching for: " + query.toString("content"));
	    final int HITS_PER_PAGE=10;
		
	    TopDocs hits = searcher.search(query, Integer.MAX_VALUE);
	    System.out.println(hits.totalHits + " total matching documents");
	    for (int start = 0; start < hits.totalHits; start += HITS_PER_PAGE) {
		  
	      int end = Math.min(hits.totalHits, start + HITS_PER_PAGE);
	      for (int i = start; i < end; i++) {
		int docnum = hits.scoreDocs[i].doc;
		Document doc = reader.document(docnum);
		String node_id = doc.get("nodeID");
		System.out.println(i + ". ID: "+node_id);
	      }
	      if (hits.totalHits > end) {
		System.out.print("more (y/n) ? ");
		line = in.readLine();
		if (line.length() == 0 || line.charAt(0) == 'n')
		  break;
	      }
	    }
		
	  }
	    
	  reader.close();
	}
	catch (Exception e) {
	  System.out.println(" caught a " + e.getClass() +
			     "\n with message: " + e.getMessage());
        }
    }
}
