<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:xslt="http://www.w3.org/1999/XSL/Transform" 
  xmlns:gslib="http://www.greenstone.org/XSL/Library" 
  xmlns:gsf="http://www.greenstone.org/greenstone3/schema/ConfigFormat" 
  xmlns:util="http://org.greenstone.gsdl3.util.XSLTUtil" 
  xmlns:gs3="http://www.greenstone.org/gs3"
  xmlns:xlink="http://www.w3.org/1999/xlink" 
  xmlns:gsvar="http://www.greenstone.org/skinning-var"
   exclude-result-prefixes="util xalan gslib gsf xslt gs3 gsvar xlink">
<!-- all namespaces used by greenstone should be defined here and listed in exclude-result-prefixes, including those in core/transform/preProcess.xsl, otherwise xmlns attributes will be included in the html output -->

  <!-- force lower priority on xsl:output, so other files like rss.xsl can override with their own xsl:output stmt 
    If other files don't specify any, gslib.xsl specifies html output as default and defines a loose DOCTYPE for it. -->
  <xsl:import href="html-output.xsl" />
	
  <!-- some global parameters - these are set by whoever is invoking the transformation
       Any servlet init parameters can be accessed by adding a param here-->
  <!-- use these like $param or {$param} -->
  <xsl:param name="interface_name"/>
  <xsl:param name="library_name"/>
  <xsl:param name="webswing_context"/>
  <xsl:param name="servlet_url_prefix"/>
  <xsl:param name="servlet_context"/>
  <xsl:param name="site_name"/>
  <xsl:param name="use_client_side_xslt"/>
  <xsl:param name="filepath"/>
  <xsl:param name="google_tracking_id"/>
  <xsl:param name="googlesignin_client_id"/>
  <xsl:param name="googlemaps_api_key"/>
  <xsl:param name="favouritebasket"/>
  <xsl:param name="documentbasket"/>
  <xsl:param name="webglilink"/>
  <xsl:param name="cookie_path"/>

  <!-- variables. use these like $variable or {$variable} -->
  <xsl:variable name="unselected_favourite_icon_url"><gsf:interfaceText name="favourite_star_image"/></xsl:variable>
  <xsl:variable name="selected_favourite_icon_url"><gsf:interfaceText name="favourite_star_selected_image"/></xsl:variable>

  <xsl:variable name="collections" select="/page/pageResponse/collectionList/collection"/>
  
  <xsl:variable name="favouriteBasketOn" select="$favouritebasket = 'true' and /page/pageRequest/paramList/param[@name='favouritebasket' and @value='on']"/>
  <xsl:variable name="documentBasketOn" select="$documentbasket = 'true' and /page/pageRequest/paramList/param[@name='documentbasket' and @value='on']"/>
  
  <xsl:variable name="thisCollectionEditor">
    <xsl:value-of select="/page/pageRequest/paramList/param[@name = 'c']/@value"/>
    <xsl:text>-collection-editor</xsl:text>
  </xsl:variable>

  <xsl:variable name="collName" select="/page/pageRequest/paramList/param[@name='c']/@value"/>
  
  <!-- If the c parameter is empty then use the p.c parameter for the collection name-->
  <xsl:variable name="collNameChecked">
    <xsl:choose>
      <xsl:when test="$collName = '' and /page/pageRequest/paramList/param[@name='p.c']/@value">
	<xsl:value-of select="/page/pageRequest/paramList/param[@name='p.c']/@value"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="$collName"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="httpPath" select="/page/pageResponse/collection/metadataList/metadata[@name='httpPath']"/>
  <xsl:variable name="httpCollection" select="$httpPath"/>
  <xsl:variable name="this-element" select="/page/pageResponse/collection|/page/pageResponse/serviceCluster"/>
  <xsl:variable name="this-service" select="/page/pageRequest/paramList/param[@name = 's']/@value"/>

  <xsl:variable name="_httpcollection_" select="$httpPath"/>
  <xsl:variable name="_httpbrowse_"><xsl:value-of select="$library_name"/>/collection/<xsl:value-of select="$collName"/>/browse</xsl:variable>
  <xsl:variable name="_httpquery_"><xsl:value-of select="$library_name"/>/collection/<xsl:value-of select="$collName"/>/search</xsl:variable>


  
  <!-- every pages ....................................................................... -->

  <xsl:template name="siteName">
    <xsl:value-of select="/page/pageResponse/displayItemList/displayItem[@name='siteName']"/>
  </xsl:template>

  <xsl:template name="siteDescription">
    <xsl:value-of select="/page/pageResponse/displayItemList/displayItem[@name='siteDescription']"/>
  </xsl:template>

  <xsl:template name="siteLink">
    <a href="./{$library_name}">
      <xsl:call-template name="siteName"/>
    </a>
	<xsl:text> </xsl:text>
  </xsl:template>

  <xsl:template name="groupLinks">
    <xsl:variable name="groupPath"><xsl:choose><xsl:when test="/page/pageRequest/paramList/param[@name='group']/@value"><xsl:value-of select="/page/pageRequest/paramList/param[@name='group']/@value"/></xsl:when><xsl:otherwise><xsl:value-of select="/page/pageRequest/paramList/param[@name='p.group']/@value"/></xsl:otherwise></xsl:choose></xsl:variable>
    <xsl:if test="$groupPath != ''">
      <xsl:for-each select="/page/pageResponse/pathList/group">
	<xsl:sort data-type="number" select="@position"/>
	<a>
	  <xsl:attribute name="href"><gslib:groupHref path="{@path}"/></xsl:attribute>				
	  <xsl:attribute name="title"><gslib:groupName path="{@path}"/></xsl:attribute>
	  <gslib:groupName path="{@path}"/>
	</a>
	<gslib:rightArrow/>
      </xsl:for-each>
    </xsl:if>
    
  </xsl:template>
  <xsl:variable name="a">
    <xsl:value-of select="/page/pageRequest/paramList/param[@name='a']/@value"/>
  </xsl:variable>
  

  <!-- template to get the name of the current collection -->
  <xsl:template name="collectionName">
    <xsl:choose>
      <xsl:when test="/page/pageResponse/collection/displayItemList/displayItem[@name='name']">
        <xsl:value-of select="/page/pageResponse/collection/displayItemList/displayItem[@name='name']"/>
      </xsl:when>
      <xsl:when test="/page/pageResponse/collection/@name">
	<xsl:value-of select="/page/pageResponse/collection/@name"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

    <!-- template to get the name of the current collection or 'all collections' if not in a specific collection -->
    <xsl:template name="collectionNameOrAll">
    <xsl:choose>
      <xsl:when test="/page/pageResponse/collection">
        <xsl:value-of select="/page/pageResponse/collection/displayItemList/displayItem[@name='name']"/>
      </xsl:when>
      <xsl:otherwise>All Collections</xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="collectionNameShort">
    <xsl:value-of select="/page/pageResponse/collection/@name"/>
  </xsl:template>
  <xsl:template name="collectionNameLinked">
    <xsl:if test="/page/pageResponse/collection">
      <a>
        <xsl:attribute name="href">./<xsl:value-of select="$library_name"/>/collection/<xsl:call-template name="collectionNameShort"/>/page/about</xsl:attribute>
        <xsl:call-template name="collectionName"/>
      </a>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="collectionMeta">
    <xsl:param name="name"/>
    <xsl:value-of select="/page/pageResponse/collection/metadataList/metadata[@name=$name]"/>
  </xsl:template>

  <!-- text to get the name of the current service ("Browse","Search" etc) -->
  <xsl:template name="serviceName">
    <xsl:value-of select="/page/pageResponse/service/displayItem[@name='name']"/>
  </xsl:template>
  
  <xsl:template name="textDirectionAttribute">
    <xsl:attribute name="dir">
      <xsl:choose>
        <xsl:when test="/page/@lang='ar' or /page/@lang='fa' or /page/@lang='he' or /page/@lang='ur' or /page/@lang='ps' or /page/@lang='prs'">rtl</xsl:when>
        <xsl:otherwise>ltr</xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
  </xsl:template>
  
  <xsl:template name="actionClass">
    <xsl:attribute name="class"><xsl:value-of select="/page/pageRequest/@action"/>Action <xsl:if test="/page/pageRequest/@subaction"><xsl:value-of select="/page/pageRequest/@subaction"/>Subaction</xsl:if></xsl:attribute>
  </xsl:template>
  <!-- username, if logged in -->
  <!--
	<xsl:template name="username">
		<xsl:if test="$un_s!=''">
			<xsl:if test="$asn!='' and $asn!='0'">
			<xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'authen.username')"/>  :  <xsl:value-of select="$un_s"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	-->
  <xsl:template name="defaultDividerBar">
    <xsl:param name="text"/>
    <xsl:choose>
      <xsl:when test="$text">
        <div class="divbar">
          <xsl:value-of select="$text"/>
        </div>
      </xsl:when>
      <xsl:otherwise>
        <div class="divbar">
          <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
        </div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template match="error">
    <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'error')"/><gsf:space/> <xsl:value-of select="."/>
  </xsl:template>
  <xsl:template name="displayErrorsIfAny">
    <xsl:if test="descendant::error">
      <script language="Javascript">
        <xsl:text disable-output-escaping="yes">
	  function removeAllChildren(node) {
	    while (node.hasChildNodes()) {
	      node.removeChild(node.firstChild);
	    }
	  }

	  function toggleHideError(obj) {
	    if (obj.style.display == "none") {
	      obj.style.display = "";
	      hide_link = document.getElementById("hide");
	      removeAllChildren(hide_link);
	      hide_link.appendChild(document.createTextNode("</xsl:text>
        <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'hide_error')"/>
        <xsl:text disable-output-escaping="yes">"));
	    } else {
	      obj.style.display = "none";
	      hide_link = document.getElementById("hide");
	      removeAllChildren(hide_link);
	      hide_link.appendChild(document.createTextNode("</xsl:text>
        <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'show_error')"/>
        <xsl:text disable-output-escaping="yes">"));
	    }
	  }
	</xsl:text>
      </script>
      <p align="right">
        <a id="hide" href="javascript:toggleHideError(error);">
          <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'show_error')"/>
        </a>
      </p>
      <div id="error" style="display: none;">
        <xsl:apply-templates select="descendant::error"/>
      </div>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="noTextBar">
    <xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><!-- could also be expressed &#160; -->
  </xsl:template>
  
  <xsl:template name="poweredByGS3TextBar">
    <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'gs3power')"/>
  </xsl:template>
  
  <xsl:template name="rightArrow">
    <xsl:text disable-output-escaping="yes"> » </xsl:text> <!-- could also be expressed &amp;raquo; or &#187; but prefer literal UTF8 char so it renders correctly if used in title of browser-tab -->
  </xsl:template>

  <!-- site home ....................................................................... -->
  <xsl:template name="siteHomePageTitle">
    <!-- put a space in the title in case the actual value is missing - mozilla will not display a page with no title-->
    <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'gsdl')"/>
    <xsl:text> </xsl:text>
  </xsl:template>
  
  <xsl:template name="selectACollectionTextBar">
    <xsl:choose>
      <xsl:when test="/page/pageResponse/groupList/group and /page/pageResponse/collectionList/collection">
      <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'home.select_a_collection_or_group')"/>
      </xsl:when>
      <xsl:when test="/page/pageResponse/groupList/group">
	<xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'home.select_a_group')"/>
      </xsl:when>
      <xsl:when test="/page/pageResponse/collectionList/collection">
	<xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'home.select_a_collection')"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:choose>
	  <xsl:when test="/page/pageResponse/pathList/group">
	    <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'home.no_collections_group')"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'home.no_collections')"/>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="crossCollectionQuickSearchForm">
    <xsl:apply-templates select="serviceList/service[@name='TextQuery']"/>
  </xsl:template>
  
  <xsl:template match="service[@name='TextQuery']">
    <form name="QuickSearch" method="get" action="{$library_name}">
      <input type="hidden" name="a" value="q"/>
      <input type="hidden" name="rt" value="rd"/>
      <input type="hidden" name="s" value="{@name}"/>
	  <xsl:choose>
		<xsl:when test="/page/pageRequest/paramList/param[@name='group']/@value">
			<input type="hidden" name="s1.group">
				<xsl:attribute name="value">
      				<xsl:value-of select="/page/pageRequest/paramList/param[@name='group']/@value" />
      			</xsl:attribute>
			</input>
		</xsl:when>
		<xsl:otherwise>
			<input type="hidden" name="s1.collection" value="all" />
		</xsl:otherwise>
	  </xsl:choose>
      <input type="text" name="s1.query" size="20"/>
      <input type="submit">
        <xsl:attribute name="value">
          <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'home.quick_search')"/>
        </xsl:attribute>
      </input>
    </form>
  </xsl:template>
  
  <xsl:template name="groupName">
    <xsl:param name="path"/>
    <xsl:variable name="groupElem" select="/page/pageResponse/pathList/group[@path=$path]"/>
    <xsl:choose>
      <xsl:when test="$groupElem/displayItem[@name='name']">
        <xsl:value-of select="$groupElem/displayItem[@name='name']"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$groupElem/title"/>
        </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="groupDescription">
    <xsl:param name="path"/>
    <xsl:value-of select="/page/pageResponse/pathList/group[@path=$path]/description"/>
  </xsl:template>

  <xsl:template name="groupHref">
    <xsl:param name="path"/>
    <xsl:value-of select="$library_name"/>/group/<xsl:value-of select="@path"/>
  </xsl:template>

  <xsl:template name="groupLinkWithImage">
    <xsl:variable name="desc"><xsl:choose><xsl:when test="displayItem[@name='shortDescription']"><xsl:value-of select="displayItem[@name='shortDescription']"/></xsl:when><xsl:otherwise><xsl:value-of select="shortDescription"/></xsl:otherwise></xsl:choose></xsl:variable>
    <xsl:variable name="group_href"><xsl:value-of select="$library_name"/>/group/<xsl:if test="/page/pageRequest/paramList/param[@name='group']"><xsl:value-of select="/page/pageRequest/paramList/param[@name='group']/@value"/>/</xsl:if><xsl:value-of select="@name"/></xsl:variable>
    <xsl:variable name="background_image"><xsl:choose><xsl:when test="displayItem[@name='backgroundImage']"><xsl:value-of select="displayItem[@name='backgroundImage']"/></xsl:when><xsl:otherwise><xsl:value-of select="backgroundImage"/></xsl:otherwise></xsl:choose></xsl:variable>
    <xsl:choose>
      <xsl:when test="util:checkFileExistence($site_name, $background_image)">
        <a href="{$group_href}" title="{$desc}">
          <img class="groupLinkImage">
            <xsl:attribute name="alt"><xsl:value-of select="displayItem[@name='name']"/></xsl:attribute>
            <xsl:attribute name="src">sites/<xsl:value-of select="$site_name"/>/<xsl:value-of select="$background_image"/></xsl:attribute>
          </img>
        </a>
      </xsl:when>
      <xsl:otherwise>
        <a href="{$group_href}" title="{$desc}">
          <div class="groupLink ui-corner-all">
			<div class="groupLinkText ui-widget-content ui-corner-top">
			  <xsl:choose>
                            <xsl:when test="displayItem[@name='name']">
                              <xsl:value-of select="displayItem[@name='name']"/>
                            </xsl:when>
					<xsl:when test="boolean(title)">
						<xsl:value-of select="title"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="@name"/>
					</xsl:otherwise>
				</xsl:choose>
			</div>
			<div style="height:15px;" class="ui-state-default ui-corner-bottom"><xsl:text> </xsl:text></div>
          </div>
        </a>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="collectionLinkWithImage">
    <xsl:variable name="desc"><xsl:value-of select="displayItemList/displayItem[@name='shortDescription']"/></xsl:variable>
    <xsl:variable name="coll_href"><xsl:value-of select="$library_name"/>/collection/<xsl:if test="/page/pageRequest/paramList/param[@name='group']"><xsl:value-of select="/page/pageRequest/paramList/param[@name='group']/@value"/>/</xsl:if><xsl:value-of select="@name"/>/page/about<xsl:choose><xsl:when test="libraryParamList/param">?<xsl:for-each select="libraryParamList/param"><xsl:value-of select="@name"/>=<xsl:value-of select="@default"/>&amp;</xsl:for-each></xsl:when></xsl:choose></xsl:variable>
    <xsl:choose>
      <xsl:when test="displayItemList/displayItem[@name='smallicon']">
        <a href="{$coll_href}" title="{$desc}">
          <img class="collectionLinkImage">
            <xsl:attribute name="alt"><xsl:value-of select="displayItemList/displayItem[@name='name']"/></xsl:attribute>
            <xsl:attribute name="src">sites/<xsl:value-of select="$site_name"/>/collect/<xsl:value-of select="@name"/>/images/<xsl:value-of select="displayItemList/displayItem[@name='smallicon']"/></xsl:attribute>
          </img>
        </a>
      </xsl:when>
      <xsl:otherwise>
        <a href="{$coll_href}" title="{$desc}">
          <div class="collectionLink ui-corner-all">
			<div class="collectionLinkText ui-widget-content ui-corner-top">
				<xsl:choose><xsl:when test="displayItemList/displayItem[@name='name']"><xsl:value-of select="displayItemList/displayItem[@name='name']"/></xsl:when>
				<xsl:otherwise>
				  <xsl:value-of select="@name"/>
				</xsl:otherwise>
			      </xsl:choose>
				  
			</div>
			<div style="height:15px;" class="ui-state-default ui-corner-bottom"><xsl:text> </xsl:text></div>
          </div>
        </a>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template name="serviceClusterList">
    <xsl:apply-templates select="serviceClusterList"/>
  </xsl:template>
  
  <xsl:template match="serviceClusterList">
    <xsl:for-each select="serviceCluster">
      <a href="{$library_name}?a=p&amp;sa=about&amp;c={@name}">
        <xsl:value-of select="@name"/>
        <xsl:value-of select="displayItemList/displayItem[@name='name']"/>
      </a>
    </xsl:for-each>
  </xsl:template>
  
  <xsl:template name="serviceLink">
    <div class="paramLabel">
      <a href="{$library_name}?a=q&amp;rt=d&amp;s={@name}">
        <xsl:value-of select="displayItem[@name='name']"/>
      </a>
    </div>
    <div class="paramValue">
      <xsl:value-of select="displayItem[@name='description']"/>
    </div>
    <br class="clear br-serviceLink"/>
  </xsl:template>
  
  <xsl:template name="authenticationLink">
    <xsl:for-each select="//serviceList/service[@type='authen']">
		<div class="paramLabel">
			<a href="{$library_name}/admin/ListUsers">
				<xsl:value-of select="displayItem[@name='name']"/>
			</a>
		</div>
		<div class="paramValue">
			<xsl:value-of select="displayItem[@name='description']"/>
		</div>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="registerLink">
    <xsl:for-each select="//serviceList/service[@type='authen']">
		<div class="paramLabel">
			<a href="{$library_name}/admin/Register"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'authen.register')"/>
			</a>
		</div>
		<div class="paramValue">
<xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'authen.register_as_new')"/>
		</div>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="webswingGLILink">
    <div class="paramLabel">
      <a href="{$library_name}/page/gli"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'webswinggli.title')"/></a>
  </div>
  <div class="paramValue">
    <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'webswinggli.brief')"/>
  </div>
  </xsl:template>

  <xsl:template name="tabletopDLLink">
    <div class="paramLabel">
      <a href="{$library_name}/page/tabletop"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'tabletopDL.title')"/></a>
  </div>
  <div class="paramValue">
    <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'tabletopDL.brief')"/>
  </div>
  </xsl:template>
    
  <xsl:template name="oaipmhServerLink">
    <div class="paramLabel">
      <a href="oaiserver?verb=Identify"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'oaipmhserver.title')"/></a>
  </div>
  <div class="paramValue">
    <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'oaipmhserver.brief')"/>
  </div>
  </xsl:template>

  <xsl:template name="aboutGreenstoneLink">
    <div class="paramLabel">
      <a href="{$library_name}/page/gsdl"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'gsdl.title')"/></a>
  </div>
  <div class="paramValue">
    <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'gsdl.brief')"/>
  </div>
  </xsl:template>


  
  <xsl:template name="libraryInterfaceLink">
    <div class="paramLabel">
	  <!-- 
		Using HTML5 download attribute to anchor tag, providing download-as-filename value, so Gli App JNLP file downloads.
		Seems we don't need to set the MIME type for downloaded JNLP to launch, if program associations are correctly set up.
	  -->
      <a href="{$library_name}?a=p&amp;sa=gli4gs3" download="GLIappWebStart.jnlp">
        <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'home.librarian_interface')"/>
      </a>
    </div>
	<div class="paramValue">
	  <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'home.gliapp_webstart')"/>
	</div>
  </xsl:template>

  <xsl:template name="depositorTitleMainLink">
    <div class="paramLabel">
      <a href="{$library_name}?a=de"><!-- HAS SIDE-EFFECT: <a href="{$library_name}/page/depositor_home">-->
	<xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'depositor.title')"/>
      </a>
    </div>
    <div class="paramValue">
      <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'depositor.description')"/>      
    </div>    
  </xsl:template>
  
  <xsl:template name="depositorTitleAndLink">
    <a href="{$library_name}?a=de"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'depositor.title')"/></a>
  </xsl:template>
  
  <xsl:template name="greenstoneLogoAlternateText">
    <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'gsdl')"/>
  </xsl:template>
  
  <!-- about page - collection home ....................................................................... -->

<!--  
_httpimages_ {_httpweb_/images}
_httpscript_ {_httpweb_/script}
_httpstyle_ {_httpweb_/style}
_httpflash_ {_httpweb_/flash}
_httpjava_ {_httpweb_/java}
-->


  <xsl:template name="define-js-variable">
    <xsl:param name="name"/>
    <xsl:param name="value"/>
    <script type="text/javascript">
      gs.variables[<xslt:text disable-output-escaping="yes">"</xslt:text><xsl:value-of select="$name"/><xslt:text disable-output-escaping="yes">"</xslt:text>]
      <xslt:text disable-output-escaping="yes"> = "</xslt:text>
      <xsl:value-of select="$value"/>
      <xslt:text disable-output-escaping="yes">";</xslt:text>
    </script>
  </xsl:template>


  <xsl:template name="define-js-macro-variables">

    <xsl:call-template name="define-js-variable">
      <xsl:with-param name="name"  select="'_httpbrowse_'"/>
      <xsl:with-param name="value" select="$_httpbrowse_"/>
    </xsl:call-template>

    <xsl:call-template name="define-js-variable">
      <xsl:with-param name="name"  select="'_httpquery_'"/>
      <xsl:with-param name="value" select="$_httpquery_"/>
    </xsl:call-template>

  </xsl:template>


  <xsl:template name="aboutCollectionPageTitle">
    <!-- put a space in the title in case the actual value is missing - mozilla will not display a page with no title-->
    <xsl:value-of select="/page/pageResponse/collection/displayItemList/displayItem[@name='name']"/>
    <xsl:text> </xsl:text>
  </xsl:template>
  
  <xsl:template name="collectionHomeLinkWithLogoIfAvailable">
    <a href="{$library_name}?a=p&amp;sa=about&amp;c={$collName}">
      <xsl:choose>
        <xsl:when test="$this-element/displayItemList/displayItem[@name='icon']">
          <img border="0">
            <xsl:attribute name="src"><xsl:value-of select="$this-element/metadataList/metadata[@name='httpPath']"/>/images/<xsl:value-of select="$this-element/displayItemList/displayItem[@name='icon']"/></xsl:attribute>
            <xsl:attribute name="alt">
              <xsl:value-of select="$this-element/displayItemList/displayItem[@name='name']"/>
            </xsl:attribute>
            <xsl:attribute name="title">
              <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'aboutpage')"/>
            </xsl:attribute>
          </img>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$this-element/displayItemList/displayItem[@name='name']"/>
        </xsl:otherwise>
      </xsl:choose>
    </a>
  </xsl:template>
  

  
  <xsl:template name="servicesNavigationBar">
    <xsl:for-each select="$this-element/serviceList/service">
      <xsl:variable name="action">
        <xsl:choose>
          <xsl:when test="@name=$this-service">CURRENT</xsl:when>
          <xsl:when test="@type='query'">q</xsl:when>
          <xsl:when test="@type='browse'">b</xsl:when>
          <xsl:when test="@type='process'">pr</xsl:when>
          <xsl:when test="@type='applet'">a</xsl:when>
          <xsl:otherwise>DO_NOT_DISPLAY</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="$action='CURRENT'">
          <li>
            <a>
              <xsl:value-of select="displayItem[@name='name']"/>
            </a>
          </li>
        </xsl:when>
        <xsl:when test="$action !='DO_NOT_DISPLAY'">
          <li>
            <a href="{$library_name}?a={$action}&amp;rt=d&amp;s={@name}&amp;c={$collName}">
              <xsl:if test="displayItem[@name='description']">
                <xsl:attribute name="title">
                  <xsl:value-of select="displayItem[@name='description']"/>
                </xsl:attribute>
              </xsl:if>
              <xsl:value-of select="displayItem[@name='name']"/>
            </a>
          </li>
        </xsl:when>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>
  
  <xsl:template name="collectionDescriptionTextAndServicesLinks">
    <xsl:apply-templates select="pageResponse/collection|serviceCluster"/>
  </xsl:template>

  <!--
      Solution to problem where incoming collection description contains HTML and we want to preserve
      that HTML instead of XML's default behaviour stripping out all tags and just concatenating their text
      content.
      The actual solution is here:
      https://stackoverflow.com/questions/19998180/xsl-copy-nodes-without-xmlns
      - Close but adds namespaces to the first HTML tag:
      https://stackoverflow.com/questions/6199345/how-to-copy-all-child-nodes-of-any-type-of-a-template-context-element
      Other links that are a learning experience:
      - https://support.microsoft.com/en-us/help/264665/how-to-display-html-in-xsl-style-sheet
      (tags need to come in in entity form for xslt to remove the entities in output)
      - https://forums.asp.net/t/1414309.aspx?Decoding+HTML+after+applying+an+XLST+transform+to+an+XML+control
      (same problem)
      - https://docs.oracle.com/javase/tutorial/jaxp/xslt/transformingXML.html
      (general information)
      - https://stackoverflow.com/questions/5876382/using-xslt-to-copy-all-nodes-in-xml-with-support-for-special-cases
      (close to solution)
  -->
  <xsl:template match="collection|serviceCluster">
    <!-- original way: does not preserve html tags -->
    <!--<xsl:value-of select="displayItemList/displayItem[@name='description']" disable-output-escaping="yes"/>-->    
    <xsl:apply-templates select="displayItemList/displayItem[@name='description']"/>

    <!-- Don't do this. It seems to remove any text nodes directly within this displayItem
	 before copying only the subdnodes -->
    <!-- <xsl:apply-templates select="displayItemList/displayItem[@name='description']/*" mode="copy-no-namespaces"/> -->

     <!-- Don't do this: it will also copy the <displayItem> element itself into the HTML output -->
     <!--<xsl:copy-of select="displayItemList/displayItem[@name='description']"/>-->
     
     <!-- The other way: requires the input to already be entity encoded for xslt to get it right,
	  to get it ending up as tags in the HTML generated. An example of it working below.
	  But that means we have to get the runtime code to send entity encoded elements, which
	  is not what we want.
     -->
    <!--<xsl:text disable-output-escaping="yes">&lt;b&gt;hello&lt;/b&gt;</xsl:text>-->
    
<!-- Uncomment this section if you want the collection service links and their descriptions to appear -->
	<!--<xsl:apply-templates select="serviceList">
      <xsl:with-param name="collName" select="$collName"/>
    </xsl:apply-templates>-->
  </xsl:template>

  <!-- preserve any HTML tags *within* the collection description
       Why is this adding an xmlns namespace to the first HTML tag encountered and converting
       non html entities like the apostrophe character into their entity forms?
       This seems to assume entities in the input should be converted:
       https://stackoverflow.com/questions/31517944/xsl-disable-output-escaping-copy-of
       But I'm wondering why when there's no entity in the input, copy-of produces entities
       for chars like apostrophe in the output?
       Note: there's xsl:copy and xsl:copy-of, we want copy-of!
       - https://www.w3schools.com/xml/ref_xsl_el_copy.asp
       - vs https://www.w3schools.com/XML/ref_xsl_el_copy-of.asp
       
       Info on avoiding doe/disable-output-escaping at https://saxonica.plan.io/issues/3214
       https://stackoverflow.com/questions/31517944/xsl-disable-output-escaping-copy-of
  -->
  <xsl:template match="displayItem[@name='description']">
    <!-- don't do this: it adds an xmlns namespace to the first/root html element in displayItem -->
    <!--<xsl:copy-of select="node()"/>-->
    <xsl:apply-templates select="node()" mode="copy-no-namespaces"/>
   </xsl:template>
   <!-- On mode attribute: https://www.w3schools.com/xml/ref_xsl_el_apply-templates.asp
	https://stackoverflow.com/questions/4486869/can-one-give-me-the-example-for-mode-of-template-in-xsl
	https://docs.microsoft.com/en-us/previous-versions/dotnet/netframework-4.0/ms256045(v=vs.100)?redirectedfrom=MSDN
   -->
   <xsl:template match="*" mode="copy-no-namespaces">
     <xsl:element name="{local-name()}">
       <xsl:copy-of select="@*"/>
       <xsl:apply-templates select="node()" mode="copy-no-namespaces"/>
     </xsl:element>
   </xsl:template>
   
   <xsl:template match="comment()| processing-instruction()" mode="copy-no-namespaces">
     <xsl:copy/>
   </xsl:template>
   
  <xsl:template match="serviceList">	
	<xsl:param name="collName"/>
		<h3>
		  <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'about.services')"/>
		</h3>
		<p>
		  <xsl:choose>
			<xsl:when test="service">
			  <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'about.servicehelp')"/>
			</xsl:when>
			<xsl:otherwise>
			  <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'about.noservices')"/>
			</xsl:otherwise>
		  </xsl:choose>
		</p>
		<xsl:if test="service">
		  <div id="servicelist">
			<xsl:for-each select="service">
			  <xsl:sort select="position()" order="descending" data-type="number"/>
			  <xsl:variable name="action">
				<xsl:choose>
				  <xsl:when test="@type='query'">q</xsl:when>
				  <xsl:when test="@type='process'">pr</xsl:when>
				  <xsl:when test="@type='applet'">a</xsl:when>
				  <xsl:otherwise>DO_NOT_DISPLAY</xsl:otherwise>
				</xsl:choose>
			  </xsl:variable>
			  <xsl:if test="$action != 'DO_NOT_DISPLAY'">
				<div class="paramLabel">
				  <a href="{$library_name}?a={$action}&amp;rt=d&amp;s={@name}&amp;c={$collName}">
					<xsl:value-of select="displayItem[@name='name']"/>
				  </a>
				</div>
				<div class="paramLabel">
				  <xsl:value-of select="displayItem[@name='description']"/>
				</div>
				<br class="clear br-paramDisplay"/>
			  </xsl:if>
			</xsl:for-each>
		  </div>
		</xsl:if>

  </xsl:template>
  
  <!-- classifier page ............................................................................ -->
  <xsl:template name="collapsedNavigationTab">
    <xsl:param name="type"/>
    <xsl:variable name="isCurrent" select="/page/pageResponse/service[@type=$type]"/>
    <li>
      <xsl:if test="$isCurrent">
        <xsl:attribute name="class">current</xsl:attribute>
      </xsl:if>
      <a>
        <xsl:if test="service[@name=$type]/displayItem[@name='description']">
          <xsl:attribute name="title">
            <xsl:value-of select="service[@name=$type]/displayItem[@name='description']"/>
          </xsl:attribute>
        </xsl:if>
        <xsl:attribute name="href"><xsl:value-of select="$library_name"/>?a=q&amp;rt=d&amp;s=<xsl:value-of select="service[@type=$type]/@name"/>&amp;c=<xsl:value-of select="/page/pageResponse/collection/@name"/></xsl:attribute>
        <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, $type)"/>
      </a>
    </li>
  </xsl:template>
  
  <xsl:template name="navigationTab">
    <xsl:variable name="isCurrent" select="@name=/page/pageResponse/service/@name"/>
    <xsl:variable name="action">
      <xsl:choose>
        <xsl:when test="@type='query'">q</xsl:when>
        <xsl:when test="@type='browse'">b</xsl:when>
        <xsl:when test="@type='process'">pr</xsl:when>
        <xsl:when test="@type='applet'">a</xsl:when>
        <xsl:otherwise>DO_NOT_DISPLAY</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:if test="$action!='DO_NOT_DISPLAY'">
      <li>
        <xsl:if test="$isCurrent">
          <xsl:attribute name="class">current</xsl:attribute>
        </xsl:if>
        <a>
          <xsl:if test="displayItem[@name='description']">
            <xsl:attribute name="title">
              <xsl:value-of select="displayItem[@name='description']"/>
            </xsl:attribute>
          </xsl:if>
          <xsl:choose>
            <xsl:when test="classifierList/classifier/@name">
              <xsl:attribute name="href"><xsl:value-of select="$library_name"/>?a=<xsl:value-of select="$action"/>&amp;rt=s&amp;s=<xsl:value-of select="@name"/>&amp;c=<xsl:value-of select="/page/pageResponse/collection/@name"/>&amp;cl=<xsl:value-of select="classifierList/classifier/@name"/></xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="href"><xsl:value-of select="$library_name"/>?a=<xsl:value-of select="$action"/>&amp;rt=d&amp;s=<xsl:value-of select="@name"/>&amp;c=<xsl:value-of select="/page/pageResponse/collection/@name"/></xsl:attribute>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:value-of select="displayItem[@name='name']"/>
        </a>
      </li>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="classifierLink">
    <xsl:if test="@name=/page/pageResponse/classifier/@name">
      <xsl:attribute name="class">current</xsl:attribute>
    </xsl:if>
    <a href="{$library_name}?a=b&amp;rt=r&amp;s={/page/pageResponse/service/@name}&amp;c={/page/pageResponse/collection/@name}&amp;cl={@name}">
      <xsl:value-of select="displayItem[@name='description']"/>
    </a>
  </xsl:template>
  
  <!-- query page ............................................................................ -->
<!--  <xsl:template name="indexName">
    <xsl:value-of select="/page/pageResponse/service/displayItem[@name='name']"/>
  </xsl:template>

  <xsl:template name="queryPageCollectionName">
    <xsl:choose>
      <xsl:when test="/page/pageResponse/collection">
        <gslib:aboutCollectionPageTitle/>
      </xsl:when>
      <xsl:otherwise>Cross-Collection</xsl:otherwise>
    </xsl:choose>
  </xsl:template>-->
  
  <!--
BASKET TEMPLATES
These get used on many different pages to add the favourites basket or 
document basket to the site
  -->
  
  <xsl:template name="displayBaskets">
    
	      <xsl:if test="$favouriteBasketOn">
		<!-- show the favourites 'basket' if it's turned on -->
		<gslib:gotoFavourites/>
		<xsl:text> </xsl:text>
 	      </xsl:if>

              <!-- is the document basket facility turned on, and does the user have permission to use it? -->
	      <xsl:if test="$documentBasketOn and /page/pageRequest/userInformation and /page/pageRequest/userInformation/@editEnabled = 'true' and util:canEditCollection(/page/pageRequest/userInformation/@username,/page/pageRequest/userInformation/@groups,$collNameChecked) ">
		
		<gslib:documentBasket/>
		<xsl:text> </xsl:text>
	      </xsl:if>
      <!--</xsl:if>-->
  </xsl:template>

  
  <!--
      Goto Favourites Template
      This gets used on many different pages to add the
      goto favourites check-out functionality to the site
  -->
  <xsl:template name="gotoFavourites">
    <xsl:if test="$favouriteBasketOn">
      <!-- set up these gsf variables so we have access in javascript -->
      <gsf:variable name="selected_favourite_icon_url"><gsf:interfaceText name="favourite_star_selected_image"/></gsf:variable>
      <gsf:variable name="unselected_favourite_icon_url"><gsf:interfaceText name="favourite_star_image"/></gsf:variable>
    <div id="favouritebasket" class="hide">  
      <img src="{$selected_favourite_icon_url}"  width="16" height="16" border="0" />
    <!--    <span><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'favourites.title')"/><xsl:text> </xsl:text></span>
	<span id="favouritesCountDisplay">...</span>
-->
	<span><a id="favouritesFullViewLink"><xsl:attribute name="href"><xsl:value-of select="$library_name"/>?a=gdl&amp;sa=fav&amp;c=&amp;s=GetFavouritesList&amp;rt=r&amp;p.c=<xsl:value-of select="$collName"/><xsl:if test="/page/pageRequest/paramList/param[@name='group']/@value">&amp;p.group=<xsl:value-of select="/page/pageRequest/paramList/param[@name='group']/@value"/></xsl:if></xsl:attribute><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'favourites.view')"/></a></span>	<span id="favouritesCountDisplay">...</span>
    </div>
    </xsl:if>
  </xsl:template>
  



	<!-- put the drag&drop document basket on the page -->
	<xsl:template name="documentBasket">
		<xsl:if test="$documentBasketOn and /page/pageRequest/userInformation and /page/pageRequest/userInformation/@editEnabled = 'true' and util:canEditCOllection(/page/pageRequest/userInformation/@username,/page/pageRequest/userInformation/@groups,$collNameChecked)">
			<div id="documentbasket" class="show">
				<span><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'db.doc_basket')"/><xsl:text> </xsl:text></span>
				<span id="documentBasketExpandCollapseLinks" style="display: none;">
					<a id="documentBasketExpandLink" href="javascript:showDocumentBox()"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'basket.expand')"/></a>
					<a id="documentBasketCollapseLink" style="display: none;" href="javascript:hideDocumentBox()"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'basket.collapse')"/></a>
				</span>
				<div id="documenthandle">
					<span>
						<xsl:text> </xsl:text>
					</span>
				</div>
				<div id="documentpages">
					<span>
						<xsl:text> </xsl:text>
					</span>
				</div>
				<div>
					<a href="javascript:clearBasket();"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'basket.clear')"/></a>
				</div>
			</div>
		</xsl:if>
	</xsl:template>

        <!-- include the required js and css for favourites-->
        <xsl:template name="favouritesHeadTags">
          <script type="text/javascript" src="interfaces/{$interface_name}/js/yui/yahoo-min.js"><xsl:text> </xsl:text></script>
          <script type="text/javascript" src="interfaces/{$interface_name}/js/yui/event-min.js"><xsl:text> </xsl:text></script>
          <script type="text/javascript" src="interfaces/{$interface_name}/js/yui/connection-min.js"><xsl:text> </xsl:text></script>
          <script type="text/javascript" src="interfaces/{$interface_name}/js/yui/dom-min.js"><xsl:text> </xsl:text></script>
          <script type="text/javascript" src="interfaces/{$interface_name}/js/favouritebasket/favouritebasket.js"><xsl:text> </xsl:text></script>
    <link rel="stylesheet" href="interfaces/{$interface_name}/style/favourites.css" type="text/css"/>
        </xsl:template>
        
  <!-- include the required javascript and css for document baskets 
       Note, this may have unneeded things in it -->
  <xsl:template name="documentBasketHeadTags">
    <script type="text/javascript" src="interfaces/{$interface_name}/js/yui/yahoo-min.js"><xsl:text> </xsl:text></script>
    <script type="text/javascript" src="interfaces/{$interface_name}/js/yui/event-min.js"><xsl:text> </xsl:text></script>
    <script type="text/javascript" src="interfaces/{$interface_name}/js/yui/connection-min.js"><xsl:text> </xsl:text></script>
    <script type="text/javascript" src="interfaces/{$interface_name}/js/yui/dom-min.js"><xsl:text> </xsl:text></script>
    <script type="text/javascript" src="interfaces/{$interface_name}/js/yui/dragdrop-min.js"><xsl:text> </xsl:text></script>
	<script type="text/javascript" src="interfaces/{$interface_name}/js/yui/cookie-min.js"><xsl:text> </xsl:text></script>
	<script type="text/javascript" src="interfaces/{$interface_name}/js/yui/animation-min.js"><xsl:text> </xsl:text></script>
	<script type="text/javascript" src="interfaces/{$interface_name}/js/documentbasket/ygDDPlayer.js"><xsl:text> </xsl:text></script>
    <script type="text/javascript" src="interfaces/{$interface_name}/js/documentbasket/ygDDOnTop.js"><xsl:text> </xsl:text></script>
	
	<!-- Combo-handled YUI CSS files: --> 
	<link rel="stylesheet" type="text/css" href="interfaces/{$interface_name}/style/skin.css"/>

	<script type="text/javascript" src="interfaces/{$interface_name}/js/documentbasket/documentbasket.js"><xsl:text> </xsl:text></script>
	<script type="text/javascript" src="interfaces/{$interface_name}/js/documentbasket/documentBasketDragDrop.js"><xsl:text> </xsl:text></script>
	<!-- Combo-handled YUI JS files: --> 
	<script type="text/javascript" src="interfaces/{$interface_name}/js/documentbasket/yahoo-dom-event.js"><xsl:text> </xsl:text></script>
	<script type="text/javascript" src="interfaces/{$interface_name}/js/documentbasket/container_core-min.js"><xsl:text> </xsl:text></script>
	<script type="text/javascript" src="interfaces/{$interface_name}/js/documentbasket/element-min.js"><xsl:text> </xsl:text></script>
	<script type="text/javascript" src="interfaces/{$interface_name}/js/documentbasket/menu-min.js"><xsl:text> </xsl:text></script>
	<script type="text/javascript" src="interfaces/{$interface_name}/js/documentbasket/button-min.js"><xsl:text> </xsl:text></script>
	<script type="text/javascript" src="interfaces/{$interface_name}/js/documentbasket/editor-min.js"><xsl:text> </xsl:text></script> 
	<script type="text/javascript" src="interfaces/{$interface_name}/js/documentbasket/yuiloader-min.js"><xsl:text> </xsl:text></script>
	<!--<script type="text/javascript" src="interfaces/{$interface_name}/js/documentbasket/editor-dialog.js"><xsl:text> </xsl:text></script>-->
    <link rel="stylesheet" href="interfaces/{$interface_name}/style/documentbasket.css" type="text/css"/>
  </xsl:template>
  
  <xsl:template name="documentFavouriteForClassifierOrSearchPage">
    <xsl:if test="$favouriteBasketOn">
     <xsl:variable name="collname"><xsl:choose><xsl:when test="@collection"><xsl:value-of select="@collection"/></xsl:when><xsl:otherwise><xsl:value-of select="/page/pageResponse/collection/@name"/></xsl:otherwise></xsl:choose></xsl:variable>
      <img src="{$unselected_favourite_icon_url}" title="click to add to favourites" width="20" height="20" border="0" onclick="toggleFavourite(this)" data-is-favourite="false">
        <xsl:attribute name="id"><xsl:value-of select="$collname"/>:<xsl:value-of select="@nodeID"/></xsl:attribute>
      </img>
    </xsl:if>
  </xsl:template>
  
 
  <xsl:template name="documentFavouriteForDocumentPage">
    <xsl:variable name="selectedNode">
      <xsl:value-of select="/page/pageResponse/document/@selectedNode"/>
    </xsl:variable>
    <xsl:variable name="rootNode">
      <xsl:value-of select="/page/pageResponse/document/documentNode[@nodeType='root']/@nodeID"/>
    </xsl:variable>
    <xsl:if test="$favouriteBasketOn">
      <div id="documentfavourites">
        <img id="{/page/pageResponse/collection/@name}:{$rootNode}" src="{$unselected_favourite_icon_url}" alt="in basket" width="15" height="15" border="0"/>
        <span id="{/page/pageResponse/collection/@name}:{$rootNode}:root" class="documentfavourite">the whole document</span>
        <!--<xsl:if test="$selectedNode != $rootNode">
          <img id="{/page/pageResponse/collection/@name}:{$selectedNode}" src="{$unselected_favourite_icon_url}" alt="in basket" width="15" height="15" border="0"/>
          <span id="{/page/pageResponse/collection/@name}:{$selectedNode}:section" class="documentfavourite">the current section</span>
        </xsl:if>-->
      </div>
    </xsl:if>
  </xsl:template>
  
  <!-- document page -->
  <xsl:template name="documentTitle">
    <xsl:value-of select="/page/pageResponse/document/documentNode/metadataList/metadata[@name='Title']"/>
  </xsl:template>
  <xsl:template name="coverImage">
    <img>
      <xsl:attribute name="src"><xsl:value-of select="/page/pageResponse/collection/metadataList/metadata[@name='httpPath']"/>/index/assoc/<xsl:value-of select="metadataList/metadata[@name='assocfilepath']"/>/cover.jpg</xsl:attribute>
    </img>
  </xsl:template>
  
  <xsl:template name="previousNextButtons">
    <!-- prev -->
    <a>
      <xsl:attribute name="href"><xsl:value-of select="$library_name"/>?a=d&amp;c=<xsl:value-of select="/page/pageResponse/collection/@name"/>&amp;d=<xsl:value-of select="@selectedNode"/>.pp&amp;sib=1&amp;p.s=<xsl:value-of select="/page/pageRequest/paramList/param[@name='p.s']/@value"/>&amp;p.sa=<xsl:value-of select="/page/pageRequest/paramList/param[@name='p.sa']/@value"/>&amp;p.a=<xsl:value-of select="/page/pageRequest/paramList/param[@name='p.a']/@value"/></xsl:attribute>
      <img class="lessarrow" src="interfaces/{$interface_name}/images/previous.png"/>
    </a>
    <!-- next -->
    <a>
      <xsl:attribute name="href"><xsl:value-of select="$library_name"/>?a=d&amp;c=<xsl:value-of select="/page/pageResponse/collection/@name"/>&amp;d=<xsl:value-of select="@selectedNode"/>.np&amp;sib=1&amp;p.s=<xsl:value-of select="/page/pageRequest/paramList/param[@name='p.s']/@value"/>&amp;p.sa=<xsl:value-of select="/page/pageRequest/paramList/param[@name='p.sa']/@value"/>&amp;p.a=<xsl:value-of select="/page/pageRequest/paramList/param[@name='p.a']/@value"/></xsl:attribute>
      <img class="morearrow" src="interfaces/{$interface_name}/images/next.png"/>
    </a>
  </xsl:template>


  <!-- This next template expands gslib:langfrag (used by document.xsl and documentbasket.xsl).
       When debugging with o=skinandlibdoc, it's seen that <gslib:langfrag name='dse' /> gets expanded to:
       <xsl:call-template name="langfrag">
	 <xsl:with-param name="name">dse</xsl:with-param>
       </xsl:call-template>
       Before the param can be used in this template, need to retrieve it by name with <xsl:param/>
       as explained in http://www.maconstateit.net/tutorials/XML/XML05/xml05-05.aspx
       -->
  <xsl:template name="langfrag">
    <xsl:param name="name"/>
    <script type="text/javascript">
      <xsl:value-of disable-output-escaping="yes" select="util:getInterfaceStringsAsJavascript($interface_name, /page/@lang, $name)"/>
    </script>
  </xsl:template>


  <!-- builds up links to available document types equivalent to the default source
       document with as anchor the equivalent documents' doctype icons. -->
  <xsl:template name="equivDocLinks">
    <xsl:param name="count"/>

      <xsl:variable name="docicon" select="metadataList/metadata[contains(@name, 'equivDocIcon')]"/>
      <xsl:variable name="docEndlink" select="metadataList/metadata[contains(@name, '/equivDocLink')]"/>

      <!--<xsl:variable name="docStartlink" select="metadataList/metadata[contains(@name, 'all_*,*_equivDocLink')]"/>-->	
      <!-- In the following variable statement, we're trying to set the docStartlink to any metadata whose value 
	ends on equivDocLink but NOT /equivDocLink. Unfortunately, the xslt function fn:ends-with only exists from
	xslt 2.0 onwards. So need to use substring() and string-lenth() functions now to check whether the 13th char
	from the end is a slash or not, in order to distinguish between the start of a doclink and end of one. 
	If this 13th char from the end is not a slash, then we found (the string we want to store in) docStartlink. -->
      <xsl:variable name="docStartlink">
	<xsl:for-each select="metadataList/metadata">
	  <xsl:if test="contains(@name, 'equivDocLink')">	
	    <xsl:variable name="tmpvar" select="substring(@name, string-length(@name)-12, 1)"/>	
	      <xsl:if test="not($tmpvar='/')">
	        <xsl:value-of select="self::node()[@name]"/> 	        
	      </xsl:if>		
	  </xsl:if>
	</xsl:for-each>	
      </xsl:variable>

      <xsl:variable name="equivDocIcon" select="java:org.greenstone.gsdl3.util.XSLTUtil.getNumberedItem($docicon, $count)" />
      <xsl:variable name="equivStartlink" select="java:org.greenstone.gsdl3.util.XSLTUtil.getNumberedItem($docStartlink, $count)" />
      <xsl:variable name="equivEndlink" select="java:org.greenstone.gsdl3.util.XSLTUtil.getNumberedItem($docEndlink, $count)" />

      <xsl:if test="$equivDocIcon != ''">
        <xsl:value-of disable-output-escaping="yes" select="$equivStartlink"/>
        <xsl:value-of disable-output-escaping="yes" select="$equivDocIcon"/>
        <xsl:value-of disable-output-escaping="yes" select="$equivEndlink"/>

        <!-- recursively call this template to get multiple entries -->
        <xsl:call-template name="equivDocLinks">
          <xsl:with-param name="count"><xsl:value-of select="$count + 1"/></xsl:with-param>
        </xsl:call-template>
      </xsl:if>

  </xsl:template>

  <xsl:template name="expandContractDocumentLinks">
    <!--<xsl:if test="count(//documentNode) > 1">-->
      <xsl:variable name="doc_url"><xsl:value-of select='$library_name'/>/collection/<xsl:value-of select='/page/pageResponse/collection/@name'/>/document/<xsl:value-of select='/page/pageResponse/document/documentNode/@nodeID'/>?<xsl:if test="/page/pageRequest/paramList/param[@name='p.s']">p.s=<xsl:value-of select="/page/pageRequest/paramList/param[@name='p.s']/@value"/>&amp;</xsl:if></xsl:variable>
      <div id="expandContractLinks"><table style="width:100%; text-align:center;"><tr><td><a href="{$doc_url}ed=1"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'doc.expand_doc')"/></a></td><td><a href="javascript:expandOrCollapseAll(false);"><xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'doc.collapse_doc')"/></a></td></tr></table></div>
    <!--</xsl:if>-->
  </xsl:template>
</xsl:stylesheet>
