// a list of doc ids
var docList = new Array();
// a corresponding list of plain text output for each doc
var docPlainList = new Array();

var mailinfo = new Array();
mailinfo['address'] = gs.text.favourites.to; 
mailinfo['cc'] = gs.text.favourites.cc; 
mailinfo['bcc'] = gs.text.favourites.bcc; 
mailinfo['subject'] = gs.text.favourites.subject; 

var delurlPath = gs.xsltParams.library_name + "?a=pr&rt=r&ro=1&s=DeleteFavourites&c=&o=XML&hhf="+makeURLComponentSafe("[{\"name\":\"Cache-Control\", \"value\":\"no-cache\"}]")+"&s1.items=";
var request_type = "GET"; // the default

var emailVisible = false;
function showAndHideEmailForm() {
    var emaildiv = document.getElementById("emailForm");
    if (emailVisible) {
        emailVisible = false;
        emaildiv.setAttribute("style","display:none;");
    } else {
        emailVisible = true;
        var textarea = document.getElementById("pretextarea");
        textarea.value = outputPlain();
        emaildiv.setAttribute("style","display:block;");
    }
}

function copyToClip() {
    function listener(e) {
        var str = outputPlain();
	str = str.replaceAll("&quot;", "\"");
	e.clipboardData.setData("text/plain", str);
	e.preventDefault();
    }
    document.addEventListener("copy", listener);
    document.execCommand("copy");
    document.removeEventListener("copy", listener);
};

function outputPlain() {
    var output = "";
    for(var i = 0; i < docPlainList.length; i++) {
        output += docPlainList[i] + "\n\n"
    }
    return output;
}

function mailTo() {
    var url = "mailto:?Subject="+gs.text.favourites.default_subject+"&body=";
    var content = outputPlain();
    content = content.replaceAll("\n", "%0D%0A");
    content = content.replaceAll("&quot;", "\"");
    window.open(url+content);

    

}
// called by clicking the delete All button
function deleteAll() {

    if(docList.length == 0) return; // nothing to delete
    
    var  delurl = delurlPath; 
    // Just need to append each doc id separated by |, but this character needs to be URL encoded,
    // else the delete doesn't work.

    for(var i = 0; i < docList.length; i++) {
        var doc_id = docList[i];
	if((i+1) == docList.length) { // if it's the last id to process, don't append separator
	    delurl += doc_id;
	} else { // there's more ids to process, so append separator (in URL encoded form!)
	    delurl += doc_id + "%7C"; // url-encoded version of |
	}
    }
    
    var delAll = true;
    doDelete(delAll, delurl, null, null);
}

// called when you click the star in the favourites list
function deleteFavouriteFromCheckout(el)
{
    var  delurl = delurlPath; 

    var doc_id = el.getAttribute('id');
    delurl += doc_id;

    var deleteAll = false;
    var selectedList = [ el ];
    var idsToDelete = [ doc_id ];
    doDelete(deleteAll, delurl, selectedList, idsToDelete);
}

// do the actual deletion, or all or some of the list
function doDelete(deleteAll, delurl, selectedList, idsToDelete) { // given list of selected checkboxes

    var delSuccess = function(o) {
	var result = o.responseXML;
	
	if(!deleteAll) { // then we're given a selection to delete: Not deleting all items, just a subset
	    // Remove id of selected doc to be deleted from docList.	    
	    // Minor optimisation to double for loop, dependent on ordering of selected favourites being
	    // in order of checkboxes (i.e. order of docList ids), and order of docList ids having
	    // the same order as the checkboxes
	    var searchForNextSelectedIdFromIndex = idsToDelete.length-1;
	    for (var i = docList.length - 1; i >= 0; i--) {
		var doc_id = docList[i];		
		for(var j = searchForNextSelectedIdFromIndex; j >= 0; j--) {
		    if(idsToDelete[j] == doc_id) {
			docList.splice(i, 1); // i indexes into docList, delete element i from docList
                        docPlainList.splice(i,1); // also remove the plain description
			searchForNextSelectedIdFromIndex = j-1;
			break;
		    }
		}
	    }
	    
	    // remove the selected documents' HTML display elements
	    var favouriteDocsList = document.getElementById('favouriteDocsList'); // ordered list item containing the favourites	
	    for(var i = 0; i < selectedList.length; i++) {
		var li = selectedList[i].parentNode; // list item parent of checkbox
		// remove the list item from its containing orderedList		
		favouriteDocsList.removeChild(li);
	    }
	}



	// if all docs are deleted by this stage, then display no favourites message
	if (deleteAll || favouriteDocsList.getElementsByTagName("li").length==0) { // 2nd clause no longer needed?, then this just becomes an else against the first if(!deleteAll) test
	    
	    // if deleting all docs, just use the easy way to empty the docList array
	    docList.length = 0; // https://www.jstips.co/en/javascript/two-ways-to-empty-an-array/
            docPlainList.length = 0;
	    // Removing all child nodes (done one at a time) is more optimal
	    // than setting innerHTML to empty string, see
	    // https://stackoverflow.com/questions/3955229/remove-all-child-elements-of-a-dom-node-in-javascript
            // this removes the empty ul, rather than the docs themselves which was done above
	    var content =  document.getElementById('favouritesContent');
	    while (content.hasChildNodes()) {
		content.removeChild(content.firstChild);
	    }  
	    content.appendChild(emptyBasketText());
	    //disable the buttons
	    disableShareButtons();

	}
        // reset the plain doclist
        var textarea = document.getElementById("pretextarea");
        textarea.value = outputPlain();

    }

    var delFailure = function(o){ alert("Deletion failed" + o);}
    
    var delcallback = {
	success:delSuccess,
	failure:delFailure,  
	argument:null // supposed to be the ygDDPlayer object, but don't have a ref to it here, so trying null
    }

    // Finally send the actual delete request
    // request_type defaults to GET, which is what's used for add and del, see ygDDPlayer.js.
    YAHOO.util.Connect.asyncRequest(request_type, delurl , delcallback);
}

function disableShareButtons() {
    var buttonids = ["sendemailbutton", "favdeleteallbutton", "copybutton"];
    for (var i=0;i<buttonids.length;  i++) {
	var button = document.getElementById(buttonids[i]);
	button.classList.add("disabled");
    }
}

function emptyBasketText() {
	return document.createTextNode(gs.text.favourites.empty_basket);
}


// send the email request to greenstone
function sendMail(){
	var url = gs.xsltParams.library_name + "?a=pr&rt=r&ro=1&s=SendFavouritesMail&c=";
	var request_type = "POST";
	var postdata = "";
	var i;

	var content = YAHOO.util.Dom.get('pretextarea').value;
    
    // To send an email, the To address and message Body must contain data.
    // HTML5 input checking (required attribute) would make empty fields red outlined,
    // but did not prevent Send button submitting form. So some basic sanity checking in JS:
    // Checking non-empty and to address field must further be a URL: checking it contains @
    var to_address = YAHOO.util.Dom.get('address').value;

    if(to_address.trim() === "") {
	alert(gs.text.favourites.invalid_to_address_empty);
	return;
    } else if(to_address.indexOf('@') === -1) {
	alert(gs.text.favourites.invalid_to_address);
	return;
    } else if(content.trim() === "") {
	alert(gs.text.favourites.invalid_msg_body_empty);
	return;
    }
    
	//get checked items
	for (i in mailinfo) {
		var input = YAHOO.util.Dom.get(i);
		var value = input.value;
		postdata +="&s1."+i+"="+value;
	}


	content = content.replace(/&/g,'-------');
	postdata +="&s1.content="+content;

	var callback = {
		success: function(o) {
			var result = o.responseText;
		    alert(gs.text.favourites.send_success); 
		} ,
		failure: function(o) {
		    alert(gs.text.favourites.send_fail); 
		}
	}
	YAHOO.util.Connect.asyncRequest(request_type , url , callback, postdata);
}	


