var facetSortOptions = {
    valueNames: [ 'facet', 'count' ]
}

function setUpFacetList(indexname)
{
    var newList = new List(indexname, facetSortOptions);
    enableMoreButtonIfNeeded(indexname);
}

function enableMoreButtonIfNeeded(indexname) {
    var morelink = $(".expandFacetList" + indexname);
    var tables = $(".facetTable");
    for(var i = 0; i < tables.length; i++)
    {
        var $current = $(tables[i]);
        if($current.attr("indexname") == indexname) {
	    var current = $current[0];
	    if (current.clientHeight < current.scrollHeight) {
		morelink.css("display", "block");
	    }
	    break;
	}
    }

}

function getFacetQueryString(facetsThatAreChecked)
{

    // if we have come here from eg next/prev page buttons, we won't have options selected in the
    // facet list, we need to use the cgi param s1.facetQueries
    if (gs.cgiParams.s1_facetQueries !== undefined) {
	var facets = gs.cgiParams.s1_facetQueries;
	// for some reason, we end up with &quot; in here. Replace these back, so then we can call
	// makeURLComponentSafe, and get back to the same encoded value we had originally
	facets = facets.replace(/&quot;/g, "\""); 
	return "s1.facetQueries="+makeURLComponentSafe(facets, 0)+"&";
    }

    var allCheckBoxes = $("#facetSelector input");
    var counts = new Array();

    for(var i = 0; i < allCheckBoxes.length; i++)
    {
	var current = $(allCheckBoxes[i]);
	if(current.prop("checked"))
	{
	    counts.push(current.parent().parent().attr("indexName") + ":(\"" + current.siblings("span").first().html() + "\")");
	    if (facetsThatAreChecked !== undefined) {
		facetsThatAreChecked.add(current.parent().parent().attr("indexName"));
	    }
	}
    }

    var countsString = "s1.facetQueries=";
    if(counts.length > 0)
    {
	var countsStringBuffer = "[";
	for(var i = 0; i < counts.length; i++)
	{
	    // escape any apostrophes in facet query terms
	    // (ext/solr's Greenstone3SearchHandler does the other half of handling them)
	    //countsStringBuffer += "\"" + encodeURI(counts[i]).replace(/'/g, "%2527") + "\"";
	    // calling makeURLSafe() here will ensure percent signs are escaped away too
	    // by the end of makeURLComponentSafe() call below
	    // Note that apostrophe's in URLs should get encoded, https://www.techwalla.com/articles/how-to-encode-an-apostrophe-in-a-url
	    // though the apostrophe is not in that other list of invalid and unsafe chars in urls dealt with in utility_scripts.js		    
	    countsStringBuffer += "\"" + makeURLSafe(counts[i]).replace(/'/g, "%2527") + "\"";
	    if(i < counts.length - 1)
	    {
		countsStringBuffer += ", ";
	    }
	}
	
	countsStringBuffer += "]";
	// We need to ensure that the *value* of s1.facetQueries (so everything after
	// s1.facetQueries= and before the connecting &) are safe, which requires escaping,
	// and are further also escaped to not be mistaken for their reserved meaning.
	// : is a reserved character in URLs, [] are unsafe characters. All need escaping.
	// So call makeURLComponentSafe(), not makeURLSafe()
	countsString = countsString + makeURLComponentSafe(countsStringBuffer, 1);
    }
    
    countsString += "&";
    return countsString;
}

function performRefinedSearch()
{
    var allCheckBoxes = $("#facetSelector input");
    var facetsThatAreChecked = new Set();
    var facetQueryString = getFacetQueryString(facetsThatAreChecked); 

	var searchString = "";
	for(var key in gs.cgiParams)
	{
	    if (gs.cgiParams.hasOwnProperty(key))
	    {
		// reset the startPage to 1, as we can't keep the previous value as we are changing the search results list
		if (key == "s1_startPage") {
		    searchString += "s1.startPage=1&";
		} else {
		    searchString += key.replace(/_/g, ".") + "=" + makeURLComponentSafe(gs.cgiParams[key]) + "&";
		}
//		console.log("PARAM FOR key " + key + ":" + gs.cgiParams[key]);
//		console.log("SAFE PARAM FOR " + key + ":" + makeURLComponentSafe(gs.cgiParams[key]));
	    }
	}
  
    $.ajax(gs.xsltParams.library_name + "/collection/" + gs.cgiParams.c + "/search/" + gs.cgiParams.s + "?" + searchString + facetQueryString + "excerptid=gs_content")
	.done(function(response)
	        {
		    var $response = $(response);
		    $("#resultsArea").replaceWith($response.find('#resultsArea'));
		    $("#matchdocs").replaceWith($response.find('#matchdocs'));
		    // the term lists don't need to be updated, as we don't get back any term freq info
		    // for facet terms

		    // only replace the facets that haven't been selected
		    var $current_facets = $(".facetContainer");
		 
		    for (var i=0; i<$current_facets.length; i++) {
			var $current = $($current_facets[i]);
			var indexName = $current.attr("indexName");
			
			if (!facetsThatAreChecked.has(indexName)) {
			    var $newNode =$response.find('#'+indexName);
			    $current.replaceWith($newNode);
			    enableMoreButtonIfNeeded(indexName);
			}
		    }

		    if(gs.cgiParams.favouritebasket == "on") {
			// this will highlight the stars on the docs that are in favourites
			favouritesCheckout();
			}
			  if(typeof mapEnabled !== 'undefined') {			      
			      
			      facetedMapSearch(gs.xsltParams.library_name + "/collection/" + gs.cgiParams.c + "/search/" + gs.cgiParams.s + "?" + searchString + facetQueryString);
			      
			  }
		});

}

function updateNextPrevLinks(facetQueryString) {

    if (facetQueryString === undefined) {
	facetQueryString = getFacetQueryString();
    }

    $("#nextTD,#nextArrowTD,#prevTD,#prevArrowTD").children("a").each(function() {
	$(this).attr("href", $(this).attr("href") + "&"+facetQueryString);
    });

}

function performRefinedSearchORIG()
{
	var allCheckBoxes = $("#facetSelector input");
	var counts = new Array();
    for(var i = 0; i < allCheckBoxes.length; i++)
	{
		var current = $(allCheckBoxes[i]);
		if(current.prop("checked"))
		{
		    counts.push(current.parent().parent().attr("indexName") + ":(\"" + current.siblings("span").first().html() + "\")");
		}
	}

	var searchString = "";
	for(var key in gs.cgiParams)
	{
	    if (gs.cgiParams.hasOwnProperty(key))
	    {
		searchString += key.replace(/_/g, ".") + "=" + makeURLComponentSafe(gs.cgiParams[key]) + "&";
		//console.log("PARAM FOR key " + key + ":" + gs.cgiParams[key]);
		//console.log("SAFE PARAM FOR " + key + ":" + makeURLComponentSafe(gs.cgiParams[key]));
	    }
	}
	
	var countsString = "s1.facetQueries=";
	if(counts.length > 0)
	{
		var countsStringBuffer = "[";
		for(var i = 0; i < counts.length; i++)
		{
		    // escape any apostrophes in facet query terms
		    // (ext/solr's Greenstone3SearchHandler does the other half of handling them)
		    //countsStringBuffer += "\"" + encodeURI(counts[i]).replace(/'/g, "%2527") + "\"";
		    // calling makeURLSafe() here will ensure percent signs are escaped away too
		    // by the end of makeURLComponentSafe() call below
		    // Note that apostrophe's in URLs should get encoded, https://www.techwalla.com/articles/how-to-encode-an-apostrophe-in-a-url
		    // though the apostrophe is not in that other list of invalid and unsafe chars in urls dealt with in utility_scripts.js		    
		    countsStringBuffer += "\"" + makeURLSafe(counts[i]).replace(/'/g, "%2527") + "\"";
			if(i < counts.length - 1)
			{
				countsStringBuffer += ", ";
			}
		}
		
	    countsStringBuffer += "]";

	    // We need to ensure that the *value* of s1.facetQueries (so everything after
	    // s1.facetQueries= and before the connecting &) are safe, which requires escaping,
	    // and are further also escaped to not be mistaken for their reserved meaning.
	    // : is a reserved character in URLs, [] are unsafe characters. All need escaping.
	    // So call makeURLComponentSafe(), not makeURLSafe()
	    countsString = countsString + makeURLComponentSafe(countsStringBuffer, 1);
	}
	
	countsString += "&";
	console.log("STRING IS " + countsString);
    
	$.ajax(gs.xsltParams.library_name + "/collection/" + gs.cgiParams.c + "/search/" + gs.cgiParams.s + "?" + searchString + countsString + "excerptid=resultsArea")
		.done(function(response)
	        {
			$("#resultsArea").html("");
			$("#resultsArea").html(response.substring(response.indexOf(">") + 1, response.lastIndexOf("<")));
			if(gs.cgiParams.favouritebasket == "on") {
		            favouritesCheckout(); // called to add back in favourites icons (if favouritebasket active)
			}
			  if(typeof mapEnabled !== 'undefined') {			      
			      
			      facetedMapSearch(gs.xsltParams.library_name + "/collection/" + gs.cgiParams.c + "/search/" + gs.cgiParams.s + "?" + searchString + countsString);
			      
			  }
		});

}
var savedFacetHeight;
function expandFacets(indexname)
{
    var tables = $(".facetTable");
    for(var i = 0; i < tables.length; i++)
    {
        var current = $(tables[i]);
     	if(current.attr("indexname") == indexname)
        {
	    savedFacetHeight = current.css("max-height");
	    current.css("max-height", "none");
	    break;
	}

    }

    var morelink = $(".expandFacetList" + indexname);
    morelink.css("display", "none");
    var lesslink = $(".collapseFacetList" + indexname);
    lesslink.css("display", "block");


}

function collapseFacets(indexname)
{
    console.log("collapse "+indexname);
    var tables = $(".facetTable");

    for(var i = 0; i < tables.length; i++)
    {
        var current = $(tables[i]);
        if(current.attr("indexname") == indexname)
        {
            current.css("max-height", savedFacetHeight);
            break;
	}

    }

    // the above code has hidden both the see more and see less links.
    // display the see more one
    var morelink = $(".expandFacetList" + indexname);
    morelink.css("display", "block");
    var lesslink = $(".collapseFacetList" + indexname);
    lesslink.css("display", "none");

}


    
function expandFacetListORIG(indexName, countSize)
{
	var tables = $(".facetTable");
	
	for(var i = 0; i < tables.length; i++)
	{
		var current = $(tables[i]);
		if(current.attr("indexName") == indexName)
		{
			var items = current.children("li");
			
			for(var j = 0; j < items.length; j++)
			{
				$(items[j]).css("display", "block");
			}
			
			break;
		}
	}
	
    // the above code has made both see more and see less links display=block, so we need to hide
    // see more
    var morelink = $(".expandFacetList" + indexName);
    morelink.css("display", "none");
    var lesslink = $(".collapseFacetList" + indexName);
    lesslink.css("display", "block");


}

function collapseFacetListORIG(indexName, countSize)
{
	var tables = $(".facetTable");
	
	for(var i = 0; i < tables.length; i++)
	{
		var current = $(tables[i]);
		if(current.attr("indexName") == indexName)
		{
			var items = current.children("li");
			
			for(var j = 0; j < items.length; j++)
			{
			    if(j > countSize) 
			    {
				$(items[j]).css("display", "none");
			    }
			}
		    
			break;
		}
	}
	
    // the above code has hidden both the see more and see less links.
    // display the see more one
    var morelink = $(".expandFacetList" + indexName);
    morelink.css("display", "block");
    var lesslink = $(".collapseFacetList" + indexName);
    lesslink.css("display", "none");

}

