/** Javascript file for editing map stuff in a documentediting situation */

var gsmap_store = {};
var gps_metadata_name = "GPS.mapOverlay";

// Called by documentedit_scripts_util.js when saving and rebuilding.
// This function should return all the doc sections' map overlay data so that
// setArchivesMetadata can be called for each and the entire collection rebuilt with the changes
function getDocMapsEditDataForSaving(collName) {
	var map_editors_array = Object.values(gsmap_store);
	var modifiedMaps = []; // the array that is the return value: an array of only all the modified maps
	
	
	for(var i = 0; i < map_editors_array.length; i++) {
		var map_editor = map_editors_array[i];
		var oldMapData = map_editor.savedOverlays; // stringified JSON shape
		var newMapData = JSON.stringify(ShapesUtil.overlayToJSON(map_editor.overlays)); // stringified JSON shape too
		
		// We only consider a map editor's map data to have been modified in the following cases:
		// - if oldMapData is null, new mapData should not be empty array
		// - OR oldMapData had some value and it's not the same as newMapData
		if(!oldMapData && newMapData !== "[]" || oldMapData && oldMapData !== newMapData) {
			var nodeID = map_editors_array[i].id;
			//console.log("old vs new mapdata for nodeID " + nodeID);
			//console.log("OLD: " + oldMapData);
			//console.log("NEW: " + newMapData);
			
			modifiedMaps.push({
				collection: collName,
				docID: nodeID,
				name:gps_metadata_name,
				metapos: 0,
				value:newMapData				
			});
			
			//map_editor.savedOverlays = newMapData;
			// Saving the new overlay values as the old ones, for the state after saving and rebuilding is done,
			// now happens after all setArchivesMeta)_ calls have succeeded,
			// which is just at the start of sendBuildRequest() in documentedit_scripts_util.js::saveAndRebuild()			
		}
		
	}
	
	return modifiedMaps;
}


function addEditMapGPSLink(cell) {
	cell = $(cell);
	var id = cell.attr("id").substring(6);
	//console.log(id);
	var mapGPScontainer = gs.jqGet("map-and-controls-" + id);
	var row = cell.parent();
	var newCell = $("<td>", {
			"style": "font-size:0.7em; padding:0px 10px",
			"class": "editMapGPSButton"
		});
	var linkSpan = $("<span>", {
			"class": "ui-state-default ui-corner-all",
			"style": "padding: 2px; float:left;"
		});

	var linkLabel = $("<span>" + gs.text.de.edit_map_gps + "</span>");
	var linkIcon = $("<span>", {
			"class": "ui-icon ui-icon-folder-collapsed"
		});
	newCell.linkIcon = linkIcon;
	newCell.linkLabel = linkLabel;

	var uList = $("<ul>", {
			"style": "outline: 0 none; margin:0px; padding:0px;"
		});
	var labelItem = $("<li>", {
			"style": "float:left; list-style:none outside none;"
		});
	var iconItem = $("<li>", {
			"style": "float:left; list-style:none outside none;"
		});

	uList.append(iconItem);
	uList.append(labelItem);
	labelItem.append(linkLabel);
	iconItem.append(linkIcon);

	var mapEditor = new MapEditor(id);
	gsmap_store["map-" + id] = mapEditor;
	
	var newLink = $("<a>", {
			"href": "javascript:;"
		});
	newLink.on("click", function () {
		//console.log(" Show/Hide Map Editor ");
		var clicked_mapEditor = gsmap_store["map-" + id];
		
		if (clicked_mapEditor.map == null) {
			clicked_mapEditor.initMapEditorControls();
			clicked_mapEditor.initMapEditor();
		}
		if (mapGPScontainer.css("display") == "none") {
			linkLabel.html(gs.text.de.hide_map_gps);
			linkIcon.attr("class", "ui-icon ui-icon-folder-open");
			mapGPScontainer.css("display", "block");
		} else {
			linkLabel.html(gs.text.de.edit_map_gps);
			linkIcon.attr("class", "ui-icon ui-icon-folder-collapsed");
			mapGPScontainer.css("display", "none");

		}
	});

	newLink.append(uList);
	linkSpan.append(newLink);
	newCell.append(linkSpan);
	row.append(newCell);

	mapGPScontainer.css("display", "none");

}
