#!/bin/bash

# glib2.28.1 was modified for Greenstone to allow compilation to succed on a Mac, so it has acquired a 'gs-' prefix
package=cups
#version=-1.6.3
#version=-1.7
version=-2.2rc1

progname=$0


source ../cascade-make/lib/cascade-lib.bash GEXTGNOME ../.. $*

prefix=$GEXTGNOME_INSTALLED

export CFLAGS="$CFLAGS -I$GEXTGNOME_INSTALLED/include"
export CPPFLAGS="$CPPFLAGS -I$GEXTGNOME_INSTALLED/include"
export CXXFLAGS="$CXXFLAGS -I$GEXTGNOME_INSTALLED/include"
export LDFLAGS="$LDFLAGS -L$GEXTGNOME_INSTALLED/lib"

opt_config_args=
this_os=`uname`
osversion=`uname -r | sed 's/\..*$//'`;
if [ "x$this_os" = "xDarwin" -a $osversion -ge 13 ] ; then
    opt_config_args=--disable-gssapi
fi

#opt_run_untar $force_untar $auto_untar $package $version ".tar.bz2"
opt_run_untar $force_untar $auto_untar $package $version

opt_run_configure $force_config $auto_config $package $version $prefix \
  --disable-launchd --datarootdir=$GEXTGNOME_INSTALLED/etc --with-bundledir=$GEXTGNOME_INSTALLED/etc --with-rcdir=$GEXTGNOME_INSTALLED/etc $opt_config_args

opt_run_make $compile $package $version
opt_run_make $install $package $version "install"
opt_run_make $clean $package $version "clean"
opt_run_make $distclean $package $version "distclean"

opt_run_tarclean $tarclean $package $version
