/**********************************************************************
 *
 * IsisDb.h
 * Copyright (C) 2003  UNESCO
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

////////////////////////////////////////////////////////////
// Isisdb.h : Class Definition for an ISIS db
////////////////////////////////////////////////////////////
 
#ifndef __ISISDB_H__
#define __ISISDB_H__

#include "AbstractIsisDb.h"
#include "IsisDef.h"
#ifndef _MFFILE_H_
#include "MFFile.h"
#endif

 
class IsisDb : public AbstractIsisDb
{
	friend class CDBaseFile;

	bool  bReadOnly_;
    TCHAR xrfname_[_MAX_PATH];
    TCHAR mfname_[_MAX_PATH];
    TCHAR fdtname_[_MAX_PATH];
    TCHAR idxname_[_MAX_PATH];
protected:
   void MkNames();
public:
   IsisDb();
   virtual ~IsisDb( );
   int OpenDb(const TCHAR *fname, FileSystem::AccessMode mode =
	                                          FileSystem::FILE_READWRITE);
   int CreateDb(const TCHAR *fname);


// Closing the database
   virtual void CloseDb();       // Close the db

   virtual void ClearDb()   { }    // Clear the db
   virtual void DestroyDb() { }  // Delete the db

// Recovery
   virtual bool IsDamaged() { return false;}   // Test if the database is damaged
   virtual bool Recover()   { return true; }   // Recover the db

// Transactions
   virtual void BeginTransaction()    { }  // Begin a transaction
   virtual void CommitTRansaction()   { }  // Commit a transaction
   virtual void RollbackTransaction() { }  // Rollback a transaction
   virtual bool InTransaction()       { return false; }  // Test if transaction is pending

   virtual void CreateIndex(int i) { }
   virtual void DropIndex(int i)   { }

   void  CreateDbRecord(MfRecord &m);
   void  CreateDbRecordWithMfn(MfRecord &m);
   void  UpdateDbRecord(MfRecord &m);
   bool  DeleteRecord(mg_s_long mfn);
   int   ReadDbRecord(mg_s_long mfn, MfRecord &m);
   int   ReadNextDbRecord(MfRecord &m);
   void  PrintDbRecord(MfRecord &m);
   void  PrintDbHdr();

   void SetNextMfn(mg_s_long mfn) { mf_->setNextMfn(mfn); }
   mg_s_long GetNextMfn()        { return mf_->GetNextMfn(); }
   mg_s_long GetNextActiveMfn(mg_s_long mfn=-1);

   SMfHeader& GetSMfHeader() { return mf_->GetSMfHeader(); }
   _TCHAR *GetIdxFileName();

   bool IsReadOnly() { return bReadOnly_; }
};
 
//////////////////////////////
 
inline int IsisDb::ReadNextDbRecord(MfRecord &m)
{
   return 1;
}
 
//////////////////////////////
 
inline void  IsisDb::PrintDbRecord(MfRecord &m)
{
   mf_->PrintMfRecord(m);
}
 
//////////////////////////////
 
inline void  IsisDb::PrintDbHdr()
{
   mf_->PrintMfHdr();
}

////////////////////////////////////////////////////////////////////////////////

class IsisDbFactory : public AbstractIsisDbFactory
{
public:
	virtual AbstractIsisDb* MakeIsisDb() { return new IsisDb(); }
};

/////////////////////////////////////////////////////////////////////////////////



#endif
