/** This class is not currently used and therefore will not be compiled by makegli. */

package org.greenstone.gatherer.feedback;

import java.io.*;
import javax.imageio.*;
import java.awt.*;
import java.awt.image.*;
import com.sun.image.codec.jpeg.*;
import javax.swing.*;

/**
 *  CombineGraphs class is a class to combine 2 images file into 1 jpeg file
 *  called test.jpg using point by point comparison.
 *  <p>User need to supplied the valid exist filenames of the 2 images that 
 *  they want to combine.If in any one point in 2nd image file is not transparent
 *  then that point will be drawn to the 1st image file.</p>  
 *  <p>To run this class properly the format is :
 *  <br><i>java CombineGraphs filename1 filename2</i>
 *  <br>where filename1 is the names of the first image file.
 *  <br>and filename2 is the names of the second image file. This file must
 *  contains transparent.</p>
 *  <p>For example: If user wants to combine the screenshot image file with the
 *  image file of the scribble lines, then
 *  <br>filename1 will be the filename of the screenshot image file, and
 *  <br>filename2 will be the filename of the scribble lines image file.</p>
 *
 *  @author Veronica Liesaputra
 */

public class CombineGraphs extends JPanel
{
    /**
     * This is a variable to stored the image that is stored inside f1.
     * After the combine method called this variable will store the resulted image of
     * combining 2 images together.
     */
    private BufferedImage bi1;

    /**
     * This is a variable to stored the image that is stored inside f2.
     */
    private BufferedImage bi2;

    /**
     * This is a variable to stored the first image file that the user supplied.
     */
    private File f1;

    /**
     * This is a variable to stored the second image file that the user supplied.
     */
    private File f2;
    
    /**
     * It will read the image files user supplied and stored the image
     * to the appropriate bufferedimage variable.
     * (Precondition: (file1 != null) && (file2 != null))
     * @param file1   the name of the first image file.
     * @param file2   the name of the second image file.
     */
    public CombineGraphs(String file1,String file2)
    {
	try
	    {
		f1 = new File(file1);
		f2 = new File(file2);
		bi1 = ImageIO.read(f1);
		bi2 = ImageIO.read(f2);	
	    }
	catch(IOException exp) {}
    }   

    /**
     * This method will combine the 2 buffered images into 1 buffered image and 
     * saved it to an output file in jpeg format.
     * (Precondition: (filename != null))
     * @param filename the name of the output file.
     * (Postcondition: the combined image is stored in a jpeg file with the name
     *                 as specified in filename.)
     */
    public void combine(String filename)
    {

	/*using bi1 as the base layer that we use to compare point by point with bi2. 
	  if in one point in bi2 its not transparent then we draw that point to bi1.*/ 
	Graphics2D G1;
	
	G1 = bi1.createGraphics();
	
	int width = bi2.getWidth();
	int height = bi2.getHeight();

	for (int y = 0 ; y < height ; y++) 
	    {
		for (int x = 0 ; x < width ; x++)
		    {
			int rgb = bi2.getRGB(x,y);
			if (rgb != 0)
			    {
				G1.setColor(new Color(rgb,true));
				G1.drawLine(x,y,x,y);
			    }
		    }
	    }
	
	// Save the combined bufferedimage into a jpeg output file.
	try {
	    File file = new File(filename);
	    FileOutputStream out = new FileOutputStream(file);
	    
	    JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out);
	    JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bi1);
	    param.setQuality(1.0f, false);
	    encoder.setJPEGEncodeParam(param);
	    encoder.encode(bi1);
	    
	} catch (Exception ex) {}
    }

    /**
     * This the main method that need 2 inputs from the user for it to
     * work properly. 
     * The inputs are the 2 image filenames that user want to combine.
     */
    public static void main (String[] args)
    {
	CombineGraphs cb = new CombineGraphs(args[0],args[1]);
	cb.combine("test.jpg");
    }
}







