#!/bin/bash

# Based on details at:
#    https://docs.pega.com/security/86/creating-keystorejks-and-truststorejks-files

echo ""
echo "Removing keystore and truststore"
rm -f ssl/gs3-webswing-{keystore,truststore}.jks gs3-webswing-truststore.cer

echo ""
echo "Generating self-signed certificate in keystore"
keytool -genkey -alias gs3-ws-server \
	-keyalg RSA -keysize 2048 -keypass 123123 \
	-dname "cn=localhost, ou=GreenstoneDL, o=www.greenstone.org, l=Waikato, c=NZ" \
	-validity 999999 \
	-keystore ssl/gs3-webswing-keystore.jks \
	-storepass 123123

echo ""
echo "Exporting certificate from keystore"
keytool -export -alias gs3-ws-server \
	-file gs3-webswing-keystore.cer \
	-keystore ssl/gs3-webswing-keystore.jks \
	-storepass 123123

echo ""
echo "Importing certificate into Truststore"
keytool -import -alias gs3-ws-client \
	-file gs3-webswing-keystore.cer \
	-keystore ssl/gs3-webswing-truststore.jks \
	-storepass 123123 -storetype JKS \
	-noprompt

