/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import jdbm.recman.BlockIo;
import jdbm.recman.FreeLogicalRowIdPage;
import jdbm.recman.Location;
import jdbm.recman.PageCursor;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowId;
import jdbm.recman.RecordFile;

final class FreeLogicalRowIdPageManager {
    private RecordFile file;
    private PageManager pageman;

    FreeLogicalRowIdPageManager(RecordFile recordFile, PageManager pageManager) throws IOException {
        this.file = recordFile;
        this.pageman = pageManager;
    }

    Location get() throws IOException {
        Location location = null;
        PageCursor pageCursor = new PageCursor(this.pageman, 3);
        while (pageCursor.next() != 0L) {
            FreeLogicalRowIdPage freeLogicalRowIdPage = FreeLogicalRowIdPage.getFreeLogicalRowIdPageView(this.file.get(pageCursor.getCurrent()));
            int n = freeLogicalRowIdPage.getFirstAllocated();
            if (n != -1) {
                location = new Location(freeLogicalRowIdPage.get(n));
                freeLogicalRowIdPage.free(n);
                if (freeLogicalRowIdPage.getCount() == 0) {
                    this.file.release(pageCursor.getCurrent(), false);
                    this.pageman.free((short)3, pageCursor.getCurrent());
                } else {
                    this.file.release(pageCursor.getCurrent(), true);
                }
                return location;
            }
            this.file.release(pageCursor.getCurrent(), false);
        }
        return null;
    }

    void put(Location location) throws IOException {
        FreeLogicalRowIdPage freeLogicalRowIdPage;
        BlockIo blockIo;
        PhysicalRowId physicalRowId = null;
        PageCursor pageCursor = new PageCursor(this.pageman, 3);
        long l = 0L;
        while (pageCursor.next() != 0L) {
            l = pageCursor.getCurrent();
            blockIo = this.file.get(l);
            freeLogicalRowIdPage = FreeLogicalRowIdPage.getFreeLogicalRowIdPageView(blockIo);
            int n = freeLogicalRowIdPage.getFirstFree();
            if (n != -1) {
                physicalRowId = freeLogicalRowIdPage.alloc(n);
                break;
            }
            this.file.release(blockIo);
        }
        if (physicalRowId == null) {
            l = this.pageman.allocate((short)3);
            blockIo = this.file.get(l);
            freeLogicalRowIdPage = FreeLogicalRowIdPage.getFreeLogicalRowIdPageView(blockIo);
            physicalRowId = freeLogicalRowIdPage.alloc(0);
        }
        physicalRowId.setBlock(location.getBlock());
        physicalRowId.setOffset(location.getOffset());
        this.file.release(l, true);
    }
}

