/*
 * Decompiled with CFR 0.152.
 */
package jdbm;

import java.io.IOException;
import java.util.Properties;
import jdbm.RecordManager;
import jdbm.RecordManagerProvider;

public final class RecordManagerFactory {
    public static RecordManager createRecordManager(String string) throws IOException {
        return RecordManagerFactory.createRecordManager(string, new Properties());
    }

    public static RecordManager createRecordManager(String string, Properties properties) throws IOException {
        RecordManagerProvider recordManagerProvider;
        String string2 = properties.getProperty("jdbm.provider", "jdbm.recman.Provider");
        try {
            Class<?> clazz = Class.forName(string2);
            recordManagerProvider = (RecordManagerProvider)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid record manager provider: " + string2 + "\n[" + exception.getClass().getName() + ": " + exception.getMessage() + "]");
        }
        return recordManagerProvider.createRecordManager(string, properties);
    }
}

