/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.xbm;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.util.x11.XbmParser;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.io.InputStream;

public class XBMDecoder
extends JimiDecoderBase {
    protected XbmParser parser_;
    protected AdaptiveRasterImage jimiImage_;
    protected int state_;
    protected InputStream input_;
    protected byte[] pixels_;

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) {
        this.parser_ = new XbmParser(inputStream);
        this.jimiImage_ = adaptiveRasterImage;
        this.input_ = inputStream;
        this.state_ = 0;
    }

    public boolean driveDecoder() throws JimiException {
        if (!this.parser_.parse()) {
            throw new JimiException("Image does not parse.");
        }
        XBMDecoder xBMDecoder = this;
        xBMDecoder.m1(xBMDecoder.parser_.getWidth(), this.parser_.getHeight(), this.parser_.getBitmap(), Color.black, Color.white, true);
        this.state_ = 4;
        this.jimiImage_.addFullCoverage();
        return false;
    }

    public int getState() {
        return this.state_;
    }

    public void freeDecoder() {
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.jimiImage_;
    }

    private void m1(int n, int n2, int[] nArray, Color color, Color color2, boolean bl) throws JimiException {
        int n3 = n;
        int n4 = n2;
        byte[] byArray = new byte[6];
        int n5 = -1;
        if (bl) {
            n5 = 0;
            byArray[0] = -1;
            byArray[1] = -1;
            byArray[2] = -1;
        } else {
            byArray[0] = (byte)color2.getRed();
            byArray[1] = (byte)color2.getGreen();
            byArray[2] = (byte)color2.getBlue();
        }
        byArray[3] = (byte)color.getRed();
        byArray[4] = (byte)color.getGreen();
        byArray[5] = (byte)color.getBlue();
        IndexColorModel indexColorModel = new IndexColorModel(8, 2, byArray, 0, false, n5);
        this.pixels_ = new byte[n3 * n4];
        int n6 = 0;
        int n7 = 0;
        int n8 = n3 >> 3;
        try {
            int n9 = 0;
            while (n9 < n4) {
                int n10 = 0;
                while (n10 < n8) {
                    byte by = (byte)nArray[n7];
                    int n11 = 0;
                    while (n11 < 8) {
                        int n12 = by & 1 << n11;
                        this.pixels_[n6] = n12 != 0 ? (byte)1 : 0;
                        ++n6;
                        ++n11;
                    }
                    ++n7;
                    ++n10;
                }
                ++n9;
            }
        }
        catch (Exception exception) {
            throw new JimiException(exception.getMessage());
        }
        this.jimiImage_.setSize(n3, n4);
        this.jimiImage_.setColorModel(indexColorModel);
        this.jimiImage_.setPixels();
        this.jimiImage_.setChannel(0, 0, 0, n3, n4, this.pixels_, 0, n3);
        this.setProgress(100);
    }
}

