/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.gif;

import com.sun.jimi.core.decoder.gif.GIFColorTable;
import com.sun.jimi.core.util.LEDataInputStream;
import java.io.IOException;

public class GIFImageDescriptor {
    static final int LOCAL_CT_FLAG = 128;
    static final int INTERLACE_FLAG = 64;
    static final int SORT_FLAG = 32;
    static final int RESERVED = 24;
    static final int LOCAL_CT_SIZE = 7;
    int left;
    int top;
    int width;
    int height;
    byte packed;
    int colorTableNumBits;
    boolean interlace;
    GIFColorTable colorTable;

    public String toString() {
        return "GIF Image Descriptor " + this.left + " " + this.top + " " + this.width + " " + this.height + " interlace " + this.interlace;
    }

    public GIFImageDescriptor(LEDataInputStream lEDataInputStream) throws IOException {
        this.left = lEDataInputStream.readUnsignedShort();
        this.top = lEDataInputStream.readUnsignedShort();
        this.width = lEDataInputStream.readUnsignedShort();
        this.height = lEDataInputStream.readUnsignedShort();
        this.packed = lEDataInputStream.readByte();
        if ((this.packed & 0x80) != 0) {
            this.colorTableNumBits = (this.packed & 7) + 1;
            this.colorTable = new GIFColorTable(lEDataInputStream, this.colorTableNumBits);
        } else {
            this.colorTableNumBits = 0;
        }
        this.interlace = (this.packed & 0x40) != 0;
    }
}

