/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.utils.Constants;
import org.apache.xml.security.utils.I18n;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$utils$XMLUtils == null ? (class$org$apache$xml$security$utils$XMLUtils = XMLUtils.class$("org.apache.xml.security.utils.XMLUtils")) : class$org$apache$xml$security$utils$XMLUtils).getName());
    private static String[] nodeTypeString = new String[]{"", "ELEMENT", "ATTRIBUTE", "TEXT_NODE", "CDATA_SECTION", "ENTITY_REFERENCE", "ENTITY", "PROCESSING_INSTRUCTION", "COMMENT", "DOCUMENT", "DOCUMENT_TYPE", "DOCUMENT_FRAGMENT", "NOTATION"};
    static /* synthetic */ Class class$org$apache$xml$security$utils$XMLUtils;
    static /* synthetic */ Class class$java$lang$Thread;

    private XMLUtils() {
    }

    public static void getSet(Node node, Set set, Node node2, boolean bl) {
        if (node2 != null && XMLUtils.isDescendantOrSelf(node2, node)) {
            return;
        }
        XMLUtils.getSetRec(node, set, node2, bl);
    }

    static final void getSetRec(Node node, Set set, Node node2, boolean bl) {
        if (node == node2) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                Object object;
                set.add(node);
                Element element = (Element)node;
                if (element.hasAttributes()) {
                    object = ((Element)node).getAttributes();
                    for (int i = 0; i < object.getLength(); ++i) {
                        set.add(object.item(i));
                    }
                }
            }
            case 9: {
                Object object;
                for (object = node.getFirstChild(); object != null; object = object.getNextSibling()) {
                    if (object.getNodeType() == 3) {
                        set.add(object);
                        while (object != null && object.getNodeType() == 3) {
                            object = object.getNextSibling();
                        }
                        if (object == null) {
                            return;
                        }
                    }
                    XMLUtils.getSetRec((Node)object, set, node2, bl);
                }
                return;
            }
            case 8: {
                if (bl) {
                    set.add(node);
                }
                return;
            }
            case 10: {
                return;
            }
        }
        set.add(node);
    }

    public static String getXalanVersion() {
        String string = XMLUtils.getXalan1Version();
        if (string != null) {
            return string;
        }
        string = XMLUtils.getXalan20Version();
        if (string != null) {
            return string;
        }
        string = XMLUtils.getXalan2Version();
        if (string != null) {
            return string;
        }
        return "Apache Xalan not installed";
    }

    public static String getXercesVersion() {
        String string = XMLUtils.getXerces1Version();
        if (string != null) {
            return string;
        }
        string = XMLUtils.getXerces2Version();
        if (string != null) {
            return string;
        }
        return "Apache Xerces not installed";
    }

    private static String getXalan1Version() {
        try {
            Class clazz = XMLUtils.classForName("org.apache.xalan.xslt.XSLProcessorVersion");
            StringBuffer stringBuffer = new StringBuffer();
            Field field = clazz.getField("PRODUCT");
            stringBuffer.append(field.get(null));
            stringBuffer.append(';');
            field = clazz.getField("LANGUAGE");
            stringBuffer.append(field.get(null));
            stringBuffer.append(';');
            field = clazz.getField("S_VERSION");
            stringBuffer.append(field.get(null));
            stringBuffer.append(';');
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getXalan20Version() {
        try {
            Class[] classArray = new Class[]{};
            Class clazz = XMLUtils.classForName("org.apache.xalan.Version");
            Method method = clazz.getMethod("getVersion", classArray);
            Object object = method.invoke(null, new Object[0]);
            return (String)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getXalan2Version() {
        try {
            Class clazz = XMLUtils.classForName("org.apache.xalan.processor.XSLProcessorVersion");
            StringBuffer stringBuffer = new StringBuffer();
            Field field = clazz.getField("S_VERSION");
            stringBuffer.append(field.get(null));
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getXerces1Version() {
        try {
            Class clazz = XMLUtils.classForName("org.apache.xerces.framework.Version");
            Field field = clazz.getField("fVersion");
            String string = (String)field.get(null);
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getXerces2Version() {
        try {
            Class clazz = XMLUtils.classForName("org.apache.xerces.impl.Version");
            Field field = clazz.getField("fVersion");
            String string = (String)field.get(null);
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Class classForName(String string) throws ClassNotFoundException {
        ClassLoader classLoader = XMLUtils.findClassLoader();
        if (classLoader == null) {
            return Class.forName(string);
        }
        return classLoader.loadClass(string);
    }

    protected static ClassLoader findClassLoader() {
        Method method = null;
        try {
            method = (class$java$lang$Thread == null ? (class$java$lang$Thread = XMLUtils.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return (class$org$apache$xml$security$utils$XMLUtils == null ? (class$org$apache$xml$security$utils$XMLUtils = XMLUtils.class$("org.apache.xml.security.utils.XMLUtils")) : class$org$apache$xml$security$utils$XMLUtils).getClassLoader();
        }
        try {
            return (ClassLoader)method.invoke((Object)Thread.currentThread(), new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static void spitOutVersions(Log log) {
        if (log.isDebugEnabled()) {
            log.debug((Object)XMLUtils.getXercesVersion());
            log.debug((Object)XMLUtils.getXalanVersion());
        }
    }

    public static String getNodeTypeString(short s) {
        if (s > 0 && s < 13) {
            return nodeTypeString[s];
        }
        return "";
    }

    public static void outputDOM(Node node, OutputStream outputStream) {
        XMLUtils.outputDOM(node, outputStream, false);
    }

    public static void outputDOM(Node node, OutputStream outputStream, boolean bl) {
        try {
            if (bl) {
                outputStream.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
            }
            outputStream.write(Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(node));
        }
        catch (IOException iOException) {
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            invalidCanonicalizerException.printStackTrace();
        }
        catch (CanonicalizationException canonicalizationException) {
            canonicalizationException.printStackTrace();
        }
    }

    public static void outputDOMc14nWithComments(Node node, OutputStream outputStream) {
        try {
            outputStream.write(Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(node));
        }
        catch (IOException iOException) {
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
        }
        catch (CanonicalizationException canonicalizationException) {
            // empty catch block
        }
    }

    public static String getFullTextChildrenFromElement(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            stringBuffer.append(((Text)node).getData());
        }
        return stringBuffer.toString();
    }

    public static Element createElementInSignatureSpace(Document document, String string) {
        if (document == null) {
            throw new RuntimeException("Document is null");
        }
        String string2 = Constants.getSignatureSpecNSprefix();
        if (string2 == null || string2.length() == 0) {
            Element element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", string);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
            return element;
        }
        Element element = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", string2 + ":" + string);
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, "http://www.w3.org/2000/09/xmldsig#");
        return element;
    }

    public static boolean elementIsInSignatureSpace(Element element, String string) {
        if (element == null || !"http://www.w3.org/2000/09/xmldsig#".equals(element.getNamespaceURI())) {
            return false;
        }
        return element.getLocalName().equals(string);
    }

    public static boolean elementIsInEncryptionSpace(Element element, String string) {
        if (element == null || !"http://www.w3.org/2001/04/xmlenc#".equals(element.getNamespaceURI())) {
            return false;
        }
        return element.getLocalName().equals(string);
    }

    public static Document getOwnerDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        try {
            return node.getOwnerDocument();
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException(I18n.translate("endorsed.jdk1.4.0") + " Original message was \"" + nullPointerException.getMessage() + "\"");
        }
    }

    public static Document getOwnerDocument(Set set) {
        NullPointerException nullPointerException = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            short s = node.getNodeType();
            if (s == 9) {
                return (Document)node;
            }
            try {
                if (s == 2) {
                    return ((Attr)node).getOwnerElement().getOwnerDocument();
                }
                return node.getOwnerDocument();
            }
            catch (NullPointerException nullPointerException2) {
                nullPointerException = nullPointerException2;
            }
        }
        throw new NullPointerException(I18n.translate("endorsed.jdk1.4.0") + " Original message was \"" + (nullPointerException == null ? "" : nullPointerException.getMessage()) + "\"");
    }

    public static Element createDSctx(Document document, String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("You must supply a prefix");
        }
        Element element = document.createElementNS(null, "namespaceContext");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string.trim(), string2);
        return element;
    }

    public static void addReturnToElement(Element element) {
        Document document = element.getOwnerDocument();
        element.appendChild(document.createTextNode("\n"));
    }

    public static Set convertNodelistToSet(NodeList nodeList) {
        if (nodeList == null) {
            return new HashSet();
        }
        int n = nodeList.getLength();
        HashSet<Node> hashSet = new HashSet<Node>(n);
        for (int i = 0; i < n; ++i) {
            hashSet.add(nodeList.item(i));
        }
        return hashSet;
    }

    public static void circumventBug2650(Document document) {
        Element element = document.getDocumentElement();
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        if (attr == null) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
        XMLUtils.circumventBug2650recurse(document);
    }

    private static void circumventBug2650recurse(Node node) {
        Node node2;
        if (node.getNodeType() == 1 && (node2 = (Element)node).hasChildNodes() && node2.hasAttributes()) {
            NamedNodeMap namedNodeMap = node2.getAttributes();
            int n = namedNodeMap.getLength();
            for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                if (node3.getNodeType() != 1) continue;
                Element element = (Element)node3;
                for (int i = 0; i < n; ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || element.hasAttributeNS("http://www.w3.org/2000/xmlns/", attr.getLocalName())) continue;
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", attr.getName(), attr.getNodeValue());
                }
            }
        }
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: 
                case 5: 
                case 9: {
                    XMLUtils.circumventBug2650recurse(node2);
                }
            }
        }
    }

    public static Element selectDsNode(Node node, String string, int n) {
        while (node != null) {
            if (string.equals(node.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(node.getNamespaceURI())) {
                if (n == 0) {
                    return (Element)node;
                }
                --n;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static Element selectXencNode(Node node, String string, int n) {
        while (node != null) {
            if (string.equals(node.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI())) {
                if (n == 0) {
                    return (Element)node;
                }
                --n;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static Text selectDsNodeText(Node node, String string, int n) {
        Node node2 = XMLUtils.selectDsNode(node, string, n);
        if (node2 == null) {
            return null;
        }
        for (node2 = node2.getFirstChild(); node2 != null && node2.getNodeType() != 3; node2 = node2.getNextSibling()) {
        }
        return (Text)node2;
    }

    public static Text selectNodeText(Node node, String string, String string2, int n) {
        Node node2 = XMLUtils.selectNode(node, string, string2, n);
        if (node2 == null) {
            return null;
        }
        for (node2 = node2.getFirstChild(); node2 != null && node2.getNodeType() != 3; node2 = node2.getNextSibling()) {
        }
        return (Text)node2;
    }

    public static Element selectNode(Node node, String string, String string2, int n) {
        while (node != null) {
            if (string2.equals(node.getLocalName()) && string.equals(node.getNamespaceURI())) {
                if (n == 0) {
                    return (Element)node;
                }
                --n;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static Element[] selectDsNodes(Node node, String string) {
        return XMLUtils.selectNodes(node, "http://www.w3.org/2000/09/xmldsig#", string);
    }

    public static Element[] selectNodes(Node node, String string, String string2) {
        int n = 20;
        Element[] elementArray = new Element[n];
        int n2 = 0;
        while (node != null) {
            if (string2.equals(node.getLocalName()) && string.equals(node.getNamespaceURI())) {
                elementArray[n2++] = (Element)node;
                if (n <= n2) {
                    int n3 = n << 2;
                    Element[] elementArray2 = new Element[n3];
                    System.arraycopy(elementArray, 0, elementArray2, 0, n);
                    elementArray = elementArray2;
                    n = n3;
                }
            }
            node = node.getNextSibling();
        }
        Element[] elementArray3 = new Element[n2];
        System.arraycopy(elementArray, 0, elementArray3, 0, n2);
        return elementArray3;
    }

    public static Set excludeNodeFromSet(Node node, Set set) {
        HashSet<Node> hashSet = new HashSet<Node>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            if (XMLUtils.isDescendantOrSelf(node, node2)) continue;
            hashSet.add(node2);
        }
        return hashSet;
    }

    static boolean isDescendantOrSelf(Node node, Node node2) {
        if (node == node2) {
            return true;
        }
        Node node3 = node2;
        while (node3 != null) {
            if (node3 == node) {
                return true;
            }
            if (node3.getNodeType() == 2) {
                node3 = ((Attr)node3).getOwnerElement();
                continue;
            }
            node3 = node3.getParentNode();
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

