/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.anttasks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.greenstone.anttasks.InsertUniqueValueJob;

public class InsertUniqueValue
extends Task {
    private File file = null;
    private ArrayList jobs = null;
    private FileSet fileset = null;
    private String pattern = null;
    private int fromLine = -1;
    private int toLine = -1;
    private boolean winPath = false;
    private int count = 0;

    public static void main(String[] stringArray) {
        InsertUniqueValue insertUniqueValue = new InsertUniqueValue();
        insertUniqueValue.setFile(new File(stringArray[0]));
        insertUniqueValue.setPattern(stringArray[1]);
        insertUniqueValue.setLines(stringArray[3]);
        insertUniqueValue.execute();
    }

    public void execute() {
        int n;
        if (this.file == null && this.fileset == null) {
            throw new BuildException("Error - No file or fileset specified !!");
        }
        if (this.file != null && !this.file.exists()) {
            throw new BuildException("Error - File not found !!");
        }
        DirectoryScanner directoryScanner = null;
        if (this.fileset != null) {
            directoryScanner = this.fileset.getDirectoryScanner(this.project);
            directoryScanner.scan();
        }
        if (this.jobs == null && this.pattern == null) {
            throw new BuildException("Error - No pattern attribute and no nested jobs !!");
        }
        if (this.jobs != null && this.pattern != null) {
            throw new BuildException("Error - Both pattern attribute and nested jobs given !!");
        }
        if (this.jobs != null) {
            for (int i = 0; i < this.jobs.size(); ++i) {
                if (((InsertUniqueValueJob)((Object)this.jobs.get(i))).getPattern() != null) continue;
                throw new BuildException("Error - One of the jobs lacks a pattern!!");
            }
        }
        File[] fileArray = null;
        if (this.file != null) {
            fileArray = new File[]{this.file};
        } else {
            String[] stringArray = directoryScanner.getIncludedFiles();
            fileArray = new File[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                fileArray[n] = new File(directoryScanner.getBasedir() + File.separator + stringArray[n]);
            }
        }
        System.out.println("-------------------");
        System.out.println(" InsertUniqueValue ");
        System.out.println("-------------------");
        if (this.fromLine != -1 || this.toLine != -1) {
            System.out.println("Lines: " + (this.fromLine == -1 ? "Start" : Integer.toString(this.fromLine)) + " ~ " + (this.toLine == -1 ? "End" : Integer.toString(this.toLine)));
            System.out.println();
        }
        System.out.println("Files: ");
        for (int i = 0; i < fileArray.length; ++i) {
            FileOutputStream fileOutputStream;
            Object object;
            n = 0;
            File file = fileArray[i];
            System.out.println(" " + file);
            BufferedWriter bufferedWriter = null;
            File file2 = null;
            try {
                file2 = File.createTempFile("iuv", ".tmp");
                file2.deleteOnExit();
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF8"));
            }
            catch (IOException iOException) {
                throw new BuildException("Error - Couldn't create or open the temp file");
            }
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            }
            catch (Exception exception) {
                throw new BuildException("Error - Couldn't open the specified file");
            }
            String string = null;
            int n2 = 1;
            boolean bl = true;
            while (bl) {
                try {
                    string = bufferedReader.readLine();
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                    throw new BuildException("Error - Couldn't read from the specified file");
                }
                if (string == null) {
                    bl = false;
                } else {
                    if (!(this.fromLine != -1 && n2 < this.fromLine || this.toLine != -1 && n2 >= this.toLine)) {
                        int n3;
                        int n4;
                        object = string;
                        if (this.pattern != null) {
                            n4 = 0;
                            n3 = 0;
                            StringBuffer stringBuffer = new StringBuffer();
                            while ((n4 = string.indexOf(this.pattern, n4)) != -1) {
                                stringBuffer.append(string.substring(n3, n4));
                                stringBuffer.append(this.pattern + this.count++);
                                n3 = n4 += this.pattern.length();
                            }
                            stringBuffer.append(string.substring(n3, string.length()));
                            string = stringBuffer.toString();
                        } else {
                            for (n4 = 0; n4 < this.jobs.size(); ++n4) {
                                n3 = 0;
                                int n5 = 0;
                                StringBuffer stringBuffer = new StringBuffer();
                                String string2 = ((InsertUniqueValueJob)((Object)this.jobs.get(n4))).getPattern();
                                while ((n3 = string.indexOf(string2, n3)) != -1) {
                                    stringBuffer.append(string.substring(n5, n3));
                                    stringBuffer.append(string2 + this.count++);
                                    n5 = n3 += string2.length();
                                }
                                stringBuffer.append(string.substring(n5, string.length()));
                                string = stringBuffer.toString();
                            }
                        }
                        if (!((String)object).equals(string)) {
                            ++n;
                        }
                    }
                    try {
                        bufferedWriter.write(string);
                        bufferedWriter.newLine();
                    }
                    catch (Exception exception) {
                        throw new BuildException("Error - Couldn't write to the temp file");
                    }
                }
                ++n2;
            }
            try {
                bufferedReader.close();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                throw new BuildException("Error - Couldn't close a file");
            }
            try {
                object = new FileInputStream(file2);
                fileOutputStream = new FileOutputStream(file);
            }
            catch (Exception exception) {
                throw new BuildException("Error - Couldn't open the temp file");
            }
            try {
                int n6;
                byte[] byArray = new byte[1024];
                while ((n6 = ((InputStream)object).read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n6);
                }
                ((InputStream)object).close();
                ((OutputStream)fileOutputStream).close();
            }
            catch (Exception exception) {
                throw new BuildException("Error - Couldn't write to the specified file");
            }
            if (n == 0) {
                System.out.println(" No Changes Made");
            } else if (n == 1) {
                System.out.println(" Successfully changed 1 line");
            } else {
                System.out.println(" Successfully changed " + n + " lines");
            }
            System.out.println();
        }
    }

    public void setFile(File file) {
        if (this.fileset != null || this.file != null) {
            throw new BuildException("Error - Only one file or one fileset may be given!!");
        }
        this.file = file;
    }

    public void setLines(String string) {
        string.replaceAll("\\s", "");
        if (string == "") {
            throw new BuildException("Error - no line number(s) given in lines attribute!! ");
        }
        String[] stringArray = string.split("-", 2);
        try {
            if (stringArray.length == 1) {
                this.fromLine = Integer.parseInt(stringArray[0]);
                this.toLine = this.fromLine + 1;
            } else {
                if (!stringArray[0].equals("")) {
                    this.fromLine = Integer.parseInt(stringArray[0]);
                }
                if (!stringArray[1].equals("")) {
                    this.toLine = Integer.parseInt(stringArray[1]);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException("Error - invalid line numbers given in lines attribute!! '" + stringArray[0] + "' - '" + stringArray[1] + "'");
        }
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setWinPath(boolean bl) {
        this.winPath = bl;
    }

    public InsertUniqueValueJob createJob() {
        InsertUniqueValueJob insertUniqueValueJob = new InsertUniqueValueJob();
        if (this.jobs == null) {
            this.jobs = new ArrayList();
        }
        this.jobs.add(insertUniqueValueJob);
        return insertUniqueValueJob;
    }

    public FileSet createFileset() {
        if (this.fileset != null || this.file != null) {
            throw new BuildException("Error - Only one file or one fileset may be given!!");
        }
        this.fileset = new FileSet();
        return this.fileset;
    }
}

