/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.security.modules;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.common.service.security.AbstractWebswingUser;
import org.webswing.server.common.service.security.AuthenticatedWebswingUser;
import org.webswing.server.services.security.api.LoginResponseClosedException;
import org.webswing.server.services.security.api.WebswingAuthenticationException;
import org.webswing.server.services.security.extension.api.BuiltInModuleExtensions;
import org.webswing.server.services.security.extension.api.SecurityModuleExtension;
import org.webswing.server.services.security.extension.api.SecurityModuleExtensionConfig;
import org.webswing.server.services.security.extension.api.WebswingExtendableSecurityModuleConfig;
import org.webswing.server.services.security.modules.AbstractSecurityModule;

public abstract class AbstractExtendableSecurityModule<T extends WebswingExtendableSecurityModuleConfig>
extends AbstractSecurityModule<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractExtendableSecurityModule.class);
    private List<SecurityModuleExtension<?>> extensions = new ArrayList();

    public AbstractExtendableSecurityModule(T config) {
        super(config);
    }

    @Override
    public void init() {
        super.init();
        if (((WebswingExtendableSecurityModuleConfig)this.getConfig()).getExtensions() != null) {
            for (String extensionName : ((WebswingExtendableSecurityModuleConfig)this.getConfig()).getExtensions()) {
                SecurityModuleExtension extension = null;
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                try {
                    Class<?> extensionClass = cl.loadClass(BuiltInModuleExtensions.getExtensionClassName(extensionName));
                    Constructor<?> defaultConstructor = null;
                    Constructor<?> configConstructor = null;
                    for (Constructor<?> constructor : extensionClass.getConstructors()) {
                        Class<?>[] parameterTypes = constructor.getParameterTypes();
                        if (parameterTypes.length == 1) {
                            if (!SecurityModuleExtensionConfig.class.isAssignableFrom(parameterTypes[0])) continue;
                            configConstructor = constructor;
                            break;
                        }
                        if (parameterTypes.length != 0) continue;
                        defaultConstructor = constructor;
                    }
                    if (configConstructor != null) {
                        Class<?> configClass = configConstructor.getParameterTypes()[0];
                        try {
                            extension = (SecurityModuleExtension)configConstructor.newInstance(((WebswingExtendableSecurityModuleConfig)this.getConfig()).getValueAs(extensionName, configClass));
                        }
                        catch (Exception e) {
                            log.error("Could not construct security module extension class (using SecurityModuleExtensionConfig constructor).", e);
                        }
                    }
                    if (extension == null && defaultConstructor != null) {
                        try {
                            extension = (SecurityModuleExtension)defaultConstructor.newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            log.error("Could not construct security module extension class (using Default constructor).", e);
                        }
                    }
                    if (extension == null) continue;
                    this.extensions.add(extension);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Failed to load Security module extensions.", e);
                }
            }
        }
    }

    @Override
    public AuthenticatedWebswingUser doLogin(HttpServletRequest request, HttpServletResponse response, String securedPath) throws IOException {
        for (SecurityModuleExtension<?> extension : this.extensions) {
            try {
                AuthenticatedWebswingUser result = extension.doSufficientPreValidation(this, request, response);
                if (result == null) continue;
                this.onAuthenticationSuccess(result, request, response, securedPath);
                return result;
            }
            catch (WebswingAuthenticationException e) {
                log.error("Extension failed to authenticate:", e);
            }
            catch (LoginResponseClosedException e) {
                return null;
            }
        }
        return super.doLogin(request, response, securedPath);
    }

    @Override
    protected void preVerify(HttpServletRequest request, HttpServletResponse response) throws WebswingAuthenticationException, LoginResponseClosedException {
        int sessionContexts = ((WebswingExtendableSecurityModuleConfig)this.getConfig()).getContext().getAuthenticatedUsersCount();
        int maxSecurityContextsPerSession = ((WebswingExtendableSecurityModuleConfig)this.getConfig()).getContext().getMaxSecurityContextsPerSession();
        if (maxSecurityContextsPerSession > 0 && sessionContexts >= maxSecurityContextsPerSession) {
            throw new WebswingAuthenticationException("Too many active sessions!", "login.tooManySessionContexts");
        }
        for (SecurityModuleExtension<?> extension : this.extensions) {
            try {
                extension.doRequiredPreValidation(this, request, response);
            }
            catch (WebswingAuthenticationException e) {
                throw e;
            }
            catch (LoginResponseClosedException e) {
                throw e;
            }
        }
    }

    @Override
    protected void postVerify(AuthenticatedWebswingUser user, HttpServletRequest request, HttpServletResponse response) throws LoginResponseClosedException, WebswingAuthenticationException {
        for (SecurityModuleExtension<?> extension : this.extensions) {
            try {
                extension.doRequiredPostValidation(this, user, request, response);
            }
            catch (WebswingAuthenticationException e) {
                throw e;
            }
            catch (LoginResponseClosedException e) {
                throw e;
            }
        }
    }

    @Override
    protected AuthenticatedWebswingUser decorateUser(AuthenticatedWebswingUser user, HttpServletRequest request, HttpServletResponse response) {
        for (SecurityModuleExtension<?> extension : this.extensions) {
            user = extension.decorateUser(user, request, response);
        }
        return user;
    }

    @Override
    protected void serveAuthenticated(AbstractWebswingUser user, String path, HttpServletRequest req, HttpServletResponse res) {
        SecurityModuleExtension<?> extension;
        boolean served;
        Iterator<SecurityModuleExtension<?>> iterator = this.extensions.iterator();
        while (iterator.hasNext() && !(served = (extension = iterator.next()).serveAuthenticated(user, path, req, res))) {
        }
    }
}

