###########################################################################
#
# win32 makefile -- gsdl
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

GSDLHOME = $(MAKEDIR)
GSDL_VC4 = 0
# It only ever makes sense for GS2 to turn on LOCAL_LIBRARY and APACHE_HTTPD if needed
LOCAL_LIBRARY = 0
APACHE_HTTPD = 0
DEBUG = 0
DLL = 0
DLLDEBUG = 0
# USE_SQLITE is enabled by default for GS2. Need to turn off explicitly for GS3 in build.xml
USE_SQLITE = 1
# It only ever makes sense for GS2 to turn on MSSQL if needed
USE_MSSQL = 0
USE_Z3950 = 0
# by default, all indexers are enabled
ENABLE_MG = 1
ENABLE_MGPP = 1
ENABLE_LUCENE = 1
# jni is disabled by default as this is the default for GS2. GS3 will set this explicitly
ENABLE_JNI = 0


MDEFINES = /f win32.mak

INSTALLDIRS = common-src build-src
!IF EXIST ("runtime-src")
INSTALLDIRS = $(INSTALLDIRS) runtime-src 
!ENDIF


MAKECMD = $(MAKE) $(MDEFINES) GSDLHOME="$(GSDLHOME)" VISUAL_STUDIO_MAJORVERSION="$(VISUAL_STUDIO_MAJORVERSION)"

!IF $(GSDL_VC4)
MAKECMD = $(MAKECMD) GSDL_VC4=1
!ENDIF
!IF $(LOCAL_LIBRARY)
MAKECMD = $(MAKECMD) LOCAL_LIBRARY=1
!ENDIF
!IF $(APACHE_HTTPD)
MAKECMD = $(MAKECMD) APACHE_HTTPD=1
!ENDIF
!IF $(DEBUG)
MAKECMD = $(MAKECMD) DEBUG=1
!ENDIF
!IF $(DLL)
MAKECMD = $(MAKECMD) DLL=1
!ENDIF
!IF $(DLLDEBUG)
MAKECMD = $(MAKECMD) DLLDEBUG=1
!ENDIF
!IF !$(USE_SQLITE)
MAKECMD = $(MAKECMD) USE_SQLITE=0
!ENDIF
!IF $(USE_MSSQL)
MAKECMD = $(MAKECMD) USE_MSSQL=1
!ENDIF
!IF $(USE_Z3950)
MAKECMD = $(MAKECMD) USE_Z3950=1
!ENDIF
!IF $(ENABLE_JNI)
MAKECMD = $(MAKECMD) ENABLE_JNI=1
!ENDIF
!IF !$(ENABLE_MG)
MAKECMD = $(MAKECMD) ENABLE_MG=0
!ENDIF
!IF !$(ENABLE_MGPP)
MAKECMD = $(MAKECMD) ENABLE_MGPP=0
!ENDIF
!IF !$(ENABLE_LUCENE)
MAKECMD = $(MAKECMD) ENABLE_LUCENE=0
!ENDIF

MAKECLEANCMD = $(MAKE) $(MDEFINES) GSDLHOME="$(GSDLHOME)" clean

all: win32.mak $(INSTALLDIRS) 

install: win32.mak $(INSTALLDIRS)

clean:
	cd common-src
	$(MAKECLEANCMD)
	cd "$(GSDLHOME)"
	cd build-src
	$(MAKECLEANCMD)
	cd "$(GSDLHOME)"
!IF EXIST ("runtime-src")
	cd runtime-src
	$(MAKECLEANCMD)
	cd "$(GSDLHOME)"
!ENDIF

$(INSTALLDIRS): FORCE
	cd "$@"
	$(MAKECMD)
	$(MAKECMD) install
	cd "$(GSDLHOME)"

FORCE:

