/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.FormatManager;
import org.greenstone.gatherer.cdm.Format;
import org.greenstone.gatherer.cdm.Format4gs3Manager;
import org.greenstone.gatherer.cdm.Format4gs3;
import org.greenstone.gatherer.cdm.DOMProxyListEntry;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.shell.GShell;
import org.greenstone.gatherer.shell.GShellEvent;
import org.greenstone.gatherer.shell.GShellListener;

public class FormatPane
extends BaseConfigPane
implements PreviewButtonOwner,GShellListener{
    
    
    /** The button for viewing the collection. */
    private static PreviewButton preview_button = null;
    private boolean buildCanceled = false;
    
    /** The constructor. */
    public FormatPane () {
        super ();
        if (Gatherer.GS3) {
            contents = new String []{ "CDM.GUI.General", "CDM.GUI.SearchMetadata", "CDM.GUI.Formats", "CDM.GUI.Translation" };
        } else {
            contents = new String []{ "CDM.GUI.General", "CDM.GUI.SearchMetadata", "CDM.GUI.Formats", "CDM.GUI.Translation", "CDM.GUI.SuperCollection","CDM.GUI.Macros", "CDM.GUI.DepositorMetadata" };
        }
        JPanel side_panel = new JPanel ();
        side_panel.setComponentOrientation(Dictionary.getOrientation());
        side_panel.setLayout (new BorderLayout ());
        remove (tree_pane);
        side_panel.add (tree_pane, BorderLayout.CENTER);
        JPanel preview_pane = new JPanel ();
        preview_pane.setComponentOrientation(Dictionary.getOrientation());
        
        preview_pane.setLayout (new BorderLayout ());
        preview_pane.setBorder (BorderFactory.createEmptyBorder (5,0,0,0));
        
        preview_button = new PreviewButton (Dictionary.get ("CreatePane.Preview_Collection"), Dictionary.get ("CreatePane.Preview_Collection_Tooltip"));
        preview_button.setEnabled (true);
        preview_button.setVariablePreview (true);
        preview_button.setOwner (this);
        preview_pane.add (preview_button, BorderLayout.CENTER);
        
        
        preview_button.addActionListener (new ActionListener () {
            public void actionPerformed (ActionEvent event) {
                if (view != null) {
                    view.loseFocus ();
                }
                
                if (buildCanceled){
                    WarningDialog dialog = new WarningDialog ("warning.ShowPreviousCollection", Dictionary.get ("ShowPreviousCollection.Title"), Dictionary.get ("ShowPreviousCollection.Message"), null, false);
                    dialog.display ();
                    dialog.dispose ();
                }
            }
            
        });
        side_panel.add (preview_pane, BorderLayout.SOUTH);
        
        add (side_panel, BorderLayout.LINE_START);
    }
    
    public void gainFocus (){
	super.gainFocus();
        if (Gatherer.c_man.built () && Configuration.library_url != null) {
            preview_button.setEnabled (true);
        }
        else{
            preview_button.setEnabled (false);
        }
        
    }
    public static void setPreviewButton (boolean ready_to_preview) {
	// if we're asked to enable the preview button, yet the collection is still
	// unbuilt (as could happen when someone clicks on a format statement before 
	// building the collection), then shouldn't enable previewing.
	if(ready_to_preview && Gatherer.c_man.previewAvailable()) {
	    ready_to_preview = false;
	}
        preview_button.setEnabled (ready_to_preview);
    }
    
    /** All implementation of GShellListener must include this method so the listener can be informed of messages from the GShell.
     * @param event A <strong>GShellEvent</strong> that contains, amoung other things, the message.
     */
    public synchronized void message (GShellEvent event) {
        // We don't care.
    }
    
    
    /** All implementation of GShellListener must include this method so the listener can be informed when a GShell begins its task. Implementation side-effect, not actually used.
     * @param event A <strong>GShellEvent</strong> that contains details of the initial state of the <strong>GShell</strong> before task comencement.
     */
    public synchronized void processBegun (GShellEvent event) {
        buildCanceled = false;
    }
    
    /** All implementation of GShellListener must include this method so the listener can be informed when a GShell completes its task.
     * @param event A <strong>GShellEvent</strong> that contains details of the final state of the <strong>GShell</strong> after task completion.
     */
    public synchronized void processComplete (GShellEvent event) {
        if(event.getStatus () == GShell.OK) {
            if(event.getType () == GShell.BUILD) {
                buildCanceled = false;
            }
        }
        else {
            buildCanceled = true;
        }
    }
    
    
    
    protected Control getSubControls (String type) {
        if(type.equals ("CDM.GUI.General")) {
            return CollectionDesignManager.general_manager.getControls ();
        }
        if (type.equals ("CDM.GUI.SearchMetadata")) {
            return CollectionDesignManager.searchmeta_manager.getControls ();
        }
        if(type.equals ("CDM.GUI.Formats")) {
            return CollectionDesignManager.format_manager.getControls ();
        }
        if (type.equals ("CDM.GUI.Translation")) {
            return CollectionDesignManager.translation_manager.getControls ();
        }
        if (type.equals ("CDM.GUI.Macros")) {
            return CollectionDesignManager.macros_manager.getControls ();
        }
        if(type.equals ("CDM.GUI.SuperCollection")) {
            return CollectionDesignManager.supercollection_manager.getControls ();
        }
	if(type.equals ("CDM.GUI.DepositorMetadata")) {
	    return CollectionDesignManager.depositormetadata_manager.getControls ();
	}
        return null;
    }
    
    private int page_type = PreviewButton.HOME_PAGE;
    private String page_params = "";
    public int getPageType () {
        System.err.println ("view type = "+view_type);
        if (view_type.equals ("CDM.GUI.General") || view_type.equals ("CDM.GUI.Translation")) {
            page_type = PreviewButton.HOME_PAGE;
        } else {
            
            if (Gatherer.GS3 == true) {
                Format4gs3 current_format = ((Format4gs3Manager.FormatControl)view).getCurrentFormat ();
                String feature_name = current_format.getFeatureName ();
                
                if (feature_name.equals ("browse")) {
                    page_type = PreviewButton.CLASSIFIER_PAGE;
                    page_params = "CL1";
                } else
                if (feature_name.startsWith ("CL")) {
                    page_type = PreviewButton.CLASSIFIER_PAGE;
                    page_params = current_format.getFeatureName ();
                }
                else if (feature_name.startsWith ("display")) {
                    page_type = PreviewButton.DOCUMENT_PAGE;
                    page_params = "HASH01e4da6100fdbb11b7ef244b";
                }
                else if (feature_name.equals ("search")) {
                    page_type = PreviewButton.SEARCH_PAGE;
                    page_params = "the";
                } else { // HOME_PAGE 
                }
            } else {
                Format current_format = ((FormatManager.FormatControl)view).getCurrentFormat ();
                String feature_name = current_format.getFeatureName ();
                System.err.println ("current format = "+feature_name);
                if (feature_name.equals ("")) {
                    // must be modifying VList or HList
                    // what should we do???
                    page_type = PreviewButton.CLASSIFIER_PAGE;
                    page_params = "CL1";
                }
                if (feature_name.startsWith ("CL")) {
                    page_type = PreviewButton.CLASSIFIER_PAGE;
                    page_params = current_format.getFeatureName ();
                }
                else if (feature_name.startsWith ("Document")) {
                    page_type = PreviewButton.DOCUMENT_PAGE;
                    page_params = "HASH01e4da6100fdbb11b7ef244b";
                }
                else if (feature_name.equals ("Search")) {
                    page_type = PreviewButton.SEARCH_PAGE;
                    page_params = "the";
                }
            }
        }
        return page_type;
    }
    
    public String getPageParams () {
        return page_params;
    }
    
}
