/** Javascript file for editing and especially deleting user comments in a documentediting situation */

// Function called by documentedit_scripts_util.js when saving and rebuilding.
// This function should return usercomments data (only exists for doc root's section) so that
// setMetadataArray can be called for doc root and the entire collection rebuilt with the changes
function getUserCommentsEditDataForSaving(userCommentsMetaFields, userCommentsRowsChanged,
					  docids_to_delCommentsMetapositions) {
    // https://medium.com/@martin.crabtree/javascript-tracking-key-value-pairs-using-hashmaps-7de6df598257
    // Just using JS object. Not using Map in case it's not always compatible with older
    // browsers we still support on 32 bit linux.
    var docIDs_to_metatable_map = {};    
    
    var i = 0;
    for (i = 0; i < userCommentsRowsChanged.length; i++) {
	// need docID, metaname, metaval, metapos, and set metamode to override
	
	var changedElem = userCommentsRowsChanged[i];
	//console.dir(changedElem);
	
	var metaval = changedElem.value; //changedElem.textContent; // gets orig value
	metaval = metaval.replace(/&nbsp;/g, " "); // copied from docedit_scripts_utl, when procsesing the array called changes.
	metaval = encodeDelimiters(metaval);
	
	var currentElem = changedElem;
	while((currentElem = currentElem.parentNode).tagName != "TABLE");	    
	var docID = currentElem.getAttribute("id").substring("usercomments-".length);
	
	currentElem = changedElem;
	while((currentElem = currentElem.parentNode).tagName != "TR");
	var metapos = currentElem.firstElementChild.textContent;
	
	// don't consider edits in user comment rows that have also been marked for deletion
	var metapositionsToBeDeleted = docids_to_delCommentsMetapositions[docID];
	if(metapositionsToBeDeleted !== undefined) {
	    // https://www.digitalocean.com/community/tutorials/js-array-search-methods
	    if(metapositionsToBeDeleted.indexOf(metapos) != -1) {
		alert("Discarding edit at metapos " + metapos + " as user comment row is to be deleted.");
		continue;
	    }
	}
	
	//currentElem = changedElem.parentNode; //TD
	currentElem = changedElem;
	while((currentElem = currentElem.parentNode).tagName != "TD");	    
	// count number of previous siblings
	var th = 0;
	while((currentElem = currentElem.previousSibling) != null) {
	    th++;
	}
	var metaname = userCommentsMetaFields[th-1]; // first column is invisible metapos col
	
	//alert("docid: " + docID + " metaname: " + metaname + " metaval: " + metaval + " metapos: " + metapos);

	// https://dmitripavlutin.com/check-if-object-has-property-javascript/
	// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/null
	if(docIDs_to_metatable_map[docID] === undefined) {
	    docIDs_to_metatable_map[docID] = [];	    
	}
	docIDs_to_metatable_map[docID].push({metaname:metaname,metavalue:metaval,metapos:metapos});
    }
    
    var docids = Object.keys(docIDs_to_metatable_map);
    i = 0;
    var docArray = [];
    for(i = 0; i < docids.length; i++) {
	var docid = docids[i];
	var metatable = docIDs_to_metatable_map[docid];
	docArray.push({
	    docid:docid,
	    metatable:metatable/*,
	    metamode:"override"*/ // metamode set universally to override in
              // documentedit_scripts_util.js::processChangesLoop when change.type=editUserComments
	});
    }

    //alert("editing: " + JSON.stringify(docArray));
    
    return docArray;
}

// Function called by documentedit_scripts_util.js when saving and rebuilding.
// This function should return usercomments data (only exists for doc root's section) so that
// removeMetadataArray can be called for doc root and the collection rebuilt with the deletions
function getUserCommentsDeletions(userCommentsMetaFields, docids_to_delCommentsMetapositions) {
    
    var docids = Object.keys(docids_to_delCommentsMetapositions);
    var docArray = [];
    var i = 0;
    for(i = 0; i < docids.length; i++) { //if(docids.length > 0) {
      var _docid = docids[i];
      var delCommentsMetapositions = docids_to_delCommentsMetapositions[_docid].sort();
	// sort unnecessary as modmetadataaction.pm ensures (reverse) sort of metapositions

      // build up the data structure for all the usercomments to be deleted
      if(delCommentsMetapositions.length > 0) {
	  //console.log("About to delete position: " + delCommentsMetapositions);
	  var timestamp_rec = {
	      metaname: userCommentsMetaFields[0],
	      metapositions: delCommentsMetapositions
	  };
	  var username_rec = {
	      metaname: userCommentsMetaFields[1],
	      metapositions: delCommentsMetapositions
	  };    
	  var comment_rec = {
	      metaname: userCommentsMetaFields[2],
	      metapositions: delCommentsMetapositions
	  };
    
    
	  var doc_rec = {
	      docid: _docid,
	      metatable: [username_rec, timestamp_rec, comment_rec]
	  };

	  docArray.push(doc_rec);	 
      }
    }

    //alert("deleting: " + JSON.stringify(docArray));
    return docArray;
}

// Determine if the user comment edits should be a synchronous AJAX call
function forceSyncUserCommentsEdits(editsDocArray, docids_to_delCommentsMetapositions) {
    var forceSync = false;
    var docids = Object.keys(docids_to_delCommentsMetapositions);
    if(docids.length == 0) { // no user comments deletions, so can process user comment edits async
	return false;
    }
    var edits = Object.keys(editsDocArray);
    if(edits.length == 0) { // no user comments edits
	return false;
    }
    
    var i = 0;
    for(i = 0; i < docids.length; i++) {
	var docid = docids[i];

	// sort metapositions of deletes to get at lowest metaposition for this docid
	var metapositions = docids_to_delCommentsMetapositions[docid].sort(); // non-zero length array
	var lowestDelMetapos = metapositions[0]; // lowest metaposition at lowest index
	
	// https://javascript.plainenglish.io/check-if-an-array-contains-an-object-with-a-certain-property-value-in-javascript-5325295a5820	
	// https://stackoverflow.com/questions/237104/how-do-i-check-if-an-array-includes-a-value-in-javascript/24827594#24827594
	// https://stackoverflow.com/questions/254302/how-can-i-determine-the-type-of-an-html-element-in-javascript
	
	var match_docRecord = editsDocArray.find((doc_rec) => doc_rec.docid === docid);
	if (match_docRecord) { // defined: this docid exists in an object in array
	//if(editsDocArray.some(item => item.docid === docid)) { // this docid exists in object
	//if(editsDocArray[docid] !== undefined) {
	    // compare lowest metaposition of user comment to be deleted for this docid
	    // against the highest metapos of user comment being edited for this docid
	    // Metapositions array of deletes would contain metapos in ascending order
	    var metatable = match_docRecord.metatable; // array of non-zero length
	    //alert("Found docid match " + JSON.stringify(match_docRecord) + " comparing low metapos " + lowestDelMetapos);
		  
	    // https://www.digitalocean.com/community/tutorials/js-array-search-methods
	    // Get array of user comment edits that are affected by deletions happening earlier
	    // in the file (deletes that have a lower metapos than the metapos of the edit).
	    var editsAffectedByDeletes = metatable.filter(meta_rec => meta_rec.metapos >= lowestDelMetapos);
	    if(editsAffectedByDeletes.length > 0) { //if any edits affected by dels, forceSync ajax
		forceSync = true; // ensure we process all edits first before processing deletes
		//alert("FORCE_SYNC because " + JSON.stringify(editsAffectedByDeletes)
		//      + " are affected by deletes starting: " + lowestDelMetapos);
	    } // else all user comment edits for this docid happen earlier (lower metapos) to deletes
	}
    }
    return forceSync;
}

function addEditUserCommentsLink(cell) {
    cell = $(cell);
    var doc_id = cell.attr("id").substring(6);
    
    var edit_usercomments_table = document.getElementById("usercomments-"+doc_id);   

    var edit_meta_table = document.getElementById("meta"+doc_id);
    var comments = edit_meta_table.querySelectorAll('.metaTableCellArea.gsusercomment');
    var gsMetaPrefix = "gs"; // metadata name prefix
    
    var unames = [];
    var timestamps = [];
    
    
    if(comments.length <= 0) {
	gsMetaPrefix = "";

	comments = edit_meta_table.querySelectorAll('.metaTableCellArea.usercomment');
	if(comments.length <= 0) {	    
	    return;
	}	
    }

    
    var classname = ".metaTableCellArea." + gsMetaPrefix + "username";
    unames = edit_meta_table.querySelectorAll(classname); 
    classname = ".metaTableCellArea." + gsMetaPrefix + "usertimestamp";
    timestamps = edit_meta_table.querySelectorAll(classname);
    
    //console.log(comments[0].textContent);
    //console.log(unames[0].textContent);
    //console.log(timestamps[0].textContent);    


    var headerRow = document.createElement("tr");    
    edit_usercomments_table.appendChild(headerRow);    

    var i = 0;
    // work with tbody child of metadatatable's table element
    edit_meta_table = edit_meta_table.firstElementChild;
    for(i = 0; i < comments.length; i++) {
	var newRow = document.createElement("tr");
	edit_usercomments_table.appendChild(newRow);

	var rowNumCell, txtNode;
	if(i == 0) {
	    rowNumCell = document.createElement("th");
	    rowNumCell.setAttribute("class", "metaposCell");
	    txtNode = document.createTextNode("metapos");	    
	    rowNumCell.appendChild(txtNode);
	    headerRow.appendChild(rowNumCell);
	}
	rowNumCell = document.createElement("td");
	rowNumCell.setAttribute("class", "metaposCell");
	txtNode = document.createTextNode(i+"");
	rowNumCell.appendChild(txtNode);
	newRow.appendChild(rowNumCell);
	
	
	//Row we work with each time: get the closest ancestor of comments[i] that is a <tr>
	// If you change the order the rows are moved into usercomments-table below, the
	// userCommentsMetaFields[] array ordering in documentedit_scripts_util.js will be affected
	shiftRowData(timestamps[i].closest("tr"), edit_meta_table, newRow, i, headerRow);
	shiftRowData(unames[i].closest("tr"), edit_meta_table, newRow, i, headerRow);
	shiftRowData(comments[i].closest("tr"), edit_meta_table, newRow, i, headerRow);
	
	//console.log("NEWROW:" + newRow.firstElementChild.textContent);
	addRemoveLinkToRow(newRow);

    }
    
	var row = cell.parent();
	var newCell = $("<td>", {
			"style": "font-size:0.7em; padding:0px 10px",
			"class": "editMapGPSButton"
		});
	var linkSpan = $("<span>", {
			"class": "ui-state-default ui-corner-all",
			"style": "padding: 2px; float:left;"
		});

	var linkLabel = $("<span>" + gs.text.de.edit_usercomments + "</span>");
	var linkIcon = $("<span>", {
			"class": "ui-icon ui-icon-folder-collapsed"
		});
	newCell.linkIcon = linkIcon;
	newCell.linkLabel = linkLabel;

	var uList = $("<ul>", {
			"style": "outline: 0 none; margin:0px; padding:0px;"
		});
	var labelItem = $("<li>", {
			"style": "float:left; list-style:none outside none;"
		});
	var iconItem = $("<li>", {
			"style": "float:left; list-style:none outside none;"
		});

	uList.append(iconItem);
	uList.append(labelItem);
	labelItem.append(linkLabel);
	iconItem.append(linkIcon);

	var newLink = $("<a>", {
			"href": "javascript:;"
	});
    
	newLink.on("click", function () {
		if (edit_usercomments_table.style.display == "none") {
			linkLabel.html(gs.text.de.hide_usercomments);
			linkIcon.attr("class", "ui-icon ui-icon-folder-open");
			edit_usercomments_table.style.display = "block";
		} else {
		    linkLabel.html(gs.text.de.edit_usercomments);
		    linkIcon.attr("class", "ui-icon ui-icon-folder-collapsed");
		    edit_usercomments_table.style.display = "none";

		}
	});

	newLink.append(uList);
	linkSpan.append(newLink);
	newCell.append(linkSpan);
	row.append(newCell);
}

function makeHeaderCellFrom(row, headerRow) {
    var cellName = row.querySelector('.metaTableCellName').textContent;
    var headerCell = document.createElement("th");
    headerCell.setAttribute("class", "metaTableCellName");
    var txt = document.createTextNode(cellName);
    headerCell.appendChild(txt);
    headerRow.appendChild(headerCell);
}

function shiftRowData(row, edit_meta_table, newRow, rownum, headerRow) {
    if(rownum == 0) {
	makeHeaderCellFrom(row, headerRow);
    }
    edit_meta_table.removeChild(row);
    var oldCell = row.querySelector('.metaTableCell');	
    newRow.appendChild(oldCell);
    var el = oldCell.querySelector('.metaTableCellArea');
    el.classList.add("threecol");
}
