###########################################################################
#
# win32 makefile -- mgpp\jni
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################
 
MGPPHOME = ..

UNAC_DIR = ../../packages/unac
ICONV_DIR = ../../packages/windows/iconv/iconv/lib

DEBUG = 0
ENABLE_ACCENTFOLD = 1

!IF $(ENABLE_ACCENTFOLD)
AFLIBS = "$(UNAC_DIR)\libunac.lib"  "$(ICONV_DIR)\iconv.lib"
AFINCLUDES = -I"$(UNAC_DIR)" -I"$(ICONV_DIR)"
!ELSE
AFLIBS = 
AFINCLUDES = 
!ENDIF

AR = lib
CC = cl

!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
!ELSE
CXXFLAGS =
!ENDIF

CXXFLAGS = $(CXXFLAGS) -GX

DEFS = -DQUIET -DHAVE_CONFIG_H -DSHORT_SUFFIX -DHAVE_STRING_H -D__WIN32__
INCLUDES = -I"$(MGPPHOME)" -I"$(MGPPHOME)\lib" -I"$(MGPPHOME)\text" \
           -I"$(JAVA_HOME)\include" -I"$(JAVA_HOME)\include\win32" $(AFINCLUDES)           

COMPILE = $(CC) -c $(CXXFLAGS) $(DEFS) $(INCLUDES) 
 
.SUFFIXES:
.SUFFIXES: .c .obj
.c.obj:
	$(COMPILE) $<

ANSI2KNR = 
o = .obj
 
HEADERS = \
    MGPPSearchWrapperImpl.h  org_greenstone_mgpp_MGPPSearchWrapper.h \
   org_greenstone_mgpp_MGPPRetrieveWrapper.h org_greenstone_mgpp_MGPPPassesWrapperImpl.h

SOURCES = \
    MGPPSearchWrapperImpl.cpp MGPPRetrieveWrapperImpl.cpp MGPPPassesWrapperImpl.cpp

RETRIEVEOBJECTS = \
    MGPPRetrieveWrapperImpl$o  $(MGPPHOME)\text\libmgpptext.lib \
    $(MGPPHOME)\lib\libmgpplib.lib $(AFLIBS)

SEARCHOBJETCS =  \
    MGPPSearchWrapperImpl$o $(MGPPHOME)\text\libmgpptext.lib \
    $(MGPPHOME)\lib\libmgpplib.lib $(AFLIBS)

PASSES_OBJECTS = \
    MGPPPassesWrapperImpl$o $(MGPPHOME)\text\libmgpppass.lib \
    $(MGPPHOME)\lib\libmgpplib.lib

DISTFILES = Makefile.in $(HEADERS) $(SOURCES)
 
all : compile link

compile:
        $(COMPILE) MGPPSearchWrapperImpl.cpp MGPPRetrieveWrapperImpl.cpp MGPPPassesWrapperImpl.cpp

link:
	$(CC) -MD -LD $(SEARCHOBJETCS) -Femgppsearchjni.dll
	$(CC) -MD -LD $(RETRIEVEOBJECTS) -Femgppretrievejni.dll
	$(CC) -MD -LD $(PASSES_OBJECTS) -Femgpppassjni.dll

install: 

clean:
	del *$o mgppsearchjni.dll mgppsearchjni.exp mgppsearchjni.lib mgppretrievejni.dll mgppretrievejni.exp mgppretrievejni.lib mgpppassjni.dll mgpppassjni.exp mgpppassjni.lib 

