package org.greenstone.gatherer.util;

import javax.swing.JCheckBox;
import org.greenstone.gatherer.Dictionary;

/** A CheckListEntry encapsulates a single row of the list, both its check box and the object the row represents. */
public class CheckListEntry
    extends JCheckBox 
    implements Comparable {

    /** Is this checkboxes state fixed. */
    private boolean fixed = false;
    /** The original object this row is based on, and whose toString() is used to generate the check box label. */
    private Object object = null;
    /** A sundry string for storing original values (rather than strings retrieved from dictionary). */
    private String property;
    /** Constructor. */
    public CheckListEntry(Object object) {
	super(object.toString());
	this.object = object;
	this.setComponentOrientation(Dictionary.getOrientation());
    }

    /** Constructor. */
    public CheckListEntry(String text, boolean is_selected) {
	super(text);
	this.setComponentOrientation(Dictionary.getOrientation());
	setSelected(is_selected);
    }

    /** Test this CheckListEntry against an Object for ordering. 
     * @param obj the other Object.
     * @return <0, 0 or >0 if this CheckListEntry is before, equal to or after the given object.
     */
    public int compareTo(Object obj) {
	return toString().toLowerCase().compareTo(obj.toString().toLowerCase());
    }
    /** Test this CheckListEntry against an Object for equality. 
     * @param obj the other Object.
     * @return true if the two are equal, false otherwise.
     */
    public boolean equals(Object obj) {
	if (obj == null) {
	    return false;
	}
	return toString().equalsIgnoreCase(obj.toString());
    }

    /** Retrieve the object associated with this entry.
     * @return An <strong>Object</strong>.
     */
    public Object getObject() {
	if(object == null) {
	    return getText();
	}
	return object;
    }

    public String getProperty() {
	return property;
    }

    public boolean isFixed() {
	return fixed;
    }

    public void setFixed(boolean fixed) {
	this.fixed = fixed;
    }

    public void setProperty(String property) {
	this.property = property;
    }

    public String toString() {
	if(object == null) {
	    return getText();
	}
	return object.toString();
    }
}
