/**
 *#########################################################################
 * FedoraCommons.java - works with the demo-client for Greenstone 3, of
 * the Greenstone digital library suite from the New Zealand Digital 
 * Library Project at the  * University of Waikato, New Zealand.
 * <BR><BR>
 * Copyright (C) 2008 New Zealand Digital Library Project
 * <BR><BR>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * <BR><BR>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *########################################################################
 */

package org.greenstone.fedora.services;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/** Methods common to both Fedora(GS3)Connection and GSearchConnection.
 * Made static here so they can be reused by these classes.
 * @author ak19
*/
public class FedoraCommons {
	/** Extract the text from an element, if any.
	 * @return the text that's nested in an element's body or "" 
	 * if there's none. 
	 * @param e is the element whose value is to be extracted.*/
	public static String getValue(Element e) {
		Node child = e.getFirstChild();
		return (child == null) ? "" : child.getNodeValue();
	}
	
	/** Turns the XML String into a DOM tree and returns it.
	 * @param XML the string to be converted into a DOM tree
	 * @param builder is the DocumentBuilder to use to parse the string XML
	 * @return the root element of the document by parsing the string XML 
	*/
	public static Element getResponseAsDOM(DocumentBuilder builder, String XML)
		throws SAXException, IOException
	{
		Element docEl = null;
		// turn the String xml into a DOM tree:	
		Document doc = builder.parse(new InputSource(new StringReader(XML)));
		docEl = doc.getDocumentElement();
		return docEl;
	}
		
	/** Given an Element, this will return its String representation without
	 * indenting it for display. 
	 * @return a string representation of e without formatting it for display. 
	 * @param e is the element to be converted to its string representation.
	*/
	public static String elementToString(Element e) 
		throws TransformerException
	{
		DOMSource domSource = new DOMSource(e);
		Transformer transformer 
			= TransformerFactory.newInstance().newTransformer();
		transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
		//transformer.setOutputProperty(OutputKeys.METHOD, "xml");
		//transformer.setOutputProperty(OutputKeys.ENCODING, "ISO-8859-1");

		StringWriter sw = new StringWriter();
		transformer.transform(domSource, new StreamResult(sw));
		return sw.toString();
	}
	
	/** Given a DOM node, this will return its String representation properly 
	 * indented for display.
	 * @return a string representation of n, formatted for display. 
	 * @param n is the DOM node to be converted to its string representation.
	*/
	public static String displayAsString(Node n) 
	{
	    try {
	    
	    DOMSource domSource = new DOMSource(n);
	    Transformer transformer = TransformerFactory.newInstance().newTransformer();
	    transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
	    //transformer.setOutputProperty(OutputKeys.METHOD, "xml");
	    //transformer.setOutputProperty(OutputKeys.ENCODING, "ISO-8859-1");
	    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
	    transformer.setOutputProperty(OutputKeys.INDENT, "yes");
	    
	    StringWriter sw = new StringWriter();
	    transformer.transform(domSource, new StreamResult(sw));
	    return sw.toString();
	    } catch(Exception e) {
		System.err.println("Couldn't display node as String.");
		return "";
	    }
	    
	}

    
}
