/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2.nlp;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import company.evo.jmorphy2.ParsedWord;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class Node {
    public final ImmutableSet<String> grammemeValues;
    public final String grammemeValuesStr;
    public final ImmutableList<Node> children;
    public final ParsedWord parsed;
    public final String word;
    public final float score;
    public final int maxDepth;
    public final long uniqueHash;

    public Node(ImmutableSet<String> grammemeValues, ImmutableList<Node> children, float score) {
        this(grammemeValues, children, null, null, score);
    }

    public Node(ImmutableSet<String> grammemeValues, String word, float score) {
        this(grammemeValues, null, null, word, score);
    }

    public Node(ImmutableSet<String> grammemeValues, ParsedWord parsed, float score) {
        this(grammemeValues, null, parsed, parsed.word, score);
    }

    protected Node(ImmutableSet<String> grammemeValues, ImmutableList<Node> children, ParsedWord parsed, String word, float score) {
        if (grammemeValues == null) {
            throw new RuntimeException("grammemeValues must not be null");
        }
        this.grammemeValues = grammemeValues;
        this.grammemeValuesStr = Joiner.on((String)",").join((Iterable)Ordering.natural().sortedCopy(grammemeValues));
        this.children = children;
        this.parsed = parsed;
        this.word = word;
        this.score = score;
        this.maxDepth = Node.maxDepthFor(this.getChildren()) + 1;
        this.uniqueHash = this.calcUniqueHash();
    }

    public boolean hasChildren() {
        return this.children != null;
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public ImmutableList<Node> getChildren() {
        if (this.hasChildren()) {
            return this.children;
        }
        return ImmutableList.of();
    }

    public int getChildrenSize() {
        return this.children == null ? 0 : this.children.size();
    }

    public String getWord() {
        return this.word;
    }

    public static float sumScoreFor(List<Node> nodes) {
        float score = 0.0f;
        for (Node n : nodes) {
            score += n.score;
        }
        return score;
    }

    public static int maxDepthFor(List<Node> nodes) {
        int maxDepth = 0;
        for (Node n : nodes) {
            if (n.maxDepth <= maxDepth) continue;
            maxDepth = n.maxDepth;
        }
        return maxDepth;
    }

    public static Comparator<Node> scoreComparator() {
        return new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                return Float.compare(n2.score, n1.score);
            }
        };
    }

    private long calcUniqueHash() {
        long h = this.grammemeValues.hashCode();
        if (this.children != null) {
            for (Node child : this.children) {
                h = h * 524287L + child.uniqueHash;
            }
        }
        if (this.word != null) {
            h = h * Integer.MAX_VALUE + (long)this.word.hashCode();
        }
        return h;
    }

    public String toString() {
        return String.format("(%s %s)", this.grammemeValuesStr, this.hasChildren() ? Joiner.on((String)" ").join(this.children) : this.word);
    }

    public String prettyToString() {
        return this.prettyToString(false);
    }

    public String prettyToString(boolean withScore) {
        return this.prettyToString(withScore, 0);
    }

    protected String prettyToString(boolean withScore, int level) {
        String pad = level == 0 ? "" : String.format("\n%s", Strings.repeat((String)" ", (int)(level * 4)));
        ArrayList<String> childrenStrings = new ArrayList<String>();
        for (Node child : this.getChildren()) {
            childrenStrings.add(child.prettyToString(withScore, level + 1));
        }
        String addInfo = "";
        if (withScore) {
            addInfo = String.format(" [%s]", Float.valueOf(this.score));
        }
        return String.format("%s(%s %s)%s", pad, this.grammemeValuesStr, this.hasChildren() ? Joiner.on((String)" ").join(childrenStrings) : this.word, addInfo);
    }

    public static class Top
    extends Node {
        public Top(ImmutableList<Node> children, float score) {
            super((ImmutableSet<String>)ImmutableSet.of((Object)"TOP"), children, score);
        }
    }
}

