/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.debugger.FileHeader;
import org.mozilla.javascript.tools.debugger.FileTextArea;
import org.mozilla.javascript.tools.debugger.LoadFile;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;

class FileWindow
extends JInternalFrame
implements ActionListener {
    Main db;
    FileTextArea textArea;
    FileHeader fileHeader;
    JScrollPane p;
    int currentPos;
    Hashtable breakpoints;
    String url;
    JLabel statusBar;

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (!string.equals("Cut")) {
            if (string.equals("Copy")) {
                this.textArea.copy();
            } else if (string.equals("Paste")) {
                // empty if block
            }
        }
    }

    public void dispose() {
        Enumeration enumeration = this.breakpoints.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)this.breakpoints.get(enumeration.nextElement());
            this.db.clearBreakPoint(this.url, n);
        }
        this.db.removeWindow(this);
        super.dispose();
    }

    void runToCursor(ActionEvent actionEvent) {
        try {
            this.db.runToCursor(this.url, this.textArea.getLineOfOffset(this.textArea.getCaretPosition()) + 1, actionEvent);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    void load() {
        Scriptable scriptable = this.db.getScope();
        if (scriptable == null) {
            MessageDialogWrapper.showMessageDialog(this.db, "Can't load scripts: no scope available", "Run", 0);
        } else {
            String string = this.url;
            if (string != null) {
                new Thread(new LoadFile(this.db, scriptable, string)).start();
            }
        }
    }

    public int getPosition(int n) {
        int n2 = -1;
        try {
            n2 = this.textArea.getLineStartOffset(n);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n2;
    }

    boolean isBreakPoint(int n) {
        int n2 = this.getPosition(n - 1);
        return this.breakpoints.get(new Integer(n2)) != null;
    }

    void toggleBreakPoint(int n) {
        int n2 = this.getPosition(n - 1);
        Integer n3 = new Integer(n2);
        if (this.breakpoints.get(n3) == null) {
            this.setBreakPoint(n);
        } else {
            this.clearBreakPoint(n);
        }
    }

    void setBreakPoint(int n) {
        int n2 = this.db.setBreakPoint(this.url, n);
        if (n2 != -1) {
            int n3 = this.getPosition(n2 - 1);
            this.breakpoints.put(new Integer(n3), new Integer(n));
            this.fileHeader.repaint();
        }
    }

    void clearBreakPoint(int n) {
        this.db.clearBreakPoint(this.url, n);
        int n2 = this.getPosition(n - 1);
        Integer n3 = new Integer(n2);
        if (this.breakpoints.get(n3) != null) {
            this.breakpoints.remove(n3);
            this.fileHeader.repaint();
        }
    }

    FileWindow(Main main, String string, String string2) {
        super(new File(string).getName(), true, true, true, true);
        this.db = main;
        this.breakpoints = (Hashtable)main.breakpointsMap.get(string);
        if (this.breakpoints == null) {
            this.breakpoints = new Hashtable();
            main.breakpointsMap.put(string, this.breakpoints);
        }
        this.setUrl(string);
        this.currentPos = -1;
        this.textArea = new FileTextArea(this);
        this.textArea.setRows(24);
        this.textArea.setColumns(80);
        this.p = new JScrollPane();
        this.fileHeader = new FileHeader(this);
        this.p.setViewportView(this.textArea);
        this.p.setRowHeaderView(this.fileHeader);
        this.setContentPane(this.p);
        this.pack();
        this.setText(string2);
        this.textArea.select(0);
    }

    public void setUrl(String string) {
        Component component = this.getComponent(1);
        if (component != null && component instanceof JComponent) {
            ((JComponent)component).setToolTipText(string);
        }
        this.url = string;
    }

    public String getUrl() {
        return this.url;
    }

    void setText(String string) {
        if (!this.textArea.getText().equals(string)) {
            this.textArea.setText(string);
            int n = 0;
            if (this.currentPos != -1) {
                n = this.currentPos;
            }
            this.textArea.select(n);
        }
        Enumeration enumeration = this.breakpoints.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Integer n = (Integer)this.breakpoints.get(k);
            if (this.db.setBreakPoint(this.url, n) != -1) continue;
            this.breakpoints.remove(k);
        }
        this.fileHeader.update();
        this.fileHeader.repaint();
    }

    void setPosition(int n) {
        this.textArea.select(n);
        this.currentPos = n;
        this.fileHeader.repaint();
    }

    void select(int n, int n2) {
        int n3 = this.textArea.getDocument().getLength();
        this.textArea.select(n3, n3);
        this.textArea.select(n, n2);
    }
}

