/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.classfile.DefiningClassLoader;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.LocalVariable;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.NativeScript;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecuritySupport;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.optimizer.OptClassNameHelper;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptIRFactory;
import org.mozilla.javascript.optimizer.OptLocalVariable;
import org.mozilla.javascript.optimizer.OptTransformer;
import org.mozilla.javascript.optimizer.OptVariableTable;
import org.mozilla.javascript.optimizer.Optimizer;

public class Codegen
extends Interpreter {
    private final int JAVASCRIPTEXCEPTION = 0;
    private final int WRAPPEDEXCEPTION = 1;
    private static final String normalFunctionSuperClassName = "org.mozilla.javascript.NativeFunction";
    private static final String normalScriptSuperClassName = "org.mozilla.javascript.NativeScript";
    private static final String debugFunctionSuperClassName = "org.mozilla.javascript.debug.NativeFunctionDebug";
    private static final String debugScriptSuperClassName = "org.mozilla.javascript.debug.NativeScriptDebug";
    private String superClassName;
    private String superClassSlashName;
    private String name;
    private int ordinal;
    boolean inFunction;
    boolean inDirectCallFunction;
    private ClassFileWriter classFile;
    private Vector namesVector;
    private Vector classFilesVector;
    private short scriptRuntimeIndex;
    private int version;
    private OptClassNameHelper itsNameHelper;
    private String itsSourceFile;
    private int itsLineNumber;
    private int stackDepth;
    private int stackDepthMax;
    private static final int MAX_LOCALS = 256;
    private boolean[] locals;
    private short firstFreeLocal;
    private short localsMax;
    private double[] itsConstantList;
    private int itsConstantListSize;
    private short variableObjectLocal;
    private short scriptResultLocal;
    private short contextLocal;
    private short argsLocal;
    private short thisObjLocal;
    private short funObjLocal;
    private short debug_pcLocal;
    private short debugStopSubRetLocal;
    private short itsZeroArgArray;
    private short itsOneArgArray;
    private boolean hasVarsInRegs;
    private boolean itsForcedObjectParameters;
    private boolean trivialInit;
    private short itsLocalAllocationBase;
    private OptVariableTable vars;
    private OptVariableTable debugVars;
    private int epilogueLabel;
    private int optLevel;
    static /* synthetic */ Class class$java$lang$Object;

    public IRFactory createIRFactory(TokenStream tokenStream, ClassNameHelper classNameHelper, Scriptable scriptable) {
        return new OptIRFactory(tokenStream, classNameHelper, scriptable);
    }

    public Node transform(Node node, TokenStream tokenStream, Scriptable scriptable) {
        OptTransformer optTransformer = new OptTransformer(new Hashtable(11));
        return optTransformer.transform(node, null, tokenStream, scriptable);
    }

    public Object compile(Context context, Scriptable scriptable, Node node, Object object, SecuritySupport securitySupport, ClassNameHelper classNameHelper) throws IOException {
        Object object2;
        Object object3;
        Object object4;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        String string = null;
        RuntimeException runtimeException = null;
        Class clazz = null;
        DefiningClassLoader definingClassLoader = new DefiningClassLoader();
        classNameHelper.reset();
        try {
            if (context.getOptimizationLevel() > 0) {
                new Optimizer().optimize(node, context.getOptimizationLevel());
            }
            string = this.generateCode(node, vector2, vector, classNameHelper);
            object4 = classNameHelper.getClassRepository();
            int n = 0;
            while (n < vector2.size()) {
                object3 = (String)vector2.elementAt(n);
                object2 = (byte[])vector.elementAt(n);
                boolean bl = ((String)object3).equals(string);
                try {
                    if (object4.storeClass((String)object3, (byte[])object2, bl)) {
                        Class<?> clazz2 = null;
                        if (securitySupport != null) {
                            clazz2 = securitySupport.defineClass((String)object3, (byte[])object2, object);
                        }
                        if (clazz2 == null) {
                            Context.checkSecurityDomainRequired();
                            clazz2 = definingClassLoader.defineClass((String)object3, (byte[])object2);
                            ClassLoader classLoader = clazz2.getClassLoader();
                            clazz2 = classLoader.loadClass((String)object3);
                        }
                        if (bl) {
                            clazz = clazz2;
                        }
                    }
                }
                catch (ClassFormatError classFormatError) {
                    throw new RuntimeException(classFormatError.toString());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException.toString());
                }
                catch (IOException iOException) {
                    throw WrappedException.wrapException(iOException);
                }
                ++n;
            }
        }
        catch (SecurityException securityException) {
            runtimeException = securityException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            runtimeException = illegalArgumentException;
        }
        if (runtimeException != null) {
            throw new RuntimeException("Malformed optimizer package " + runtimeException);
        }
        object4 = (OptClassNameHelper)classNameHelper;
        if (((OptClassNameHelper)object4).getTargetImplements() != null || ((OptClassNameHelper)object4).getTargetExtends() != null) {
            String string2 = ((OptClassNameHelper)object4).getJavaScriptClassName(null, true);
            object3 = new NativeObject();
            object2 = node.getFirstChild();
            while (object2 != null) {
                if (((Node)object2).getType() == 110) {
                    ((ScriptableObject)object3).put(((Node)object2).getString(), (Scriptable)object3, ((Node)object2).getProp(5));
                }
                object2 = ((Node)object2).getNextSibling();
            }
            try {
                Class clazz3 = ((OptClassNameHelper)object4).getTargetExtends();
                if (clazz3 == null) {
                    clazz3 = class$java$lang$Object == null ? (class$java$lang$Object = Codegen.class$("java.lang.Object")) : class$java$lang$Object;
                }
                JavaAdapter.createAdapterClass(context, (Scriptable)object3, string2, clazz3, ((OptClassNameHelper)object4).getTargetImplements(), string, (ClassNameHelper)object4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error(classNotFoundException.toString());
            }
        }
        if (node instanceof OptFunctionNode) {
            if (clazz == null) {
                return null;
            }
            return ScriptRuntime.createFunctionObject(scriptable, clazz, context, true);
        }
        try {
            if (clazz == null) {
                return null;
            }
            NativeScript nativeScript = (NativeScript)clazz.newInstance();
            if (scriptable != null) {
                nativeScript.setPrototype(ScriptableObject.getClassPrototype(scriptable, "Script"));
                nativeScript.setParentScope(scriptable);
            }
            return nativeScript;
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        throw new RuntimeException("Unable to instantiate compiled class");
    }

    void addByteCode(byte by) {
        this.classFile.add(by);
    }

    void addByteCode(byte by, int n) {
        this.classFile.add(by, n);
    }

    void addByteCode(byte by, String string) {
        this.classFile.add(by, string);
    }

    void addVirtualInvoke(String string, String string2, String string3, String string4) {
        this.classFile.add((byte)-74, string, string2, string3, string4);
    }

    void addStaticInvoke(String string, String string2, String string3, String string4) {
        this.classFile.add((byte)-72, string, string2, string3, string4);
    }

    void addScriptRuntimeInvoke(String string, String string2, String string3) {
        this.classFile.add((byte)-72, "org/mozilla/javascript/ScriptRuntime", string, string2, string3);
    }

    void addOptRuntimeInvoke(String string, String string2, String string3) {
        this.classFile.add((byte)-72, "org/mozilla/javascript/optimizer/OptRuntime", string, string2, string3);
    }

    void addSpecialInvoke(String string, String string2, String string3, String string4) {
        this.classFile.add((byte)-73, string, string2, string3, string4);
    }

    void addDoubleConstructor() {
        this.classFile.add((byte)-73, "java/lang/Double", "<init>", "(D)", "V");
    }

    public int markLabel(int n) {
        return this.classFile.markLabel(n);
    }

    public int markLabel(int n, short s) {
        return this.classFile.markLabel(n, s);
    }

    public int acquireLabel() {
        return this.classFile.acquireLabel();
    }

    public void emitDirectConstructor(OptFunctionNode optFunctionNode) {
        short s = 17;
        this.classFile.startMethod("constructDirect", optFunctionNode.getDirectCallParameterSignature() + "Ljava/lang/Object;", s);
        int n = optFunctionNode.getVariableTable().getParameterCount();
        short s2 = (short)(4 + n * 3 + 1);
        this.addByteCode((byte)-69, "org/mozilla/javascript/NativeObject");
        this.addByteCode((byte)89);
        this.classFile.add((byte)-73, "org/mozilla/javascript/NativeObject", "<init>", "()", "V");
        this.astore(s2);
        this.aload(s2);
        this.aload((short)0);
        this.addVirtualInvoke("org/mozilla/javascript/NativeFunction", "getClassPrototype", "()", "Lorg/mozilla/javascript/Scriptable;");
        this.classFile.add((byte)-71, "org/mozilla/javascript/Scriptable", "setPrototype", "(Lorg/mozilla/javascript/Scriptable;)", "V");
        this.aload(s2);
        this.aload((short)0);
        this.addVirtualInvoke("org/mozilla/javascript/NativeFunction", "getParentScope", "()", "Lorg/mozilla/javascript/Scriptable;");
        this.classFile.add((byte)-71, "org/mozilla/javascript/Scriptable", "setPrototype", "(Lorg/mozilla/javascript/Scriptable;)", "V");
        this.aload((short)0);
        this.aload((short)1);
        this.aload((short)2);
        this.aload(s2);
        int n2 = 0;
        while (n2 < n) {
            this.aload((short)(4 + n2 * 3));
            this.dload((short)(5 + n2 * 3));
            ++n2;
        }
        this.aload((short)(4 + n * 3));
        this.addVirtualInvoke(this.name, "callDirect", optFunctionNode.getDirectCallParameterSignature(), "Ljava/lang/Object;");
        this.astore((short)(s2 + 1));
        int n3 = this.acquireLabel();
        this.aload((short)(s2 + 1));
        this.addByteCode((byte)-58, n3);
        this.aload((short)(s2 + 1));
        this.pushUndefined();
        this.addByteCode((byte)-91, n3);
        this.aload((short)(s2 + 1));
        this.addByteCode((byte)-63, "org/mozilla/javascript/Scriptable");
        this.addByteCode((byte)-103, n3);
        this.aload((short)(s2 + 1));
        this.addByteCode((byte)-64, "org/mozilla/javascript/Scriptable");
        this.addByteCode((byte)-80);
        this.markLabel(n3);
        this.aload(s2);
        this.addByteCode((byte)-80);
        this.classFile.stopMethod((short)(s2 + 2), null);
    }

    public String generateCode(Node node, Vector vector, Vector vector2, ClassNameHelper classNameHelper) {
        Node node2;
        Object object;
        Object object2;
        this.itsNameHelper = (OptClassNameHelper)classNameHelper;
        this.namesVector = vector;
        this.classFilesVector = vector2;
        Context context = Context.getCurrentContext();
        this.itsSourceFile = null;
        if (!context.isGeneratingDebugChanged() || context.isGeneratingDebug()) {
            this.itsSourceFile = (String)node.getProp(16);
        }
        this.version = context.getLanguageVersion();
        this.optLevel = context.getOptimizationLevel();
        this.inFunction = node.getType() == 110;
        this.superClassName = this.inFunction ? normalFunctionSuperClassName : normalScriptSuperClassName;
        this.superClassSlashName = this.superClassName.replace('.', '/');
        if (this.inFunction) {
            object2 = (OptFunctionNode)node;
            this.inDirectCallFunction = ((OptFunctionNode)object2).isTargetOfDirectCall();
            this.vars = (OptVariableTable)((FunctionNode)object2).getVariableTable();
            this.name = ((OptFunctionNode)object2).getClassName();
            this.classFile = new ClassFileWriter(this.name, this.superClassName, this.itsSourceFile);
            object = node.getFirstChild();
            String string = ((FunctionNode)object2).getFunctionName();
            this.generateInit(context, "<init>", node, string, (Node)object);
            if (((OptFunctionNode)object2).isTargetOfDirectCall()) {
                int n;
                this.classFile.startMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", (short)17);
                this.addByteCode((byte)42);
                this.addByteCode((byte)43);
                this.addByteCode((byte)44);
                this.addByteCode((byte)45);
                int n2 = 0;
                while (n2 < this.vars.getParameterCount()) {
                    this.push(n2);
                    this.addByteCode((byte)25, 4);
                    this.addByteCode((byte)-66);
                    n = this.acquireLabel();
                    int n3 = this.acquireLabel();
                    this.addByteCode((byte)-94, n);
                    this.addByteCode((byte)25, 4);
                    this.push(n2);
                    this.addByteCode((byte)50);
                    this.push(0.0);
                    this.addByteCode((byte)-89, n3);
                    this.markLabel(n);
                    this.pushUndefined();
                    this.push(0.0);
                    this.markLabel(n3);
                    ++n2;
                }
                this.addByteCode((byte)25, 4);
                this.addVirtualInvoke(this.name, "callDirect", ((OptFunctionNode)object2).getDirectCallParameterSignature(), "Ljava/lang/Object;");
                this.addByteCode((byte)-80);
                this.classFile.stopMethod((short)5, null);
                this.emitDirectConstructor((OptFunctionNode)object2);
                this.startNewMethod("callDirect", ((OptFunctionNode)object2).getDirectCallParameterSignature() + "Ljava/lang/Object;", 1, false, true);
                this.vars.assignParameterJRegs();
                if (!((OptFunctionNode)object2).getParameterNumberContext()) {
                    this.itsForcedObjectParameters = true;
                    n = 0;
                    while (n < this.vars.getParameterCount()) {
                        OptLocalVariable optLocalVariable = (OptLocalVariable)this.vars.getVariable(n);
                        this.aload(optLocalVariable.getJRegister());
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        int n4 = this.acquireLabel();
                        this.addByteCode((byte)-90, n4);
                        this.addByteCode((byte)-69, "java/lang/Double");
                        this.addByteCode((byte)89);
                        this.dload((short)(optLocalVariable.getJRegister() + 1));
                        this.addDoubleConstructor();
                        this.astore(optLocalVariable.getJRegister());
                        this.markLabel(n4);
                        ++n;
                    }
                }
                this.generatePrologue(context, node, true, this.vars.getParameterCount());
            } else {
                this.startNewMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", 1, false, true);
                this.generatePrologue(context, node, true, -1);
            }
            node2 = node.getLastChild();
        } else {
            if (node.getType() != 146) {
                this.badTree();
            }
            this.vars = (OptVariableTable)node.getProp(10);
            boolean bl = this.itsNameHelper.getTargetExtends() == null && this.itsNameHelper.getTargetImplements() == null;
            this.name = this.itsNameHelper.getJavaScriptClassName(null, bl);
            this.classFile = new ClassFileWriter(this.name, this.superClassName, this.itsSourceFile);
            this.classFile.addInterface("org/mozilla/javascript/Script");
            this.generateScriptCtor(context, node);
            this.generateMain(context);
            this.generateInit(context, "initScript", node, "", null);
            this.generateExecute(context);
            this.startNewMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", 1, false, true);
            this.generatePrologue(context, node, false, -1);
            int n = node.getIntProp(29, -1);
            if (n != -1) {
                this.classFile.addLineNumberEntry((short)n);
            }
            node.addChildToBack(new Node(5));
            node2 = node;
        }
        this.generateCodeFromNode(node2, null, -1, -1);
        this.generateEpilogue();
        this.finishMethod(context, this.debugVars);
        this.emitConstantDudeInitializers();
        object2 = new ByteArrayOutputStream(512);
        try {
            this.classFile.write((OutputStream)object2);
        }
        catch (IOException iOException) {
            throw new RuntimeException("unexpected IOException");
        }
        object = ((ByteArrayOutputStream)object2).toByteArray();
        this.namesVector.addElement(this.name);
        this.classFilesVector.addElement(object);
        this.classFile = null;
        this.namesVector = null;
        this.classFilesVector = null;
        return this.name;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void generateCodeFromNode(Node node, Node node2, int n, int n2) {
        int n3 = node.getType();
        Node node3 = node.getFirstChild();
        switch (n3) {
            case 124: 
            case 136: 
            case 138: {
                this.visitStatement(node);
                while (true) {
                    if (node3 == null) {
                        return;
                    }
                    this.generateCodeFromNode(node3, node, n, n2);
                    node3 = node3.getNextSibling();
                }
            }
            case 116: 
            case 117: 
            case 128: 
            case 132: 
            case 133: 
            case 146: {
                this.visitStatement(node);
                while (true) {
                    if (node3 == null) {
                        return;
                    }
                    this.generateCodeFromNode(node3, node, n, n2);
                    node3 = node3.getNextSibling();
                }
            }
            case 110: {
                FunctionNode functionNode;
                byte by;
                if (!this.inFunction) {
                    if (node2.getType() == 146) return;
                }
                if ((by = (functionNode = (FunctionNode)node.getProp(5)).getFunctionType()) == 1) return;
                this.visitFunction(functionNode, by == 3);
                return;
            }
            case 44: {
                this.visitName(node);
                return;
            }
            case 30: 
            case 43: {
                this.visitCall(node, n3, node3);
                return;
            }
            case 45: 
            case 46: {
                this.visitLiteral(node);
                return;
            }
            case 109: {
                this.visitPrimary(node);
                return;
            }
            case 56: {
                this.visitObject(node);
                return;
            }
            case 75: {
                this.visitTryCatchFinally(node, node3);
                return;
            }
            case 62: {
                this.visitThrow(node, node3);
                return;
            }
            case 5: {
                this.visitReturn(node, node3);
                return;
            }
            case 115: {
                this.visitSwitch(node, node3);
                return;
            }
            case 96: {
                this.generateCodeFromNode(node3, node, -1, -1);
                this.addByteCode((byte)87);
                this.generateCodeFromNode(node3.getNextSibling(), node, n, n2);
                return;
            }
            case 77: {
                this.addScriptRuntimeInvoke("newScope", "()", "Lorg/mozilla/javascript/Scriptable;");
                return;
            }
            case 3: {
                this.visitEnterWith(node, node3);
                return;
            }
            case 4: {
                this.visitLeaveWith(node, node3);
                return;
            }
            case 79: {
                this.visitEnumInit(node, node3);
                return;
            }
            case 80: {
                this.visitEnumNext(node, node3);
                return;
            }
            case 139: {
                this.visitEnumDone(node, node3);
                return;
            }
            case 57: {
                this.visitStatement(node);
                if (node3.getType() == 73) {
                    this.visitSetVar(node3, node3.getFirstChild(), false);
                    return;
                }
                while (true) {
                    if (node3 == null) {
                        if (node.getIntProp(26, -1) == -1) break;
                        this.addByteCode((byte)88);
                        return;
                    }
                    this.generateCodeFromNode(node3, node, n, n2);
                    node3 = node3.getNextSibling();
                }
                this.addByteCode((byte)87);
                return;
            }
            case 2: {
                this.visitStatement(node);
                while (true) {
                    if (node3 == null) {
                        this.astore(this.scriptResultLocal);
                        return;
                    }
                    this.generateCodeFromNode(node3, node, n, n2);
                    node3 = node3.getNextSibling();
                }
            }
            case 137: {
                this.visitTarget(node);
                return;
            }
            case 6: 
            case 7: 
            case 8: 
            case 143: {
                this.visitGOTO(node, n3, node3);
                return;
            }
            case 105: {
                this.visitUnary(node, node3, n, n2);
                return;
            }
            case 32: {
                this.visitTypeof(node, node3);
                return;
            }
            case 106: {
                this.visitIncDec(node, true);
                return;
            }
            case 107: {
                this.visitIncDec(node, false);
                return;
            }
            case 100: 
            case 101: {
                if (n == -1) {
                    this.generateCodeFromNode(node3, node, n, n2);
                    this.addByteCode((byte)89);
                    this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                    int n4 = this.acquireLabel();
                    if (n3 == 101) {
                        this.addByteCode((byte)-103, n4);
                    } else {
                        this.addByteCode((byte)-102, n4);
                    }
                    this.addByteCode((byte)87);
                    this.generateCodeFromNode(node3.getNextSibling(), node, n, n2);
                    this.markLabel(n4);
                    return;
                }
                int n5 = this.acquireLabel();
                if (n3 == 101) {
                    this.generateCodeFromNode(node3, node, n5, n2);
                    if ((node3.getType() != 105 || node3.getInt() != 129) && node3.getType() != 101 && node3.getType() != 100 && node3.getType() != 103 && node3.getType() != 102) {
                        this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                        this.addByteCode((byte)-102, n5);
                        this.addByteCode((byte)-89, n2);
                    }
                } else {
                    this.generateCodeFromNode(node3, node, n, n5);
                    if ((node3.getType() != 105 || node3.getInt() != 129) && node3.getType() != 101 && node3.getType() != 100 && node3.getType() != 103 && node3.getType() != 102) {
                        this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                        this.addByteCode((byte)-102, n);
                        this.addByteCode((byte)-89, n5);
                    }
                }
                this.markLabel(n5);
                node3 = node3.getNextSibling();
                this.generateCodeFromNode(node3, node, n, n2);
                if (node3.getType() == 105) {
                    if (node3.getInt() == 129) return;
                }
                if (node3.getType() == 101) return;
                if (node3.getType() == 100) return;
                if (node3.getType() == 103) return;
                if (node3.getType() == 102) {
                    return;
                }
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                this.addByteCode((byte)-102, n);
                this.addByteCode((byte)-89, n2);
                return;
            }
            case 23: {
                this.generateCodeFromNode(node3, node, n, n2);
                this.generateCodeFromNode(node3.getNextSibling(), node, n, n2);
                switch (node.getIntProp(26, -1)) {
                    case 0: {
                        this.addByteCode((byte)99);
                        return;
                    }
                    case 1: {
                        this.addOptRuntimeInvoke("add", "(DLjava/lang/Object;)", "Ljava/lang/Object;");
                        return;
                    }
                    case 2: {
                        this.addOptRuntimeInvoke("add", "(Ljava/lang/Object;D)", "Ljava/lang/Object;");
                        return;
                    }
                }
                this.addScriptRuntimeInvoke("add", "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Object;");
                return;
            }
            case 25: {
                this.visitArithmetic(node, (byte)107, node3, node2);
                return;
            }
            case 24: {
                this.visitArithmetic(node, (byte)103, node3, node2);
                return;
            }
            case 26: 
            case 27: {
                this.visitArithmetic(node, n3 == 26 ? (byte)111 : 115, node3, node2);
                return;
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: {
                this.visitBitOp(node, n3, node3);
                return;
            }
            case 142: {
                Object object = node.getProp(18);
                if (object == ScriptRuntime.NumberClass) {
                    this.addByteCode((byte)-69, "java/lang/Double");
                    this.addByteCode((byte)89);
                    this.generateCodeFromNode(node3, node, n, n2);
                    this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
                    this.addDoubleConstructor();
                    return;
                }
                if (object == ScriptRuntime.DoubleClass) {
                    this.generateCodeFromNode(node3, node, n, n2);
                    this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
                    return;
                }
                if (object != ScriptRuntime.ObjectClass) {
                    this.badTree();
                    return;
                }
                int n6 = -1;
                if (node3.getType() == 45) {
                    n6 = node3.getIntProp(26, -1);
                }
                if (n6 != -1) {
                    node3.removeProp(26);
                    this.generateCodeFromNode(node3, node, n, n2);
                    node3.putIntProp(26, n6);
                    return;
                }
                this.addByteCode((byte)-69, "java/lang/Double");
                this.addByteCode((byte)89);
                this.generateCodeFromNode(node3, node, n, n2);
                this.addDoubleConstructor();
                return;
            }
            case 103: {
                if (n == -1) {
                    this.visitRelOp(node, node3, node2);
                    return;
                }
                this.visitGOTOingRelOp(node, node3, node2, n, n2);
                return;
            }
            case 102: {
                this.visitEqOp(node, node3, node2, n, n2);
                return;
            }
            case 39: {
                this.visitGetProp(node, node3);
                return;
            }
            case 41: {
                while (true) {
                    if (node3 == null) {
                        this.aload(this.variableObjectLocal);
                        if (node.getIntProp(26, -1) == -1) break;
                        this.addOptRuntimeInvoke("getElem", "(Ljava/lang/Object;DLorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
                        return;
                    }
                    this.generateCodeFromNode(node3, node, n, n2);
                    node3 = node3.getNextSibling();
                }
                this.addScriptRuntimeInvoke("getElem", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
                return;
            }
            case 72: {
                OptLocalVariable optLocalVariable = (OptLocalVariable)node.getProp(24);
                this.visitGetVar(optLocalVariable, node.getIntProp(26, -1) != -1, node.getString());
                return;
            }
            case 73: {
                this.visitSetVar(node, node3, true);
                return;
            }
            case 10: {
                this.visitSetName(node, node3);
                return;
            }
            case 40: {
                this.visitSetProp(node, node3);
                return;
            }
            case 42: {
                while (true) {
                    if (node3 == null) {
                        this.aload(this.variableObjectLocal);
                        if (node.getIntProp(26, -1) == -1) break;
                        this.addOptRuntimeInvoke("setElem", "(Ljava/lang/Object;DLjava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
                        return;
                    }
                    this.generateCodeFromNode(node3, node, n, n2);
                    node3 = node3.getNextSibling();
                }
                this.addScriptRuntimeInvoke("setElem", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
                return;
            }
            case 31: {
                while (true) {
                    if (node3 == null) {
                        this.addScriptRuntimeInvoke("delete", "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Object;");
                        return;
                    }
                    this.generateCodeFromNode(node3, node, n, n2);
                    node3 = node3.getNextSibling();
                }
            }
            case 61: 
            case 71: {
                this.visitBind(node, n3, node3);
                return;
            }
            case 68: {
                this.generateCodeFromNode(node3, node, n, n2);
                this.addScriptRuntimeInvoke("getThis", "(Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
                return;
            }
            case 141: {
                this.generateCodeFromNode(node3, node, n, n2);
                this.addScriptRuntimeInvoke("getParent", "(Ljava/lang/Object;)", "Lorg/mozilla/javascript/Scriptable;");
                return;
            }
            case 69: {
                this.visitNewTemp(node, node3);
                return;
            }
            case 70: {
                this.visitUseTemp(node, node3);
                return;
            }
            case 144: {
                this.visitNewLocal(node, node3);
                return;
            }
            case 145: {
                this.visitUseLocal(node, node3);
                return;
            }
        }
        throw new RuntimeException("Unexpected node type " + TokenStream.tokenToName(n3));
    }

    private void startNewMethod(String string, String string2, int n, boolean bl, boolean bl2) {
        this.locals = new boolean[256];
        this.localsMax = (short)(n + 1);
        this.firstFreeLocal = 0;
        this.contextLocal = (short)-1;
        this.variableObjectLocal = (short)-1;
        this.scriptResultLocal = (short)-1;
        this.argsLocal = (short)-1;
        this.thisObjLocal = (short)-1;
        this.funObjLocal = (short)-1;
        this.debug_pcLocal = (short)-1;
        this.debugStopSubRetLocal = (short)-1;
        this.itsZeroArgArray = (short)-1;
        this.itsOneArgArray = (short)-1;
        short s = 1;
        if (bl) {
            s = (short)(s | 8);
        }
        if (bl2) {
            s = (short)(s | 0x10);
        }
        this.epilogueLabel = -1;
        this.classFile.startMethod(string, string2, s);
    }

    private void finishMethod(Context context, VariableTable variableTable) {
        this.classFile.stopMethod((short)(this.localsMax + 1), variableTable);
        this.contextLocal = (short)-1;
    }

    private void generateMain(Context context) {
        this.startNewMethod("main", "([Ljava/lang/String;)V", 1, true, true);
        this.push(this.name);
        this.addByteCode((byte)42);
        this.addScriptRuntimeInvoke("main", "(Ljava/lang/String;[Ljava/lang/String;)", "V");
        this.addByteCode((byte)-79);
        this.finishMethod(context, null);
    }

    private void generateExecute(Context context) {
        String string = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;";
        this.startNewMethod("exec", string, 2, false, true);
        String string2 = this.name.replace('.', '/');
        if (!this.trivialInit) {
            this.addByteCode((byte)42);
            this.addByteCode((byte)44);
            this.addByteCode((byte)43);
            this.addVirtualInvoke(string2, "initScript", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)", "V");
        }
        this.addByteCode((byte)42);
        this.addByteCode((byte)43);
        this.addByteCode((byte)44);
        this.addByteCode((byte)89);
        this.addByteCode((byte)1);
        this.addVirtualInvoke(string2, "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)", "Ljava/lang/Object;");
        this.addByteCode((byte)-80);
        this.finishMethod(context, null);
    }

    private void generateScriptCtor(Context context, Node node) {
        this.startNewMethod("<init>", "()V", 1, false, false);
        this.addByteCode((byte)42);
        this.addSpecialInvoke(this.superClassSlashName, "<init>", "()", "V");
        this.addByteCode((byte)-79);
        this.finishMethod(context, null);
    }

    private void setNonTrivialInit(String string) {
        if (!this.trivialInit) {
            return;
        }
        this.trivialInit = false;
        this.startNewMethod(string, "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)V", 1, false, false);
        this.reserveWordLocal(0);
        this.variableObjectLocal = this.reserveWordLocal(1);
        this.contextLocal = this.reserveWordLocal(2);
    }

    private void generateInit(Context context, String string, Node node, String string2, Node node2) {
        Vector vector;
        Vector vector2;
        String string3;
        int n;
        this.trivialInit = true;
        boolean bl = false;
        VariableTable variableTable = node instanceof OptFunctionNode ? ((OptFunctionNode)node).getVariableTable() : (VariableTable)node.getProp(10);
        if (string.equals("<init>")) {
            bl = true;
            this.setNonTrivialInit(string);
            this.addByteCode((byte)42);
            this.addSpecialInvoke(this.superClassSlashName, "<init>", "()", "V");
            this.addByteCode((byte)42);
            this.addByteCode((byte)43);
            this.classFile.add((byte)-75, "org/mozilla/javascript/ScriptableObject", "parent", "Lorg/mozilla/javascript/Scriptable;");
        }
        if (string2.length() != 0) {
            this.setNonTrivialInit(string);
            this.addByteCode((byte)42);
            this.classFile.addLoadConstant(string2);
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "functionName", "Ljava/lang/String;");
        }
        if (variableTable != null && (n = variableTable.size()) != 0) {
            this.setNonTrivialInit(string);
            this.push(n);
            this.addByteCode((byte)-67, "java/lang/String");
            int n2 = 0;
            while (n2 != n) {
                this.addByteCode((byte)89);
                this.push(n2);
                this.push(variableTable.getName(n2));
                this.addByteCode((byte)83);
                ++n2;
            }
            this.addByteCode((byte)42);
            this.addByteCode((byte)95);
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "argNames", "[Ljava/lang/String;");
        }
        int n3 = n = variableTable == null ? 0 : variableTable.getParameterCount();
        if (n != 0) {
            this.setNonTrivialInit(string);
            this.addByteCode((byte)42);
            this.push(n);
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "argCount", "S");
        }
        if (context.getLanguageVersion() != 0) {
            this.setNonTrivialInit(string);
            this.addByteCode((byte)42);
            this.push(context.getLanguageVersion());
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "version", "S");
        }
        if ((string3 = (String)node.getProp(17)) != null && context.isGeneratingSource() && string3.length() < 65536) {
            this.setNonTrivialInit(string);
            this.addByteCode((byte)42);
            this.push(string3);
            this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "source", "Ljava/lang/String;");
        }
        if ((vector2 = (Vector)node.getProp(12)) != null) {
            this.setNonTrivialInit(string);
            this.generateRegExpLiterals(vector2, bl);
        }
        if ((vector = (Vector)node.getProp(5)) != null) {
            this.setNonTrivialInit(string);
            this.generateFunctionInits(vector);
        }
        if (node instanceof OptFunctionNode) {
            OptFunctionNode optFunctionNode = (OptFunctionNode)node;
            Vector vector3 = ((OptFunctionNode)node).getDirectCallTargets();
            if (vector3 != null) {
                this.setNonTrivialInit(string);
                this.classFile.addField("EmptyArray", "[Ljava/lang/Object;", (short)2);
                this.addByteCode((byte)42);
                this.push(0);
                this.addByteCode((byte)-67, "java/lang/Object");
                this.classFile.add((byte)-75, ClassFileWriter.fullyQualifiedForm(this.name), "EmptyArray", "[Ljava/lang/Object;");
            }
            if (optFunctionNode.isTargetOfDirectCall()) {
                this.setNonTrivialInit(string);
                String string4 = ClassFileWriter.fullyQualifiedForm(optFunctionNode.getClassName());
                String string5 = string4.replace('/', '_');
                this.classFile.addField(string5, "L" + string4 + ";", (short)9);
                this.addByteCode((byte)42);
                this.classFile.add((byte)-77, string4, string5, "L" + string4 + ";");
            }
        }
        if (!this.trivialInit) {
            this.addByteCode((byte)-79);
            this.finishMethod(context, null);
        }
    }

    private void generateRegExpLiterals(Vector vector, boolean bl) {
        int n = 0;
        while (n < vector.size()) {
            Node node = (Node)vector.elementAt(n);
            StringBuffer stringBuffer = new StringBuffer("_re");
            stringBuffer.append(n);
            String string = stringBuffer.toString();
            short s = 2;
            if (bl) {
                s = (short)(s | 0x10);
            }
            this.classFile.addField(string, "Lorg/mozilla/javascript/regexp/NativeRegExp;", s);
            this.addByteCode((byte)42);
            this.addByteCode((byte)-69, "org/mozilla/javascript/regexp/NativeRegExp");
            this.addByteCode((byte)89);
            this.aload(this.contextLocal);
            this.aload(this.variableObjectLocal);
            Node node2 = node.getFirstChild();
            this.push(node2.getString());
            Node node3 = node.getLastChild();
            if (node2 == node3) {
                this.addByteCode((byte)1);
            } else {
                this.push(node3.getString());
            }
            this.push(0);
            this.addSpecialInvoke("org/mozilla/javascript/regexp/NativeRegExp", "<init>", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Ljava/lang/String;Z)", "V");
            node.putProp(12, string);
            this.classFile.add((byte)-75, ClassFileWriter.fullyQualifiedForm(this.name), string, "Lorg/mozilla/javascript/regexp/NativeRegExp;");
            ++n;
        }
    }

    private void generateFunctionInits(Vector vector) {
        this.push(vector.size());
        this.addByteCode((byte)-67, "org/mozilla/javascript/NativeFunction");
        int n = 0;
        while (n < vector.size()) {
            this.addByteCode((byte)89);
            this.push(n);
            Node node = (Node)vector.elementAt(n);
            Codegen codegen = new Codegen();
            String string = codegen.generateCode(node, this.namesVector, this.classFilesVector, this.itsNameHelper);
            this.addByteCode((byte)-69, string);
            this.addByteCode((byte)89);
            if (this.inFunction) {
                this.addByteCode((byte)42);
            } else {
                this.aload(this.variableObjectLocal);
            }
            this.aload(this.contextLocal);
            this.addSpecialInvoke(string, "<init>", "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;)", "V");
            if (this.inFunction) {
                this.addByteCode((byte)42);
            } else {
                this.aload(this.variableObjectLocal);
            }
            String string2 = node.getString();
            if (string2 != null) {
                this.push(string2);
            } else {
                this.addByteCode((byte)1);
            }
            this.aload(this.contextLocal);
            boolean bl = string2 != null && string2.length() > 0 && ((FunctionNode)node).getFunctionType() == 1;
            this.addByteCode(bl ? (byte)4 : 3);
            this.addScriptRuntimeInvoke("initFunction", "(Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Context;Z)", "Lorg/mozilla/javascript/NativeFunction;");
            node.putIntProp(5, n);
            this.addByteCode((byte)83);
            n = (short)(n + 1);
        }
        this.addByteCode((byte)42);
        this.addByteCode((byte)95);
        this.classFile.add((byte)-75, "org/mozilla/javascript/NativeFunction", "nestedFunctions", "[Lorg/mozilla/javascript/NativeFunction;");
    }

    private void generatePrologue(Context context, Node node, boolean bl, int n) {
        String string;
        int n2;
        int n3;
        this.funObjLocal = this.reserveWordLocal(0);
        this.contextLocal = this.reserveWordLocal(1);
        this.variableObjectLocal = this.reserveWordLocal(2);
        this.thisObjLocal = this.reserveWordLocal(3);
        if (bl && !context.hasCompileFunctionsWithDynamicScope() && n == -1) {
            this.aload(this.funObjLocal);
            this.classFile.add((byte)-71, "org/mozilla/javascript/Scriptable", "getParentScope", "()", "Lorg/mozilla/javascript/Scriptable;");
            this.astore(this.variableObjectLocal);
        }
        if (n > 0) {
            n3 = 0;
            while (n3 < 3 * n) {
                this.reserveWordLocal(n3 + 4);
                ++n3;
            }
        }
        this.argsLocal = this.reserveWordLocal(n <= 0 ? 4 : 3 * n + 4);
        n3 = node.getIntProp(22, 0);
        if (n3 != 0) {
            this.itsLocalAllocationBase = (short)(this.argsLocal + 1);
            n2 = 0;
            while (n2 < n3) {
                this.reserveWordLocal(this.itsLocalAllocationBase + n2);
                ++n2;
            }
        }
        if (bl && ((OptFunctionNode)node).getCheckThis()) {
            this.aload(this.thisObjLocal);
            this.addScriptRuntimeInvoke("getThis", "(Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
            this.astore(this.thisObjLocal);
        }
        boolean bl2 = this.hasVarsInRegs = bl && !((OptFunctionNode)node).requiresActivation();
        if (this.hasVarsInRegs) {
            short s;
            n2 = this.vars.getParameterCount();
            if (bl && n2 > 0 && n < 0) {
                this.aload(this.argsLocal);
                this.addByteCode((byte)-66);
                this.push(n2);
                s = this.acquireLabel();
                this.addByteCode((byte)-94, s);
                this.aload(this.argsLocal);
                this.push(n2);
                this.addScriptRuntimeInvoke("padArguments", "([Ljava/lang/Object;I)", "[Ljava/lang/Object;");
                this.astore(this.argsLocal);
                this.markLabel(s);
            }
            s = -1;
            int n4 = 0;
            while (n4 < this.vars.size()) {
                OptLocalVariable optLocalVariable = (OptLocalVariable)this.vars.getVariable(n4);
                if (optLocalVariable.isNumber()) {
                    optLocalVariable.assignJRegister(this.getNewWordPairLocal());
                    this.push(0.0);
                    this.dstore(optLocalVariable.getJRegister());
                } else if (optLocalVariable.isParameter()) {
                    if (n < 0) {
                        optLocalVariable.assignJRegister(this.getNewWordLocal());
                        this.aload(this.argsLocal);
                        this.push(n4);
                        this.addByteCode((byte)50);
                        this.astore(optLocalVariable.getJRegister());
                    }
                } else {
                    optLocalVariable.assignJRegister(this.getNewWordLocal());
                    if (s == -1) {
                        this.pushUndefined();
                        s = optLocalVariable.getJRegister();
                    } else {
                        this.aload(s);
                    }
                    this.astore(optLocalVariable.getJRegister());
                }
                optLocalVariable.setStartPC(this.classFile.getCurrentCodeOffset());
                ++n4;
            }
            this.debugVars = this.vars;
            return;
        }
        if (n > 0) {
            this.aload(this.argsLocal);
            this.push(n);
            this.addOptRuntimeInvoke("padStart", "([Ljava/lang/Object;I)", "[Ljava/lang/Object;");
            this.astore(this.argsLocal);
            n2 = 0;
            while (n2 < n) {
                this.aload(this.argsLocal);
                this.push(n2);
                this.aload((short)(3 * n2 + 4));
                this.addByteCode((byte)83);
                ++n2;
            }
        }
        if (bl) {
            this.aload(this.contextLocal);
            this.aload(this.variableObjectLocal);
            this.aload(this.funObjLocal);
            this.aload(this.thisObjLocal);
            this.aload(this.argsLocal);
            this.addScriptRuntimeInvoke("initVarObj", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)", "Lorg/mozilla/javascript/Scriptable;");
            string = "activation";
        } else {
            this.aload(this.contextLocal);
            this.aload(this.variableObjectLocal);
            this.aload(this.funObjLocal);
            this.aload(this.thisObjLocal);
            this.push(0);
            this.addScriptRuntimeInvoke("initScript", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/NativeFunction;Lorg/mozilla/javascript/Scriptable;Z)", "Lorg/mozilla/javascript/Scriptable;");
            string = "global";
        }
        this.astore(this.variableObjectLocal);
        Vector vector = (Vector)node.getProp(5);
        if (bl && vector != null) {
            int n5 = 0;
            while (n5 < vector.size()) {
                FunctionNode functionNode = (FunctionNode)vector.elementAt(n5);
                if (functionNode.getFunctionType() == 1) {
                    this.visitFunction(functionNode, true);
                    this.addByteCode((byte)87);
                }
                ++n5;
            }
        }
        if (!context.isGeneratingDebugChanged() || context.isGeneratingDebug()) {
            this.debugVars = new OptVariableTable();
            this.debugVars.addLocal(string);
            OptLocalVariable optLocalVariable = (OptLocalVariable)this.debugVars.getVariable(string);
            optLocalVariable.assignJRegister(this.variableObjectLocal);
            optLocalVariable.setStartPC(this.classFile.getCurrentCodeOffset());
        }
        if (!bl) {
            this.scriptResultLocal = this.getNewWordLocal();
            this.pushUndefined();
            this.astore(this.scriptResultLocal);
        }
        if (bl && ((OptFunctionNode)node).containsCalls(-1)) {
            if (((OptFunctionNode)node).containsCalls(0)) {
                this.itsZeroArgArray = this.getNewWordLocal();
                this.classFile.add((byte)-78, "org/mozilla/javascript/ScriptRuntime", "emptyArgs", "[Ljava/lang/Object;");
                this.astore(this.itsZeroArgArray);
            }
            if (((OptFunctionNode)node).containsCalls(1)) {
                this.itsOneArgArray = this.getNewWordLocal();
                this.push(1);
                this.addByteCode((byte)-67, "java/lang/Object");
                this.astore(this.itsOneArgArray);
            }
        }
    }

    private void generateEpilogue() {
        if (this.epilogueLabel != -1) {
            this.classFile.markLabel(this.epilogueLabel);
        }
        if (!this.hasVarsInRegs || !this.inFunction) {
            this.aload(this.contextLocal);
            this.addScriptRuntimeInvoke("popActivation", "(Lorg/mozilla/javascript/Context;)", "V");
        }
        this.addByteCode((byte)-80);
    }

    private void visitFunction(Node node, boolean bl) {
        this.aload(this.variableObjectLocal);
        int n = node.getExistingIntProp(5);
        this.aload(this.funObjLocal);
        this.classFile.add((byte)-76, "org/mozilla/javascript/NativeFunction", "nestedFunctions", "[Lorg/mozilla/javascript/NativeFunction;");
        this.push((short)n);
        this.addByteCode((byte)50);
        this.addVirtualInvoke("java/lang/Object", "getClass", "()", "Ljava/lang/Class;");
        this.aload(this.contextLocal);
        this.addByteCode((byte)16, bl ? 1 : 0);
        this.addScriptRuntimeInvoke("createFunctionObject", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Class;Lorg/mozilla/javascript/Context;Z)", "Lorg/mozilla/javascript/NativeFunction;");
    }

    private void visitTarget(Node node) {
        int n = node.getIntProp(20, -1);
        if (n == -1) {
            n = this.acquireLabel();
            node.putIntProp(20, n);
        }
        this.markLabel(n);
    }

    /*
     * Unable to fully structure code
     */
    private void visitGOTO(Node var1_1, int var2_2, Node var3_3) {
        block14: {
            block13: {
                var4_4 = (Node)var1_1.getProp(1);
                var5_5 = var4_4.getIntProp(20, -1);
                if (var5_5 == -1) {
                    var5_5 = this.acquireLabel();
                    var4_4.putIntProp(20, var5_5);
                }
                var6_6 = this.acquireLabel();
                if (var2_2 != 7 && var2_2 != 8) ** GOTO lbl29
                if (var3_3 != null) break block13;
                this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                if (var2_2 == 7) {
                    this.addByteCode((byte)-102, var5_5);
                } else {
                    this.addByteCode((byte)-103, var5_5);
                }
                break block14;
            }
            if (var2_2 == 7) {
                this.generateCodeFromNode(var3_3, var1_1, var5_5, var6_6);
            } else {
                this.generateCodeFromNode(var3_3, var1_1, var6_6, var5_5);
            }
            if (var3_3.getType() == 105 && var3_3.getInt() == 129 || var3_3.getType() == 101 || var3_3.getType() == 100 || var3_3.getType() == 103 || var3_3.getType() == 102) break block14;
            this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
            if (var2_2 == 7) {
                this.addByteCode((byte)-102, var5_5);
            } else {
                this.addByteCode((byte)-103, var5_5);
            }
            break block14;
lbl-1000:
            // 1 sources

            {
                this.generateCodeFromNode(var3_3, var1_1, -1, -1);
                var3_3 = var3_3.getNextSibling();
lbl29:
                // 2 sources

                ** while (var3_3 != null)
            }
lbl30:
            // 1 sources

            if (var2_2 == 143) {
                this.addByteCode((byte)-88, var5_5);
            } else {
                this.addByteCode((byte)-89, var5_5);
            }
        }
        this.markLabel(var6_6);
    }

    private void visitEnumInit(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("initEnum", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/util/Enumeration;");
        short s = this.getNewWordLocal();
        this.astore(s);
        node.putIntProp(7, s);
    }

    private void visitEnumNext(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        Node node3 = (Node)node.getProp(4);
        int n = node3.getExistingIntProp(7);
        this.aload((short)n);
        this.addScriptRuntimeInvoke("nextEnum", "(Ljava/util/Enumeration;)", "Ljava/lang/Object;");
    }

    private void visitEnumDone(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        Node node3 = (Node)node.getProp(4);
        int n = node3.getExistingIntProp(7);
        this.releaseWordLocal((short)n);
    }

    private void visitEnterWith(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("enterWith", "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
        this.astore(this.variableObjectLocal);
    }

    private void visitLeaveWith(Node node, Node node2) {
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("leaveWith", "(Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
        this.astore(this.variableObjectLocal);
    }

    private void resetTargets(Node node) {
        if (node.getType() == 137) {
            node.removeProp(20);
        }
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this.resetTargets(node2);
            node2 = node2.getNextSibling();
        }
    }

    private void visitCall(Node node, int n, Node node2) {
        Node node3 = node2;
        OptFunctionNode optFunctionNode = (OptFunctionNode)node.getProp(27);
        if (optFunctionNode != null) {
            int n2;
            this.generateCodeFromNode(node2, node, -1, -1);
            int n3 = this.acquireLabel();
            String string = ClassFileWriter.fullyQualifiedForm(optFunctionNode.getClassName());
            String string2 = string.replace('/', '_');
            this.classFile.add((byte)-78, ClassFileWriter.fullyQualifiedForm(string), string2, "L" + string + ";");
            short s = this.classFile.getStackTop();
            this.addByteCode((byte)92);
            this.addByteCode((byte)-90, n3);
            this.addByteCode((byte)95);
            this.addByteCode((byte)87);
            this.addByteCode((byte)89);
            this.classFile.add((byte)-71, "org/mozilla/javascript/Scriptable", "getParentScope", "()", "Lorg/mozilla/javascript/Scriptable;");
            this.aload(this.contextLocal);
            this.addByteCode((byte)95);
            if (n == 30) {
                this.addByteCode((byte)1);
            } else {
                node2 = node2.getNextSibling();
                this.generateCodeFromNode(node2, node, -1, -1);
            }
            node2 = node2.getNextSibling();
            while (node2 != null) {
                OptLocalVariable optLocalVariable;
                n2 = 0;
                if (node2.getType() == 72 && this.inDirectCallFunction && (optLocalVariable = (OptLocalVariable)node2.getProp(24)).isParameter()) {
                    n2 = 1;
                    this.aload(optLocalVariable.getJRegister());
                    this.dload((short)(optLocalVariable.getJRegister() + 1));
                }
                if (n2 == 0) {
                    int n4 = node2.getIntProp(26, -1);
                    if (n4 == 0) {
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        this.generateCodeFromNode(node2, node, -1, -1);
                    } else {
                        this.generateCodeFromNode(node2, node, -1, -1);
                        this.push(0.0);
                    }
                }
                this.resetTargets(node2);
                node2 = node2.getNextSibling();
            }
            this.addByteCode((byte)42);
            this.classFile.add((byte)-76, ClassFileWriter.fullyQualifiedForm(this.name), "EmptyArray", "[Ljava/lang/Object;");
            if (n == 30) {
                this.addVirtualInvoke(optFunctionNode.getClassName(), "constructDirect", optFunctionNode.getDirectCallParameterSignature(), "Ljava/lang/Object;");
            } else {
                this.addVirtualInvoke(optFunctionNode.getClassName(), "callDirect", optFunctionNode.getDirectCallParameterSignature(), "Ljava/lang/Object;");
            }
            n2 = this.acquireLabel();
            this.addByteCode((byte)-89, n2);
            this.markLabel(n3, s);
            this.addByteCode((byte)87);
            this.visitRegularCall(node, n, node3, true);
            this.markLabel(n2);
        } else {
            this.visitRegularCall(node, n, node3, false);
        }
    }

    private String getSimpleCallName(Node node) {
        Node node2;
        Node node3 = node.getFirstChild();
        if (node3.getType() == 39 && (node2 = node3.getFirstChild()).getType() == 69) {
            Node node4 = node2.getNextSibling();
            Node node5 = node2.getFirstChild();
            if (node5.getType() == 71) {
                Node node6;
                Node node7;
                Node node8;
                String string = node5.getString();
                if (node4 != null && node4.getType() == 46 && string.equals(node4.getString()) && (node8 = node3.getNextSibling()).getType() == 68 && (node7 = node8.getFirstChild()).getType() == 70 && (node6 = (Node)node7.getProp(6)) == node2) {
                    return string;
                }
            }
        }
        return null;
    }

    private void constructArgArray(int n) {
        if (n == 0) {
            if (this.itsZeroArgArray >= 0) {
                this.aload(this.itsZeroArgArray);
            } else {
                this.push(0);
                this.addByteCode((byte)-67, "java/lang/Object");
            }
        } else if (n == 1) {
            if (this.itsOneArgArray >= 0) {
                this.aload(this.itsOneArgArray);
            } else {
                this.push(1);
                this.addByteCode((byte)-67, "java/lang/Object");
            }
        } else {
            this.push(n);
            this.addByteCode((byte)-67, "java/lang/Object");
        }
    }

    private void visitRegularCall(Node node, int n, Node node2, boolean bl) {
        String string;
        String string2;
        String string3;
        Object object;
        OptFunctionNode optFunctionNode = (OptFunctionNode)node.getProp(27);
        Node node3 = node2;
        int n2 = 0;
        int n3 = n == 30 ? 1 : 2;
        while (node2 != null) {
            ++n2;
            node2 = node2.getNextSibling();
        }
        node2 = node3;
        int n4 = -n3;
        if (bl && node2 != null) {
            node2 = node2.getNextSibling();
            ++n4;
            this.aload(this.contextLocal);
            this.addByteCode((byte)95);
        } else {
            this.aload(this.contextLocal);
        }
        if (bl && n == 30) {
            this.constructArgArray(n2 - n3);
        }
        boolean bl2 = node.getProp(30) != null;
        boolean bl3 = false;
        String string4 = null;
        if (n != 30 && (string4 = this.getSimpleCallName(node)) != null && !bl2) {
            bl3 = true;
            this.push(string4);
            this.aload(this.variableObjectLocal);
            node2 = node2.getNextSibling().getNextSibling();
            n4 = 0;
            this.push(n2 - n3);
            this.addByteCode((byte)-67, "java/lang/Object");
        }
        while (node2 != null) {
            if (n4 < 0) {
                this.generateCodeFromNode(node2, node, -1, -1);
            } else {
                this.addByteCode((byte)89);
                this.push(n4);
                if (optFunctionNode != null) {
                    boolean bl4 = false;
                    if (node2.getType() == 72 && this.inDirectCallFunction && ((LocalVariable)(object = (OptLocalVariable)node2.getProp(24))).isParameter()) {
                        node2.removeProp(26);
                        this.generateCodeFromNode(node2, node, -1, -1);
                        bl4 = true;
                    }
                    if (!bl4) {
                        int n5 = node2.getIntProp(26, -1);
                        if (n5 == 0) {
                            this.addByteCode((byte)-69, "java/lang/Double");
                            this.addByteCode((byte)89);
                            this.generateCodeFromNode(node2, node, -1, -1);
                            this.addDoubleConstructor();
                        } else {
                            this.generateCodeFromNode(node2, node, -1, -1);
                        }
                    }
                } else {
                    this.generateCodeFromNode(node2, node, -1, -1);
                }
                this.addByteCode((byte)83);
            }
            if (++n4 == 0) {
                this.constructArgArray(n2 - n3);
            }
            node2 = node2.getNextSibling();
        }
        if (bl2) {
            string3 = "org/mozilla/javascript/ScriptRuntime";
            object = "newObjectSpecial";
            string2 = "callSpecial";
            if (n != 30) {
                string = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;I)";
                this.aload(this.thisObjLocal);
                this.aload(this.variableObjectLocal);
                this.push(this.itsSourceFile == null ? "" : this.itsSourceFile);
                this.push(this.itsLineNumber);
            } else {
                string = "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)";
                this.aload(this.variableObjectLocal);
            }
        } else {
            object = "newObject";
            if (bl3) {
                string = "(Lorg/mozilla/javascript/Context;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)";
                string2 = "callSimple";
                string3 = "org/mozilla/javascript/optimizer/OptRuntime";
            } else {
                this.aload(this.variableObjectLocal);
                string = n == 30 ? "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)" : "(Lorg/mozilla/javascript/Context;Ljava/lang/Object;Ljava/lang/Object;[Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)";
                string2 = "call";
                string3 = "org/mozilla/javascript/ScriptRuntime";
            }
        }
        if (n == 30) {
            this.addStaticInvoke(string3, (String)object, string, "Lorg/mozilla/javascript/Scriptable;");
        } else {
            this.addStaticInvoke(string3, string2, string, "Ljava/lang/Object;");
        }
    }

    private void visitStatement(Node node) {
        Object object = node.getDatum();
        if (object == null || !(object instanceof Number)) {
            return;
        }
        this.itsLineNumber = ((Number)object).shortValue();
        if (this.itsLineNumber == -1) {
            return;
        }
        this.classFile.addLineNumberEntry((short)this.itsLineNumber);
    }

    private void visitTryCatchFinally(Node node, Node node2) {
        int n;
        short s3 = this.getNewWordLocal();
        this.aload(this.variableObjectLocal);
        this.astore(s3);
        int n2 = this.markLabel(this.acquireLabel(), (short)1);
        this.visitStatement(node);
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        Node node3 = (Node)node.getProp(1);
        Node node4 = (Node)node.getProp(21);
        int n3 = this.acquireLabel();
        this.addByteCode((byte)-89, n3);
        if (node3 != null) {
            n = node3.getExistingIntProp(20);
            this.generateCatchBlock(0, s3, n, n2);
            this.generateCatchBlock(1, s3, n, n2);
            int s2 = this.classFile.markHandler(this.acquireLabel());
            short s = this.getNewWordLocal();
            this.astore(s);
            this.aload(s3);
            this.astore(this.variableObjectLocal);
            this.aload(s);
            this.addVirtualInvoke("org/mozilla/javascript/EcmaError", "getErrorObject", "()", "Lorg/mozilla/javascript/Scriptable;");
            this.releaseWordLocal(s);
            this.addByteCode((byte)-89, n);
            this.classFile.addExceptionHandler(n2, n, s2, "org/mozilla/javascript/EcmaError");
        }
        if (node4 != null) {
            n = this.classFile.markHandler(this.acquireLabel());
            this.aload(s3);
            this.astore(this.variableObjectLocal);
            short s = this.itsLocalAllocationBase;
            this.itsLocalAllocationBase = (short)(s + 1);
            short s2 = s;
            this.astore(s2);
            int n4 = node4.getExistingIntProp(20);
            this.addByteCode((byte)-88, n4);
            this.aload(s2);
            this.addByteCode((byte)-65);
            this.classFile.addExceptionHandler(n2, n4, n, null);
        }
        this.releaseWordLocal(s3);
        this.markLabel(n3);
    }

    private void generateCatchBlock(int n, short s, int n2, int n3) {
        int n4 = this.classFile.markHandler(this.acquireLabel());
        short s2 = this.getNewWordLocal();
        this.astore(s2);
        this.aload(s);
        this.astore(this.variableObjectLocal);
        this.aload(s2);
        this.releaseWordLocal(s2);
        if (n == 0) {
            this.addScriptRuntimeInvoke("unwrapJavaScriptException", "(Lorg/mozilla/javascript/JavaScriptException;)", "Ljava/lang/Object;");
        } else {
            this.addScriptRuntimeInvoke("unwrapWrappedException", "(Lorg/mozilla/javascript/WrappedException;)", "Ljava/lang/Object;");
        }
        String string = n == 0 ? "org/mozilla/javascript/JavaScriptException" : "org/mozilla/javascript/WrappedException";
        this.classFile.addExceptionHandler(n3, n2, n4, string);
        this.addByteCode((byte)-89, n2);
    }

    private void visitThrow(Node node, Node node2) {
        this.visitStatement(node);
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        this.addByteCode((byte)-69, "org/mozilla/javascript/JavaScriptException");
        this.addByteCode((byte)90);
        this.addByteCode((byte)95);
        this.addSpecialInvoke("org/mozilla/javascript/JavaScriptException", "<init>", "(Ljava/lang/Object;)", "V");
        this.addByteCode((byte)-65);
    }

    private void visitReturn(Node node, Node node2) {
        this.visitStatement(node);
        if (node2 != null) {
            do {
                this.generateCodeFromNode(node2, node, -1, -1);
            } while ((node2 = node2.getNextSibling()) != null);
        } else if (this.inFunction) {
            this.pushUndefined();
        } else {
            this.aload(this.scriptResultLocal);
        }
        if (this.epilogueLabel == -1) {
            this.epilogueLabel = this.classFile.acquireLabel();
        }
        this.addByteCode((byte)-89, this.epilogueLabel);
    }

    private void visitSwitch(Node node, Node node2) {
        Node node3;
        Node node4;
        this.visitStatement(node);
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        short s = this.getNewWordLocal();
        this.astore(s);
        Vector vector = (Vector)node.getProp(13);
        int n = 0;
        while (n < vector.size()) {
            node4 = (Node)vector.elementAt(n);
            node3 = node4.getFirstChild();
            this.generateCodeFromNode(node3, node4, -1, -1);
            this.aload(s);
            this.addScriptRuntimeInvoke("seqB", "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Boolean;");
            Node node5 = new Node(137);
            node4.replaceChild(node3, node5);
            this.generateGOTO(7, node5);
            ++n;
        }
        node4 = (Node)node.getProp(14);
        if (node4 != null) {
            node3 = new Node(137);
            node4.getFirstChild().addChildToFront(node3);
            this.generateGOTO(6, node3);
        }
        node3 = (Node)node.getProp(2);
        this.generateGOTO(6, node3);
    }

    private void generateGOTO(int n, Node node) {
        Node node2 = new Node(n);
        node2.putProp(1, node);
        this.visitGOTO(node2, n, null);
    }

    private void visitUnary(Node node, Node node2, int n, int n2) {
        int n3 = node.getInt();
        switch (n3) {
            case 129: {
                if (n != -1) {
                    this.generateCodeFromNode(node2, node, n2, n);
                    if (node2.getType() == 105 && node2.getInt() == 129 || node2.getType() == 101 || node2.getType() == 100 || node2.getType() == 103 || node2.getType() == 102) break;
                    this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                    this.addByteCode((byte)-102, n2);
                    this.addByteCode((byte)-89, n);
                    break;
                }
                int n4 = this.acquireLabel();
                int n5 = this.acquireLabel();
                int n6 = this.acquireLabel();
                this.generateCodeFromNode(node2, node, n4, n5);
                if ((node2.getType() != 105 || node2.getInt() != 129) && node2.getType() != 101 && node2.getType() != 100 && node2.getType() != 103 && node2.getType() != 102) {
                    this.addScriptRuntimeInvoke("toBoolean", "(Ljava/lang/Object;)", "Z");
                    this.addByteCode((byte)-103, n5);
                    this.addByteCode((byte)-89, n4);
                }
                this.markLabel(n4);
                this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                this.addByteCode((byte)-89, n6);
                this.markLabel(n5);
                this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                this.markLabel(n6);
                this.classFile.adjustStackTop(-1);
                break;
            }
            case 32: {
                this.visitTypeof(node, node2);
                break;
            }
            case 132: {
                this.generateCodeFromNode(node2, node, -1, -1);
                this.addByteCode((byte)87);
                this.pushUndefined();
                break;
            }
            case 28: {
                this.addByteCode((byte)-69, "java/lang/Double");
                this.addByteCode((byte)89);
                this.generateCodeFromNode(node2, node, -1, -1);
                this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)", "I");
                this.push(-1);
                this.addByteCode((byte)-126);
                this.addByteCode((byte)-121);
                this.addDoubleConstructor();
                break;
            }
            case 23: 
            case 24: {
                this.addByteCode((byte)-69, "java/lang/Double");
                this.addByteCode((byte)89);
                this.generateCodeFromNode(node2, node, -1, -1);
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
                if (n3 == 24) {
                    this.addByteCode((byte)119);
                }
                this.addDoubleConstructor();
                break;
            }
            default: {
                this.badTree();
            }
        }
    }

    private void visitTypeof(Node node, Node node2) {
        OptLocalVariable optLocalVariable;
        if (node.getType() == 105) {
            this.generateCodeFromNode(node2, node, -1, -1);
            this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)", "Ljava/lang/String;");
            return;
        }
        String string = node.getString();
        if (this.hasVarsInRegs && (optLocalVariable = (OptLocalVariable)this.vars.getVariable(string)) != null) {
            if (optLocalVariable.isNumber()) {
                this.push("number");
                return;
            }
            this.visitGetVar(optLocalVariable, false, string);
            this.addScriptRuntimeInvoke("typeof", "(Ljava/lang/Object;)", "Ljava/lang/String;");
            return;
        }
        this.aload(this.variableObjectLocal);
        this.push(string);
        this.addScriptRuntimeInvoke("typeofName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Ljava/lang/String;");
    }

    private void visitIncDec(Node node, boolean bl) {
        Node node2 = node.getFirstChild();
        if (node.getIntProp(26, -1) != -1) {
            OptLocalVariable optLocalVariable = (OptLocalVariable)node2.getProp(24);
            if (optLocalVariable.getJRegister() == -1) {
                optLocalVariable.assignJRegister(this.getNewWordPairLocal());
            }
            this.dload(optLocalVariable.getJRegister());
            this.addByteCode((byte)92);
            this.push(1.0);
            this.addByteCode(bl ? (byte)99 : 103);
            this.dstore(optLocalVariable.getJRegister());
        } else {
            String string;
            OptLocalVariable optLocalVariable = (OptLocalVariable)node2.getProp(24);
            String string2 = string = bl ? "postIncrement" : "postDecrement";
            if (this.hasVarsInRegs && node2.getType() == 72) {
                if (optLocalVariable == null) {
                    optLocalVariable = (OptLocalVariable)this.vars.getVariable(node2.getString());
                }
                if (optLocalVariable.getJRegister() == -1) {
                    optLocalVariable.assignJRegister(this.getNewWordLocal());
                }
                this.aload(optLocalVariable.getJRegister());
                this.addByteCode((byte)89);
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;)", "Ljava/lang/Object;");
                this.astore(optLocalVariable.getJRegister());
            } else if (node2.getType() == 39) {
                Node node3 = node2.getFirstChild();
                this.generateCodeFromNode(node3, node, -1, -1);
                this.generateCodeFromNode(node3.getNextSibling(), node, -1, -1);
                this.aload(this.variableObjectLocal);
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            } else if (node2.getType() == 41) {
                string = string + "Elem";
                Node node4 = node2.getFirstChild();
                this.generateCodeFromNode(node4, node, -1, -1);
                this.generateCodeFromNode(node4.getNextSibling(), node, -1, -1);
                this.aload(this.variableObjectLocal);
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            } else {
                this.aload(this.variableObjectLocal);
                this.push(node2.getString());
                this.addScriptRuntimeInvoke(string, "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Ljava/lang/Object;");
            }
        }
    }

    private boolean isArithmeticNode(Node node) {
        int n = node.getType();
        return n == 24 || n == 27 || n == 26 || n == 25;
    }

    private void visitArithmetic(Node node, byte by, Node node2, Node node3) {
        int n = node.getIntProp(26, -1);
        if (n != -1) {
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            this.addByteCode(by);
        } else {
            boolean bl = this.isArithmeticNode(node3);
            if (!bl) {
                this.addByteCode((byte)-69, "java/lang/Double");
                this.addByteCode((byte)89);
            }
            this.generateCodeFromNode(node2, node, -1, -1);
            if (!this.isArithmeticNode(node2)) {
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
            }
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            if (!this.isArithmeticNode(node2.getNextSibling())) {
                this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
            }
            this.addByteCode(by);
            if (!bl) {
                this.addDoubleConstructor();
            }
        }
    }

    private void visitBitOp(Node node, int n, Node node2) {
        int n2 = node.getIntProp(26, -1);
        if (n2 == -1) {
            this.addByteCode((byte)-69, "java/lang/Double");
            this.addByteCode((byte)89);
        }
        this.generateCodeFromNode(node2, node, -1, -1);
        if (n == 22) {
            this.addScriptRuntimeInvoke("toUint32", "(Ljava/lang/Object;)", "J");
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)", "I");
            this.push(31);
            this.addByteCode((byte)126);
            this.addByteCode((byte)125);
            this.addByteCode((byte)-118);
            this.addDoubleConstructor();
            return;
        }
        if (n2 == -1) {
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)", "I");
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            this.addScriptRuntimeInvoke("toInt32", "(Ljava/lang/Object;)", "I");
        } else {
            this.addScriptRuntimeInvoke("toInt32", "(D)", "I");
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            this.addScriptRuntimeInvoke("toInt32", "(D)", "I");
        }
        switch (n) {
            case 11: {
                this.addByteCode((byte)-128);
                break;
            }
            case 12: {
                this.addByteCode((byte)-126);
                break;
            }
            case 13: {
                this.addByteCode((byte)126);
                break;
            }
            case 21: {
                this.addByteCode((byte)122);
                break;
            }
            case 20: {
                this.addByteCode((byte)120);
                break;
            }
            default: {
                this.badTree();
            }
        }
        this.addByteCode((byte)-121);
        if (n2 == -1) {
            this.addDoubleConstructor();
        }
    }

    private boolean nodeIsDirectCallParameter(Node node) {
        OptLocalVariable optLocalVariable;
        return node.getType() == 72 && (optLocalVariable = (OptLocalVariable)node.getProp(24)) != null && optLocalVariable.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters;
    }

    private void genSimpleCompare(int n, int n2, int n3) {
        switch (n) {
            case 17: {
                this.addByteCode((byte)-104);
                this.addByteCode((byte)-98, n2);
                break;
            }
            case 19: {
                this.addByteCode((byte)-105);
                this.addByteCode((byte)-100, n2);
                break;
            }
            case 16: {
                this.addByteCode((byte)-104);
                this.addByteCode((byte)-101, n2);
                break;
            }
            case 18: {
                this.addByteCode((byte)-105);
                this.addByteCode((byte)-99, n2);
            }
        }
        if (n3 != -1) {
            this.addByteCode((byte)-89, n3);
        }
    }

    private void visitGOTOingRelOp(Node node, Node node2, Node node3, int n, int n2) {
        int n3 = node.getInt();
        int n4 = node.getIntProp(26, -1);
        if (n4 == 0) {
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            this.genSimpleCompare(n3, n, n2);
        } else if (n3 == 64) {
            this.aload(this.variableObjectLocal);
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            this.addScriptRuntimeInvoke("instanceOf", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;)", "Z");
            this.addByteCode((byte)-102, n);
            this.addByteCode((byte)-89, n2);
        } else if (n3 == 63) {
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            this.aload(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("in", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Z");
            this.addByteCode((byte)-102, n);
            this.addByteCode((byte)-89, n2);
        } else {
            Object object;
            Node node4 = node2.getNextSibling();
            boolean bl = this.nodeIsDirectCallParameter(node2);
            boolean bl2 = this.nodeIsDirectCallParameter(node4);
            if (bl || bl2) {
                int n5;
                if (bl) {
                    if (bl2) {
                        object = (OptLocalVariable)node2.getProp(24);
                        this.aload(((OptLocalVariable)object).getJRegister());
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        n5 = this.acquireLabel();
                        this.addByteCode((byte)-90, n5);
                        OptLocalVariable optLocalVariable = (OptLocalVariable)node4.getProp(24);
                        this.aload(optLocalVariable.getJRegister());
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        this.addByteCode((byte)-90, n5);
                        this.dload((short)(((OptLocalVariable)object).getJRegister() + 1));
                        this.dload((short)(optLocalVariable.getJRegister() + 1));
                        this.genSimpleCompare(n3, n, n2);
                        this.markLabel(n5);
                    } else if (n4 == 2) {
                        object = (OptLocalVariable)node2.getProp(24);
                        this.aload(((OptLocalVariable)object).getJRegister());
                        this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                        n5 = this.acquireLabel();
                        this.addByteCode((byte)-90, n5);
                        this.dload((short)(((OptLocalVariable)object).getJRegister() + 1));
                        this.generateCodeFromNode(node4, node, -1, -1);
                        this.genSimpleCompare(n3, n, n2);
                        this.markLabel(n5);
                    }
                } else if (n4 == 1) {
                    object = (OptLocalVariable)node4.getProp(24);
                    this.aload(((OptLocalVariable)object).getJRegister());
                    this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    n5 = this.acquireLabel();
                    this.addByteCode((byte)-90, n5);
                    this.generateCodeFromNode(node2, node, -1, -1);
                    this.dload((short)(((OptLocalVariable)object).getJRegister() + 1));
                    this.genSimpleCompare(n3, n, n2);
                    this.markLabel(n5);
                }
            }
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node4, node, -1, -1);
            if (n4 == -1) {
                if (n3 == 19 || n3 == 18) {
                    this.addByteCode((byte)95);
                }
                object = n3 == 16 || n3 == 18 ? "cmp_LT" : "cmp_LE";
                this.addScriptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)", "I");
            } else {
                String string;
                boolean bl3;
                boolean bl4 = bl3 = n4 == 1;
                if (n3 == 19 || n3 == 18) {
                    if (bl3) {
                        this.addByteCode((byte)91);
                        this.addByteCode((byte)87);
                        bl3 = false;
                    } else {
                        this.addByteCode((byte)93);
                        this.addByteCode((byte)88);
                        bl3 = true;
                    }
                }
                String string2 = string = n3 == 16 || n3 == 18 ? "cmp_LT" : "cmp_LE";
                if (bl3) {
                    this.addOptRuntimeInvoke(string, "(DLjava/lang/Object;)", "I");
                } else {
                    this.addOptRuntimeInvoke(string, "(Ljava/lang/Object;D)", "I");
                }
            }
            this.addByteCode((byte)-102, n);
            this.addByteCode((byte)-89, n2);
        }
    }

    private void visitRelOp(Node node, Node node2, Node node3) {
        int n = node.getInt();
        int n2 = node.getIntProp(26, -1);
        if (n2 == 0 || n == 64 || n == 63) {
            if (n == 64) {
                this.aload(this.variableObjectLocal);
            }
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            int n3 = this.acquireLabel();
            int n4 = this.acquireLabel();
            if (n == 64) {
                this.addScriptRuntimeInvoke("instanceOf", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                this.addByteCode((byte)-102, n3);
            } else if (n == 63) {
                this.aload(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("in", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Z");
                this.addByteCode((byte)-102, n3);
            } else {
                this.genSimpleCompare(n, n3, -1);
            }
            this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
            this.addByteCode((byte)-89, n4);
            this.markLabel(n3);
            this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
            this.markLabel(n4);
            this.classFile.adjustStackTop(-1);
        } else {
            String string = n == 16 || n == 18 ? "cmp_LTB" : "cmp_LEB";
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            if (n2 == -1) {
                if (n == 19 || n == 18) {
                    this.addByteCode((byte)95);
                }
                this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Boolean;");
            } else {
                boolean bl;
                boolean bl2 = bl = n2 == 1;
                if (n == 19 || n == 18) {
                    if (bl) {
                        this.addByteCode((byte)91);
                        this.addByteCode((byte)87);
                        bl = false;
                    } else {
                        this.addByteCode((byte)93);
                        this.addByteCode((byte)88);
                        bl = true;
                    }
                }
                if (bl) {
                    this.addOptRuntimeInvoke(string, "(DLjava/lang/Object;)", "Ljava/lang/Boolean;");
                } else {
                    this.addOptRuntimeInvoke(string, "(Ljava/lang/Object;D)", "Ljava/lang/Boolean;");
                }
            }
        }
    }

    private Node getConvertToObjectOfNumberNode(Node node) {
        Node node2;
        Object object;
        if (node.getType() == 142 && (object = node.getProp(18)) == ScriptRuntime.ObjectClass && (node2 = node.getFirstChild()).getType() == 45) {
            return node2;
        }
        return null;
    }

    private void visitEqOp(Node node, Node node2, Node node3, int n, int n2) {
        int n3 = node.getInt();
        Node node4 = node2.getNextSibling();
        if (n == -1) {
            String string;
            if (node4.getType() == 109 && node4.getInt() == 49) {
                this.generateCodeFromNode(node2, node, -1, -1);
                this.addByteCode((byte)89);
                this.addByteCode((byte)-58, 15);
                this.pushUndefined();
                this.addByteCode((byte)-91, 10);
                if (n3 == 14 || n3 == 53) {
                    this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                } else {
                    this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                }
                this.addByteCode((byte)-89, 7);
                this.addByteCode((byte)87);
                if (n3 == 14 || n3 == 53) {
                    this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                } else {
                    this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                }
                return;
            }
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            switch (n3) {
                case 14: {
                    string = this.version == 120 ? "seqB" : "eqB";
                    break;
                }
                case 15: {
                    string = this.version == 120 ? "sneB" : "neB";
                    break;
                }
                case 53: {
                    string = "seqB";
                    break;
                }
                case 54: {
                    string = "sneB";
                    break;
                }
                default: {
                    string = null;
                    this.badTree();
                }
            }
            this.addScriptRuntimeInvoke(string, "(Ljava/lang/Object;Ljava/lang/Object;)", "Ljava/lang/Boolean;");
        } else {
            Object object;
            if (node4.getType() == 109 && node4.getInt() == 49) {
                boolean bl;
                this.generateCodeFromNode(node2, node, -1, -1);
                boolean bl2 = bl = node2.getType() == 72;
                if (!bl) {
                    this.addByteCode((byte)89);
                }
                int n4 = this.acquireLabel();
                if (n3 == 14 || n3 == 53) {
                    this.addByteCode((byte)-58, bl ? n : n4);
                    short s = this.classFile.getStackTop();
                    if (bl) {
                        this.generateCodeFromNode(node2, node, -1, -1);
                    }
                    this.pushUndefined();
                    this.addByteCode((byte)-91, n);
                    this.addByteCode((byte)-89, n2);
                    if (!bl) {
                        this.markLabel(n4, s);
                        this.addByteCode((byte)87);
                        this.addByteCode((byte)-89, n);
                    }
                } else {
                    this.addByteCode((byte)-58, bl ? n2 : n4);
                    short s = this.classFile.getStackTop();
                    if (bl) {
                        this.generateCodeFromNode(node2, node, -1, -1);
                    }
                    this.pushUndefined();
                    this.addByteCode((byte)-91, n2);
                    this.addByteCode((byte)-89, n);
                    if (!bl) {
                        this.markLabel(n4, s);
                        this.addByteCode((byte)87);
                        this.addByteCode((byte)-89, n2);
                    }
                }
                return;
            }
            Node node5 = node2.getNextSibling();
            if (this.nodeIsDirectCallParameter(node2) && (object = this.getConvertToObjectOfNumberNode(node5)) != null) {
                OptLocalVariable optLocalVariable = (OptLocalVariable)node2.getProp(24);
                this.aload(optLocalVariable.getJRegister());
                this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                int n5 = this.acquireLabel();
                this.addByteCode((byte)-90, n5);
                this.dload((short)(optLocalVariable.getJRegister() + 1));
                this.push(((Node)object).getDouble());
                this.addByteCode((byte)-105);
                if (n3 == 14) {
                    this.addByteCode((byte)-103, n);
                } else {
                    this.addByteCode((byte)-102, n);
                }
                this.addByteCode((byte)-89, n2);
                this.markLabel(n5);
            }
            this.generateCodeFromNode(node2, node, -1, -1);
            this.generateCodeFromNode(node5, node, -1, -1);
            switch (n3) {
                case 14: {
                    object = this.version == 120 ? "shallowEq" : "eq";
                    this.addScriptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                    break;
                }
                case 15: {
                    object = this.version == 120 ? "shallowNeq" : "neq";
                    this.addOptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                    break;
                }
                case 53: {
                    object = "shallowEq";
                    this.addScriptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                    break;
                }
                case 54: {
                    object = "shallowNeq";
                    this.addOptRuntimeInvoke((String)object, "(Ljava/lang/Object;Ljava/lang/Object;)", "Z");
                    break;
                }
                default: {
                    object = null;
                    this.badTree();
                }
            }
            this.addByteCode((byte)-102, n);
            this.addByteCode((byte)-89, n2);
        }
    }

    private void visitLiteral(Node node) {
        if (node.getType() == 46) {
            this.push(node.getString());
        } else {
            double d = node.getDouble();
            if (node.getIntProp(26, -1) != -1) {
                this.push(d);
            } else if (this.itsConstantListSize >= 2000) {
                this.pushAsWrapperObject(d);
            } else {
                String string = "jsK_" + this.addNumberConstant(d);
                String string2 = this.getStaticConstantWrapperType(d);
                this.classFile.add((byte)-78, ClassFileWriter.fullyQualifiedForm(this.name), string, string2);
            }
        }
    }

    private String getStaticConstantWrapperType(double d) {
        int n = (int)d;
        String string = (double)n == d ? ((byte)n == n ? "Ljava/lang/Byte;" : ((short)n == n ? "Ljava/lang/Short;" : "Ljava/lang/Integer;")) : "Ljava/lang/Double;";
        return string;
    }

    private int addNumberConstant(double d) {
        int n = this.itsConstantListSize;
        if (n == 0) {
            this.itsConstantList = new double[128];
        } else {
            double[] dArray = this.itsConstantList;
            int n2 = 0;
            while (n2 != n) {
                if (dArray[n2] == d) {
                    return n2;
                }
                ++n2;
            }
            if (n == dArray.length) {
                dArray = new double[n * 2];
                System.arraycopy(this.itsConstantList, 0, dArray, 0, n);
                this.itsConstantList = dArray;
            }
        }
        this.itsConstantList[n] = d;
        this.itsConstantListSize = n + 1;
        return n;
    }

    private void emitConstantDudeInitializers() {
        int n = this.itsConstantListSize;
        if (n == 0) {
            return;
        }
        this.classFile.startMethod("<clinit>", "()V", (short)24);
        double[] dArray = this.itsConstantList;
        int n2 = 0;
        while (n2 != n) {
            double d = dArray[n2];
            String string = "jsK_" + this.addNumberConstant(d);
            String string2 = this.getStaticConstantWrapperType(d);
            this.classFile.addField(string, string2, (short)8);
            this.pushAsWrapperObject(d);
            this.classFile.add((byte)-77, ClassFileWriter.fullyQualifiedForm(this.name), string, string2);
            ++n2;
        }
        this.addByteCode((byte)-79);
        this.classFile.stopMethod((short)0, null);
    }

    private void visitPrimary(Node node) {
        int n = node.getInt();
        switch (n) {
            case 50: {
                this.aload(this.thisObjLocal);
                break;
            }
            case 87: {
                this.classFile.add((byte)42);
                break;
            }
            case 49: {
                this.addByteCode((byte)1);
                break;
            }
            case 52: {
                this.classFile.add((byte)-78, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
                break;
            }
            case 51: {
                this.classFile.add((byte)-78, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
                break;
            }
            case 74: {
                this.pushUndefined();
                break;
            }
            default: {
                this.badTree();
            }
        }
    }

    private void visitObject(Node node) {
        Node node2 = (Node)node.getProp(12);
        String string = (String)node2.getProp(12);
        this.aload(this.funObjLocal);
        this.classFile.add((byte)-76, ClassFileWriter.fullyQualifiedForm(this.name), string, "Lorg/mozilla/javascript/regexp/NativeRegExp;");
    }

    private void visitName(Node node) {
        this.aload(this.variableObjectLocal);
        this.push(node.getString());
        this.addScriptRuntimeInvoke("name", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Ljava/lang/Object;");
    }

    private void visitSetName(Node node, Node node2) {
        String string = node.getFirstChild().getString();
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        this.aload(this.variableObjectLocal);
        this.push(string);
        this.addScriptRuntimeInvoke("setName", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Ljava/lang/Object;");
    }

    private void visitGetVar(OptLocalVariable optLocalVariable, boolean bl, String string) {
        if (this.hasVarsInRegs && optLocalVariable == null) {
            optLocalVariable = (OptLocalVariable)this.vars.getVariable(string);
        }
        if (optLocalVariable != null) {
            if (optLocalVariable.getJRegister() == -1) {
                if (optLocalVariable.isNumber()) {
                    optLocalVariable.assignJRegister(this.getNewWordPairLocal());
                } else {
                    optLocalVariable.assignJRegister(this.getNewWordLocal());
                }
            }
            if (optLocalVariable.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters) {
                if (bl) {
                    this.aload(optLocalVariable.getJRegister());
                    this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int n = this.acquireLabel();
                    int n2 = this.acquireLabel();
                    this.addByteCode((byte)-91, n);
                    this.aload(optLocalVariable.getJRegister());
                    this.addScriptRuntimeInvoke("toNumber", "(Ljava/lang/Object;)", "D");
                    this.addByteCode((byte)-89, n2);
                    this.markLabel(n);
                    this.dload((short)(optLocalVariable.getJRegister() + 1));
                    this.markLabel(n2);
                } else {
                    this.aload(optLocalVariable.getJRegister());
                    this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int n = this.acquireLabel();
                    int n3 = this.acquireLabel();
                    this.addByteCode((byte)-91, n);
                    this.aload(optLocalVariable.getJRegister());
                    this.addByteCode((byte)-89, n3);
                    this.markLabel(n);
                    this.addByteCode((byte)-69, "java/lang/Double");
                    this.addByteCode((byte)89);
                    this.dload((short)(optLocalVariable.getJRegister() + 1));
                    this.addDoubleConstructor();
                    this.markLabel(n3);
                }
            } else if (optLocalVariable.isNumber()) {
                this.dload(optLocalVariable.getJRegister());
            } else {
                this.aload(optLocalVariable.getJRegister());
            }
            return;
        }
        this.aload(this.variableObjectLocal);
        this.push(string);
        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
    }

    private void visitSetVar(Node node, Node node2, boolean bl) {
        OptLocalVariable optLocalVariable = (OptLocalVariable)node.getProp(24);
        if (this.hasVarsInRegs && optLocalVariable == null) {
            optLocalVariable = (OptLocalVariable)this.vars.getVariable(node2.getString());
        }
        if (optLocalVariable != null) {
            this.generateCodeFromNode(node2.getNextSibling(), node, -1, -1);
            if (optLocalVariable.getJRegister() == -1) {
                if (optLocalVariable.isNumber()) {
                    optLocalVariable.assignJRegister(this.getNewWordPairLocal());
                } else {
                    optLocalVariable.assignJRegister(this.getNewWordLocal());
                }
            }
            if (optLocalVariable.isParameter() && this.inDirectCallFunction && !this.itsForcedObjectParameters) {
                if (node.getIntProp(26, -1) != -1) {
                    if (bl) {
                        this.addByteCode((byte)92);
                    }
                    this.aload(optLocalVariable.getJRegister());
                    this.classFile.add((byte)-78, "java/lang/Void", "TYPE", "Ljava/lang/Class;");
                    int n = this.acquireLabel();
                    int n2 = this.acquireLabel();
                    this.addByteCode((byte)-91, n);
                    this.addByteCode((byte)-69, "java/lang/Double");
                    this.addByteCode((byte)89);
                    this.addByteCode((byte)94);
                    this.addByteCode((byte)88);
                    this.addDoubleConstructor();
                    this.astore(optLocalVariable.getJRegister());
                    this.addByteCode((byte)-89, n2);
                    this.markLabel(n);
                    this.dstore((short)(optLocalVariable.getJRegister() + 1));
                    this.markLabel(n2);
                } else {
                    if (bl) {
                        this.addByteCode((byte)89);
                    }
                    this.astore(optLocalVariable.getJRegister());
                }
            } else if (node.getIntProp(26, -1) != -1) {
                this.dstore(optLocalVariable.getJRegister());
                if (bl) {
                    this.dload(optLocalVariable.getJRegister());
                }
            } else {
                this.astore(optLocalVariable.getJRegister());
                if (bl) {
                    this.aload(optLocalVariable.getJRegister());
                }
            }
            return;
        }
        node2.setType(61);
        node.setType(10);
        this.visitSetName(node, node2);
        if (!bl) {
            this.addByteCode((byte)87);
        }
    }

    private void visitGetProp(Node node, Node node2) {
        String string = (String)node.getProp(19);
        if (string != null) {
            while (node2 != null) {
                this.generateCodeFromNode(node2, node, -1, -1);
                node2 = node2.getNextSibling();
            }
            this.aload(this.variableObjectLocal);
            String string2 = null;
            if (string.equals("__proto__")) {
                string2 = "getProto";
            } else if (string.equals("__parent__")) {
                string2 = "getParent";
            } else {
                this.badTree();
            }
            this.addScriptRuntimeInvoke(string2, "(Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Lorg/mozilla/javascript/Scriptable;");
            return;
        }
        Node node3 = node2.getNextSibling();
        this.generateCodeFromNode(node2, node, -1, -1);
        this.generateCodeFromNode(node3, node, -1, -1);
        if (node3.getType() == 46) {
            if (node2.getType() == 109 && node2.getInt() == 50 || node2.getType() == 69 && node2.getFirstChild().getType() == 109 && node2.getFirstChild().getInt() == 50) {
                this.aload(this.variableObjectLocal);
                this.addOptRuntimeInvoke("thisGet", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            } else {
                this.aload(this.variableObjectLocal);
                this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
            }
        } else {
            this.aload(this.variableObjectLocal);
            this.addScriptRuntimeInvoke("getProp", "(Ljava/lang/Object;Ljava/lang/String;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void visitSetProp(Node var1_1, Node var2_2) {
        var3_3 = (String)var1_1.getProp(19);
        if (var3_3 == null) ** GOTO lbl20
        while (var2_2 != null) {
            this.generateCodeFromNode(var2_2, var1_1, -1, -1);
            var2_2 = var2_2.getNextSibling();
        }
        this.aload(this.variableObjectLocal);
        var4_4 = null;
        if (var3_3.equals("__proto__")) {
            var4_4 = "setProto";
        } else if (var3_3.equals("__parent__")) {
            var4_4 = "setParent";
        } else {
            this.badTree();
        }
        this.addScriptRuntimeInvoke(var4_4, "(Ljava/lang/Object;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
        return;
lbl-1000:
        // 1 sources

        {
            this.generateCodeFromNode(var2_2, var1_1, -1, -1);
            var2_2 = var2_2.getNextSibling();
lbl20:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl21:
        // 1 sources

        this.aload(this.variableObjectLocal);
        this.addScriptRuntimeInvoke("setProp", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;Lorg/mozilla/javascript/Scriptable;)", "Ljava/lang/Object;");
    }

    private void visitBind(Node node, int n, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        this.aload(this.variableObjectLocal);
        this.push(node.getString());
        this.addScriptRuntimeInvoke(n == 61 ? "bind" : "getBase", "(Lorg/mozilla/javascript/Scriptable;Ljava/lang/String;)", "Lorg/mozilla/javascript/Scriptable;");
    }

    private short getLocalFromNode(Node node) {
        int n = node.getIntProp(7, -1);
        if (n == -1) {
            short s;
            if (node.getType() == 144 || node.getType() == 145) {
                short s2 = this.itsLocalAllocationBase;
                s = s2;
                this.itsLocalAllocationBase = (short)(s2 + 1);
            } else {
                s = this.getNewWordLocal();
            }
            n = s;
            node.putIntProp(7, n);
        }
        return (short)n;
    }

    private void visitNewTemp(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        short s = this.getLocalFromNode(node);
        this.addByteCode((byte)89);
        this.astore(s);
        if (node.getIntProp(11, 0) == 0) {
            this.releaseWordLocal(s);
        }
    }

    private void visitUseTemp(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        Node node3 = (Node)node.getProp(6);
        short s = this.getLocalFromNode(node3);
        if (node.getProp(1) != null) {
            this.addByteCode((byte)-87, s);
        } else {
            this.aload(s);
        }
        int n = node3.getIntProp(11, 0);
        if (n <= 1) {
            this.releaseWordLocal(s);
        }
        if (n != 0 && n != Integer.MAX_VALUE) {
            node3.putIntProp(11, n - 1);
        }
    }

    private void visitNewLocal(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        short s = this.getLocalFromNode(node);
        this.addByteCode((byte)89);
        this.astore(s);
    }

    private void visitUseLocal(Node node, Node node2) {
        while (node2 != null) {
            this.generateCodeFromNode(node2, node, -1, -1);
            node2 = node2.getNextSibling();
        }
        Node node3 = (Node)node.getProp(7);
        short s = this.getLocalFromNode(node3);
        if (node.getProp(1) != null) {
            this.addByteCode((byte)-87, s);
        } else {
            this.aload(s);
        }
    }

    private void dstore(short s) {
        this.xop((byte)71, (byte)57, s);
    }

    private void istore(short s) {
        this.xop((byte)59, (byte)54, s);
    }

    private void astore(short s) {
        this.xop((byte)75, (byte)58, s);
    }

    private void xop(byte by, byte by2, short s) {
        switch (s) {
            case 0: {
                this.addByteCode(by);
                break;
            }
            case 1: {
                this.addByteCode((byte)(by + 1));
                break;
            }
            case 2: {
                this.addByteCode((byte)(by + 2));
                break;
            }
            case 3: {
                this.addByteCode((byte)(by + 3));
                break;
            }
            default: {
                if (s < 0 || s >= Short.MAX_VALUE) {
                    throw new RuntimeException("bad local");
                }
                if (s < 127) {
                    this.addByteCode(by2, (byte)s);
                    break;
                }
                this.addByteCode((byte)-60);
                this.addByteCode(by2);
                this.addByteCode((byte)(s >> 8));
                this.addByteCode((byte)(s & 0xFF));
            }
        }
    }

    private void dload(short s) {
        this.xop((byte)38, (byte)24, s);
    }

    private void iload(short s) {
        this.xop((byte)26, (byte)21, s);
    }

    private void aload(short s) {
        this.xop((byte)42, (byte)25, s);
    }

    private short getNewWordPairLocal() {
        short s;
        for (s = this.firstFreeLocal; s < 255 && (this.locals[s] || this.locals[s + 1]); s = (short)(s + 1)) {
        }
        if (s < 255) {
            this.locals[s] = true;
            this.locals[s + 1] = true;
            if (s == this.firstFreeLocal) {
                int n = this.firstFreeLocal + 2;
                while (n < 256) {
                    if (!this.locals[n]) {
                        this.firstFreeLocal = (short)n;
                        if (this.localsMax < this.firstFreeLocal) {
                            this.localsMax = this.firstFreeLocal;
                        }
                        return s;
                    }
                    ++n;
                }
            } else {
                return s;
            }
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private short reserveWordLocal(int n) {
        if (this.getNewWordLocal() != n) {
            throw new RuntimeException("Local allocation error");
        }
        return (short)n;
    }

    private short getNewWordLocal() {
        short s = this.firstFreeLocal;
        this.locals[s] = true;
        int n = this.firstFreeLocal + 1;
        while (n < 256) {
            if (!this.locals[n]) {
                this.firstFreeLocal = (short)n;
                if (this.localsMax < this.firstFreeLocal) {
                    this.localsMax = this.firstFreeLocal;
                }
                return s;
            }
            ++n;
        }
        throw Context.reportRuntimeError("Program too complex (out of locals)");
    }

    private void releaseWordpairLocal(short s) {
        if (s < this.firstFreeLocal) {
            this.firstFreeLocal = s;
        }
        this.locals[s] = false;
        this.locals[s + 1] = false;
    }

    private void releaseWordLocal(short s) {
        if (s < this.firstFreeLocal) {
            this.firstFreeLocal = s;
        }
        this.locals[s] = false;
    }

    private void push(int n) {
        if ((byte)n == n) {
            if (n == -1) {
                this.addByteCode((byte)2);
            } else if (0 <= n && n <= 5) {
                this.addByteCode((byte)(3 + n));
            } else {
                this.addByteCode((byte)16, (byte)n);
            }
        } else if ((short)n == n) {
            this.addByteCode((byte)17, (short)n);
        } else {
            this.classFile.addLoadConstant(n);
        }
    }

    private void push(double d) {
        if (d == 0.0) {
            this.addByteCode((byte)14);
        } else if (d == 1.0) {
            this.addByteCode((byte)15);
        } else {
            this.classFile.addLoadConstant(d);
        }
    }

    private void pushAsWrapperObject(double d) {
        String string;
        String string2;
        boolean bl;
        int n = (int)d;
        if ((double)n == d) {
            bl = true;
            if ((byte)n == n) {
                string2 = "java/lang/Byte";
                string = "(B)";
            } else if ((short)n == n) {
                string2 = "java/lang/Short";
                string = "(S)";
            } else {
                string2 = "java/lang/Integer";
                string = "(I)";
            }
        } else {
            bl = false;
            string2 = "java/lang/Double";
            string = "(D)";
        }
        this.addByteCode((byte)-69, string2);
        this.addByteCode((byte)89);
        if (bl) {
            this.push(n);
        } else {
            this.push(d);
        }
        this.addSpecialInvoke(string2, "<init>", string, "V");
    }

    private void push(String string) {
        this.classFile.addLoadConstant(string);
    }

    private void pushUndefined() {
        this.classFile.add((byte)-78, "org/mozilla/javascript/Undefined", "instance", "Lorg/mozilla/javascript/Scriptable;");
    }

    private void badTree() {
        throw new RuntimeException("Bad tree in codegen");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

