/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.PreorderNodeIterator;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.VariableTable;

public class NodeTransformer {
    protected Stack loops;
    protected Stack loopEnds;
    protected boolean inFunction;
    protected IRFactory irFactory;

    public NodeTransformer newInstance() {
        return new NodeTransformer();
    }

    public IRFactory createIRFactory(TokenStream tokenStream, Scriptable scriptable) {
        return new IRFactory(tokenStream, scriptable);
    }

    public Node transform(Node node, Node node2, TokenStream tokenStream, Scriptable scriptable) {
        Node node3;
        this.loops = new Stack();
        this.loopEnds = new Stack();
        boolean bl = this.inFunction = node.getType() == 110;
        if (!this.inFunction) {
            this.addVariables(node, this.getVariableTable(node));
        }
        this.irFactory = this.createIRFactory(tokenStream, scriptable);
        boolean bl2 = false;
        PreorderNodeIterator preorderNodeIterator = node.getPreorderIterator();
        block22: while ((node3 = preorderNodeIterator.nextNode()) != null) {
            int n = node3.getType();
            block0 : switch (n) {
                case 110: {
                    if (node3 == node) {
                        VariableTable variableTable = this.getVariableTable(node);
                        this.addVariables(node, variableTable);
                        Node node4 = node3.getLastChild();
                        Node node5 = node4.getLastChild();
                        if (node5 != null && node5.getType() == 5) continue block22;
                        node4.addChildToBack(new Node(5));
                        break;
                    }
                    FunctionNode functionNode = (FunctionNode)node3.getProp(5);
                    if (this.inFunction) {
                        ((FunctionNode)node).setRequiresActivation(true);
                        functionNode.setCheckThis(true);
                    }
                    this.addParameters(functionNode);
                    NodeTransformer nodeTransformer = this.newInstance();
                    functionNode = (FunctionNode)nodeTransformer.transform(functionNode, node, tokenStream, scriptable);
                    node3.putProp(5, functionNode);
                    Vector<FunctionNode> vector = (Vector<FunctionNode>)node.getProp(5);
                    if (vector == null) {
                        vector = new Vector<FunctionNode>(7);
                        node.putProp(5, vector);
                    }
                    vector.addElement(functionNode);
                    break;
                }
                case 136: {
                    Object object4;
                    Node node6;
                    Node node7 = node3.getFirstChild();
                    node3.removeChild(node7);
                    String string = node7.getString();
                    int n2 = this.loops.size() - 1;
                    while (n2 >= 0) {
                        node6 = (Node)this.loops.elementAt(n2);
                        if (node6.getType() == 136 && string.equals(object4 = (String)node6.getProp(20))) {
                            String string2 = Context.getMessage1("msg.dup.label", string);
                            this.reportMessage(Context.getContext(), string2, node3, node, true, scriptable);
                            break block0;
                        }
                        --n2;
                    }
                    node3.putProp(20, string);
                    node6 = new Node(137);
                    object4 = preorderNodeIterator.getCurrentParent();
                    Node node8 = node3.getNextSibling();
                    while (node8 != null && (node8.getType() == 136 || node8.getType() == 137)) {
                        node8 = node8.getNextSibling();
                    }
                    if (node8 == null) continue block22;
                    ((Node)object4).addChildAfter(node6, node8);
                    node3.putProp(2, node6);
                    if (node8.getType() == 138) {
                        node3.putProp(3, node8.getProp(3));
                    }
                    this.loops.push(node3);
                    this.loopEnds.push(node6);
                    break;
                }
                case 115: {
                    Object object4;
                    Node node9 = new Node(137);
                    Node node10 = preorderNodeIterator.getCurrentParent();
                    node10.addChildAfter(node9, node3);
                    Node node11 = node3;
                    Object object2 = node3.getFirstChild().next;
                    while (object2 != null) {
                        object4 = ((Node)object2).next;
                        node3.removeChild((Node)object2);
                        node10.addChildAfter((Node)object2, node11);
                        node11 = object2;
                        object2 = object4;
                    }
                    node3.putProp(2, node9);
                    this.loops.push(node3);
                    this.loopEnds.push(node9);
                    node3.putProp(13, new Vector(13));
                    break;
                }
                case 116: 
                case 117: {
                    Node node12 = (Node)this.loops.peek();
                    if (n == 116) {
                        Vector vector = (Vector)node12.getProp(13);
                        vector.addElement(node3);
                        break;
                    }
                    node12.putProp(14, node3);
                    break;
                }
                case 144: {
                    int n3 = node.getIntProp(22, 0);
                    node.putIntProp(22, n3 + 1);
                    break;
                }
                case 138: {
                    this.loops.push(node3);
                    this.loopEnds.push(node3.getProp(2));
                    break;
                }
                case 124: {
                    if (this.inFunction) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    this.loops.push(node3);
                    Node node13 = node3.getNextSibling();
                    if (node13.getType() != 4) {
                        throw new RuntimeException("Unexpected tree");
                    }
                    this.loopEnds.push(node13);
                    break;
                }
                case 75: {
                    Node node14 = (Node)node3.getProp(21);
                    if (node14 != null) {
                        bl2 = true;
                        this.loops.push(node3);
                        this.loopEnds.push(node14);
                    }
                    int n4 = node.getIntProp(22, 0);
                    node.putIntProp(22, n4 + 1);
                    break;
                }
                case 4: 
                case 137: {
                    if (this.loopEnds.empty() || this.loopEnds.peek() != node3) continue block22;
                    this.loopEnds.pop();
                    this.loops.pop();
                    break;
                }
                case 5: {
                    Object object4;
                    if (!bl2) continue block22;
                    Node node15 = preorderNodeIterator.getCurrentParent();
                    int n5 = this.loops.size() - 1;
                    while (n5 >= 0) {
                        Node node16 = (Node)this.loops.elementAt(n5);
                        int n6 = node16.getType();
                        if (n6 == 75) {
                            object4 = new Node(143);
                            Object object3 = node16.getProp(21);
                            ((Node)object4).putProp(1, object3);
                            node15.addChildBefore((Node)object4, node3);
                        } else if (n6 == 124) {
                            node15.addChildBefore(new Node(4), node3);
                        }
                        --n5;
                    }
                    continue block22;
                }
                case 121: 
                case 122: {
                    Node node17;
                    Object[] objectArray;
                    Object object;
                    Node node18 = null;
                    boolean bl3 = node3.hasChildren();
                    String string = null;
                    if (bl3) {
                        Node node19 = node3.getFirstChild();
                        string = node19.getString();
                        node3.removeChild(node19);
                    }
                    Object object4 = preorderNodeIterator.getCurrentParent();
                    int n7 = this.loops.size() - 1;
                    while (n7 >= 0) {
                        Node node20 = (Node)this.loops.elementAt(n7);
                        int n8 = node20.getType();
                        if (n8 == 124) {
                            ((Node)object4).addChildBefore(new Node(4), node3);
                        } else if (n8 == 75) {
                            object = new Node(143);
                            objectArray = node20.getProp(21);
                            ((Node)object).putProp(1, objectArray);
                            ((Node)object4).addChildBefore((Node)object, node3);
                        } else {
                            if (!bl3 && (n8 == 138 || n8 == 115 && n == 121)) {
                                node18 = node20;
                                break;
                            }
                            if (bl3 && n8 == 136 && string.equals((String)node20.getProp(20))) {
                                node18 = node20;
                                break;
                            }
                        }
                        --n7;
                    }
                    int n9 = n == 121 ? 2 : 3;
                    Node node21 = node17 = node18 == null ? null : (Node)node18.getProp(n9);
                    if (node18 == null || node17 == null) {
                        if (!bl3) {
                            object = n == 122 ? Context.getMessage("msg.continue.outside", null) : Context.getMessage("msg.bad.break", null);
                        } else if (node18 != null) {
                            object = Context.getMessage0("msg.continue.nonloop");
                        } else {
                            objectArray = new Object[]{string};
                            object = Context.getMessage("msg.undef.label", objectArray);
                        }
                        this.reportMessage(Context.getContext(), (String)object, node3, node, true, scriptable);
                        node3.setType(128);
                        break;
                    }
                    node3.setType(6);
                    node3.putProp(1, node17);
                    break;
                }
                case 43: {
                    if (this.isSpecialCallName(node, node3)) {
                        node3.putProp(30, Boolean.TRUE);
                    }
                    this.visitCall(node3, node);
                    break;
                }
                case 30: {
                    if (this.isSpecialCallName(node, node3)) {
                        node3.putProp(30, Boolean.TRUE);
                    }
                    this.visitNew(node3, node);
                    break;
                }
                case 108: {
                    Node node22 = node3.getLastChild();
                    node22.setType(46);
                    break;
                }
                case 140: {
                    node3.setType(this.inFunction ? 57 : 2);
                    break;
                }
                case 56: {
                    Vector<Node> vector = (Vector<Node>)node.getProp(12);
                    if (vector == null) {
                        vector = new Vector<Node>(3);
                        node.putProp(12, vector);
                    }
                    vector.addElement(node3);
                    Node node23 = new Node(56);
                    preorderNodeIterator.replaceCurrent(node23);
                    node23.putProp(12, node3);
                    break;
                }
                case 123: {
                    Object object4;
                    Node node24 = new Node(133);
                    Node node25 = node3.getFirstChild();
                    while (node25 != null) {
                        Node node26 = node25;
                        node25 = node25.getNextSibling();
                        if (!node26.hasChildren()) continue;
                        Node node27 = node26.getFirstChild();
                        node26.removeChild(node27);
                        object4 = (Node)this.irFactory.createAssignment(128, node26, node27, null, false);
                        Node node28 = new Node(57, (Node)object4, node3.getDatum());
                        node24.addChildToBack(node28);
                    }
                    preorderNodeIterator.replaceCurrent(node24);
                    break;
                }
                case 10: 
                case 31: {
                    VariableTable variableTable;
                    Node node29;
                    if (!this.inFunction || this.inWithStatement() || (node29 = node3.getFirstChild()) == null || node29.getType() != 61) continue block22;
                    String string = node29.getString();
                    Context context = Context.getCurrentContext();
                    if (context != null && context.isActivationNeeded(string)) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    if ((variableTable = this.getVariableTable(node)).getVariable(string) == null) break;
                    if (n == 10) {
                        node3.setType(73);
                        node29.setType(46);
                        break;
                    }
                    Object object4 = new Node(109, 51);
                    preorderNodeIterator.replaceCurrent((Node)object4);
                    break;
                }
                case 39: {
                    if (!this.inFunction) break;
                    Node node30 = node3.getFirstChild().getNextSibling();
                    String string = node30 == null ? "" : node30.getString();
                    Context context = Context.getCurrentContext();
                    if ((context == null || !context.isActivationNeeded(string)) && (!string.equals("length") || Context.getContext().getLanguageVersion() != 120)) continue block22;
                    ((FunctionNode)node).setRequiresActivation(true);
                    break;
                }
                case 44: {
                    VariableTable variableTable;
                    if (!this.inFunction || this.inWithStatement()) continue block22;
                    String string = node3.getString();
                    Context context = Context.getCurrentContext();
                    if (context != null && context.isActivationNeeded(string)) {
                        ((FunctionNode)node).setRequiresActivation(true);
                    }
                    if ((variableTable = this.getVariableTable(node)).getVariable(string) == null) break;
                    node3.setType(72);
                }
            }
        }
        return node;
    }

    protected void addVariables(Node node, VariableTable variableTable) {
        Object object;
        Node node2;
        boolean bl = node.getType() == 110;
        PreorderNodeIterator preorderNodeIterator = node.getPreorderIterator();
        Hashtable<Object, Boolean> hashtable = null;
        while ((node2 = preorderNodeIterator.nextNode()) != null) {
            int n = node2.getType();
            if (bl && n == 110 && node2 != node && ((FunctionNode)node2.getProp(5)).getFunctionType() == 3) {
                object = node2.getString();
                if (object == null) continue;
                variableTable.removeLocal((String)object);
                if (hashtable == null) {
                    hashtable = new Hashtable<Object, Boolean>();
                }
                hashtable.put(object, Boolean.TRUE);
            }
            if (n != 123) continue;
            object = node2.getFirstChild();
            while (object != null) {
                if (hashtable == null || hashtable.get(((Node)object).getString()) == null) {
                    variableTable.addLocal(((Node)object).getString());
                }
                object = ((Node)object).getNextSibling();
            }
        }
        String string = node.getString();
        if (bl && ((FunctionNode)node).getFunctionType() == 2 && string != null && string.length() > 0 && variableTable.getVariable(string) == null) {
            variableTable.addLocal(string);
            object = node.getLastChild();
            Node node3 = new Node(57, new Node(73, new Node(46, string), new Node(109, 87)));
            ((Node)object).addChildrenToFront(node3);
        }
    }

    protected void addParameters(FunctionNode functionNode) {
        VariableTable variableTable = functionNode.getVariableTable();
        Node node = functionNode.getFirstChild();
        if (node.getType() == 94 && variableTable.getParameterCount() == 0) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                String string = node2.getString();
                variableTable.addParameter(string);
                node2 = node2.getNextSibling();
            }
        }
    }

    protected void visitNew(Node node, Node node2) {
    }

    protected void visitCall(Node node, Node node2) {
        Node node3;
        Object object;
        Object object2;
        Node node4 = node.getFirstChild();
        int n = 0;
        Node node5 = node4.getNextSibling();
        while (node5 != null) {
            node5 = node5.getNextSibling();
            ++n;
        }
        boolean bl = false;
        if (node4.getType() == 44) {
            object2 = this.getVariableTable(node2);
            object = node4.getString();
            if (this.inFunction && ((VariableTable)object2).getVariable((String)object) != null && !this.inWithStatement()) {
                node4.setType(72);
            } else {
                node.removeChild(node4);
                node4.setType(71);
                node3 = node4.cloneNode();
                node3.setType(46);
                Node node6 = new Node(39, node4, node3);
                node.addChildToFront(node6);
                node4 = node6;
                boolean bl2 = bl = this.inWithStatement() || !this.inFunction;
            }
        }
        if (node4.getType() != 39 && node4.getType() != 41) {
            node.removeChild(node4);
            object2 = this.irFactory.createNewTemp(node4);
            object = this.irFactory.createUseTemp((Node)object2);
            ((Node)object).putProp(6, object2);
            node3 = new Node(141, (Node)object);
            node.addChildToFront(node3);
            node.addChildToFront((Node)object2);
            return;
        }
        object2 = node4.getFirstChild();
        node4.removeChild((Node)object2);
        object = this.irFactory.createNewTemp((Node)object2);
        node4.addChildToFront((Node)object);
        node3 = this.irFactory.createUseTemp((Node)object);
        node3.putProp(6, object);
        if (bl) {
            node3 = new Node(68, node3);
        }
        node.addChildAfter(node3, node4);
    }

    protected boolean inWithStatement() {
        int n = this.loops.size() - 1;
        while (n >= 0) {
            Node node = (Node)this.loops.elementAt(n);
            if (node.getType() == 124) {
                return true;
            }
            --n;
        }
        return false;
    }

    private boolean isSpecialCallName(Node node, Node node2) {
        Node node3 = node2.getFirstChild();
        boolean bl = false;
        if (node3.getType() == 44) {
            String string = node3.getString();
            bl = string.equals("eval") || string.equals("With");
        } else if (node3.getType() == 39) {
            String string = node3.getLastChild().getString();
            bl = string.equals("exec");
        }
        if (bl) {
            if (this.inFunction) {
                ((FunctionNode)node).setRequiresActivation(true);
            }
            return true;
        }
        return false;
    }

    protected VariableTable createVariableTable() {
        return new VariableTable();
    }

    protected VariableTable getVariableTable(Node node) {
        if (this.inFunction) {
            return ((FunctionNode)node).getVariableTable();
        }
        VariableTable variableTable = (VariableTable)node.getProp(10);
        if (variableTable == null) {
            variableTable = this.createVariableTable();
            node.putProp(10, variableTable);
        }
        return variableTable;
    }

    protected void reportMessage(Context context, String string, Node node, Node node2, boolean bl, Scriptable scriptable) {
        Object object;
        Object object2 = node.getDatum();
        int n = 0;
        if (object2 != null && object2 instanceof Integer) {
            n = (Integer)object2;
        }
        Object object3 = object = node2 == null ? null : node2.getProp(16);
        if (bl) {
            if (scriptable != null) {
                throw NativeGlobal.constructError(context, "SyntaxError", string, scriptable, (String)object, n, 0, null);
            }
            Context.reportError(string, (String)object, n, null, 0);
        } else {
            Context.reportWarning(string, (String)object, n, null, 0);
        }
    }
}

