/*
 * Decompiled with CFR 0.152.
 */
package company.evo.jmorphy2;

import company.evo.jmorphy2.FileLoader;
import company.evo.jmorphy2.JSONUtils;
import company.evo.jmorphy2.SuffixesDAWG;
import company.evo.jmorphy2.Tag;
import company.evo.jmorphy2.WordsDAWG;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.SwappedDataInputStream;

public final class Dictionary {
    private final Tag.Storage tagStorage;
    private final Meta meta;
    private final String[] paradigmPrefixes;
    private final WordsDAWG words;
    private final SuffixesDAWG[] predictionSuffixes;
    private final Paradigm[] paradigms;
    private final String[] suffixes;
    private final Tag[] gramtab;

    private Dictionary(Tag.Storage tagStorage, Meta meta, WordsDAWG words, SuffixesDAWG[] predictionSuffixes, Paradigm[] paradigms, String[] suffixes, Tag[] gramtab) {
        this.tagStorage = tagStorage;
        this.meta = meta;
        this.paradigmPrefixes = meta.compileOptions.paradigmPrefixes;
        this.words = words;
        this.predictionSuffixes = predictionSuffixes;
        this.paradigms = paradigms;
        this.suffixes = suffixes;
        this.gramtab = gramtab;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public WordsDAWG getWords() {
        return this.words;
    }

    public SuffixesDAWG getPredictionSuffixes(int n) {
        return this.predictionSuffixes[n];
    }

    public String[] getParadigmPrefixes() {
        return this.paradigmPrefixes;
    }

    public Paradigm getParadigm(short paradigmId) {
        return this.paradigms[paradigmId];
    }

    public String getSuffix(short paradigmId, short idx) {
        return this.suffixes[this.paradigms[paradigmId].getStemSuffixId(idx)];
    }

    public Tag buildTag(short paradigmId, short idx) {
        Paradigm paradigm = this.paradigms[paradigmId];
        return this.gramtab[paradigm.getTagId(idx)];
    }

    public String buildNormalForm(short paradigmId, short idx, String word) {
        Paradigm paradigm = this.paradigms[paradigmId];
        String stem = this.buildStem(paradigmId, idx, word);
        String prefix = this.paradigmPrefixes[paradigm.getNormPrefixId()];
        String suffix = this.suffixes[paradigm.getNormSuffixId()];
        return prefix + stem + suffix;
    }

    public String buildStem(short paradigmId, short idx, String word) {
        Paradigm paradigm = this.paradigms[paradigmId];
        String prefix = this.paradigmPrefixes[paradigm.getStemPrefixId(idx)];
        String suffix = this.suffixes[paradigm.getStemSuffixId(idx)];
        if (!suffix.equals("")) {
            return word.substring(prefix.length(), word.length() - suffix.length());
        }
        return word.substring(prefix.length());
    }

    public class ParadigmInfo {
        public final String prefix;
        public final String suffix;
        public final Tag tag;

        public ParadigmInfo(String prefix, String suffix, Tag tag) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.tag = tag;
        }
    }

    public static class Paradigm {
        private final short[] data;
        private final int length;

        public Paradigm(DataInput input) throws IOException {
            int size = input.readShort();
            assert (size % 3 == 0) : size;
            this.data = new short[size];
            for (int i = 0; i < size; ++i) {
                this.data[i] = input.readShort();
            }
            this.length = size / 3;
        }

        public int getNormSuffixId() {
            return this.data[0];
        }

        public int getNormPrefixId() {
            return this.data[this.length * 2];
        }

        public int getStemSuffixId(short idx) {
            return this.data[idx];
        }

        public int getStemPrefixId(short idx) {
            return this.data[this.length * 2 + idx];
        }

        public int getTagId(short idx) {
            return this.data[this.length + idx];
        }

        public int size() {
            return this.length;
        }
    }

    public static class Meta {
        public static final String FORMAT_VERSION = "2.4";
        public final String formatVersion;
        public final String pymorphy2Version;
        public final String languageCode;
        public final String compiledAt;
        public final String source;
        public final String sourceVersion;
        public final String sourceRevision;
        public final long sourceLexemesCount;
        public final long sourceLinksCount;
        public final long gramtabLength;
        public final Map<String, String> gramtabFormats;
        public final long paradigmsLength;
        public final long suffixesLength;
        public final long wordsDawgLength;
        public final CompileOptions compileOptions;
        public final Long[] predictionSuffixesDawgLengths;
        public final boolean ptw;
        public final long ptwUniqueWords;
        public final long ptwOutcomes;
        public final long ptwMinWordFreq;
        public final String corpusRevision;

        public Meta(Map<String, Object> meta) {
            this.formatVersion = (String)meta.get("format_version");
            if (!this.formatVersion.equals(FORMAT_VERSION)) {
                throw new RuntimeException(String.format("Unsupported format version: %s, expected %s", this.formatVersion, FORMAT_VERSION));
            }
            this.pymorphy2Version = (String)meta.get("pymorphy2_version");
            this.languageCode = ((String)meta.get("language_code")).toLowerCase();
            this.compiledAt = (String)meta.get("compile_at");
            this.source = (String)meta.get("source");
            this.sourceVersion = (String)meta.get("source_version");
            this.sourceRevision = (String)meta.get("source_revision");
            this.sourceLexemesCount = (Long)meta.get("source_lexemes_count");
            this.sourceLinksCount = (Long)meta.get("source_links_count");
            this.gramtabLength = (Long)meta.get("gramtab_length");
            this.gramtabFormats = (Map)meta.get("gramtab_formats");
            this.paradigmsLength = (Long)meta.get("paradigms_length");
            this.suffixesLength = (Long)meta.get("suffixes_length");
            this.wordsDawgLength = (Long)meta.get("words_dawg_length");
            this.compileOptions = new CompileOptions((Map)meta.get("compile_options"));
            this.predictionSuffixesDawgLengths = ((List)meta.get("prediction_suffixes_dawg_lengths")).toArray(new Long[0]);
            this.ptw = (Boolean)(meta.containsKey("P(t|w)") ? meta.get("P(t|w)") : Boolean.valueOf(false));
            this.ptwUniqueWords = (Long)(meta.containsKey("P(t|w)_unique_words") ? meta.get("P(t|w)_unique_words") : Long.valueOf(-1L));
            this.ptwOutcomes = (Long)(meta.containsKey("P(t|w)_outcomes") ? meta.get("P(t|w)_outcomes") : Long.valueOf(-1L));
            this.ptwMinWordFreq = (Long)(meta.containsKey("P(t|w)_min_word_freq") ? meta.get("P(t|w)_min_word_freq") : Long.valueOf(-1L));
            this.corpusRevision = meta.containsKey("corpus_revision") ? meta.get("corpus_revision") : "";
        }

        public static class CompileOptions {
            public final long maxSuffixLength;
            public final String[] paradigmPrefixes;
            public final long minEndingFreq;
            public final long minParadigmPopularity;

            public CompileOptions(Map<String, Object> options) {
                this.maxSuffixLength = (Long)options.get("max_suffix_length");
                this.paradigmPrefixes = ((List)options.get("paradigm_prefixes")).toArray(new String[0]);
                this.minEndingFreq = (Long)options.get("min_ending_freq");
                this.minParadigmPopularity = (Long)options.get("min_paradigm_popularity");
            }
        }
    }

    public static class Builder {
        private FileLoader loader;
        private Dictionary cachedDict;
        public static final String META_FILENAME = "meta.json";
        public static final String WORDS_FILENAME = "words.dawg";
        public static final String PARADIGMS_FILENAME = "paradigms.array";
        public static final String SUFFIXES_FILENAME = "suffixes.json";
        public static final String PREDICTION_SUFFIXES_FILENAME_TEMPLATE = "prediction-suffixes-%s.dawg";
        public static final String GRAMMEMES_FILENAME = "grammemes.json";
        public static final String GRAMTAB_OPENCORPORA_FILENAME = "gramtab-opencorpora-int.json";

        public Builder(FileLoader loader) {
            this.loader = loader;
        }

        private Meta parseMeta(InputStream stream) throws IOException {
            HashMap<String, Object> rawMeta = new HashMap<String, Object>();
            List parsed = (List)JSONUtils.parseJSON(stream);
            for (List pair : parsed) {
                rawMeta.put((String)pair.get(0), pair.get(1));
            }
            return new Meta(rawMeta);
        }

        private SuffixesDAWG[] parsePredictionSuffixes(FileLoader loader, String filenameTemplate, int num) throws IOException {
            SuffixesDAWG[] predictionSuffixes = new SuffixesDAWG[num];
            for (int i = 0; i < num; ++i) {
                InputStream suffixesStream = loader.newStream(String.format(filenameTemplate, i));
                predictionSuffixes[i] = new SuffixesDAWG(suffixesStream);
                suffixesStream.close();
            }
            return predictionSuffixes;
        }

        private Paradigm[] parseParadigms(InputStream stream) throws IOException {
            SwappedDataInputStream paradigmsStream = new SwappedDataInputStream(stream);
            int paradigmCount = paradigmsStream.readShort();
            Paradigm[] paradigms = new Paradigm[paradigmCount];
            for (int paraId = 0; paraId < paradigmCount; ++paraId) {
                paradigms[paraId] = new Paradigm((DataInput)paradigmsStream);
            }
            return paradigms;
        }

        private String[] parseSuffixes(InputStream stream) throws IOException {
            return ((List)JSONUtils.parseJSON(stream)).toArray(new String[0]);
        }

        private void loadGrammemes(Tag.Storage tagStorage, InputStream stream) throws IOException {
            for (List grammemeInfo : (List)JSONUtils.parseJSON(stream)) {
                tagStorage.newGrammeme(grammemeInfo);
            }
        }

        private Tag[] parseGramtab(Tag.Storage tagStorage, InputStream stream) throws IOException {
            List tagStrings = (List)JSONUtils.parseJSON(stream);
            int tagsLength = tagStrings.size();
            Tag[] gramtab = new Tag[tagsLength];
            for (int i = 0; i < tagsLength; ++i) {
                gramtab[i] = tagStorage.newTag((String)tagStrings.get(i));
            }
            return gramtab;
        }

        public Dictionary build(Tag.Storage tagStorage) throws IOException {
            if (this.cachedDict == null) {
                InputStream metaStream = this.loader.newStream(META_FILENAME);
                Meta meta = this.parseMeta(metaStream);
                metaStream.close();
                InputStream grammemesStream = this.loader.newStream(GRAMMEMES_FILENAME);
                this.loadGrammemes(tagStorage, grammemesStream);
                grammemesStream.close();
                InputStream wordsStream = this.loader.newStream(WORDS_FILENAME);
                InputStream paradigmsStream = this.loader.newStream(PARADIGMS_FILENAME);
                InputStream suffixesStream = this.loader.newStream(SUFFIXES_FILENAME);
                InputStream gramtabStream = this.loader.newStream(GRAMTAB_OPENCORPORA_FILENAME);
                this.cachedDict = new Dictionary(tagStorage, meta, new WordsDAWG(wordsStream), this.parsePredictionSuffixes(this.loader, PREDICTION_SUFFIXES_FILENAME_TEMPLATE, meta.compileOptions.paradigmPrefixes.length), this.parseParadigms(paradigmsStream), this.parseSuffixes(suffixesStream), this.parseGramtab(tagStorage, gramtabStream));
                wordsStream.close();
                paradigmsStream.close();
                suffixesStream.close();
                gramtabStream.close();
            }
            return this.cachedDict;
        }
    }
}

