/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.search.BooleanQuery;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.MoreLikeThisHandler;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocListAndSet;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreLikeThisComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "mlt";
    public static final String DIST_DOC_ID = "mlt.dist.id";
    static final Logger log = LoggerFactory.getLogger(MoreLikeThisComponent.class);

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        SolrReturnFields returnFields = new SolrReturnFields(rb.req);
        int flags = 0;
        if (((ReturnFields)returnFields).wantsScore()) {
            flags |= 1;
        }
        rb.setFieldFlags(flags);
        if (params.getBool(COMPONENT_NAME, false)) {
            log.debug("Starting MoreLikeThis.Process.  isShard: " + params.getBool("isShard"));
            SolrIndexSearcher searcher = rb.req.getSearcher();
            if (params.getBool("isShard", false)) {
                if (params.get(DIST_DOC_ID) == null) {
                    if (rb.getResults().docList.size() == 0) {
                        rb.rsp.add("moreLikeThis", new NamedList());
                        return;
                    }
                    MoreLikeThisHandler.MoreLikeThisHelper mlt = new MoreLikeThisHandler.MoreLikeThisHelper(params, searcher);
                    NamedList<BooleanQuery> bQuery = mlt.getMoreLikeTheseQuery(rb.getResults().docList);
                    NamedList temp = new NamedList();
                    for (Map.Entry idToQuery : bQuery) {
                        String s = ((BooleanQuery)idToQuery.getValue()).toString();
                        log.debug("MLT Query:" + s);
                        temp.add((String)idToQuery.getKey(), (Object)((BooleanQuery)idToQuery.getValue()).toString());
                    }
                    rb.rsp.add("moreLikeThis", temp);
                } else {
                    NamedList<DocList> sim = this.getMoreLikeThese(rb, rb.req.getSearcher(), rb.getResults().docList, flags);
                    rb.rsp.add("moreLikeThis", sim);
                }
            } else {
                NamedList<DocList> sim = this.getMoreLikeThese(rb, rb.req.getSearcher(), rb.getResults().docList, flags);
                rb.rsp.add("moreLikeThis", sim);
            }
        }
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if ((sreq.purpose & 4) != 0 && rb.req.getParams().getBool(COMPONENT_NAME, false)) {
            log.debug("ShardRequest.response.size: " + sreq.responses.size());
            for (ShardResponse r : sreq.responses) {
                NamedList moreLikeThisReponse = (NamedList)r.getSolrResponse().getResponse().get("moreLikeThis");
                log.debug("ShardRequest.response.shard: " + r.getShard());
                if (moreLikeThisReponse == null) continue;
                for (Map.Entry entry : moreLikeThisReponse) {
                    log.debug("id: \"" + (String)entry.getKey() + "\" Query: \"" + entry.getValue() + "\"");
                    ShardRequest s = this.buildShardQuery(rb, (String)entry.getValue(), (String)entry.getKey());
                    rb.addRequest(this, s);
                }
            }
        }
        if ((sreq.purpose & 0x1000) != 0) {
            for (ShardResponse r : sreq.responses) {
                log.debug("MLT Query returned: " + r.getSolrResponse().getResponse().toString());
            }
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS && rb.req.getParams().getBool(COMPONENT_NAME, false)) {
            LinkedHashMap<Object, SolrDocumentList> tempResults = new LinkedHashMap<Object, SolrDocumentList>();
            int mltcount = rb.req.getParams().getInt("mlt.count", 5);
            String keyName = rb.req.getSchema().getUniqueKeyField().getName();
            for (ShardRequest sreq : rb.finished) {
                if ((sreq.purpose & 0x1000) == 0) continue;
                for (ShardResponse r : sreq.responses) {
                    log.debug("ShardRequest.response.shard: " + r.getShard());
                    String key = r.getShardRequest().params.get(DIST_DOC_ID);
                    SolrDocumentList shardDocList = (SolrDocumentList)r.getSolrResponse().getResponse().get("response");
                    if (shardDocList == null) continue;
                    log.info("MLT: results added for key: " + key + " documents: " + shardDocList.toString());
                    SolrDocumentList mergedDocList = (SolrDocumentList)tempResults.get(key);
                    if (mergedDocList == null) {
                        mergedDocList = new SolrDocumentList();
                        mergedDocList.addAll((Collection)shardDocList);
                        mergedDocList.setNumFound(shardDocList.getNumFound());
                        mergedDocList.setStart(shardDocList.getStart());
                        mergedDocList.setMaxScore(shardDocList.getMaxScore());
                    } else {
                        mergedDocList = this.mergeSolrDocumentList(mergedDocList, shardDocList, mltcount, keyName);
                    }
                    log.debug("Adding docs for key: " + key);
                    tempResults.put(key, mergedDocList);
                }
            }
            NamedList<SolrDocumentList> list = this.buildMoreLikeThisNamed(tempResults, rb.resultIds);
            rb.rsp.add("moreLikeThis", list);
        }
        super.finishStage(rb);
    }

    NamedList<SolrDocumentList> buildMoreLikeThisNamed(Map<Object, SolrDocumentList> allMlt, Map<Object, ShardDoc> resultIds) {
        NamedList result = new NamedList();
        TreeMap<Integer, Object> sortingMap = new TreeMap<Integer, Object>();
        for (Map.Entry<Object, ShardDoc> next : resultIds.entrySet()) {
            sortingMap.put(next.getValue().positionInResponse, next.getKey());
        }
        for (Map.Entry<Object, ShardDoc> key : sortingMap.values()) {
            SolrDocumentList sdl = allMlt.get(key);
            if (sdl == null) {
                sdl = new SolrDocumentList();
                sdl.setNumFound(0L);
                sdl.setStart(0L);
            }
            result.add(key.toString(), (Object)sdl);
        }
        return result;
    }

    public SolrDocumentList mergeSolrDocumentList(SolrDocumentList one, SolrDocumentList two, int maxSize, String idField) {
        List<Object> l = new ArrayList();
        HashMap<String, SolrDocument> map = new HashMap<String, SolrDocument>();
        for (SolrDocument doc : one) {
            Object id = doc.getFieldValue(idField);
            assert (id != null) : doc.toString();
            map.put(id.toString(), doc);
        }
        for (SolrDocument doc : two) {
            map.put(doc.getFieldValue(idField).toString(), doc);
        }
        l = new ArrayList(map.values());
        Comparator<SolrDocument> c = new Comparator<SolrDocument>(){

            @Override
            public int compare(SolrDocument o1, SolrDocument o2) {
                Float f1 = this.getFloat(o1);
                Float f2 = this.getFloat(o2);
                return f2.compareTo(f1);
            }

            private Float getFloat(SolrDocument doc) {
                Object o;
                Float f = Float.valueOf(0.0f);
                if (doc != null && (o = doc.getFieldValue("score")) != null && o instanceof Float) {
                    f = (Float)o;
                }
                return f;
            }
        };
        Collections.sort(l, c);
        if (l.size() > maxSize) {
            l = l.subList(0, maxSize);
        }
        SolrDocumentList result = new SolrDocumentList();
        result.addAll(l);
        result.setMaxScore(Float.valueOf(Math.max(one.getMaxScore().floatValue(), two.getMaxScore().floatValue())));
        result.setNumFound(one.getNumFound() + two.getNumFound());
        result.setStart(Math.min(one.getStart(), two.getStart()));
        return result;
    }

    ShardRequest buildShardQuery(ResponseBuilder rb, String q, String key) {
        ShardRequest s = new ShardRequest();
        s.params = new ModifiableSolrParams(rb.req.getParams());
        s.purpose |= 0x1000;
        s.purpose |= 1;
        s.params.remove("shards");
        s.params.set(DIST_DOC_ID, new String[]{key});
        s.params.set("start", 0);
        int mltcount = s.params.getInt("mlt.count", 20);
        s.params.set("rows", mltcount);
        s.params.remove("fl");
        String id = rb.req.getSchema().getUniqueKeyField().getName();
        s.params.set("fl", new String[]{"score," + id});
        s.params.set("sort", new String[]{"score desc"});
        s.params.set("q", new String[]{q});
        return s;
    }

    ShardRequest buildMLTQuery(ResponseBuilder rb, String q) {
        ShardRequest s = new ShardRequest();
        s.params = new ModifiableSolrParams();
        s.params.set("start", 0);
        String id = rb.req.getSchema().getUniqueKeyField().getName();
        s.params.set("fl", new String[]{"score," + id});
        s.params.set("q", new String[]{q});
        s.shards = ShardRequest.ALL_SHARDS;
        return s;
    }

    NamedList<DocList> getMoreLikeThese(ResponseBuilder rb, SolrIndexSearcher searcher, DocList docs, int flags) throws IOException {
        SolrParams p = rb.req.getParams();
        IndexSchema schema = searcher.getSchema();
        MoreLikeThisHandler.MoreLikeThisHelper mltHelper = new MoreLikeThisHandler.MoreLikeThisHelper(p, searcher);
        SimpleOrderedMap mlt = new SimpleOrderedMap();
        DocIterator iterator = docs.iterator();
        SimpleOrderedMap dbg = null;
        if (rb.isDebug()) {
            dbg = new SimpleOrderedMap();
        }
        while (iterator.hasNext()) {
            int id = iterator.nextDoc();
            int rows = p.getInt("mlt.count", 5);
            DocListAndSet sim = mltHelper.getMoreLikeThis(id, 0, rows, null, null, flags);
            String name = schema.printableUniqueKey(searcher.doc(id));
            mlt.add(name, (Object)sim.docList);
            if (dbg == null) continue;
            SimpleOrderedMap docDbg = new SimpleOrderedMap();
            docDbg.add("rawMLTQuery", (Object)mltHelper.getRawMLTQuery().toString());
            docDbg.add("boostedMLTQuery", (Object)mltHelper.getBoostedMLTQuery().toString());
            docDbg.add("realMLTQuery", (Object)mltHelper.getRealMLTQuery().toString());
            SimpleOrderedMap explains = new SimpleOrderedMap();
            DocIterator mltIte = sim.docList.iterator();
            while (mltIte.hasNext()) {
                int mltid = mltIte.nextDoc();
                String key = schema.printableUniqueKey(searcher.doc(mltid));
                explains.add(key, (Object)searcher.explain(mltHelper.getRealMLTQuery(), mltid));
            }
            docDbg.add("explain", (Object)explains);
            dbg.add(name, (Object)docDbg);
        }
        if (dbg != null) {
            rb.addDebugInfo("moreLikeThis", dbg);
        }
        return mlt;
    }

    @Override
    public String getDescription() {
        return "More Like This";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_7/solr/core/src/java/org/apache/solr/handler/component/MoreLikeThisComponent.java $";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }
}

