/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedQueue {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedQueue.class);
    private static long DEFAULT_TIMEOUT = 300000L;
    private final String dir;
    private SolrZkClient zookeeper;
    private List<ACL> acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
    private final String prefix = "qn-";
    private final String response_prefix = "qnr-";

    public DistributedQueue(SolrZkClient zookeeper, String dir, List<ACL> acl) {
        this.dir = dir;
        ZkCmdExecutor cmdExecutor = new ZkCmdExecutor(zookeeper.getZkClientTimeout());
        try {
            cmdExecutor.ensureExists(dir, zookeeper);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        if (acl != null) {
            this.acl = acl;
        }
        this.zookeeper = zookeeper;
    }

    private TreeMap<Long, String> orderedChildren(Watcher watcher) throws KeeperException, InterruptedException {
        TreeMap<Long, String> orderedChildren = new TreeMap<Long, String>();
        List childNames = null;
        childNames = this.zookeeper.getChildren(this.dir, watcher, true);
        for (String childName : childNames) {
            try {
                if (!childName.regionMatches(0, "qn-", 0, "qn-".length())) {
                    LOG.debug("Found child node with improper name: " + childName);
                    continue;
                }
                String suffix = childName.substring("qn-".length());
                Long childId = new Long(suffix);
                orderedChildren.put(childId, childName);
            }
            catch (NumberFormatException e) {
                LOG.warn("Found child node with improper format : " + childName + " " + e, (Throwable)e);
            }
        }
        return orderedChildren;
    }

    private QueueEvent element() throws KeeperException, InterruptedException {
        block4: while (true) {
            TreeMap<Long, String> orderedChildren;
            try {
                orderedChildren = this.orderedChildren(null);
            }
            catch (KeeperException.NoNodeException e) {
                return null;
            }
            if (orderedChildren.size() == 0) {
                return null;
            }
            Iterator<String> i$ = orderedChildren.values().iterator();
            while (true) {
                if (!i$.hasNext()) continue block4;
                String headNode = i$.next();
                if (headNode == null) continue;
                try {
                    return new QueueEvent(this.dir + "/" + headNode, this.zookeeper.getData(this.dir + "/" + headNode, null, null, true), null);
                }
                catch (KeeperException.NoNodeException e) {
                    continue;
                }
                break;
            }
            break;
        }
    }

    public byte[] remove() throws NoSuchElementException, KeeperException, InterruptedException {
        block4: while (true) {
            TreeMap<Long, String> orderedChildren;
            try {
                orderedChildren = this.orderedChildren(null);
            }
            catch (KeeperException.NoNodeException e) {
                throw new NoSuchElementException();
            }
            if (orderedChildren.size() == 0) {
                throw new NoSuchElementException();
            }
            Iterator<String> i$ = orderedChildren.values().iterator();
            while (true) {
                if (!i$.hasNext()) continue block4;
                String headNode = i$.next();
                String path = this.dir + "/" + headNode;
                try {
                    byte[] data = this.zookeeper.getData(path, null, null, true);
                    this.zookeeper.delete(path, -1, true);
                    return data;
                }
                catch (KeeperException.NoNodeException e) {
                    continue;
                }
                break;
            }
            break;
        }
    }

    public byte[] remove(QueueEvent event) throws KeeperException, InterruptedException {
        String path = event.getId();
        String responsePath = this.dir + "/" + "qnr-" + path.substring(path.lastIndexOf("-") + 1);
        if (this.zookeeper.exists(responsePath, true).booleanValue()) {
            this.zookeeper.setData(responsePath, event.getBytes(), true);
        }
        byte[] data = this.zookeeper.getData(path, null, null, true);
        this.zookeeper.delete(path, -1, true);
        return data;
    }

    /*
     * Unable to fully structure code
     */
    public byte[] take() throws KeeperException, InterruptedException {
        block4: while (true) {
            childWatcher = new LatchChildWatcher();
            try {
                orderedChildren = this.orderedChildren(childWatcher);
            }
            catch (KeeperException.NoNodeException e) {
                this.zookeeper.create(this.dir, new byte[0], this.acl, CreateMode.PERSISTENT, true);
                continue;
            }
            if (orderedChildren.size() == 0) {
                childWatcher.await(DistributedQueue.DEFAULT_TIMEOUT);
                continue;
            }
            i$ = orderedChildren.values().iterator();
            while (true) {
                if (i$.hasNext()) ** break;
                continue block4;
                headNode = i$.next();
                path = this.dir + "/" + headNode;
                try {
                    data = this.zookeeper.getData(path, null, null, true);
                    this.zookeeper.delete(path, -1, true);
                    return data;
                }
                catch (KeeperException.NoNodeException e) {
                    continue;
                }
                break;
            }
            break;
        }
    }

    public boolean offer(byte[] data) throws KeeperException, InterruptedException {
        return this.createData(this.dir + "/" + "qn-", data, CreateMode.PERSISTENT_SEQUENTIAL) != null;
    }

    private String createData(String path, byte[] data, CreateMode mode) throws KeeperException, InterruptedException {
        while (true) {
            try {
                return this.zookeeper.create(path, data, this.acl, mode, true);
            }
            catch (KeeperException.NoNodeException e) {
                try {
                    this.zookeeper.create(this.dir, new byte[0], this.acl, CreateMode.PERSISTENT, true);
                }
                catch (KeeperException.NodeExistsException ne) {
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueEvent offer(byte[] data, long timeout) throws KeeperException, InterruptedException {
        String path = this.createData(this.dir + "/" + "qn-", data, CreateMode.PERSISTENT_SEQUENTIAL);
        String watchID = this.createData(this.dir + "/" + "qnr-" + path.substring(path.lastIndexOf("-") + 1), null, CreateMode.EPHEMERAL);
        Object lock = new Object();
        LatchChildWatcher watcher = new LatchChildWatcher(lock);
        Object object = lock;
        synchronized (object) {
            if (this.zookeeper.exists(watchID, (Watcher)watcher, true) != null) {
                watcher.await(timeout);
            }
        }
        byte[] bytes = this.zookeeper.getData(watchID, null, null, true);
        this.zookeeper.delete(watchID, -1, true);
        return new QueueEvent(watchID, bytes, watcher.getWatchedEvent());
    }

    public byte[] peek() throws KeeperException, InterruptedException {
        QueueEvent element = this.element();
        if (element == null) {
            return null;
        }
        return element.getBytes();
    }

    public QueueEvent peek(boolean block) throws KeeperException, InterruptedException {
        return this.peek(block ? Long.MAX_VALUE : 0L);
    }

    /*
     * Unable to fully structure code
     */
    public QueueEvent peek(long wait) throws KeeperException, InterruptedException {
        if (wait == 0L) {
            return this.element();
        }
        waitedEnough = false;
        block4: while (true) {
            childWatcher = new LatchChildWatcher();
            try {
                orderedChildren = this.orderedChildren(childWatcher);
            }
            catch (KeeperException.NoNodeException e) {
                this.zookeeper.create(this.dir, new byte[0], this.acl, CreateMode.PERSISTENT, true);
                continue;
            }
            if (waitedEnough && orderedChildren.isEmpty()) {
                return null;
            }
            if (orderedChildren.size() == 0) {
                childWatcher.await(wait == 0x7FFFFFFFFFFFFFFFL ? DistributedQueue.DEFAULT_TIMEOUT : wait);
                waitedEnough = wait != 0x7FFFFFFFFFFFFFFFL;
                continue;
            }
            i$ = orderedChildren.values().iterator();
            while (true) {
                if (i$.hasNext()) ** break;
                continue block4;
                headNode = i$.next();
                path = this.dir + "/" + headNode;
                try {
                    data = this.zookeeper.getData(path, null, null, true);
                    return new QueueEvent(path, data, childWatcher.getWatchedEvent());
                }
                catch (KeeperException.NoNodeException e) {
                    continue;
                }
                break;
            }
            break;
        }
    }

    public byte[] poll() throws KeeperException, InterruptedException {
        try {
            return this.remove();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public static class QueueEvent {
        private WatchedEvent event = null;
        private String id;
        private byte[] bytes;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueueEvent other = (QueueEvent)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        QueueEvent(String id, byte[] bytes, WatchedEvent event) {
            this.id = id;
            this.bytes = bytes;
            this.event = event;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public WatchedEvent getWatchedEvent() {
            return this.event;
        }
    }

    private class LatchChildWatcher
    implements Watcher {
        Object lock = new Object();
        private WatchedEvent event = null;

        public LatchChildWatcher() {
        }

        public LatchChildWatcher(Object lock) {
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            LOG.info("LatchChildWatcher fired on path: " + event.getPath() + " state: " + event.getState() + " type " + event.getType());
            Object object = this.lock;
            synchronized (object) {
                this.event = event;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await(long timeout) throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait(timeout);
            }
        }

        public WatchedEvent getWatchedEvent() {
            return this.event;
        }
    }
}

