/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.schema.BinaryField;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;

public class DocumentBuilder {
    private final IndexSchema schema;
    private Document doc;
    private HashMap<String, String> map;

    public DocumentBuilder(IndexSchema schema) {
        this.schema = schema;
    }

    public void startDoc() {
        this.doc = new Document();
        this.map = new HashMap();
    }

    protected void addSingleField(SchemaField sfield, String val, float boost) {
        if (sfield.isPolyField()) {
            Fieldable[] fields = sfield.createFields(val, boost);
            if (fields.length > 0) {
                String oldValue;
                if (!sfield.multiValued() && (oldValue = this.map.put(sfield.getName(), val)) != null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: multiple values encountered for non multiValued field " + sfield.getName() + ": first='" + oldValue + "' second='" + val + "'");
                }
                for (Fieldable field : fields) {
                    this.doc.add(field);
                }
            }
        } else {
            String oldValue;
            Fieldable field = sfield.createField(val, boost);
            if (field != null && !sfield.multiValued() && (oldValue = this.map.put(sfield.getName(), val)) != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: multiple values encountered for non multiValued field " + sfield.getName() + ": first='" + oldValue + "' second='" + val + "'");
            }
            this.doc.add(field);
        }
    }

    public void addField(SchemaField sfield, String val, float boost) {
        this.addSingleField(sfield, val, boost);
    }

    public void addField(String name, String val) {
        this.addField(name, val, 1.0f);
    }

    public void addField(String name, String val, float boost) {
        List<CopyField> copyFields;
        SchemaField sfield = this.schema.getFieldOrNull(name);
        if (sfield != null) {
            this.addField(sfield, val, boost);
        }
        if ((copyFields = this.schema.getCopyFieldsList(name)) != null) {
            for (CopyField cf : copyFields) {
                this.addSingleField(cf.getDestination(), cf.getLimitedValue(val), boost);
            }
        }
        if (sfield == null && (copyFields == null || copyFields.size() == 0)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR:unknown field '" + name + "'");
        }
    }

    public void setBoost(float boost) {
        this.doc.setBoost(boost);
    }

    public void endDoc() {
    }

    public Document getDoc() throws IllegalArgumentException {
        ArrayList<String> missingFields = null;
        for (SchemaField field : this.schema.getRequiredFields()) {
            if (this.doc.getFieldable(field.getName()) != null) continue;
            if (field.getDefaultValue() != null) {
                DocumentBuilder.addField(this.doc, field, field.getDefaultValue(), 1.0f);
                continue;
            }
            if (missingFields == null) {
                missingFields = new ArrayList<String>(1);
            }
            missingFields.add(field.getName());
        }
        if (missingFields != null) {
            StringBuilder builder = new StringBuilder();
            if (this.schema.getUniqueKeyField() != null) {
                String n = this.schema.getUniqueKeyField().getName();
                String v = this.doc.get(n);
                builder.append("Document [" + n + "=" + v + "] ");
            }
            builder.append("missing required fields: ");
            for (String field : missingFields) {
                builder.append(field);
                builder.append(" ");
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, builder.toString());
        }
        Document ret = this.doc;
        this.doc = null;
        return ret;
    }

    private static void addField(Document doc, SchemaField field, String val, float boost) {
        if (field.isPolyField()) {
            Fieldable[] farr;
            for (Fieldable f : farr = field.getType().createFields(field, val, boost)) {
                if (f == null) continue;
                doc.add(f);
            }
        } else {
            Fieldable f = field.createField(val, boost);
            if (f != null) {
                doc.add(f);
            }
        }
    }

    public static Document toDocument(SolrInputDocument doc, IndexSchema schema) {
        Document out = new Document();
        out.setBoost(doc.getDocumentBoost());
        for (SolrInputField solrInputField : doc) {
            String name = solrInputField.getName();
            SchemaField sfield = schema.getFieldOrNull(name);
            boolean used = false;
            float boost = solrInputField.getBoost();
            if (sfield != null && !sfield.multiValued() && solrInputField.getValueCount() > 1) {
                String id = "";
                SchemaField sf = schema.getUniqueKeyField();
                if (sf != null) {
                    id = "[" + doc.getFieldValue(sf.getName()) + "] ";
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: " + id + "multiple values encountered for non multiValued field " + sfield.getName() + ": " + solrInputField.getValue());
            }
            boolean hasField = false;
            for (Object v : solrInputField) {
                if (v == null) continue;
                String val = null;
                hasField = true;
                boolean isBinaryField = false;
                if (sfield != null && sfield.getType() instanceof BinaryField) {
                    isBinaryField = true;
                    BinaryField binaryField = (BinaryField)sfield.getType();
                    Field f = binaryField.createField(sfield, v, boost);
                    if (f != null) {
                        out.add((Fieldable)f);
                    }
                    used = true;
                } else {
                    if (sfield != null && v instanceof Date && sfield.getType() instanceof DateField) {
                        DateField df = (DateField)sfield.getType();
                        val = df.toInternal((Date)v) + 'Z';
                    } else if (v != null) {
                        val = v.toString();
                    }
                    if (sfield != null) {
                        used = true;
                        DocumentBuilder.addField(out, sfield, val, boost);
                    }
                }
                List<CopyField> copyFields = schema.getCopyFieldsList(name);
                for (CopyField cf : copyFields) {
                    SchemaField destinationField = cf.getDestination();
                    if (!destinationField.multiValued() && out.get(destinationField.getName()) != null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR: multiple values encountered for non multiValued copy field " + destinationField.getName() + ": " + val);
                    }
                    used = true;
                    Fieldable[] fields = null;
                    if (isBinaryField) {
                        if (destinationField.getType() instanceof BinaryField) {
                            BinaryField binaryField = (BinaryField)destinationField.getType();
                            fields = new Fieldable[]{binaryField.createField(destinationField, v, boost)};
                        }
                    } else {
                        fields = destinationField.createFields(cf.getLimitedValue(val), boost);
                    }
                    if (fields == null) continue;
                    for (Fieldable f : fields) {
                        out.add(f);
                    }
                }
                boost = 1.0f;
            }
            if (used || !hasField) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "ERROR:unknown field '" + name + "'");
        }
        for (SchemaField schemaField : schema.getRequiredFields()) {
            if (out.getFieldable(schemaField.getName()) != null) continue;
            if (schemaField.getDefaultValue() != null) {
                DocumentBuilder.addField(out, schemaField, schemaField.getDefaultValue(), 1.0f);
                continue;
            }
            String id = schema.printableUniqueKey(out);
            String msg = "Document [" + id + "] missing required field: " + schemaField.getName();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
        return out;
    }

    public SolrDocument loadStoredFields(SolrDocument doc, Document luceneDoc) {
        for (Fieldable f : luceneDoc.getFields()) {
            SchemaField sf;
            Fieldable field = f;
            if (!field.isStored() || this.schema.isCopyFieldTarget(sf = this.schema.getField(field.name()))) continue;
            doc.addField(field.name(), sf.getType().toObject(field));
        }
        return doc;
    }
}

