/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.UpdateCommand;

public class AddUpdateCommand
extends UpdateCommand {
    public String indexedId;
    public Document doc;
    public SolrInputDocument solrDoc;
    public boolean allowDups;
    public boolean overwritePending;
    public boolean overwriteCommitted;
    public Term updateTerm;
    public int commitWithin = -1;

    public void clear() {
        this.doc = null;
        this.solrDoc = null;
        this.indexedId = null;
    }

    public SolrInputDocument getSolrInputDocument() {
        return this.solrDoc;
    }

    public Document getLuceneDocument(IndexSchema schema) {
        if (this.doc != null || this.solrDoc != null) {
            // empty if block
        }
        return this.doc;
    }

    public String getIndexedId(IndexSchema schema) {
        SchemaField sf;
        if (this.indexedId == null && (sf = schema.getUniqueKeyField()) != null) {
            SolrInputField field;
            if (this.doc != null) {
                schema.getUniqueKeyField();
                Fieldable storedId = this.doc.getFieldable(sf.getName());
                this.indexedId = sf.getType().storedToIndexed(storedId);
            }
            if (this.solrDoc != null && (field = this.solrDoc.getField(sf.getName())) != null) {
                this.indexedId = sf.getType().toInternal(field.getFirstValue().toString());
            }
        }
        return this.indexedId;
    }

    public String getPrintableId(IndexSchema schema) {
        SolrInputField field;
        SchemaField sf = schema.getUniqueKeyField();
        if (this.indexedId != null) {
            return schema.getUniqueKeyField().getType().indexedToReadable(this.indexedId);
        }
        if (this.doc != null) {
            return schema.printableUniqueKey(this.doc);
        }
        if (this.solrDoc != null && (field = this.solrDoc.getField(sf.getName())) != null) {
            return field.getFirstValue().toString();
        }
        return "(null)";
    }

    public AddUpdateCommand() {
        super("add");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.commandName);
        sb.append(':');
        if (this.indexedId != null) {
            sb.append("id=").append(this.indexedId);
        }
        sb.append(",allowDups=").append(this.allowDups);
        sb.append(",overwritePending=").append(this.overwritePending);
        sb.append(",overwriteCommitted=").append(this.overwriteCommitted);
        return sb.toString();
    }
}

