/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.util.StringHelper;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.VersionedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileFloatSource
extends ValueSource {
    private SchemaField field;
    private final SchemaField keyField;
    private final float defVal;
    private final String dataDir;
    static Cache floatCache = new Cache(){

        protected Object createValue(IndexReader reader, Object key) {
            return FileFloatSource.getFloats(((Entry)key).ffs, reader);
        }
    };
    static Object onlyForTesting;

    public FileFloatSource(SchemaField field, SchemaField keyField, float defVal, QParser parser) {
        this.field = field;
        this.keyField = keyField;
        this.defVal = defVal;
        this.dataDir = parser.getReq().getCore().getDataDir();
    }

    public String description() {
        return "float(" + this.field + ')';
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        int offset = 0;
        if (reader instanceof SolrIndexReader) {
            SolrIndexReader r = (SolrIndexReader)((Object)reader);
            while (r.getParent() != null) {
                offset += r.getBase();
                r = r.getParent();
            }
            reader = r;
        }
        final int off = offset;
        final float[] arr = this.getCachedFloats((IndexReader)reader);
        return new DocValues(){

            public float floatVal(int doc) {
                return arr[doc + off];
            }

            public int intVal(int doc) {
                return (int)arr[doc + off];
            }

            public long longVal(int doc) {
                return (long)arr[doc + off];
            }

            public double doubleVal(int doc) {
                return arr[doc + off];
            }

            public String strVal(int doc) {
                return Float.toString(arr[doc + off]);
            }

            public String toString(int doc) {
                return FileFloatSource.this.description() + '=' + this.floatVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        if (o.getClass() != FileFloatSource.class) {
            return false;
        }
        FileFloatSource other = (FileFloatSource)o;
        return this.field.getName().equals(other.field.getName()) && this.keyField.getName().equals(other.keyField.getName()) && this.defVal == other.defVal && this.dataDir.equals(other.dataDir);
    }

    public int hashCode() {
        return FileFloatSource.class.hashCode() + this.field.getName().hashCode();
    }

    public String toString() {
        return "FileFloatSource(field=" + this.field.getName() + ",keyField=" + this.keyField.getName() + ",defVal=" + this.defVal + ",dataDir=" + this.dataDir + ")";
    }

    public static void resetCache() {
        floatCache.resetCache();
    }

    private final float[] getCachedFloats(IndexReader reader) {
        return (float[])floatCache.get(reader, new Entry(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static float[] getFloats(FileFloatSource ffs, IndexReader reader) {
        int notFoundCount;
        ArrayList<String> notFound;
        String fname;
        float[] vals;
        block44: {
            Exception e4;
            TermEnum termEnum;
            TermDocs termDocs;
            BufferedReader r;
            block40: {
                String line;
                InputStream is;
                vals = new float[reader.maxDoc()];
                if (ffs.defVal != 0.0f) {
                    Arrays.fill(vals, ffs.defVal);
                }
                fname = "external_" + ffs.field.getName();
                try {
                    is = VersionedFile.getLatestFile(ffs.dataDir, fname);
                }
                catch (IOException e2) {
                    SolrCore.log.error("Error opening external value source file: " + e2);
                    return vals;
                }
                r = new BufferedReader(new InputStreamReader(is));
                String idName = StringHelper.intern((String)ffs.keyField.getName());
                FieldType idType = ffs.keyField.getType();
                boolean sorted = true;
                notFound = new ArrayList<String>();
                notFoundCount = 0;
                int otherErrors = 0;
                termDocs = null;
                Term protoTerm = new Term(idName, "");
                termEnum = null;
                int numTimesNext = 10;
                int delimiter = 61;
                boolean hasNext = true;
                String prevKey = "";
                String lastVal = "\uffff\uffff\uffff\uffff\uffff\uffff\uffff\uffff";
                termDocs = reader.termDocs();
                termEnum = reader.terms(protoTerm);
                Term t = termEnum.term();
                String termVal = t != null && t.field() == idName ? t.text() : lastVal;
                while ((line = r.readLine()) != null) {
                    float fval;
                    int delimIndex = line.indexOf(delimiter);
                    if (delimIndex < 0) continue;
                    int endIndex = line.length();
                    String key = line.substring(0, delimIndex);
                    String val = line.substring(delimIndex + 1, endIndex);
                    String internalKey = idType.toInternal(key);
                    try {
                        fval = Float.parseFloat(val);
                    }
                    catch (Exception e3) {
                        if (++otherErrors > 10) continue;
                        SolrCore.log.error("Error loading external value source + fileName + " + e3 + (otherErrors < 10 ? "" : "\tSkipping future errors for this file."));
                        continue;
                    }
                    if (sorted) {
                        sorted = internalKey.compareTo(prevKey) >= 0;
                        prevKey = internalKey;
                        if (sorted) {
                            int countNext = 0;
                            while (true) {
                                int cmp;
                                if ((cmp = internalKey.compareTo(termVal)) == 0) {
                                    termDocs.seek(termEnum);
                                    while (termDocs.next()) {
                                        vals[termDocs.doc()] = fval;
                                    }
                                    break;
                                }
                                if (cmp < 0) {
                                    if (notFoundCount < 10) {
                                        notFound.add(key);
                                    }
                                    ++notFoundCount;
                                    break;
                                }
                                if (++countNext > numTimesNext) {
                                    termEnum = reader.terms(protoTerm.createTerm(internalKey));
                                    t = termEnum.term();
                                } else {
                                    hasNext = termEnum.next();
                                    Term term = t = hasNext ? termEnum.term() : null;
                                }
                                if (t != null && t.field() == idName) {
                                    termVal = t.text();
                                    continue;
                                }
                                termVal = lastVal;
                            }
                        }
                    }
                    if (sorted) continue;
                    termEnum = reader.terms(protoTerm.createTerm(internalKey));
                    t = termEnum.term();
                    if (t != null && t.field() == idName && internalKey.equals(t.text())) {
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            vals[termDocs.doc()] = fval;
                        }
                        continue;
                    }
                    if (notFoundCount < 10) {
                        notFound.add(key);
                    }
                    ++notFoundCount;
                }
                Object var32_34 = null;
                if (termDocs == null) break block40;
                try {
                    termDocs.close();
                }
                catch (Exception e4) {
                    // empty catch block
                }
            }
            if (termEnum != null) {
                try {
                    termEnum.close();
                }
                catch (Exception e4) {
                    // empty catch block
                }
            }
            try {
                r.close();
            }
            catch (Exception e4) {}
            break block44;
            {
                catch (IOException e5) {
                    SolrCore.log.error("Error loading external value source: " + e5);
                    Object var32_35 = null;
                    if (termDocs != null) {
                        try {
                            termDocs.close();
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                    }
                    if (termEnum != null) {
                        try {
                            termEnum.close();
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                    }
                    try {
                        r.close();
                    }
                    catch (Exception e4) {}
                }
            }
            catch (Throwable throwable) {
                Object var32_36 = null;
                if (termDocs != null) {
                    try {
                        termDocs.close();
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                }
                if (termEnum != null) {
                    try {
                        termEnum.close();
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                }
                try {
                    r.close();
                }
                catch (Exception e4) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        SolrCore.log.info("Loaded external value source " + fname + (notFoundCount == 0 ? "" : " :" + notFoundCount + " missing keys " + notFound));
        return vals;
    }

    public static class ReloadCacheRequestHandler
    extends RequestHandlerBase {
        static final Logger log = LoggerFactory.getLogger(ReloadCacheRequestHandler.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
            FileFloatSource.resetCache();
            log.debug("readerCache has been reset.");
            UpdateRequestProcessor processor = req.getCore().getUpdateProcessingChain(null).createProcessor(req, rsp);
            try {
                RequestHandlerUtils.handleCommit(processor, req.getParams(), true);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                processor.finish();
                throw throwable;
            }
            processor.finish();
        }

        public String getDescription() {
            return "Reload readerCache request handler";
        }

        public String getSource() {
            return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_3/solr/src/java/org/apache/solr/search/function/FileFloatSource.java $";
        }

        public String getSourceId() {
            return "$Id: FileFloatSource.java 1126492 2011-05-23 13:56:30Z koji $";
        }

        public String getVersion() {
            return "$Revision: 1126492 $";
        }
    }

    private static class Entry {
        final FileFloatSource ffs;

        public Entry(FileFloatSource ffs) {
            this.ffs = ffs;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            return this.ffs.equals(other.ffs);
        }

        public int hashCode() {
            return this.ffs.hashCode();
        }
    }

    static final class CreationPlaceholder {
        Object value;

        CreationPlaceholder() {
        }
    }

    static abstract class Cache {
        private final Map readerCache = new WeakHashMap();

        Cache() {
        }

        protected abstract Object createValue(IndexReader var1, Object var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object get(IndexReader reader, Object key) {
            Object value;
            HashMap<Object, Object> innerCache;
            Object object = this.readerCache;
            synchronized (object) {
                innerCache = (HashMap<Object, Object>)this.readerCache.get(reader);
                if (innerCache == null) {
                    innerCache = new HashMap<Object, Object>();
                    this.readerCache.put(reader, innerCache);
                    value = null;
                } else {
                    value = innerCache.get(key);
                }
                if (value == null) {
                    value = new CreationPlaceholder();
                    innerCache.put(key, value);
                }
            }
            if (value instanceof CreationPlaceholder) {
                object = value;
                synchronized (object) {
                    CreationPlaceholder progress = (CreationPlaceholder)value;
                    if (progress.value == null) {
                        progress.value = this.createValue(reader, key);
                        Map map = this.readerCache;
                        synchronized (map) {
                            innerCache.put(key, progress.value);
                            onlyForTesting = progress.value;
                        }
                    }
                    return progress.value;
                }
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetCache() {
            Map map = this.readerCache;
            synchronized (map) {
                this.readerCache.clear();
            }
        }
    }
}

