/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.HighlightComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.util.SolrPluginUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugComponent
extends SearchComponent {
    public static final String COMPONENT_NAME = "debug";
    private Set<String> excludeSet = new HashSet<String>(Arrays.asList("explain"));

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        if (rb.isDebug()) {
            NamedList stdinfo = SolrPluginUtils.doStandardDebug(rb.req, rb.getQueryString(), rb.getQuery(), rb.getResults().docList);
            NamedList info = rb.getDebugInfo();
            if (info == null) {
                rb.setDebugInfo((NamedList<Object>)stdinfo);
                info = stdinfo;
            } else {
                info.addAll(stdinfo);
            }
            if (rb.getQparser() != null) {
                rb.getQparser().addDebugInfo(rb.getDebugInfo());
            }
            if (null != rb.getDebugInfo()) {
                if (null != rb.getFilters()) {
                    info.add("filter_queries", (Object)rb.req.getParams().getParams("fq"));
                    ArrayList<String> fqs = new ArrayList<String>(rb.getFilters().size());
                    for (Query fq : rb.getFilters()) {
                        fqs.add(QueryParsing.toString(fq, rb.req.getSchema()));
                    }
                    info.add("parsed_filter_queries", fqs);
                }
                rb.rsp.add(COMPONENT_NAME, rb.getDebugInfo());
            }
        }
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        if (!rb.isDebug()) {
            return;
        }
        if ((sreq.purpose & 0x40) != 0) {
            sreq.purpose |= 0x100;
            sreq.params.set("debugQuery", new String[]{"true"});
        } else {
            sreq.params.set("debugQuery", new String[]{"false"});
        }
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        if (rb.isDebug() && rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            int idx;
            SimpleOrderedMap info = null;
            SimpleOrderedMap explain = new SimpleOrderedMap();
            NamedList.NamedListEntry[] arr = new NamedList.NamedListEntry[rb.resultIds.size()];
            for (ShardRequest sreq : rb.finished) {
                if ((sreq.purpose & 0x100) == 0) continue;
                for (ShardResponse srsp : sreq.responses) {
                    NamedList sdebug = (NamedList)srsp.getSolrResponse().getResponse().get(COMPONENT_NAME);
                    info = (NamedList)this.merge(sdebug, info, this.excludeSet);
                    NamedList sexplain = (NamedList)sdebug.get("explain");
                    for (int i = 0; i < sexplain.size(); ++i) {
                        String id = sexplain.getName(i);
                        ShardDoc sdoc = rb.resultIds.get(id);
                        int idx2 = sdoc.positionInResponse;
                        arr[idx2] = new NamedList.NamedListEntry(id, sexplain.getVal(i));
                    }
                }
            }
            explain = HighlightComponent.removeNulls((NamedList)new SimpleOrderedMap((Map.Entry[])arr));
            if (info == null) {
                info = new SimpleOrderedMap();
            }
            if ((idx = info.indexOf("explain", 0)) >= 0) {
                info.setVal(idx, (Object)explain);
            } else {
                info.add("explain", (Object)explain);
            }
            rb.setDebugInfo((NamedList<Object>)info);
            rb.rsp.add(COMPONENT_NAME, rb.getDebugInfo());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object merge(Object source, Object dest, Set<String> exclude) {
        if (source == null) {
            return dest;
        }
        if (dest == null) {
            if (!(source instanceof NamedList)) return source;
            dest = source instanceof SimpleOrderedMap ? new SimpleOrderedMap() : new NamedList();
        } else {
            if (dest instanceof Collection) {
                if (source instanceof Collection) {
                    ((Collection)dest).addAll((Collection)source);
                    return dest;
                } else {
                    ((Collection)dest).add(source);
                }
                return dest;
            }
            if (source instanceof Number) {
                if (dest instanceof Number) {
                    if (!(source instanceof Double) && !(dest instanceof Double)) return ((Number)source).longValue() + ((Number)dest).longValue();
                    return ((Number)source).doubleValue() + ((Number)dest).doubleValue();
                }
            } else if (source instanceof String && source.equals(dest)) {
                return dest;
            }
        }
        if (source instanceof NamedList && dest instanceof NamedList) {
            NamedList tmp = new NamedList();
            NamedList sl = (NamedList)source;
            NamedList dl = (NamedList)dest;
            for (int i = 0; i < sl.size(); ++i) {
                String dkey;
                String skey = sl.getName(i);
                if (exclude != null && exclude.contains(skey)) continue;
                Object sval = sl.getVal(i);
                int didx = -1;
                if (i < dl.size() && (skey == (dkey = dl.getName(i)) || skey != null && skey.equals(dkey))) {
                    didx = i;
                }
                if (didx == -1) {
                    didx = dl.indexOf(skey, 0);
                }
                if (didx == -1) {
                    tmp.add(skey, this.merge(sval, null, null));
                    continue;
                }
                dl.setVal(didx, this.merge(sval, dl.getVal(didx), null));
            }
            dl.addAll(tmp);
            return dl;
        }
        ArrayList<Object> t = new ArrayList<Object>();
        t.add(dest);
        t.add(source);
        return t;
    }

    @Override
    public String getDescription() {
        return "Debug Information";
    }

    @Override
    public String getVersion() {
        return "$Revision: 1065312 $";
    }

    @Override
    public String getSourceId() {
        return "$Id: DebugComponent.java 1065312 2011-01-30 16:08:25Z rmuir $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_3/solr/src/java/org/apache/solr/handler/component/DebugComponent.java $";
    }

    @Override
    public URL[] getDocs() {
        return null;
    }
}

