/*
 * Copyright (C) 1995-2005, Index Data ApS
 * See the file LICENSE for details.
 *
 * $Id: read-marc.c,v 1.6 2005/01/15 19:47:16 adam Exp $
 */

/*
 * Little toy-thing to read a MARC records from a fixed array.
 */
#include <ctype.h>
#include <yaz/wrbuf.h>
#include <yaz/marcdisp.h>
#include <yaz/odr.h>

char *marc_records[] = {

  "\x30\x30\x33\x36\x36\x6E\x61\x6D\x20\x20\x32\x32\x30\x30\x31\x36"
  "\x39\x38\x61\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x31\x33\x30"
  "\x30\x30\x30\x30\x30\x30\x33\x30\x30\x30\x34\x30\x30\x30\x31\x33"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x31\x37\x30\x30\x38\x30"
  "\x30\x34\x31\x30\x30\x30\x33\x34\x30\x31\x30\x30\x30\x31\x37\x30"
  "\x30\x31\x37\x39\x30\x34\x30\x30\x30\x31\x33\x30\x30\x30\x37\x35"
  "\x30\x35\x30\x30\x30\x31\x32\x30\x30\x30\x38\x38\x31\x30\x30\x30"
  "\x30\x31\x37\x30\x30\x31\x30\x30\x32\x34\x35\x30\x30\x33\x30\x30"
  "\x30\x31\x31\x37\x32\x36\x30\x30\x30\x31\x32\x30\x30\x31\x34\x37"
  "\x32\x36\x33\x30\x30\x30\x39\x30\x30\x31\x35\x39\x33\x30\x30\x30"
  "\x30\x31\x31\x30\x30\x31\x36\x38\x1E\x20\x20\x20\x31\x31\x32\x32"
  "\x34\x34\x36\x36\x20\x1E\x44\x4C\x43\x1E\x30\x30\x30\x30\x30\x30"
  "\x30\x30\x30\x30\x30\x30\x30\x30\x2E\x30\x1E\x39\x31\x30\x37\x31"
  "\x30\x63\x31\x39\x39\x31\x30\x37\x30\x31\x6E\x6A\x75\x20\x20\x20"
  "\x20\x20\x20\x20\x20\x20\x20\x20\x30\x30\x30\x31\x30\x20\x65\x6E"
  "\x67\x20\x20\x1E\x20\x20\x1F\x61\x44\x4C\x43\x1F\x63\x44\x4C\x43"
  "\x1E\x30\x30\x1F\x61\x31\x32\x33\x2D\x78\x79\x7A\x1E\x31\x30\x1F"
  "\x61\x4A\x61\x63\x6B\x20\x43\x6F\x6C\x6C\x69\x6E\x73\x1E\x31\x30"
  "\x1F\x61\x48\x6F\x77\x20\x74\x6F\x20\x70\x72\x6F\x67\x72\x61\x6D"
  "\x20\x61\x20\x63\x6F\x6D\x70\x75\x74\x65\x72\x1E\x31\x20\x1F\x61"
  "\x50\x65\x6E\x67\x75\x69\x6E\x1E\x20\x20\x1F\x61\x38\x37\x31\x30"
  "\x1E\x20\x20\x1F\x61\x70\x2E\x20\x63\x6D\x2E\x1E\x20\x20\x1F\x61"
  "\x20\x20\x20\x31\x31\x32\x32\x34\x34\x36\x36\x20\x1E\x1D"
,
  "\x30\x30\x33\x36\x36\x6E\x61\x6D\x20\x20\x32\x32\x30\x30\x31\x36"
  "\x39\x38\x61\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x31\x33\x30"
  "\x30\x30\x30\x30\x30\x30\x33\x30\x30\x30\x34\x30\x30\x30\x31\x33"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x31\x37\x30\x30\x38\x30"
  "\x30\x34\x31\x30\x30\x30\x33\x34\x30\x31\x30\x30\x30\x31\x37\x30"
  "\x30\x31\x37\x39\x30\x34\x30\x30\x30\x31\x33\x30\x30\x30\x37\x35"
  "\x30\x35\x30\x30\x30\x31\x32\x30\x30\x30\x38\x38\x31\x30\x30\x30"
  "\x30\x31\x37\x30\x30\x31\x30\x30\x32\x34\x35\x30\x30\x33\x30\x30"
  "\x30\x31\x31\x37\x32\x36\x30\x30\x30\x31\x32\x30\x30\x31\x34\x37"
  "\x32\x36\x33\x30\x30\x30\x39\x30\x30\x31\x35\x39\x33\x30\x30\x30"
  "\x30\x31\x31\x30\x30\x31\x36\x38\x1E\x20\x20\x20\x31\x31\x32\x32"
  "\x34\x34\x36\x37\x20\x1E\x44\x4C\x43\x1E\x30\x30\x30\x30\x30\x30"
  "\x30\x30\x30\x30\x30\x30\x30\x30\x2E\x30\x1E\x39\x31\x30\x37\x31"
  "\x30\x63\x31\x39\x39\x31\x30\x37\x30\x31\x6E\x6A\x75\x20\x20\x20"
  "\x20\x20\x20\x20\x20\x20\x20\x20\x30\x30\x30\x31\x30\x20\x65\x6E"
  "\x67\x20\x20\x1E\x20\x20\x1F\x61\x44\x4C\x43\x1F\x63\x44\x4C\x43"
  "\x1E\x30\x30\x1F\x61\x31\x32\x33\x2D\x78\x79\x7A\x1E\x31\x30\x1F"
  "\x61\x4A\x61\x63\x6B\x20\x43\x6F\x6C\x6C\x69\x6E\x73\x1E\x31\x30"
  "\x1F\x61\x48\x6F\x77\x20\x74\x6F\x20\x70\x72\x6F\x67\x72\x61\x6D"
  "\x20\x61\x20\x63\x6F\x6D\x70\x75\x74\x65\x72\x1E\x31\x20\x1F\x61"
  "\x50\x65\x6E\x67\x75\x69\x6E\x1E\x20\x20\x1F\x61\x38\x37\x31\x30"
  "\x1E\x20\x20\x1F\x61\x70\x2E\x20\x63\x6D\x2E\x1E\x20\x20\x1F\x61"
  "\x20\x20\x20\x31\x31\x32\x32\x34\x34\x36\x37\x20\x1E\x1D"
,
  "\x30\x31\x33\x36\x39\x63\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x36"
  "\x35\x20\x69\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x31\x38\x30"
  "\x30\x30\x30\x30\x30\x30\x33\x30\x30\x30\x34\x30\x30\x30\x31\x38"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x32\x32\x30\x30\x38\x30"
  "\x30\x34\x31\x30\x30\x30\x33\x39\x30\x31\x30\x30\x30\x32\x32\x30"
  "\x31\x30\x38\x31\x30\x34\x30\x30\x30\x31\x38\x30\x30\x30\x38\x30"
  "\x30\x35\x30\x30\x30\x32\x32\x30\x30\x30\x39\x38\x30\x38\x32\x30"
  "\x30\x32\x31\x30\x30\x31\x32\x30\x31\x31\x31\x30\x31\x32\x31\x30"
  "\x30\x31\x34\x31\x32\x34\x35\x30\x33\x34\x37\x30\x30\x32\x36\x32"
  "\x32\x36\x30\x30\x30\x35\x34\x30\x30\x36\x30\x39\x33\x30\x30\x30"
  "\x30\x33\x30\x30\x30\x36\x36\x33\x35\x30\x34\x30\x30\x35\x31\x30"
  "\x30\x36\x39\x33\x36\x35\x30\x30\x30\x35\x36\x30\x30\x37\x34\x34"
  "\x36\x35\x30\x30\x30\x33\x39\x30\x30\x38\x30\x30\x36\x35\x30\x30"
  "\x30\x36\x32\x30\x30\x38\x33\x39\x37\x30\x30\x30\x30\x32\x33\x30"
  "\x30\x39\x30\x31\x37\x30\x30\x30\x30\x32\x30\x30\x30\x39\x32\x34"
  "\x37\x31\x30\x30\x30\x37\x31\x30\x30\x39\x34\x34\x37\x31\x30\x30"
  "\x30\x36\x36\x30\x31\x30\x31\x35\x1E\x20\x20\x20\x37\x33\x30\x39"
  "\x30\x39\x32\x34\x20\x2F\x2F\x72\x38\x32\x1E\x44\x4C\x43\x1E\x31"
  "\x39\x38\x32\x30\x35\x32\x34\x30\x30\x30\x30\x30\x30\x2E\x30\x1E"
  "\x37\x36\x30\x36\x30\x39\x73\x31\x39\x37\x34\x20\x20\x20\x20\x6E"
  "\x79\x75\x61\x20\x20\x20\x20\x20\x62\x20\x20\x20\x20\x31\x30\x31"
  "\x31\x30\x20\x65\x6E\x67\x20\x20\x1E\x20\x20\x1F\x61\x44\x4C\x43"
  "\x1F\x63\x44\x4C\x43\x1F\x64\x44\x4C\x43\x1E\x30\x30\x1F\x61\x52"
  "\x43\x37\x31\x2E\x33\x1F\x62\x2E\x57\x36\x37\x20\x31\x39\x37\x31"
  "\x1E\x30\x30\x1F\x61\x36\x31\x36\x2E\x30\x37\x2F\x35\x37\x35\x2F"
  "\x30\x32\x38\x35\x34\x1E\x32\x30\x1F\x61\x57\x6F\x72\x6B\x73\x68"
  "\x6F\x70\x20\x6F\x6E\x20\x43\x6F\x6D\x70\x75\x74\x65\x72\x20\x50"
  "\x72\x6F\x63\x65\x73\x73\x69\x6E\x67\x20\x6F\x66\x20\x44\x79\x6E"
  "\x61\x6D\x69\x63\x20\x49\x6D\x61\x67\x65\x73\x20\x66\x72\x6F\x6D"
  "\x20\x61\x6E\x20\x41\x6E\x67\x65\x72\x20\x53\x63\x69\x6E\x74\x69"
  "\x6C\x6C\x61\x74\x69\x6F\x6E\x20\x43\x61\x6D\x65\x72\x61\x2C\x1F"
  "\x63\x57\x61\x73\x68\x69\x6E\x67\x74\x6F\x6E\x20\x55\x6E\x69\x76"
  "\x65\x72\x73\x69\x74\x79\x2C\x1F\x64\x31\x39\x37\x31\x2E\x1E\x31"
  "\x30\x1F\x61\x43\x6F\x6D\x70\x75\x74\x65\x72\x20\x70\x72\x6F\x63"
  "\x65\x73\x73\x69\x6E\x67\x20\x6F\x66\x20\x64\x79\x6E\x61\x6D\x69"
  "\x63\x20\x69\x6D\x61\x67\x65\x73\x20\x66\x72\x6F\x6D\x20\x61\x6E"
  "\x20\x41\x6E\x67\x65\x72\x20\x73\x63\x69\x6E\x74\x69\x6C\x6C\x61"
  "\x74\x69\x6F\x6E\x20\x63\x61\x6D\x65\x72\x61\x20\x3A\x1F\x62\x74"
  "\x68\x65\x20\x70\x72\x6F\x63\x65\x65\x64\x69\x6E\x67\x73\x20\x6F"
  "\x66\x20\x61\x20\x77\x6F\x72\x6B\x73\x68\x6F\x70\x20\x2F\x1F\x63"
  "\x63\x6F\x73\x70\x6F\x6E\x73\x6F\x72\x65\x64\x20\x62\x79\x20\x74"
  "\x68\x65\x20\x42\x69\x6F\x6D\x65\x64\x69\x63\x61\x6C\x20\x43\x6F"
  "\x6D\x70\x75\x74\x65\x72\x20\x4C\x61\x62\x6F\x72\x61\x74\x6F\x72"
  "\x79\x20\x61\x6E\x64\x20\x74\x68\x65\x20\x4E\x75\x63\x6C\x65\x61"
  "\x72\x20\x4D\x65\x64\x69\x63\x69\x6E\x65\x20\x44\x69\x76\x69\x73"
  "\x69\x6F\x6E\x2C\x20\x44\x65\x70\x61\x72\x74\x6D\x65\x6E\x74\x20"
  "\x6F\x66\x20\x52\x61\x64\x69\x6F\x6C\x6F\x67\x79\x2C\x20\x53\x63"
  "\x68\x6F\x6F\x6C\x20\x6F\x66\x20\x4D\x65\x64\x69\x63\x69\x6E\x65"
  "\x2C\x20\x57\x61\x73\x68\x69\x6E\x67\x74\x6F\x6E\x20\x55\x6E\x69"
  "\x76\x65\x72\x73\x69\x74\x79\x2C\x20\x53\x74\x2E\x20\x4C\x6F\x75"
  "\x69\x73\x2C\x20\x4A\x61\x6E\x75\x61\x72\x79\x20\x31\x38\x2D\x32"
  "\x32\x2C\x20\x31\x39\x37\x31\x20\x3B\x20\x65\x64\x69\x74\x65\x64"
  "\x20\x62\x79\x20\x4B\x65\x6E\x6E\x65\x74\x68\x20\x42\x2E\x20\x4C"
  "\x61\x72\x73\x6F\x6E\x2C\x20\x4A\x65\x72\x6F\x6D\x65\x20\x52\x2E"
  "\x20\x43\x6F\x78\x2C\x20\x4A\x72\x2E\x1E\x30\x20\x1F\x61\x4E\x65"
  "\x77\x20\x59\x6F\x72\x6B\x20\x3A\x1F\x62\x53\x6F\x63\x69\x65\x74"
  "\x79\x20\x6F\x66\x20\x4E\x75\x63\x6C\x65\x61\x72\x20\x4D\x65\x64"
  "\x69\x63\x69\x6E\x65\x2C\x1F\x63\x5B\x63\x31\x39\x37\x34\x5D\x1E"
  "\x20\x20\x1F\x61\x78\x69\x76\x2C\x20\x70\x2E\x20\x3A\x1F\x62\x69"
  "\x6C\x6C\x2E\x20\x3B\x1F\x63\x32\x34\x20\x63\x6D\x2E\x1E\x20\x20"
  "\x1F\x61\x49\x6E\x63\x6C\x75\x64\x65\x73\x20\x62\x69\x62\x6C\x69"
  "\x6F\x67\x72\x61\x70\x68\x69\x63\x61\x6C\x20\x72\x65\x66\x65\x72"
  "\x65\x6E\x63\x65\x73\x20\x61\x6E\x64\x20\x69\x6E\x64\x65\x78\x2E"
  "\x1E\x20\x30\x1F\x61\x52\x61\x64\x69\x6F\x69\x73\x6F\x74\x6F\x70"
  "\x65\x20\x73\x63\x61\x6E\x6E\x69\x6E\x67\x1F\x78\x44\x61\x74\x61"
  "\x20\x70\x72\x6F\x63\x65\x73\x73\x69\x6E\x67\x1F\x78\x43\x6F\x6E"
  "\x67\x72\x65\x73\x73\x65\x73\x2E\x1E\x20\x30\x1F\x61\x53\x63\x69"
  "\x6E\x74\x69\x6C\x6C\x61\x74\x69\x6F\x6E\x20\x63\x61\x6D\x65\x72"
  "\x61\x73\x1F\x78\x43\x6F\x6E\x67\x72\x65\x73\x73\x65\x73\x2E\x1E"
  "\x20\x30\x1F\x61\x49\x6D\x61\x67\x69\x6E\x67\x20\x73\x79\x73\x74"
  "\x65\x6D\x73\x20\x69\x6E\x20\x6D\x65\x64\x69\x63\x69\x6E\x65\x1F"
  "\x78\x44\x61\x74\x61\x20\x70\x72\x6F\x63\x65\x73\x73\x69\x6E\x67"
  "\x1F\x78\x43\x6F\x6E\x67\x72\x65\x73\x73\x65\x73\x2E\x1E\x31\x30"
  "\x1F\x61\x4C\x61\x72\x73\x6F\x6E\x2C\x20\x4B\x65\x6E\x6E\x65\x74"
  "\x68\x20\x42\x2E\x1E\x31\x30\x1F\x61\x43\x6F\x78\x2C\x20\x4A\x65"
  "\x72\x6F\x6D\x65\x20\x52\x2E\x20\x1E\x32\x30\x1F\x61\x57\x61\x73"
  "\x68\x69\x6E\x67\x74\x6F\x6E\x20\x55\x6E\x69\x76\x65\x72\x73\x69"
  "\x74\x79\x2C\x20\x53\x74\x2E\x20\x4C\x6F\x75\x69\x73\x2E\x1F\x62"
  "\x42\x69\x6F\x6D\x65\x64\x69\x63\x61\x6C\x20\x43\x6F\x6D\x70\x75"
  "\x74\x65\x72\x20\x4C\x61\x62\x6F\x72\x61\x74\x6F\x72\x79\x2E\x1E"
  "\x32\x30\x1F\x61\x57\x61\x73\x68\x69\x6E\x67\x74\x6F\x6E\x20\x55"
  "\x6E\x69\x76\x65\x72\x73\x69\x74\x79\x2C\x20\x53\x74\x2E\x20\x4C"
  "\x6F\x75\x69\x73\x2E\x1F\x62\x4E\x75\x63\x6C\x65\x61\x72\x20\x4D"
  "\x65\x64\x69\x63\x69\x6E\x65\x20\x44\x69\x76\x69\x73\x69\x6F\x6E"
  "\x2E\x1E\x20\x20\x1F\x61\x20\x20\x20\x37\x33\x30\x39\x30\x39\x32"
  "\x34\x20\x2F\x2F\x72\x38\x32\x1E\x1D"
,
  "\x30\x30\x39\x34\x32\x63\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x35"
  "\x33\x31\x61\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x31\x39\x30"
  "\x30\x30\x30\x30\x30\x30\x33\x30\x30\x30\x34\x30\x30\x30\x31\x39"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x32\x33\x30\x30\x38\x30"
  "\x30\x34\x31\x30\x30\x30\x34\x30\x30\x31\x30\x30\x30\x32\x33\x30"
  "\x30\x36\x36\x35\x30\x34\x30\x30\x30\x31\x38\x30\x30\x30\x38\x31"
  "\x30\x34\x31\x30\x30\x31\x34\x30\x30\x30\x39\x39\x30\x35\x30\x30"
  "\x30\x31\x36\x30\x30\x31\x31\x33\x30\x38\x32\x30\x30\x31\x36\x30"
  "\x30\x31\x32\x39\x32\x34\x35\x30\x30\x37\x33\x30\x30\x31\x34\x35"
  "\x32\x36\x30\x30\x30\x37\x30\x30\x30\x32\x31\x38\x33\x30\x30\x30"
  "\x30\x35\x30\x30\x30\x32\x38\x38\x35\x30\x30\x30\x30\x34\x38\x30"
  "\x30\x33\x33\x38\x35\x30\x30\x30\x30\x39\x36\x30\x30\x33\x38\x36"
  "\x36\x33\x30\x30\x30\x33\x39\x30\x30\x34\x38\x32\x36\x33\x30\x30"
  "\x30\x33\x39\x30\x30\x35\x32\x31\x37\x30\x30\x30\x30\x33\x38\x30"
  "\x30\x35\x36\x30\x37\x30\x30\x30\x30\x33\x33\x30\x30\x35\x39\x38"
  "\x37\x31\x30\x30\x30\x33\x34\x30\x30\x36\x33\x31\x1E\x20\x20\x20"
  "\x37\x33\x32\x30\x39\x36\x32\x32\x20\x2F\x2F\x72\x38\x32\x33\x1E"
  "\x44\x4C\x43\x1E\x31\x39\x38\x32\x30\x33\x32\x35\x30\x30\x30\x30"
  "\x30\x30\x2E\x30\x1E\x37\x38\x30\x33\x30\x36\x6D\x31\x39\x30\x30"
  "\x39\x39\x39\x39\x6F\x68\x75\x20\x20\x20\x20\x20\x20\x20\x20\x20"
  "\x20\x20\x30\x30\x30\x30\x30\x20\x67\x72\x63\x20\x20\x1E\x20\x20"
  "\x1F\x61\x44\x4C\x43\x1F\x63\x44\x4C\x43\x1F\x64\x44\x4C\x43\x1E"
  "\x30\x20\x1F\x61\x67\x72\x63\x68\x65\x62\x65\x6E\x67\x1E\x30\x30"
  "\x1F\x61\x42\x53\x34\x32\x31\x1F\x62\x2E\x43\x36\x34\x1E\x30\x30"
  "\x1F\x61\x32\x32\x30\x2E\x34\x2F\x34\x1F\x32\x31\x39\x1E\x30\x34"
  "\x1F\x61\x54\x68\x65\x20\x43\x6F\x6D\x70\x75\x74\x65\x72\x20\x42"
  "\x69\x62\x6C\x65\x20\x2F\x1F\x63\x4A\x2E\x20\x41\x72\x74\x68\x75"
  "\x72\x20\x42\x61\x69\x72\x64\x2C\x20\x44\x61\x76\x69\x64\x20\x4E"
  "\x6F\x65\x6C\x20\x46\x72\x65\x65\x64\x6D\x61\x6E\x2C\x20\x65\x64"
  "\x69\x74\x6F\x72\x73\x2E\x1E\x30\x20\x1F\x61\x5B\x57\x6F\x6F\x73"
  "\x74\x65\x72\x2C\x20\x4F\x68\x69\x6F\x5D\x20\x3A\x1F\x62\x42\x69"
  "\x62\x6C\x69\x63\x61\x6C\x20\x52\x65\x73\x65\x61\x72\x63\x68\x20"
  "\x41\x73\x73\x6F\x63\x69\x61\x74\x65\x73\x2C\x1F\x63\x3C\x31\x39"
  "\x37\x33\x2D\x63\x31\x39\x38\x30\x20\x20\x20\x3E\x1E\x20\x20\x1F"
  "\x61\x76\x2E\x20\x3C\x32\x2D\x34\x2C\x20\x37\x2D\x31\x30\x2C\x20"
  "\x31\x33\x2C\x20\x31\x35\x2D\x31\x38\x2C\x20\x32\x30\x2D\x32\x34"
  "\x20\x20\x20\x3E\x20\x3B\x1F\x63\x32\x38\x20\x63\x6D\x2E\x1E\x20"
  "\x20\x1F\x61\x48\x65\x62\x72\x65\x77\x20\x61\x6E\x64\x20\x47\x72"
  "\x65\x65\x6B\x3B\x20\x69\x6E\x74\x72\x6F\x64\x75\x63\x74\x69\x6F"
  "\x6E\x73\x20\x69\x6E\x20\x45\x6E\x67\x6C\x69\x73\x68\x2E\x1E\x20"
  "\x20\x1F\x61\x56\x6F\x6C\x73\x2E\x20\x32\x2C\x20\x38\x3A\x20\x4D"
  "\x69\x73\x73\x6F\x75\x6C\x61\x2C\x20\x4D\x6F\x6E\x74\x2E\x20\x3A"
  "\x20\x50\x75\x62\x6C\x69\x73\x68\x65\x64\x20\x62\x79\x20\x53\x63"
  "\x68\x6F\x6C\x61\x72\x73\x20\x50\x72\x65\x73\x73\x20\x66\x6F\x72"
  "\x20\x42\x69\x62\x6C\x69\x63\x61\x6C\x20\x52\x65\x73\x65\x61\x72"
  "\x63\x68\x20\x41\x73\x73\x6F\x63\x69\x61\x74\x65\x73\x2E\x1E\x20"
  "\x30\x1F\x61\x42\x69\x62\x6C\x65\x2E\x20\x4F\x2E\x54\x2E\x1F\x78"
  "\x43\x6F\x6E\x63\x6F\x72\x64\x61\x6E\x63\x65\x73\x2C\x20\x48\x65"
  "\x62\x72\x65\x77\x2E\x1E\x30\x30\x1F\x61\x42\x69\x62\x6C\x65\x2E"
  "\x1F\x70\x4E\x2E\x54\x2E\x1F\x78\x43\x6F\x6E\x63\x6F\x72\x64\x61"
  "\x6E\x63\x65\x73\x2C\x20\x47\x72\x65\x65\x6B\x2E\x1E\x31\x30\x1F"
  "\x61\x42\x61\x69\x72\x64\x2C\x20\x4A\x2E\x20\x41\x72\x74\x68\x75"
  "\x72\x1F\x71\x28\x4A\x6F\x73\x65\x70\x68\x20\x41\x72\x74\x68\x75"
  "\x72\x29\x1E\x31\x30\x1F\x61\x46\x72\x65\x65\x64\x6D\x61\x6E\x2C"
  "\x20\x44\x61\x76\x69\x64\x20\x4E\x6F\x65\x6C\x2C\x1F\x64\x31\x39"
  "\x32\x32\x2D\x1E\x32\x30\x1F\x61\x42\x69\x62\x6C\x69\x63\x61\x6C"
  "\x20\x52\x65\x73\x65\x61\x72\x63\x68\x20\x41\x73\x73\x6F\x63\x69"
  "\x61\x74\x65\x73\x2E\x1E\x20\x20\x1F\x61\x20\x20\x20\x37\x33\x32"
  "\x30\x39\x36\x32\x32\x20\x2F\x2F\x72\x38\x32\x33\x1E\x1D"
,
  "\x30\x31\x30\x33\x33\x63\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x35"
  "\x33\x20\x69\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x32\x31\x30"
  "\x30\x30\x30\x30\x30\x30\x33\x30\x30\x30\x34\x30\x30\x30\x32\x31"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x32\x35\x30\x30\x38\x30"
  "\x30\x34\x31\x30\x30\x30\x34\x32\x30\x31\x30\x30\x30\x32\x35\x30"
  "\x30\x37\x35\x34\x30\x34\x30\x30\x30\x31\x38\x30\x30\x30\x38\x33"
  "\x30\x34\x33\x30\x30\x31\x32\x30\x30\x31\x30\x31\x30\x35\x30\x30"
  "\x30\x32\x32\x30\x30\x31\x31\x33\x31\x30\x30\x30\x30\x31\x39\x30"
  "\x30\x31\x33\x35\x32\x34\x35\x30\x31\x30\x35\x30\x30\x31\x35\x34"
  "\x32\x36\x30\x30\x30\x37\x33\x30\x30\x32\x35\x39\x33\x30\x30\x30"
  "\x30\x33\x38\x30\x30\x33\x33\x32\x34\x39\x30\x30\x30\x36\x38\x30"
  "\x30\x33\x37\x30\x35\x30\x30\x30\x30\x33\x35\x30\x30\x34\x33\x38"
  "\x35\x30\x34\x30\x30\x32\x34\x30\x30\x34\x37\x33\x36\x35\x30\x30"
  "\x30\x33\x34\x30\x30\x34\x39\x37\x36\x35\x31\x30\x30\x34\x36\x30"
  "\x30\x35\x33\x31\x37\x30\x30\x30\x30\x33\x39\x30\x30\x35\x37\x37"
  "\x38\x31\x30\x30\x31\x33\x38\x30\x30\x36\x31\x36\x1E\x20\x20\x20"
  "\x37\x36\x33\x35\x37\x38\x39\x35\x20\x2F\x4D\x41\x50\x2F\x72\x38"
  "\x32\x1E\x44\x4C\x43\x1E\x31\x39\x38\x32\x30\x38\x30\x36\x30\x30"
  "\x30\x30\x30\x30\x2E\x30\x1E\x37\x36\x30\x34\x30\x37\x73\x31\x39"
  "\x37\x34\x20\x20\x20\x20\x77\x61\x75\x61\x20\x20\x20\x20\x20\x62"
  "\x20\x20\x20\x20\x30\x30\x30\x31\x30\x20\x65\x6E\x67\x20\x20\x1E"
  "\x20\x20\x1F\x61\x44\x4C\x43\x1F\x63\x44\x4C\x43\x1F\x64\x44\x4C"
  "\x43\x1E\x20\x20\x1F\x61\x6E\x2D\x75\x73\x2D\x77\x61\x1E\x30\x30"
  "\x1F\x61\x47\x31\x34\x36\x37\x2E\x50\x38\x1F\x62\x4D\x33\x20\x31"
  "\x39\x37\x34\x1E\x31\x30\x1F\x61\x4D\x61\x69\x72\x73\x2C\x20\x4A"
  "\x6F\x68\x6E\x20\x57\x2E\x1E\x31\x34\x1F\x61\x54\x68\x65\x20\x50"
  "\x75\x67\x65\x74\x20\x53\x6F\x75\x6E\x64\x20\x52\x65\x67\x69\x6F"
  "\x6E\x20\x3A\x1F\x62\x61\x20\x70\x6F\x72\x74\x66\x6F\x6C\x69\x6F"
  "\x20\x6F\x66\x20\x74\x68\x65\x6D\x61\x74\x69\x63\x20\x63\x6F\x6D"
  "\x70\x75\x74\x65\x72\x20\x6D\x61\x70\x73\x20\x2F\x1F\x63\x4A\x6F"
  "\x68\x6E\x20\x57\x2E\x20\x4D\x61\x69\x72\x73\x2C\x20\x45\x75\x67"
  "\x65\x6E\x65\x20\x41\x2E\x20\x48\x6F\x65\x72\x61\x75\x66\x2E\x1E"
  "\x30\x20\x1F\x61\x5B\x42\x65\x6C\x6C\x69\x6E\x67\x68\x61\x6D\x2C"
  "\x20\x57\x61\x73\x68\x2E\x5D\x20\x3A\x1F\x62\x43\x65\x6E\x74\x65"
  "\x72\x20\x66\x6F\x72\x20\x50\x61\x63\x69\x66\x69\x63\x20\x4E\x6F"
  "\x72\x74\x68\x77\x65\x73\x74\x20\x53\x74\x75\x64\x69\x65\x73\x2C"
  "\x1F\x63\x63\x31\x39\x37\x34\x2E\x1E\x20\x20\x1F\x61\x69\x69\x69"
  "\x2C\x20\x34\x31\x20\x70\x2E\x20\x3A\x1F\x62\x69\x6C\x6C\x2E\x20"
  "\x3B\x1F\x63\x32\x35\x20\x78\x20\x33\x36\x20\x63\x6D\x2E\x1E\x31"
  "\x20\x1F\x61\x4F\x63\x63\x61\x73\x69\x6F\x6E\x61\x6C\x20\x70\x61"
  "\x70\x65\x72\x20\x2D\x20\x43\x65\x6E\x74\x65\x72\x20\x66\x6F\x72"
  "\x20\x50\x61\x63\x69\x66\x69\x63\x20\x4E\x6F\x72\x74\x68\x77\x65"
  "\x73\x74\x20\x53\x74\x75\x64\x69\x65\x73\x20\x3B\x20\x6E\x6F\x2E"
  "\x20\x33\x1E\x20\x20\x1F\x61\x53\x63\x61\x6C\x65\x20\x6F\x66\x20"
  "\x6D\x61\x70\x73\x20\x63\x61\x2E\x20\x31\x3A\x31\x2C\x30\x30\x30"
  "\x2C\x30\x30\x30\x2E\x1E\x20\x20\x1F\x61\x42\x69\x62\x6C\x69\x6F"
  "\x67\x72\x61\x70\x68\x79\x3A\x20\x70\x2E\x20\x34\x2E\x1E\x20\x30"
  "\x1F\x61\x43\x61\x72\x74\x6F\x67\x72\x61\x70\x68\x79\x1F\x78\x44"
  "\x61\x74\x61\x20\x70\x72\x6F\x63\x65\x73\x73\x69\x6E\x67\x2E\x1E"
  "\x20\x30\x1F\x61\x50\x75\x67\x65\x74\x20\x53\x6F\x75\x6E\x64\x20"
  "\x72\x65\x67\x69\x6F\x6E\x20\x28\x57\x61\x73\x68\x2E\x29\x1F\x78"
  "\x43\x65\x6E\x73\x75\x73\x1F\x78\x4D\x61\x70\x73\x2E\x1E\x31\x30"
  "\x1F\x61\x48\x6F\x65\x72\x61\x75\x66\x2C\x20\x45\x75\x67\x65\x6E"
  "\x65\x20\x41\x2E\x2C\x1F\x65\x6A\x6F\x69\x6E\x74\x20\x61\x75\x74"
  "\x68\x6F\x72\x2E\x1E\x31\x20\x1F\x61\x57\x61\x73\x68\x69\x6E\x67"
  "\x74\x6F\x6E\x20\x28\x53\x74\x61\x74\x65\x29\x2E\x1F\x62\x57\x65"
  "\x73\x74\x65\x72\x6E\x20\x57\x61\x73\x68\x69\x6E\x67\x74\x6F\x6E"
  "\x20\x53\x74\x61\x74\x65\x20\x43\x6F\x6C\x6C\x65\x67\x65\x2C\x20"
  "\x42\x65\x6C\x6C\x69\x6E\x67\x68\x61\x6D\x2E\x1F\x62\x43\x65\x6E"
  "\x74\x65\x72\x20\x66\x6F\x72\x20\x50\x61\x63\x69\x66\x69\x63\x20"
  "\x4E\x6F\x72\x74\x68\x77\x65\x73\x74\x20\x53\x74\x75\x64\x69\x65"
  "\x73\x2E\x1F\x74\x4F\x63\x63\x61\x73\x69\x6F\x6E\x61\x6C\x20\x70"
  "\x61\x70\x65\x72\x20\x3B\x1F\x76\x6E\x6F\x2E\x20\x33\x2E\x1E\x20"
  "\x20\x1F\x61\x20\x20\x20\x37\x36\x33\x35\x37\x38\x39\x35\x20\x2F"
  "\x4D\x41\x50\x2F\x72\x38\x32\x1E\x1D"
,
  "\x30\x31\x30\x30\x30\x70\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x32"
  "\x39\x20\x69\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x31\x33\x30"
  "\x30\x30\x30\x30\x30\x30\x33\x30\x30\x30\x34\x30\x30\x30\x31\x33"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x31\x37\x30\x30\x38\x30"
  "\x30\x34\x31\x30\x30\x30\x33\x34\x30\x31\x30\x30\x30\x31\x37\x30"
  "\x30\x37\x35\x33\x30\x32\x30\x30\x30\x31\x35\x30\x30\x30\x37\x35"
  "\x30\x34\x30\x30\x30\x31\x38\x30\x30\x30\x39\x30\x30\x35\x30\x30"
  "\x30\x31\x38\x30\x30\x31\x30\x38\x30\x38\x32\x30\x30\x31\x35\x30"
  "\x30\x31\x32\x36\x32\x34\x35\x30\x33\x30\x34\x30\x30\x31\x34\x31"
  "\x32\x36\x30\x30\x30\x34\x38\x30\x30\x34\x34\x35\x33\x30\x30\x30"
  "\x30\x33\x33\x30\x30\x34\x39\x33\x35\x30\x34\x30\x30\x35\x31\x30"
  "\x30\x35\x32\x36\x36\x35\x30\x30\x30\x32\x38\x30\x30\x35\x37\x37"
  "\x37\x30\x30\x30\x30\x32\x39\x30\x30\x36\x30\x35\x37\x31\x30\x30"
  "\x30\x34\x38\x30\x30\x36\x33\x34\x37\x31\x30\x30\x30\x37\x31\x30"
  "\x30\x36\x38\x32\x1E\x20\x20\x20\x37\x37\x30\x30\x30\x33\x34\x38"
  "\x20\x1E\x44\x4C\x43\x1E\x31\x39\x37\x37\x30\x37\x30\x37\x30\x30"
  "\x30\x30\x30\x30\x2E\x30\x1E\x37\x37\x30\x31\x31\x32\x73\x31\x39"
  "\x37\x37\x20\x20\x20\x20\x6D\x64\x75\x61\x20\x20\x20\x20\x20\x62"
  "\x20\x20\x20\x20\x31\x30\x31\x31\x30\x20\x65\x6E\x67\x20\x20\x1E"
  "\x20\x20\x1F\x61\x30\x38\x33\x39\x31\x30\x38\x38\x32\x36\x1E\x20"
  "\x20\x1F\x61\x44\x4C\x43\x1F\x63\x44\x4C\x43\x1F\x64\x44\x4C\x43"
  "\x1E\x30\x30\x1F\x61\x52\x43\x37\x38\x2E\x37\x2E\x54\x36\x1F\x62"
  "\x52\x34\x1E\x30\x30\x1F\x61\x36\x31\x36\x2E\x30\x37\x2F\x35\x37"
  "\x32\x1E\x30\x30\x1F\x61\x52\x65\x63\x6F\x6E\x73\x74\x72\x75\x63"
  "\x74\x69\x6F\x6E\x20\x74\x6F\x6D\x6F\x67\x72\x61\x70\x68\x79\x20"
  "\x69\x6E\x20\x64\x69\x61\x67\x6E\x6F\x73\x74\x69\x63\x20\x72\x61"
  "\x64\x69\x6F\x6C\x6F\x67\x79\x20\x61\x6E\x64\x20\x6E\x75\x63\x6C"
  "\x65\x61\x72\x20\x6D\x65\x64\x69\x63\x69\x6E\x65\x20\x3A\x1F\x62"
  "\x70\x72\x6F\x63\x65\x65\x64\x69\x6E\x67\x73\x20\x6F\x66\x20\x74"
  "\x68\x65\x20\x77\x6F\x72\x6B\x73\x68\x6F\x70\x20\x2E\x2E\x2E\x20"
  "\x2F\x1F\x63\x65\x64\x69\x74\x65\x64\x20\x62\x79\x20\x4D\x69\x63"
  "\x68\x65\x6C\x20\x4D\x2E\x20\x54\x65\x72\x2D\x50\x6F\x67\x6F\x73"
  "\x73\x69\x61\x6E\x20\x2E\x2E\x2E\x20\x5B\x65\x74\x20\x61\x6C\x2E"
  "\x5D\x20\x3B\x20\x63\x6F\x2D\x73\x70\x6F\x6E\x73\x6F\x72\x73\x2C"
  "\x20\x74\x68\x65\x20\x45\x64\x77\x61\x72\x64\x20\x4D\x61\x6C\x6C"
  "\x69\x6E\x63\x6B\x72\x6F\x64\x74\x20\x49\x6E\x73\x74\x69\x74\x75"
  "\x74\x65\x20\x6F\x66\x20\x52\x61\x64\x69\x6F\x6C\x6F\x67\x79\x20"
  "\x61\x6E\x64\x20\x42\x69\x6F\x6D\x65\x64\x69\x63\x61\x6C\x20\x43"
  "\x6F\x6D\x70\x75\x74\x65\x72\x20\x4C\x61\x62\x6F\x72\x61\x74\x6F"
  "\x72\x79\x2C\x20\x57\x61\x73\x68\x69\x6E\x67\x74\x6F\x6E\x20\x55"
  "\x6E\x69\x76\x65\x72\x73\x69\x74\x79\x20\x53\x63\x68\x6F\x6F\x6C"
  "\x20\x6F\x66\x20\x4D\x65\x64\x69\x63\x69\x6E\x65\x20\x2E\x2E\x2E"
  "\x2E\x1E\x30\x20\x1F\x61\x42\x61\x6C\x74\x69\x6D\x6F\x72\x65\x20"
  "\x3A\x1F\x62\x55\x6E\x69\x76\x65\x72\x73\x69\x74\x79\x20\x50\x61"
  "\x72\x6B\x20\x50\x72\x65\x73\x73\x2C\x1F\x63\x63\x31\x39\x37\x37"
  "\x2E\x1E\x20\x20\x1F\x61\x78\x76\x2C\x20\x35\x37\x33\x20\x70\x2E"
  "\x20\x3A\x1F\x62\x69\x6C\x6C\x2E\x20\x3B\x1F\x63\x32\x34\x20\x63"
  "\x6D\x2E\x1E\x20\x20\x1F\x61\x49\x6E\x63\x6C\x75\x64\x65\x73\x20"
  "\x62\x69\x62\x6C\x69\x6F\x67\x72\x61\x70\x68\x69\x63\x61\x6C\x20"
  "\x72\x65\x66\x65\x72\x65\x6E\x63\x65\x73\x20\x61\x6E\x64\x20\x69"
  "\x6E\x64\x65\x78\x2E\x1E\x20\x30\x1F\x61\x54\x6F\x6D\x6F\x67\x72"
  "\x61\x70\x68\x79\x1F\x78\x43\x6F\x6E\x67\x72\x65\x73\x73\x65\x73"
  "\x2E\x1E\x32\x30\x1F\x61\x54\x65\x72\x2D\x50\x6F\x67\x6F\x73\x73"
  "\x69\x61\x6E\x2C\x20\x4D\x69\x63\x68\x65\x6C\x20\x4D\x2E\x1E\x32"
  "\x30\x1F\x61\x45\x64\x77\x61\x72\x64\x20\x4D\x61\x6C\x6C\x69\x6E"
  "\x63\x6B\x72\x6F\x64\x74\x20\x49\x6E\x73\x74\x69\x74\x75\x74\x65"
  "\x20\x6F\x66\x20\x52\x61\x64\x69\x6F\x6C\x6F\x67\x79\x2E\x1E\x32"
  "\x30\x1F\x61\x57\x61\x73\x68\x69\x6E\x67\x74\x6F\x6E\x20\x55\x6E"
  "\x69\x76\x65\x72\x73\x69\x74\x79\x2C\x20\x53\x74\x2E\x20\x4C\x6F"
  "\x75\x69\x73\x2E\x1F\x62\x42\x69\x6F\x6D\x65\x64\x69\x63\x61\x6C"
  "\x20\x43\x6F\x6D\x70\x75\x74\x65\x72\x20\x4C\x61\x62\x6F\x72\x61"
  "\x74\x6F\x72\x79\x2E\x1E\x20\x20\x1F\x61\x20\x20\x20\x37\x37\x30"
  "\x30\x30\x33\x34\x38\x20\x1E\x1D"
,
  "\x30\x31\x34\x39\x33\x70\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x37"
  "\x37\x20\x69\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x31\x33\x30"
  "\x30\x30\x30\x30\x30\x30\x33\x30\x30\x30\x34\x30\x30\x30\x31\x33"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x31\x37\x30\x30\x38\x30"
  "\x30\x34\x31\x30\x30\x30\x33\x34\x30\x31\x30\x30\x30\x31\x37\x30"
  "\x31\x31\x39\x38\x30\x34\x30\x30\x30\x31\x38\x30\x30\x30\x37\x35"
  "\x30\x34\x33\x30\x30\x31\x32\x30\x30\x30\x39\x33\x30\x35\x30\x30"
  "\x30\x33\x34\x30\x30\x31\x30\x35\x30\x38\x32\x30\x30\x32\x38\x30"
  "\x30\x31\x33\x39\x30\x38\x36\x30\x30\x31\x38\x30\x30\x31\x36\x37"
  "\x31\x31\x31\x30\x30\x39\x35\x30\x30\x31\x38\x35\x32\x34\x35\x30"
  "\x34\x34\x38\x30\x30\x32\x38\x30\x32\x36\x30\x30\x31\x33\x38\x30"
  "\x30\x37\x32\x38\x33\x30\x30\x30\x30\x33\x34\x30\x30\x38\x36\x36"
  "\x34\x39\x30\x30\x30\x33\x36\x30\x30\x39\x30\x30\x36\x35\x30\x30"
  "\x30\x35\x39\x30\x30\x39\x33\x36\x37\x30\x30\x30\x30\x33\x31\x30"
  "\x30\x39\x39\x35\x37\x30\x30\x30\x30\x32\x31\x30\x31\x30\x32\x36"
  "\x37\x30\x30\x30\x30\x32\x30\x30\x31\x30\x34\x37\x37\x31\x30\x30"
  "\x30\x35\x30\x30\x31\x30\x36\x37\x38\x31\x30\x30\x30\x38\x31\x30"
  "\x31\x31\x31\x37\x1E\x20\x20\x20\x37\x37\x30\x30\x34\x37\x37\x33"
  "\x20\x1E\x44\x4C\x43\x1E\x31\x39\x37\x37\x30\x38\x32\x32\x30\x30"
  "\x30\x30\x30\x30\x2E\x30\x1E\x37\x37\x30\x33\x32\x31\x73\x31\x39"
  "\x37\x37\x20\x20\x20\x20\x64\x63\x75\x61\x20\x20\x20\x20\x20\x20"
  "\x20\x20\x20\x20\x31\x30\x30\x30\x30\x20\x65\x6E\x67\x20\x20\x1E"
  "\x20\x20\x1F\x61\x44\x4C\x43\x1F\x63\x44\x4C\x43\x1F\x64\x44\x4C"
  "\x43\x1E\x20\x20\x1F\x61\x6E\x2D\x75\x73\x2D\x2D\x2D\x1E\x30\x30"
  "\x1F\x61\x51\x43\x31\x30\x30\x1F\x62\x2E\x55\x35\x37\x20\x6E\x6F"
  "\x2E\x20\x35\x30\x30\x2D\x38\x1F\x61\x54\x41\x31\x36\x35\x30\x1E"
  "\x30\x30\x1F\x61\x36\x30\x32\x2F\x2E\x31\x20\x73\x1F\x61\x36\x32"
  "\x31\x2E\x33\x38\x31\x2E\x39\x2F\x35\x39\x38\x1E\x20\x20\x1F\x61"
  "\x43\x31\x33\x2E\x31\x30\x3A\x35\x30\x30\x2D\x38\x2E\x1E\x32\x30"
  "\x1F\x61\x57\x6F\x72\x6B\x73\x68\x6F\x70\x20\x6F\x6E\x20\x53\x74"
  "\x61\x6E\x64\x61\x72\x64\x73\x20\x66\x6F\x72\x20\x49\x6D\x61\x67"
  "\x65\x20\x50\x61\x74\x74\x65\x72\x6E\x20\x52\x65\x63\x6F\x67\x6E"
  "\x69\x74\x69\x6F\x6E\x2C\x1F\x63\x4E\x61\x74\x69\x6F\x6E\x61\x6C"
  "\x20\x42\x75\x72\x65\x61\x75\x20\x6F\x66\x20\x53\x74\x61\x6E\x64"
  "\x61\x72\x64\x73\x2C\x1F\x64\x31\x39\x37\x36\x2E\x1E\x31\x30\x1F"
  "\x61\x43\x6F\x6D\x70\x75\x74\x65\x72\x20\x73\x63\x69\x65\x6E\x63"
  "\x65\x20\x26\x20\x74\x65\x63\x68\x6E\x6F\x6C\x6F\x67\x79\x20\x3A"
  "\x1F\x62\x70\x72\x6F\x63\x65\x65\x64\x69\x6E\x67\x73\x20\x6F\x66"
  "\x20\x61\x20\x77\x6F\x72\x6B\x73\x68\x6F\x70\x20\x68\x65\x6C\x64"
  "\x20\x61\x74\x20\x74\x68\x65\x20\x4E\x61\x74\x69\x6F\x6E\x61\x6C"
  "\x20\x42\x75\x72\x65\x61\x75\x20\x6F\x66\x20\x53\x74\x61\x6E\x64"
  "\x61\x72\x64\x73\x2C\x20\x47\x61\x69\x74\x68\x65\x72\x73\x62\x75"
  "\x72\x67\x2C\x20\x4D\x44\x2C\x20\x4A\x75\x6E\x65\x20\x33\x2D\x34"
  "\x2C\x20\x31\x39\x37\x36\x20\x2F\x1F\x63\x57\x6F\x72\x6B\x73\x68"
  "\x6F\x70\x20\x6F\x6E\x20\x53\x74\x61\x6E\x64\x61\x72\x64\x73\x20"
  "\x66\x6F\x72\x20\x49\x6D\x61\x67\x65\x20\x50\x61\x74\x74\x65\x72"
  "\x6E\x20\x52\x65\x63\x6F\x67\x6E\x69\x74\x69\x6F\x6E\x20\x3B\x20"
  "\x4A\x6F\x68\x6E\x20\x4D\x2E\x20\x45\x76\x61\x6E\x73\x2C\x20\x4A"
  "\x72\x2E\x2C\x20\x52\x75\x73\x73\x65\x6C\x6C\x20\x4B\x69\x72\x73"
  "\x63\x68\x2C\x20\x61\x6E\x64\x20\x52\x6F\x67\x65\x72\x20\x4E\x2E"
  "\x20\x4E\x61\x67\x65\x6C\x2C\x20\x65\x64\x69\x74\x6F\x72\x5B\x73"
  "\x5D\x20\x3B\x20\x73\x70\x6F\x6E\x73\x6F\x72\x65\x64\x20\x62\x79"
  "\x20\x4E\x61\x74\x69\x6F\x6E\x61\x6C\x20\x42\x75\x72\x65\x61\x75"
  "\x20\x6F\x66\x20\x53\x74\x61\x6E\x64\x61\x72\x64\x73\x2C\x20\x45"
  "\x6C\x65\x63\x74\x72\x6F\x6E\x69\x63\x20\x49\x6E\x64\x75\x73\x74"
  "\x72\x69\x65\x73\x20\x41\x73\x73\x6F\x63\x69\x61\x74\x69\x6F\x6E"
  "\x2C\x20\x49\x6E\x73\x74\x69\x74\x75\x74\x65\x20\x6F\x66\x20\x45"
  "\x6C\x65\x63\x74\x72\x69\x63\x61\x6C\x20\x61\x6E\x64\x20\x45\x6C"
  "\x65\x63\x74\x72\x6F\x6E\x69\x63\x20\x45\x6E\x67\x69\x6E\x65\x65"
  "\x72\x73\x2C\x20\x69\x6E\x20\x63\x6F\x6F\x70\x65\x72\x61\x74\x69"
  "\x6F\x6E\x20\x77\x69\x74\x68\x20\x41\x73\x73\x6F\x63\x69\x61\x74"
  "\x69\x6F\x6E\x20\x66\x6F\x72\x20\x43\x6F\x6D\x70\x75\x74\x69\x6E"
  "\x67\x20\x4D\x61\x63\x68\x69\x6E\x65\x72\x79\x2E\x1E\x30\x20\x1F"
  "\x61\x5B\x57\x61\x73\x68\x69\x6E\x67\x74\x6F\x6E\x5D\x20\x3A\x1F"
  "\x62\x55\x2E\x53\x2E\x20\x44\x65\x70\x74\x2E\x20\x6F\x66\x20\x43"
  "\x6F\x6D\x6D\x65\x72\x63\x65\x2C\x20\x4E\x61\x74\x69\x6F\x6E\x61"
  "\x6C\x20\x42\x75\x72\x65\x61\x75\x20\x6F\x66\x20\x53\x74\x61\x6E"
  "\x64\x61\x72\x64\x73\x20\x3A\x20\x66\x6F\x72\x20\x73\x61\x6C\x65"
  "\x20\x62\x79\x20\x74\x68\x65\x20\x53\x75\x70\x74\x2E\x20\x6F\x66"
  "\x20\x44\x6F\x63\x73\x2E\x2C\x20\x55\x2E\x53\x2E\x20\x47\x6F\x76"
  "\x74\x2E\x20\x50\x72\x69\x6E\x74\x2E\x20\x4F\x66\x66\x2E\x2C\x1F"
  "\x63\x31\x39\x37\x37\x2E\x1E\x20\x20\x1F\x61\x76\x69\x69\x2C\x20"
  "\x31\x31\x32\x20\x70\x2E\x20\x3A\x1F\x62\x69\x6C\x6C\x2E\x20\x3B"
  "\x1F\x63\x32\x36\x20\x63\x6D\x2E\x1E\x31\x20\x1F\x61\x4E\x42\x53"
  "\x20\x73\x70\x65\x63\x69\x61\x6C\x20\x70\x75\x62\x6C\x69\x63\x61"
  "\x74\x69\x6F\x6E\x20\x3B\x20\x35\x30\x30\x2D\x38\x1E\x20\x30\x1F"
  "\x61\x4F\x70\x74\x69\x63\x61\x6C\x20\x70\x61\x74\x74\x65\x72\x6E"
  "\x20\x72\x65\x63\x6F\x67\x6E\x69\x74\x69\x6F\x6E\x1F\x78\x53\x74"
  "\x61\x6E\x64\x61\x72\x64\x73\x1F\x7A\x55\x6E\x69\x74\x65\x64\x20"
  "\x53\x74\x61\x74\x65\x73\x2E\x1E\x31\x30\x1F\x61\x45\x76\x61\x6E"
  "\x73\x2C\x20\x4A\x6F\x68\x6E\x20\x4D\x61\x72\x74\x69\x6E\x2C\x1F"
  "\x64\x31\x39\x34\x32\x2D\x1E\x31\x30\x1F\x61\x4B\x69\x72\x73\x63"
  "\x68\x2C\x20\x52\x75\x73\x73\x65\x6C\x6C\x2E\x1E\x31\x30\x1F\x61"
  "\x4E\x61\x67\x65\x6C\x2C\x20\x52\x6F\x67\x65\x72\x20\x4E\x2E\x1E"
  "\x31\x30\x1F\x61\x55\x6E\x69\x74\x65\x64\x20\x53\x74\x61\x74\x65"
  "\x73\x2E\x1F\x62\x4E\x61\x74\x69\x6F\x6E\x61\x6C\x20\x42\x75\x72"
  "\x65\x61\x75\x20\x6F\x66\x20\x53\x74\x61\x6E\x64\x61\x72\x64\x73"
  "\x2E\x1E\x31\x20\x1F\x61\x55\x6E\x69\x74\x65\x64\x20\x53\x74\x61"
  "\x74\x65\x73\x2E\x1F\x62\x4E\x61\x74\x69\x6F\x6E\x61\x6C\x20\x42"
  "\x75\x72\x65\x61\x75\x20\x6F\x66\x20\x53\x74\x61\x6E\x64\x61\x72"
  "\x64\x73\x2E\x1F\x74\x53\x70\x65\x63\x69\x61\x6C\x20\x70\x75\x62"
  "\x6C\x69\x63\x61\x74\x69\x6F\x6E\x20\x3B\x1F\x76\x35\x30\x30\x2D"
  "\x38\x2E\x1E\x20\x20\x1F\x61\x20\x20\x20\x37\x37\x30\x30\x34\x37"
  "\x37\x33\x20\x1E\x1D"
,
  "\x30\x30\x38\x37\x38\x63\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x32"
  "\x39\x20\x69\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x31\x33\x30"
  "\x30\x30\x30\x30\x30\x30\x33\x30\x30\x30\x34\x30\x30\x30\x31\x33"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x31\x37\x30\x30\x38\x30"
  "\x30\x34\x31\x30\x30\x30\x33\x34\x30\x31\x30\x30\x30\x31\x37\x30"
  "\x30\x36\x33\x31\x30\x34\x30\x30\x30\x31\x38\x30\x30\x30\x37\x35"
  "\x30\x35\x30\x30\x30\x33\x38\x30\x30\x30\x39\x33\x30\x38\x32\x30"
  "\x30\x32\x32\x30\x30\x31\x33\x31\x30\x38\x36\x30\x30\x31\x37\x30"
  "\x30\x31\x35\x33\x31\x30\x30\x30\x30\x31\x39\x30\x30\x31\x37\x30"
  "\x32\x34\x35\x30\x30\x38\x37\x30\x30\x31\x38\x39\x32\x36\x30\x30"
  "\x31\x33\x38\x30\x30\x32\x37\x36\x33\x30\x30\x30\x30\x32\x34\x30"
  "\x30\x34\x31\x34\x34\x34\x30\x30\x30\x33\x34\x30\x30\x34\x33\x38"
  "\x34\x39\x30\x30\x30\x33\x36\x30\x30\x34\x37\x32\x36\x35\x30\x30"
  "\x30\x34\x32\x30\x30\x35\x30\x38\x38\x31\x30\x30\x30\x38\x31\x30"
  "\x30\x35\x35\x30\x1E\x20\x20\x20\x37\x37\x30\x30\x35\x35\x35\x38"
  "\x20\x1E\x44\x4C\x43\x1E\x31\x39\x37\x37\x30\x37\x31\x33\x30\x30"
  "\x30\x30\x30\x30\x2E\x30\x1E\x37\x37\x30\x34\x30\x31\x73\x31\x39"
  "\x37\x37\x20\x20\x20\x20\x64\x63\x75\x20\x20\x20\x20\x20\x20\x20"
  "\x20\x20\x20\x20\x30\x30\x30\x31\x30\x20\x65\x6E\x67\x20\x20\x1E"
  "\x20\x20\x1F\x61\x44\x4C\x43\x1F\x63\x44\x4C\x43\x1F\x64\x44\x4C"
  "\x43\x1E\x30\x30\x1F\x61\x51\x43\x31\x30\x30\x1F\x62\x2E\x55\x35"
  "\x37\x20\x6E\x6F\x2E\x20\x35\x30\x30\x2D\x39\x1F\x61\x51\x41\x37"
  "\x36\x2E\x39\x2E\x41\x32\x35\x1E\x30\x30\x1F\x61\x36\x30\x32\x2F"
  "\x2E\x31\x20\x73\x1F\x61\x30\x30\x31\x2E\x36\x2F\x34\x1E\x30\x20"
  "\x1F\x61\x43\x31\x33\x2E\x31\x30\x3A\x35\x30\x30\x2D\x39\x1E\x31"
  "\x30\x1F\x61\x57\x6F\x6F\x64\x2C\x20\x48\x65\x6C\x65\x6E\x20\x4D"
  "\x2E\x1E\x31\x34\x1F\x61\x54\x68\x65\x20\x75\x73\x65\x20\x6F\x66"
  "\x20\x70\x61\x73\x73\x77\x6F\x72\x64\x73\x20\x66\x6F\x72\x20\x63"
  "\x6F\x6E\x74\x72\x6F\x6C\x6C\x65\x64\x20\x61\x63\x63\x65\x73\x73"
  "\x20\x74\x6F\x20\x63\x6F\x6D\x70\x75\x74\x65\x72\x20\x72\x65\x73"
  "\x6F\x75\x72\x63\x65\x73\x20\x2F\x1F\x63\x48\x65\x6C\x65\x6E\x20"
  "\x4D\x2E\x20\x57\x6F\x6F\x64\x2E\x1E\x30\x20\x1F\x61\x5B\x57\x61"
  "\x73\x68\x69\x6E\x67\x74\x6F\x6E\x5D\x20\x3A\x1F\x62\x55\x2E\x53"
  "\x2E\x20\x44\x65\x70\x74\x2E\x20\x6F\x66\x20\x43\x6F\x6D\x6D\x65"
  "\x72\x63\x65\x2C\x20\x4E\x61\x74\x69\x6F\x6E\x61\x6C\x20\x42\x75"
  "\x72\x65\x61\x75\x20\x6F\x66\x20\x53\x74\x61\x6E\x64\x61\x72\x64"
  "\x73\x20\x3A\x20\x66\x6F\x72\x20\x73\x61\x6C\x65\x20\x62\x79\x20"
  "\x74\x68\x65\x20\x53\x75\x70\x74\x2E\x20\x6F\x66\x20\x44\x6F\x63"
  "\x73\x2E\x2C\x20\x55\x2E\x53\x2E\x20\x47\x6F\x76\x74\x2E\x20\x50"
  "\x72\x69\x6E\x74\x2E\x20\x4F\x66\x66\x2E\x2C\x1F\x63\x31\x39\x37"
  "\x37\x2E\x1E\x20\x20\x1F\x61\x69\x76\x2C\x20\x35\x33\x20\x70\x2E"
  "\x20\x3B\x1F\x63\x32\x36\x20\x63\x6D\x2E\x1E\x20\x30\x1F\x61\x43"
  "\x6F\x6D\x70\x75\x74\x65\x72\x20\x73\x63\x69\x65\x6E\x63\x65\x20"
  "\x26\x20\x74\x65\x63\x68\x6E\x6F\x6C\x6F\x67\x79\x1E\x31\x20\x1F"
  "\x61\x4E\x42\x53\x20\x73\x70\x65\x63\x69\x61\x6C\x20\x70\x75\x62"
  "\x6C\x69\x63\x61\x74\x69\x6F\x6E\x20\x3B\x20\x35\x30\x30\x2D\x39"
  "\x1E\x20\x30\x1F\x61\x43\x6F\x6D\x70\x75\x74\x65\x72\x73\x1F\x78"
  "\x41\x63\x63\x65\x73\x73\x20\x63\x6F\x6E\x74\x72\x6F\x6C\x1F\x78"
  "\x50\x61\x73\x73\x77\x6F\x72\x64\x73\x2E\x1E\x31\x20\x1F\x61\x55"
  "\x6E\x69\x74\x65\x64\x20\x53\x74\x61\x74\x65\x73\x2E\x1F\x62\x4E"
  "\x61\x74\x69\x6F\x6E\x61\x6C\x20\x42\x75\x72\x65\x61\x75\x20\x6F"
  "\x66\x20\x53\x74\x61\x6E\x64\x61\x72\x64\x73\x2E\x1F\x74\x53\x70"
  "\x65\x63\x69\x61\x6C\x20\x70\x75\x62\x6C\x69\x63\x61\x74\x69\x6F"
  "\x6E\x20\x3B\x1F\x76\x35\x30\x30\x2D\x39\x2E\x1E\x20\x20\x1F\x61"
  "\x20\x20\x20\x37\x37\x30\x30\x35\x35\x35\x38\x20\x1E\x1D"
,
  "\x30\x30\x37\x39\x31\x63\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x31"
  "\x37\x20\x20\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x31\x38\x30"
  "\x30\x30\x30\x30\x30\x30\x33\x30\x30\x30\x34\x30\x30\x30\x31\x38"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x32\x32\x30\x30\x38\x30"
  "\x30\x34\x31\x30\x30\x30\x33\x39\x30\x31\x30\x30\x30\x32\x32\x30"
  "\x30\x35\x35\x31\x30\x34\x30\x30\x30\x31\x38\x30\x30\x30\x38\x30"
  "\x30\x34\x33\x30\x30\x33\x30\x30\x30\x30\x39\x38\x30\x35\x30\x30"
  "\x30\x31\x38\x30\x30\x31\x32\x38\x30\x38\x32\x30\x30\x31\x38\x30"
  "\x30\x31\x34\x36\x31\x30\x30\x30\x30\x32\x31\x30\x30\x31\x36\x34"
  "\x32\x34\x35\x30\x31\x36\x32\x30\x30\x31\x38\x35\x32\x36\x30\x30"
  "\x30\x32\x33\x30\x30\x33\x34\x37\x33\x30\x30\x30\x30\x32\x36\x30"
  "\x30\x33\x37\x30\x35\x30\x30\x30\x30\x32\x39\x30\x30\x33\x39\x36"
  "\x36\x35\x30\x30\x30\x36\x34\x30\x30\x34\x32\x35\x37\x31\x30\x30"
  "\x30\x36\x32\x30\x30\x34\x38\x39\x1E\x20\x20\x20\x37\x37\x36\x31"
  "\x36\x33\x36\x37\x20\x2F\x2F\x72\x38\x34\x1E\x44\x4C\x43\x1E\x31"
  "\x39\x38\x34\x31\x32\x31\x33\x30\x30\x30\x30\x30\x30\x2E\x30\x1E"
  "\x37\x32\x30\x33\x32\x39\x73\x31\x39\x37\x31\x20\x20\x20\x20\x64"
  "\x63\x75\x61\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x30\x30\x30"
  "\x31\x30\x20\x65\x6E\x67\x20\x20\x1E\x20\x20\x1F\x61\x44\x4C\x43"
  "\x1F\x63\x44\x4C\x43\x1F\x64\x44\x4C\x43\x1E\x20\x20\x1F\x61\x6E"
  "\x2D\x75\x73\x2D\x64\x63\x1F\x61\x6E\x2D\x75\x73\x2D\x6D\x64\x1F"
  "\x61\x6E\x2D\x75\x73\x2D\x76\x61\x1E\x30\x30\x1F\x61\x48\x45\x32"
  "\x37\x38\x31\x2E\x57\x33\x1F\x62\x45\x35\x1E\x30\x30\x1F\x61\x33"
  "\x38\x35\x2F\x2E\x32\x32\x2F\x30\x39\x37\x35\x33\x1E\x31\x30\x1F"
  "\x61\x45\x6E\x67\x6C\x75\x6E\x64\x2C\x20\x43\x61\x72\x6C\x20\x52"
  "\x2E\x1E\x31\x30\x1F\x61\x57\x61\x73\x68\x69\x6E\x67\x74\x6F\x6E"
  "\x20\x6D\x65\x74\x72\x6F\x70\x6F\x6C\x69\x74\x61\x6E\x20\x61\x72"
  "\x65\x61\x20\x72\x61\x69\x6C\x20\x63\x6F\x6D\x70\x75\x74\x65\x72"
  "\x20\x66\x65\x61\x73\x69\x62\x69\x6C\x69\x74\x79\x20\x73\x74\x75"
  "\x64\x79\x3B\x1F\x62\x66\x69\x6E\x61\x6C\x20\x72\x65\x70\x6F\x72"
  "\x74\x1F\x63\x5B\x62\x79\x5D\x20\x43\x61\x72\x6C\x20\x52\x2E\x20"
  "\x45\x6E\x67\x6C\x75\x6E\x64\x2C\x20\x4A\x72\x2E\x20\x50\x72\x65"
  "\x70\x61\x72\x65\x64\x20\x66\x6F\x72\x20\x55\x72\x62\x61\x6E\x20"
  "\x4D\x61\x73\x73\x20\x54\x72\x61\x6E\x73\x70\x6F\x72\x74\x61\x74"
  "\x69\x6F\x6E\x20\x41\x64\x6D\x69\x6E\x69\x73\x74\x72\x61\x74\x69"
  "\x6F\x6E\x2E\x1E\x30\x20\x1F\x61\x57\x61\x73\x68\x69\x6E\x67\x74"
  "\x6F\x6E\x2C\x1F\x63\x31\x39\x37\x31\x2E\x1E\x20\x20\x1F\x61\x39"
  "\x32\x20\x6C\x2E\x1F\x62\x69\x6C\x6C\x75\x73\x2E\x1F\x63\x32\x38"
  "\x20\x63\x6D\x2E\x1E\x20\x20\x1F\x61\x22\x43\x6F\x6E\x74\x72\x61"
  "\x63\x74\x20\x44\x4F\x54\x2D\x55\x54\x2D\x31\x30\x30\x30\x33\x2E"
  "\x22\x1E\x20\x30\x1F\x61\x52\x61\x69\x6C\x72\x6F\x61\x64\x73\x1F"
  "\x7A\x57\x61\x73\x68\x69\x6E\x67\x74\x6F\x6E\x20\x4D\x65\x74\x72"
  "\x6F\x70\x6F\x6C\x69\x74\x61\x6E\x20\x41\x72\x65\x61\x1F\x78\x43"
  "\x6F\x6D\x6D\x75\x74\x69\x6E\x67\x20\x74\x72\x61\x66\x66\x69\x63"
  "\x2E\x1E\x31\x30\x1F\x61\x55\x6E\x69\x74\x65\x64\x20\x53\x74\x61"
  "\x74\x65\x73\x2E\x1F\x62\x55\x72\x62\x61\x6E\x20\x4D\x61\x73\x73"
  "\x20\x54\x72\x61\x6E\x73\x70\x6F\x72\x74\x61\x74\x69\x6F\x6E\x20"
  "\x41\x64\x6D\x69\x6E\x69\x73\x74\x72\x61\x74\x69\x6F\x6E\x2E\x1E"
  "\x20\x20\x1F\x61\x20\x20\x20\x37\x37\x36\x31\x36\x33\x36\x37\x20"
  "\x2F\x2F\x72\x38\x34\x1E\x1D"
,
  "\x30\x30\x36\x38\x36\x63\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x32"
  "\x39\x20\x20\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x31\x38\x30"
  "\x30\x30\x30\x30\x30\x30\x33\x30\x30\x30\x34\x30\x30\x30\x31\x38"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x32\x32\x30\x30\x38\x30"
  "\x30\x34\x31\x30\x30\x30\x33\x39\x30\x31\x30\x30\x30\x32\x32\x30"
  "\x30\x34\x33\x34\x30\x34\x30\x30\x30\x31\x38\x30\x30\x30\x38\x30"
  "\x30\x34\x33\x30\x30\x31\x32\x30\x30\x30\x39\x38\x30\x35\x30\x30"
  "\x30\x32\x34\x30\x30\x31\x31\x30\x30\x38\x32\x30\x30\x31\x39\x30"
  "\x30\x31\x33\x34\x31\x31\x30\x30\x30\x37\x30\x30\x30\x31\x35\x33"
  "\x32\x34\x35\x30\x30\x35\x35\x30\x30\x32\x32\x33\x32\x35\x30\x30"
  "\x30\x30\x39\x30\x30\x32\x37\x38\x32\x36\x30\x30\x30\x32\x31\x30"
  "\x30\x32\x38\x37\x33\x30\x30\x30\x30\x31\x38\x30\x30\x33\x30\x38"
  "\x35\x30\x30\x30\x30\x31\x37\x30\x30\x33\x32\x36\x36\x35\x30\x30"
  "\x30\x34\x38\x30\x30\x33\x34\x33\x36\x35\x30\x30\x30\x34\x33\x30"
  "\x30\x33\x39\x31\x1E\x20\x20\x20\x37\x37\x36\x33\x37\x30\x37\x35"
  "\x20\x2F\x2F\x72\x38\x32\x1E\x44\x4C\x43\x1E\x31\x39\x38\x32\x30"
  "\x38\x31\x37\x30\x30\x30\x30\x30\x30\x2E\x30\x1E\x37\x32\x30\x33"
  "\x32\x30\x73\x31\x39\x37\x31\x20\x20\x20\x20\x77\x61\x75\x20\x20"
  "\x20\x20\x20\x20\x73\x20\x20\x20\x20\x30\x30\x30\x30\x30\x20\x65"
  "\x6E\x67\x20\x20\x1E\x20\x20\x1F\x61\x44\x4C\x43\x1F\x63\x44\x4C"
  "\x43\x1F\x64\x44\x4C\x43\x1E\x20\x20\x1F\x61\x6E\x2D\x75\x73\x2D"
  "\x77\x61\x1E\x30\x30\x1F\x61\x4C\x42\x31\x30\x32\x38\x2E\x35\x1F"
  "\x62\x2E\x57\x33\x37\x20\x31\x39\x37\x31\x1E\x30\x30\x1F\x61\x33"
  "\x37\x38\x2F\x2E\x30\x35\x32\x2F\x30\x39\x37\x39\x37\x1E\x31\x30"
  "\x1F\x61\x57\x61\x73\x68\x69\x6E\x67\x74\x6F\x6E\x20\x28\x53\x74"
  "\x61\x74\x65\x29\x2E\x1F\x62\x53\x74\x61\x74\x65\x20\x42\x6F\x61"
  "\x72\x64\x20\x66\x6F\x72\x20\x43\x6F\x6D\x6D\x75\x6E\x69\x74\x79"
  "\x20\x43\x6F\x6C\x6C\x65\x67\x65\x20\x45\x64\x75\x63\x61\x74\x69"
  "\x6F\x6E\x2E\x1E\x31\x32\x1F\x61\x41\x20\x70\x6C\x61\x6E\x20\x66"
  "\x6F\x72\x20\x63\x6F\x6D\x6D\x75\x6E\x69\x74\x79\x20\x63\x6F\x6C"
  "\x6C\x65\x67\x65\x20\x63\x6F\x6D\x70\x75\x74\x65\x72\x20\x64\x65"
  "\x76\x65\x6C\x6F\x70\x6D\x65\x6E\x74\x2E\x1E\x20\x20\x1F\x61\x52"
  "\x65\x76\x2E\x1E\x31\x20\x1F\x61\x5B\x4F\x6C\x79\x6D\x70\x69\x61"
  "\x5D\x1F\x63\x31\x39\x37\x31\x2E\x1E\x20\x20\x1F\x61\x34\x37\x20"
  "\x6C\x2E\x1F\x63\x32\x38\x20\x63\x6D\x2E\x1E\x20\x20\x1F\x61\x43"
  "\x6F\x76\x65\x72\x20\x74\x69\x74\x6C\x65\x2E\x1E\x20\x30\x1F\x61"
  "\x55\x6E\x69\x76\x65\x72\x73\x69\x74\x69\x65\x73\x20\x61\x6E\x64"
  "\x20\x63\x6F\x6C\x6C\x65\x67\x65\x73\x1F\x78\x44\x61\x74\x61\x20"
  "\x70\x72\x6F\x63\x65\x73\x73\x69\x6E\x67\x2E\x1E\x20\x30\x1F\x61"
  "\x43\x6F\x6D\x6D\x75\x6E\x69\x74\x79\x20\x63\x6F\x6C\x6C\x65\x67"
  "\x65\x73\x1F\x7A\x57\x61\x73\x68\x69\x6E\x67\x74\x6F\x6E\x20\x28"
  "\x53\x74\x61\x74\x65\x29\x1E\x20\x20\x1F\x61\x20\x20\x20\x37\x37"
  "\x36\x33\x37\x30\x37\x35\x20\x2F\x2F\x72\x38\x32\x1E\x1D"
,
  "\x30\x30\x36\x36\x38\x6E\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x31"
  "\x37\x31\x20\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x31\x33\x30"
  "\x30\x30\x30\x30\x30\x30\x33\x30\x30\x30\x34\x30\x30\x30\x31\x33"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x31\x37\x30\x30\x38\x30"
  "\x30\x34\x31\x30\x30\x30\x33\x34\x30\x31\x30\x30\x30\x31\x37\x30"
  "\x30\x34\x33\x33\x30\x34\x30\x30\x30\x31\x38\x30\x30\x30\x37\x35"
  "\x30\x35\x30\x30\x30\x31\x38\x30\x30\x30\x39\x33\x30\x38\x32\x30"
  "\x30\x31\x36\x30\x30\x31\x31\x31\x31\x30\x30\x30\x30\x31\x39\x30"
  "\x30\x31\x32\x37\x32\x34\x35\x30\x30\x37\x36\x30\x30\x31\x34\x36"
  "\x32\x36\x30\x30\x30\x34\x30\x30\x30\x32\x32\x32\x33\x30\x30\x30"
  "\x30\x34\x30\x30\x30\x32\x36\x32\x33\x35\x30\x30\x30\x30\x39\x30"
  "\x30\x33\x30\x32\x34\x39\x30\x30\x30\x33\x32\x30\x30\x33\x31\x31"
  "\x35\x30\x34\x30\x30\x33\x30\x30\x30\x33\x34\x33\x36\x33\x30\x30"
  "\x30\x36\x30\x30\x30\x33\x37\x33\x1E\x20\x20\x20\x37\x30\x30\x30"
  "\x31\x30\x37\x30\x20\x1E\x44\x4C\x43\x1E\x31\x39\x37\x30\x30\x34"
  "\x32\x37\x30\x30\x30\x30\x30\x30\x2E\x30\x1E\x37\x30\x30\x33\x30"
  "\x32\x73\x31\x39\x36\x38\x20\x20\x20\x20\x6D\x6F\x75\x61\x62\x20"
  "\x20\x20\x20\x62\x20\x20\x20\x20\x30\x30\x30\x30\x30\x20\x65\x6E"
  "\x67\x20\x20\x1E\x20\x20\x1F\x61\x44\x4C\x43\x1F\x63\x44\x4C\x43"
  "\x1F\x64\x44\x4C\x43\x1E\x30\x30\x1F\x61\x42\x53\x31\x32\x37\x35"
  "\x2E\x35\x1F\x62\x2E\x4F\x32\x1E\x30\x30\x1F\x61\x32\x32\x32\x2F"
  "\x2E\x31\x35\x2F\x30\x30\x37\x1E\x31\x30\x1F\x61\x4F\x62\x65\x72"
  "\x73\x74\x2C\x20\x42\x72\x75\x63\x65\x2E\x1E\x30\x30\x1F\x61\x44"
  "\x65\x75\x74\x65\x72\x6F\x6E\x6F\x6D\x79\x2E\x1F\x63\x54\x68\x6F"
  "\x75\x67\x68\x74\x20\x71\x75\x65\x73\x74\x69\x6F\x6E\x73\x2C\x20"
  "\x62\x79\x20\x44\x6F\x6E\x20\x44\x65\x57\x65\x6C\x74\x2E\x20\x53"
  "\x75\x6D\x6D\x61\x72\x79\x20\x62\x79\x20\x41\x64\x61\x6D\x20\x43"
  "\x6C\x61\x72\x6B\x65\x2E\x1E\x30\x20\x1F\x61\x4A\x6F\x70\x6C\x69"
  "\x6E\x2C\x20\x4D\x6F\x2E\x2C\x1F\x62\x43\x6F\x6C\x6C\x65\x67\x65"
  "\x20\x50\x72\x65\x73\x73\x1F\x63\x5B\x31\x39\x36\x38\x5D\x1E\x20"
  "\x20\x1F\x61\x76\x69\x69\x69\x2C\x20\x34\x35\x32\x20\x70\x2E\x1F"
  "\x62\x69\x6C\x6C\x75\x73\x2E\x2C\x20\x6D\x61\x70\x73\x2E\x1F\x63"
  "\x32\x32\x20\x63\x6D\x2E\x1E\x20\x20\x1F\x61\x35\x2E\x39\x35\x1E"
  "\x30\x20\x1F\x61\x42\x69\x62\x6C\x65\x20\x73\x74\x75\x64\x79\x20"
  "\x74\x65\x78\x74\x62\x6F\x6F\x6B\x20\x73\x65\x72\x69\x65\x73\x1E"
  "\x20\x20\x1F\x61\x42\x69\x62\x6C\x69\x6F\x67\x72\x61\x70\x68\x79"
  "\x3A\x20\x70\x2E\x20\x34\x34\x39\x2D\x34\x35\x32\x2E\x1E\x20\x30"
  "\x1F\x61\x42\x69\x62\x6C\x65\x2E\x20\x4F\x2E\x54\x2E\x20\x44\x65"
  "\x75\x74\x65\x72\x6F\x6E\x6F\x6D\x79\x1F\x78\x53\x74\x75\x64\x79"
  "\x1F\x78\x4F\x75\x74\x6C\x69\x6E\x65\x73\x2C\x20\x73\x79\x6C\x6C"
  "\x61\x62\x69\x2C\x20\x65\x74\x63\x2E\x1E\x20\x20\x1F\x61\x20\x20"
  "\x20\x37\x30\x30\x30\x31\x30\x37\x30\x20\x1E\x1D"
,
  "\x30\x30\x38\x38\x38\x70\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x36"
  "\x35\x20\x20\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x31\x33\x30"
  "\x30\x30\x30\x30\x30\x30\x33\x30\x30\x30\x34\x30\x30\x30\x31\x33"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x31\x37\x30\x30\x38\x30"
  "\x30\x34\x31\x30\x30\x30\x33\x34\x30\x31\x30\x30\x30\x31\x37\x30"
  "\x30\x36\x30\x35\x30\x32\x30\x30\x30\x31\x35\x30\x30\x30\x37\x35"
  "\x30\x34\x30\x30\x30\x31\x38\x30\x30\x30\x39\x30\x30\x34\x33\x30"
  "\x30\x31\x32\x30\x30\x31\x30\x38\x30\x35\x30\x30\x30\x32\x30\x30"
  "\x30\x31\x32\x30\x30\x38\x32\x30\x30\x31\x32\x30\x30\x31\x34\x30"
  "\x31\x30\x30\x30\x30\x32\x39\x30\x30\x31\x35\x32\x32\x34\x35\x30"
  "\x30\x39\x33\x30\x30\x31\x38\x31\x32\x36\x30\x30\x30\x35\x35\x30"
  "\x30\x32\x37\x34\x33\x30\x30\x30\x30\x32\x38\x30\x30\x33\x32\x39"
  "\x35\x30\x30\x30\x30\x38\x31\x30\x30\x33\x35\x37\x35\x30\x34\x30"
  "\x30\x34\x31\x30\x30\x34\x33\x38\x36\x35\x30\x30\x30\x34\x35\x30"
  "\x30\x34\x37\x39\x36\x35\x30\x30\x30\x32\x35\x30\x30\x35\x32\x34"
  "\x36\x35\x31\x30\x30\x32\x32\x30\x30\x35\x34\x39\x38\x33\x30\x30"
  "\x30\x33\x34\x30\x30\x35\x37\x31\x1E\x20\x20\x20\x37\x32\x30\x30"
  "\x32\x35\x36\x35\x20\x1E\x44\x4C\x43\x1E\x31\x39\x37\x33\x30\x34"
  "\x30\x39\x30\x30\x30\x30\x30\x30\x2E\x30\x1E\x37\x32\x30\x34\x31"
  "\x38\x72\x31\x39\x37\x32\x31\x39\x30\x39\x6E\x79\x75\x20\x20\x20"
  "\x20\x20\x20\x62\x20\x20\x20\x20\x30\x30\x30\x30\x30\x20\x65\x6E"
  "\x67\x20\x20\x1E\x20\x20\x1F\x61\x30\x38\x33\x36\x39\x36\x38\x34"
  "\x33\x33\x1E\x20\x20\x1F\x61\x44\x4C\x43\x1F\x63\x44\x4C\x43\x1F"
  "\x64\x44\x4C\x43\x1E\x20\x20\x1F\x61\x65\x2D\x67\x72\x2D\x2D\x2D"
  "\x1E\x30\x30\x1F\x61\x42\x4C\x37\x38\x35\x1F\x62\x2E\x41\x33\x20"
  "\x31\x39\x37\x32\x1E\x30\x30\x1F\x61\x32\x39\x32\x2F\x2E\x30\x38"
  "\x1E\x31\x30\x1F\x61\x41\x64\x61\x6D\x2C\x20\x4A\x61\x6D\x65\x73"
  "\x2C\x1F\x64\x31\x38\x36\x30\x2D\x31\x39\x30\x37\x2E\x1E\x31\x34"
  "\x1F\x61\x54\x68\x65\x20\x72\x65\x6C\x69\x67\x69\x6F\x75\x73\x20"
  "\x74\x65\x61\x63\x68\x65\x72\x73\x20\x6F\x66\x20\x47\x72\x65\x65"
  "\x63\x65\x2E\x1F\x63\x45\x64\x69\x74\x65\x64\x20\x77\x69\x74\x68"
  "\x20\x61\x20\x6D\x65\x6D\x6F\x69\x72\x2C\x20\x62\x79\x20\x68\x69"
  "\x73\x20\x77\x69\x66\x65\x2C\x20\x41\x64\x65\x6C\x61\x20\x4D\x61"
  "\x72\x69\x6F\x6E\x20\x41\x64\x61\x6D\x2E\x1E\x30\x20\x1F\x61\x46"
  "\x72\x65\x65\x70\x6F\x72\x74\x2C\x20\x4E\x2E\x59\x2E\x2C\x1F\x62"
  "\x42\x6F\x6F\x6B\x73\x20\x66\x6F\x72\x20\x4C\x69\x62\x72\x61\x72"
  "\x69\x65\x73\x20\x50\x72\x65\x73\x73\x1F\x63\x5B\x31\x39\x37\x32"
  "\x5D\x1E\x20\x20\x1F\x61\x78\x69\x78\x2C\x20\x6C\x76\x2C\x20\x34"
  "\x36\x37\x20\x70\x2E\x1F\x63\x32\x32\x20\x63\x6D\x2E\x1E\x20\x20"
  "\x1F\x61\x52\x65\x70\x72\x69\x6E\x74\x20\x6F\x66\x20\x74\x68\x65"
  "\x20\x31\x39\x30\x39\x20\x65\x64\x2E\x2C\x20\x77\x68\x69\x63\x68"
  "\x20\x77\x61\x73\x20\x69\x73\x73\x75\x65\x64\x20\x61\x73\x20\x74"
  "\x68\x65\x20\x31\x39\x30\x34\x2D\x31\x39\x30\x36\x20\x47\x69\x66"
  "\x66\x6F\x72\x64\x20\x6C\x65\x63\x74\x75\x72\x65\x73\x2E\x1E\x20"
  "\x20\x1F\x61\x49\x6E\x63\x6C\x75\x64\x65\x73\x20\x62\x69\x62\x6C"
  "\x69\x6F\x67\x72\x61\x70\x68\x69\x63\x61\x6C\x20\x72\x65\x66\x65"
  "\x72\x65\x6E\x63\x65\x73\x2E\x1E\x20\x30\x1F\x61\x47\x72\x65\x65"
  "\x6B\x20\x6C\x69\x74\x65\x72\x61\x74\x75\x72\x65\x1F\x78\x48\x69"
  "\x73\x74\x6F\x72\x79\x20\x61\x6E\x64\x20\x63\x72\x69\x74\x69\x63"
  "\x69\x73\x6D\x2E\x1E\x20\x30\x1F\x61\x50\x68\x69\x6C\x6F\x73\x6F"
  "\x70\x68\x79\x2C\x20\x41\x6E\x63\x69\x65\x6E\x74\x2E\x1E\x20\x30"
  "\x1F\x61\x47\x72\x65\x65\x63\x65\x1F\x78\x52\x65\x6C\x69\x67\x69"
  "\x6F\x6E\x2E\x1E\x20\x30\x1F\x61\x47\x69\x66\x66\x6F\x72\x64\x20"
  "\x6C\x65\x63\x74\x75\x72\x65\x73\x2C\x1F\x76\x31\x39\x30\x34\x2D"
  "\x31\x39\x30\x36\x2E\x1E\x20\x20\x1F\x61\x20\x20\x20\x37\x32\x30"
  "\x30\x32\x35\x36\x35\x20\x1E\x1D"
,
  "\x30\x31\x31\x32\x36\x6E\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x36"
  "\x35\x20\x61\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x31\x33\x30"
  "\x30\x30\x30\x30\x30\x30\x33\x30\x30\x30\x34\x30\x30\x30\x31\x33"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x31\x37\x30\x30\x38\x30"
  "\x30\x34\x31\x30\x30\x30\x33\x34\x30\x31\x30\x30\x30\x31\x37\x30"
  "\x30\x38\x34\x33\x30\x32\x30\x30\x30\x33\x31\x30\x30\x30\x37\x35"
  "\x30\x34\x30\x30\x30\x31\x38\x30\x30\x31\x30\x36\x30\x35\x30\x30"
  "\x30\x32\x31\x30\x30\x31\x32\x34\x30\x38\x32\x30\x30\x31\x38\x30"
  "\x30\x31\x34\x35\x31\x30\x30\x30\x30\x34\x32\x30\x30\x31\x36\x33"
  "\x32\x34\x35\x30\x31\x35\x38\x30\x30\x32\x30\x35\x32\x35\x30\x30"
  "\x30\x33\x37\x30\x30\x33\x36\x33\x32\x36\x30\x30\x30\x34\x35\x30"
  "\x30\x34\x30\x30\x33\x30\x30\x30\x30\x35\x30\x30\x30\x34\x34\x35"
  "\x34\x34\x30\x30\x30\x33\x35\x30\x30\x34\x39\x35\x36\x33\x30\x30"
  "\x30\x36\x34\x30\x30\x35\x33\x30\x36\x33\x30\x30\x30\x36\x34\x30"
  "\x30\x35\x39\x34\x36\x33\x30\x30\x30\x36\x32\x30\x30\x36\x35\x38"
  "\x36\x33\x30\x30\x30\x36\x33\x30\x30\x37\x32\x30\x37\x33\x30\x30"
  "\x30\x36\x30\x30\x30\x37\x38\x33\x1E\x20\x20\x20\x38\x30\x30\x38"
  "\x32\x33\x32\x39\x20\x1E\x44\x4C\x43\x1E\x31\x39\x38\x31\x30\x35"
  "\x32\x38\x30\x30\x30\x30\x30\x30\x2E\x30\x1E\x38\x31\x30\x35\x32"
  "\x36\x73\x31\x39\x38\x30\x20\x20\x20\x20\x63\x74\x75\x61\x66\x20"
  "\x20\x20\x20\x20\x20\x20\x20\x20\x30\x30\x30\x31\x30\x20\x65\x6E"
  "\x67\x20\x20\x1E\x20\x20\x1F\x61\x30\x38\x37\x39\x38\x33\x32\x33"
  "\x35\x35\x20\x28\x70\x62\x6B\x2E\x29\x20\x3A\x1F\x63\x24\x34\x2E"
  "\x39\x35\x1E\x20\x20\x1F\x61\x44\x4C\x43\x1F\x63\x44\x4C\x43\x1F"
  "\x64\x44\x4C\x43\x1E\x30\x30\x1F\x61\x42\x53\x31\x34\x33\x33\x1F"
  "\x62\x2E\x53\x35\x20\x31\x39\x38\x30\x1E\x30\x30\x1F\x61\x32\x32"
  "\x33\x2F\x2E\x32\x30\x37\x37\x1F\x32\x31\x39\x1E\x31\x30\x1F\x61"
  "\x53\x6D\x69\x74\x68\x2C\x20\x47\x65\x6F\x72\x67\x65\x20\x41\x64"
  "\x61\x6D\x2C\x1F\x63\x53\x69\x72\x2C\x1F\x64\x31\x38\x35\x36\x2D"
  "\x31\x39\x34\x32\x2E\x1E\x31\x30\x1F\x61\x46\x6F\x75\x72\x20\x70"
  "\x73\x61\x6C\x6D\x73\x20\x3A\x1F\x62\x58\x58\x49\x49\x49\x2C\x20"
  "\x58\x58\x58\x56\x49\x2C\x20\x4C\x49\x49\x2C\x20\x43\x58\x58\x49"
  "\x20\x2F\x1F\x63\x69\x6E\x74\x65\x72\x70\x72\x65\x74\x65\x64\x20"
  "\x66\x6F\x72\x20\x70\x72\x61\x63\x74\x69\x63\x61\x6C\x20\x75\x73"
  "\x65\x20\x62\x79\x20\x47\x65\x6F\x72\x67\x65\x20\x41\x64\x61\x6D"
  "\x20\x53\x6D\x69\x74\x68\x20\x3B\x20\x69\x6E\x74\x72\x6F\x64\x75"
  "\x63\x74\x69\x6F\x6E\x20\x62\x79\x20\x46\x2E\x46\x2E\x20\x42\x72"
  "\x75\x63\x65\x20\x3B\x20\x69\x6C\x6C\x75\x73\x74\x72\x61\x74\x69"
  "\x6F\x6E\x73\x20\x62\x79\x20\x52\x6F\x6E\x20\x4D\x63\x43\x61\x72"
  "\x74\x79\x2E\x1E\x20\x20\x1F\x61\x53\x68\x65\x70\x68\x65\x72\x64"
  "\x20\x69\x6C\x6C\x75\x73\x74\x72\x61\x74\x65\x64\x20\x63\x6C\x61"
  "\x73\x73\x69\x63\x20\x65\x64\x2E\x1E\x30\x20\x1F\x61\x4E\x65\x77"
  "\x20\x43\x61\x6E\x61\x61\x6E\x2C\x20\x43\x6F\x6E\x6E\x2E\x20\x3A"
  "\x1F\x62\x4B\x65\x61\x74\x73\x20\x50\x75\x62\x2E\x2C\x1F\x63\x63"
  "\x31\x39\x38\x30\x2E\x1E\x20\x20\x1F\x61\x38\x31\x20\x70\x2E\x2C"
  "\x20\x5B\x35\x5D\x20\x6C\x65\x61\x76\x65\x73\x20\x6F\x66\x20\x70"
  "\x6C\x61\x74\x65\x73\x20\x3A\x1F\x62\x69\x6C\x6C\x2E\x20\x3B\x1F"
  "\x63\x32\x31\x20\x63\x6D\x2E\x1E\x20\x32\x1F\x61\x41\x20\x53\x68"
  "\x65\x70\x68\x65\x72\x64\x20\x69\x6C\x6C\x75\x73\x74\x72\x61\x74"
  "\x65\x64\x20\x63\x6C\x61\x73\x73\x69\x63\x1E\x30\x30\x1F\x61\x42"
  "\x69\x62\x6C\x65\x2E\x1F\x70\x4F\x2E\x54\x2E\x1F\x70\x50\x73\x61"
  "\x6C\x6D\x73\x20\x58\x58\x49\x49\x49\x1F\x78\x43\x72\x69\x74\x69"
  "\x63\x69\x73\x6D\x2C\x20\x69\x6E\x74\x65\x72\x70\x72\x65\x74\x61"
  "\x74\x69\x6F\x6E\x2C\x20\x65\x74\x63\x2E\x1E\x30\x30\x1F\x61\x42"
  "\x69\x62\x6C\x65\x2E\x1F\x70\x4F\x2E\x54\x2E\x1F\x70\x50\x73\x61"
  "\x6C\x6D\x73\x20\x58\x58\x58\x56\x49\x1F\x78\x43\x72\x69\x74\x69"
  "\x63\x69\x73\x6D\x2C\x20\x69\x6E\x74\x65\x72\x70\x72\x65\x74\x61"
  "\x74\x69\x6F\x6E\x2C\x20\x65\x74\x63\x2E\x1E\x30\x30\x1F\x61\x42"
  "\x69\x62\x6C\x65\x2E\x1F\x70\x4F\x2E\x54\x2E\x1F\x70\x50\x73\x61"
  "\x6C\x6D\x73\x20\x4C\x49\x49\x1F\x78\x43\x72\x69\x74\x69\x63\x69"
  "\x73\x6D\x2C\x20\x69\x6E\x74\x65\x72\x70\x72\x65\x74\x61\x74\x69"
  "\x6F\x6E\x2C\x20\x65\x74\x63\x2E\x1E\x30\x30\x1F\x61\x42\x69\x62"
  "\x6C\x65\x2E\x1F\x70\x4F\x2E\x54\x2E\x1F\x70\x50\x73\x61\x6C\x6D"
  "\x73\x20\x43\x58\x58\x49\x1F\x78\x43\x72\x69\x74\x69\x63\x69\x73"
  "\x6D\x2C\x20\x69\x6E\x74\x65\x72\x70\x72\x65\x74\x61\x74\x69\x6F"
  "\x6E\x2C\x20\x65\x74\x63\x2E\x1E\x30\x31\x1F\x61\x42\x69\x62\x6C"
  "\x65\x2E\x1F\x70\x4F\x2E\x54\x2E\x1F\x70\x50\x73\x61\x6C\x6D\x73"
  "\x20\x58\x58\x49\x49\x49\x2C\x20\x58\x58\x58\x56\x49\x2C\x20\x4C"
  "\x49\x49\x2C\x20\x43\x58\x58\x49\x2E\x1F\x6C\x45\x6E\x67\x6C\x69"
  "\x73\x68\x2E\x1E\x20\x20\x1F\x61\x20\x20\x20\x38\x30\x30\x38\x32"
  "\x33\x32\x39\x20\x1E\x1D"
,
  "\x30\x31\x34\x33\x33\x6E\x61\x73\x20\x20\x32\x32\x30\x30\x34\x32"
  "\x31\x20\x61\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x30\x39\x30"
  "\x30\x30\x30\x30\x30\x30\x33\x30\x30\x30\x34\x30\x30\x30\x30\x39"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x31\x33\x30\x30\x38\x30"
  "\x30\x34\x31\x30\x30\x30\x33\x30\x30\x31\x30\x30\x30\x33\x31\x30"
  "\x30\x30\x37\x31\x30\x32\x32\x30\x30\x31\x34\x30\x30\x31\x30\x32"
  "\x30\x33\x30\x30\x30\x31\x31\x30\x30\x31\x31\x36\x30\x33\x32\x30"
  "\x30\x31\x37\x30\x30\x31\x32\x37\x30\x33\x35\x30\x30\x32\x30\x30"
  "\x30\x31\x34\x34\x30\x33\x35\x30\x30\x32\x37\x30\x30\x31\x36\x34"
  "\x30\x34\x30\x30\x30\x39\x36\x30\x30\x31\x39\x31\x30\x34\x32\x30"
  "\x30\x31\x33\x30\x30\x32\x38\x37\x30\x35\x30\x30\x30\x32\x30\x30"
  "\x30\x33\x30\x30\x30\x37\x30\x30\x30\x31\x38\x30\x30\x33\x32\x30"
  "\x30\x37\x32\x30\x30\x30\x39\x30\x30\x33\x33\x38\x30\x38\x32\x30"
  "\x30\x31\x34\x30\x30\x33\x34\x37\x32\x31\x30\x30\x30\x31\x39\x30"
  "\x30\x33\x36\x31\x32\x32\x32\x30\x30\x31\x39\x30\x30\x33\x38\x30"
  "\x32\x34\x35\x30\x30\x32\x30\x30\x30\x33\x39\x39\x32\x36\x30\x30"
  "\x30\x34\x33\x30\x30\x34\x31\x39\x32\x36\x35\x30\x30\x35\x38\x30"
  "\x30\x34\x36\x32\x33\x30\x30\x30\x30\x31\x37\x30\x30\x35\x32\x30"
  "\x33\x31\x30\x30\x30\x36\x32\x30\x30\x35\x33\x37\x33\x35\x30\x30"
  "\x30\x31\x31\x30\x30\x35\x39\x39\x33\x36\x32\x30\x30\x33\x32\x30"
  "\x30\x36\x31\x30\x35\x30\x30\x30\x30\x32\x34\x30\x30\x36\x34\x32"
  "\x36\x35\x30\x30\x30\x34\x36\x30\x30\x36\x36\x36\x36\x35\x30\x30"
  "\x30\x33\x36\x30\x30\x37\x31\x32\x36\x35\x30\x30\x30\x33\x39\x30"
  "\x30\x37\x34\x38\x36\x35\x30\x30\x30\x33\x35\x30\x30\x37\x38\x37"
  "\x36\x35\x30\x30\x30\x33\x33\x30\x30\x38\x32\x32\x37\x38\x30\x30"
  "\x30\x38\x32\x30\x30\x38\x35\x35\x38\x35\x30\x30\x30\x37\x34\x30"
  "\x30\x39\x33\x37\x1E\x41\x43\x44\x2D\x33\x38\x33\x37\x1E\x44\x4C"
  "\x43\x1E\x31\x39\x39\x34\x30\x36\x31\x34\x30\x36\x35\x36\x31\x34"
  "\x2E\x30\x1E\x39\x32\x30\x37\x32\x38\x63\x31\x39\x39\x32\x39\x39"
  "\x39\x39\x63\x74\x75\x6D\x6E\x31\x70\x20\x20\x20\x20\x20\x20\x20"
  "\x30\x20\x20\x20\x61\x30\x65\x6E\x67\x20\x64\x1E\x20\x20\x1F\x61"
  "\x20\x20\x20\x39\x32\x36\x34\x36\x30\x36\x32\x20\x1F\x7A\x73\x6E"
  "\x20\x39\x32\x30\x30\x34\x34\x33\x30\x20\x1E\x30\x20\x1F\x61\x31"
  "\x30\x36\x34\x2D\x33\x39\x32\x33\x1E\x20\x20\x1F\x61\x49\x45\x52"
  "\x4E\x45\x38\x1E\x20\x20\x1F\x61\x30\x30\x38\x31\x38\x37\x1F\x62"
  "\x55\x53\x50\x53\x1E\x20\x20\x1F\x61\x28\x4F\x43\x6F\x4C\x43\x29"
  "\x32\x36\x32\x37\x33\x32\x37\x35\x1E\x30\x30\x1F\x69\x6C\x63\x6D"
  "\x61\x72\x63\x2F\x41\x51\x50\x2D\x36\x32\x38\x35\x2F\x4A\x45\x41"
  "\x4E\x4E\x45\x1E\x20\x20\x1F\x61\x4E\x53\x44\x50\x1F\x63\x4E\x53"
  "\x44\x50\x1F\x64\x57\x61\x55\x1F\x64\x4E\x49\x43\x1F\x64\x44\x4E"
  "\x41\x4C\x1F\x64\x4F\x55\x43\x41\x1F\x64\x4E\x53\x54\x1F\x64\x44"
  "\x4C\x43\x1F\x64\x4E\x53\x54\x1F\x64\x4E\x53\x44\x50\x1F\x64\x4E"
  "\x53\x54\x1F\x64\x44\x4C\x43\x1F\x64\x49\x6E\x55\x1F\x64\x4D\x48"
  "\x1F\x64\x4E\x53\x44\x50\x1F\x64\x4E\x1F\x64\x44\x4C\x43\x1F\x64"
  "\x4D\x69\x55\x1E\x20\x20\x1F\x61\x6E\x73\x64\x70\x1F\x61\x6C\x63"
  "\x1E\x30\x30\x1F\x61\x54\x4B\x35\x31\x30\x35\x2E\x35\x1F\x62\x2E"
  "\x52\x34\x34\x38\x1E\x30\x20\x1F\x61\x54\x4B\x35\x31\x30\x35\x2E"
  "\x35\x2E\x52\x34\x34\x38\x1E\x20\x30\x1F\x61\x58\x32\x30\x30\x1E"
  "\x30\x30\x1F\x61\x33\x38\x34\x2E\x33\x1F\x32\x32\x30\x1E\x30\x20"
  "\x1F\x61\x49\x6E\x74\x65\x72\x6E\x65\x74\x20\x77\x6F\x72\x6C\x64"
  "\x1E\x20\x30\x1F\x61\x49\x6E\x74\x65\x72\x6E\x65\x74\x20\x77\x6F"
  "\x72\x6C\x64\x1E\x30\x30\x1F\x61\x49\x6E\x74\x65\x72\x6E\x65\x74"
  "\x20\x77\x6F\x72\x6C\x64\x2E\x1E\x20\x20\x1F\x61\x57\x65\x73\x74"
  "\x70\x6F\x72\x74\x2C\x20\x43\x54\x20\x3A\x1F\x62\x4D\x65\x63\x6B"
  "\x6C\x65\x72\x20\x43\x6F\x72\x70\x2E\x2C\x1F\x63\x63\x31\x39\x39"
  "\x32\x2D\x1E\x20\x20\x1F\x61\x4D\x65\x63\x6B\x6C\x65\x72\x20\x43"
  "\x6F\x72\x70\x2E\x2C\x20\x31\x31\x20\x46\x65\x72\x72\x79\x20\x4C"
  "\x61\x6E\x65\x20\x57\x65\x73\x74\x2C\x20\x57\x65\x73\x74\x70\x6F"
  "\x72\x74\x2C\x20\x43\x54\x20\x30\x36\x38\x38\x30\x1E\x20\x20\x1F"
  "\x61\x76\x2E\x20\x3B\x1F\x63\x32\x38\x20\x63\x6D\x2E\x1E\x20\x20"
  "\x1F\x61\x4D\x6F\x6E\x74\x68\x6C\x79\x20\x28\x65\x78\x63\x65\x70"
  "\x74\x20\x4A\x61\x6E\x2E\x2F\x46\x65\x62\x2E\x2C\x20\x4A\x75\x6C"
  "\x79\x2F\x41\x75\x67\x2E\x2C\x20\x4E\x6F\x76\x2E\x2F\x44\x65\x63"
  "\x2E\x20\x63\x6F\x6D\x62\x69\x6E\x65\x64\x29\x1E\x20\x20\x1F\x61"
  "\x24\x39\x37\x2E\x30\x30\x1E\x30\x20\x1F\x61\x56\x6F\x6C\x2E\x20"
  "\x33\x2C\x20\x6E\x6F\x2E\x20\x37\x20\x28\x53\x65\x70\x74\x2E\x20"
  "\x31\x39\x39\x32\x29\x2D\x1E\x20\x20\x1F\x61\x54\x69\x74\x6C\x65"
  "\x20\x66\x72\x6F\x6D\x20\x63\x61\x70\x74\x69\x6F\x6E\x2E\x1E\x20"
  "\x30\x1F\x61\x49\x6E\x74\x65\x72\x6E\x65\x74\x20\x28\x43\x6F\x6D"
  "\x70\x75\x74\x65\x72\x20\x6E\x65\x74\x77\x6F\x72\x6B\x29\x1F\x78"
  "\x50\x65\x72\x69\x6F\x64\x69\x63\x61\x6C\x73\x2E\x1E\x20\x30\x1F"
  "\x61\x43\x6F\x6D\x70\x75\x74\x65\x72\x20\x6E\x65\x74\x77\x6F\x72"
  "\x6B\x73\x1F\x78\x50\x65\x72\x69\x6F\x64\x69\x63\x61\x6C\x73\x2E"
  "\x1E\x20\x30\x1F\x61\x49\x6E\x66\x6F\x72\x6D\x61\x74\x69\x6F\x6E"
  "\x20\x6E\x65\x74\x77\x6F\x72\x6B\x73\x1F\x78\x50\x65\x72\x69\x6F"
  "\x64\x69\x63\x61\x6C\x73\x2E\x1E\x20\x32\x1F\x61\x43\x6F\x6D\x70"
  "\x75\x74\x65\x72\x20\x53\x79\x73\x74\x65\x6D\x73\x1F\x78\x70\x65"
  "\x72\x69\x6F\x64\x69\x63\x61\x6C\x73\x2E\x1E\x20\x32\x1F\x61\x4F"
  "\x6E\x6C\x69\x6E\x65\x20\x53\x79\x73\x74\x65\x6D\x73\x1F\x78\x70"
  "\x65\x72\x69\x6F\x64\x69\x63\x61\x6C\x73\x2E\x1E\x30\x30\x1F\x74"
  "\x52\x65\x73\x65\x61\x72\x63\x68\x20\x26\x20\x65\x64\x75\x63\x61"
  "\x74\x69\x6F\x6E\x20\x6E\x65\x74\x77\x6F\x72\x6B\x69\x6E\x67\x1F"
  "\x78\x31\x30\x35\x31\x2D\x34\x37\x39\x31\x1F\x77\x28\x44\x4C\x43"
  "\x29\x20\x20\x20\x39\x30\x36\x34\x36\x36\x31\x33\x1F\x77\x28\x4F"
  "\x43\x6F\x4C\x43\x29\x32\x31\x39\x37\x34\x34\x34\x38\x1E\x20\x20"
  "\x1F\x61\x44\x4C\x43\x1F\x61\x44\x4E\x41\x4C\x1F\x61\x44\x4E\x47"
  "\x41\x1F\x61\x49\x6E\x55\x1F\x61\x4D\x42\x43\x6F\x1F\x61\x4D\x48"
  "\x2D\x45\x64\x1F\x61\x4D\x64\x42\x4A\x1F\x61\x4D\x69\x55\x1F\x61"
  "\x4D\x6F\x4B\x4C\x1F\x61\x4E\x1F\x61\x4E\x49\x43\x1F\x61\x54\x78"
  "\x48\x52\x1F\x61\x57\x61\x55\x1E\x1D"
,
  "\x30\x31\x33\x33\x30\x6E\x61\x73\x20\x20\x32\x32\x30\x30\x33\x37"
  "\x33\x35\x61\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x30\x39\x30"
  "\x30\x30\x30\x30\x30\x30\x33\x30\x30\x30\x34\x30\x30\x30\x30\x39"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x31\x33\x30\x30\x38\x30"
  "\x30\x34\x31\x30\x30\x30\x33\x30\x30\x31\x30\x30\x30\x31\x37\x30"
  "\x30\x30\x37\x31\x30\x32\x32\x30\x30\x32\x35\x30\x30\x30\x38\x38"
  "\x30\x33\x35\x30\x30\x32\x30\x30\x30\x31\x31\x33\x30\x33\x35\x30"
  "\x30\x32\x37\x30\x30\x31\x33\x33\x30\x34\x30\x30\x30\x32\x39\x30"
  "\x30\x31\x36\x30\x30\x34\x32\x30\x30\x31\x36\x30\x30\x31\x38\x39"
  "\x30\x34\x33\x30\x30\x31\x32\x30\x30\x32\x30\x35\x30\x35\x35\x30"
  "\x30\x31\x32\x30\x30\x32\x31\x37\x30\x38\x32\x30\x30\x31\x32\x30"
  "\x30\x32\x32\x39\x31\x33\x30\x30\x30\x33\x35\x30\x30\x32\x34\x31"
  "\x32\x31\x30\x30\x30\x32\x37\x30\x30\x32\x37\x36\x32\x32\x32\x30"
  "\x30\x32\x39\x30\x30\x33\x30\x33\x32\x34\x35\x30\x30\x31\x37\x30"
  "\x30\x33\x33\x32\x32\x36\x30\x30\x30\x35\x34\x30\x30\x33\x34\x39"
  "\x32\x36\x35\x30\x30\x36\x39\x30\x30\x34\x30\x33\x33\x30\x30\x30"
  "\x30\x32\x35\x30\x30\x34\x37\x32\x33\x31\x30\x30\x30\x31\x32\x30"
  "\x30\x34\x39\x37\x33\x35\x30\x30\x30\x32\x31\x30\x30\x35\x30\x39"
  "\x33\x36\x32\x30\x30\x33\x33\x30\x30\x35\x33\x30\x35\x30\x30\x30"
  "\x30\x32\x34\x30\x30\x35\x36\x33\x35\x38\x30\x30\x30\x35\x38\x30"
  "\x30\x35\x38\x37\x37\x38\x30\x30\x30\x38\x33\x30\x30\x36\x34\x35"
  "\x37\x38\x30\x30\x30\x35\x31\x30\x30\x37\x32\x38\x37\x38\x35\x30"
  "\x30\x38\x33\x30\x30\x37\x37\x39\x37\x38\x37\x30\x30\x39\x34\x30"
  "\x30\x38\x36\x32\x1E\x41\x43\x44\x2D\x33\x37\x39\x39\x1E\x44\x4C"
  "\x43\x1E\x31\x39\x39\x34\x30\x36\x31\x34\x30\x39\x30\x35\x31\x34"
  "\x2E\x30\x1E\x39\x32\x30\x37\x32\x33\x63\x31\x39\x39\x31\x39\x39"
  "\x39\x39\x6F\x6E\x63\x6D\x72\x34\x70\x20\x20\x20\x20\x20\x20\x20"
  "\x30\x20\x20\x20\x61\x30\x65\x6E\x67\x20\x64\x1E\x20\x20\x1F\x61"
  "\x63\x6E\x20\x39\x32\x30\x33\x31\x36\x34\x31\x20\x1E\x30\x20\x1F"
  "\x61\x31\x31\x38\x37\x2D\x37\x30\x38\x31\x1F\x79\x30\x30\x32\x35"
  "\x2D\x39\x35\x33\x35\x1E\x20\x20\x1F\x61\x28\x4F\x43\x6F\x4C\x43"
  "\x29\x32\x36\x32\x34\x34\x38\x34\x34\x1E\x30\x30\x1F\x69\x6C\x63"
  "\x6D\x61\x72\x63\x2F\x41\x51\x46\x2D\x32\x38\x39\x36\x2F\x4A\x45"
  "\x41\x4E\x4E\x45\x1E\x20\x20\x1F\x61\x43\x61\x4F\x4F\x43\x4D\x1F"
  "\x62\x65\x6E\x67\x1F\x63\x43\x61\x4F\x4F\x4E\x4C\x1F\x64\x49\x6E"
  "\x55\x1E\x20\x20\x1F\x61\x6E\x6C\x63\x1F\x61\x69\x73\x64\x73\x2F"
  "\x63\x1E\x20\x20\x1F\x61\x6E\x2D\x63\x6E\x2D\x2D\x2D\x1E\x20\x32"
  "\x1F\x61\x48\x44\x39\x36\x39\x36\x2A\x1E\x31\x20\x1F\x61\x30\x30"
  "\x34\x1F\x32\x31\x32\x1E\x30\x20\x1F\x61\x49\x6E\x66\x6F\x20\x43"
  "\x61\x6E\x61\x64\x61\x20\x28\x44\x6F\x77\x6E\x73\x76\x69\x65\x77"
  "\x2C\x20\x4F\x6E\x74\x2E\x29\x2E\x1E\x30\x20\x1F\x61\x49\x6E\x66"
  "\x6F\x20\x43\x61\x6E\x2E\x1F\x62\x28\x44\x6F\x77\x6E\x73\x76\x69"
  "\x65\x77\x29\x1E\x20\x30\x1F\x61\x49\x6E\x66\x6F\x20\x43\x61\x6E"
  "\x61\x64\x61\x1F\x62\x28\x44\x6F\x77\x6E\x73\x76\x69\x65\x77\x29"
  "\x1E\x30\x30\x1F\x61\x49\x6E\x66\x6F\x20\x43\x61\x6E\x61\x64\x61"
  "\x2E\x1E\x20\x20\x1F\x61\x44\x6F\x77\x6E\x73\x76\x69\x65\x77\x2C"
  "\x20\x4F\x6E\x74\x2E\x20\x3A\x1F\x62\x4C\x61\x75\x72\x65\x6E\x74"
  "\x69\x61\x6E\x20\x54\x65\x63\x68\x6E\x6F\x6D\x65\x64\x69\x61\x2C"
  "\x1F\x63\x31\x39\x39\x31\x2D\x1E\x20\x20\x1F\x61\x4C\x61\x75\x72"
  "\x65\x6E\x74\x69\x61\x6E\x20\x54\x65\x63\x68\x6E\x6F\x6D\x65\x64"
  "\x69\x61\x2C\x20\x35\x30\x31\x20\x4F\x61\x6B\x64\x61\x6C\x65\x20"
  "\x52\x64\x2E\x2C\x20\x44\x6F\x77\x6E\x73\x76\x69\x65\x77\x2C\x20"
  "\x4F\x6E\x74\x2E\x20\x4D\x33\x4E\x20\x31\x57\x37\x1E\x20\x20\x1F"
  "\x61\x76\x2E\x20\x3A\x1F\x62\x69\x6C\x6C\x2E\x20\x3B\x1F\x63\x34"
  "\x30\x20\x63\x6D\x2E\x1E\x20\x20\x1F\x61\x4D\x6F\x6E\x74\x68\x6C"
  "\x79\x1E\x20\x20\x1F\x61\x24\x35\x30\x2E\x30\x30\x20\x70\x65\x72"
  "\x20\x79\x65\x61\x72\x2E\x1E\x30\x20\x1F\x61\x56\x6F\x6C\x2E\x20"
  "\x31\x36\x2C\x20\x6E\x6F\x2E\x20\x39\x20\x28\x53\x65\x70\x74\x2E"
  "\x20\x31\x39\x39\x31\x29\x2D\x1E\x20\x20\x1F\x61\x54\x69\x74\x6C"
  "\x65\x20\x66\x72\x6F\x6D\x20\x63\x61\x70\x74\x69\x6F\x6E\x2E\x1E"
  "\x20\x20\x1F\x61\x49\x6E\x63\x6C\x75\x64\x65\x73\x3A\x20\x4E\x65"
  "\x74\x77\x6F\x72\x6B\x20\x77\x6F\x72\x6C\x64\x20\x43\x61\x6E\x61"
  "\x64\x61\x2C\x20\x53\x65\x70\x74\x2E\x20\x31\x39\x39\x31\x2D\x4A"
  "\x61\x6E\x2E\x20\x31\x39\x39\x32\x2E\x1E\x30\x30\x1F\x74\x43\x6F"
  "\x6D\x70\x75\x74\x65\x72\x20\x64\x61\x74\x61\x1F\x78\x30\x33\x38"
  "\x33\x2D\x37\x33\x31\x39\x1F\x77\x28\x43\x61\x4F\x4F\x4E\x4C\x29"
  "\x37\x37\x30\x33\x30\x38\x33\x31\x37\x1F\x77\x28\x4F\x43\x6F\x4C"
  "\x43\x29\x31\x31\x34\x31\x36\x34\x37\x39\x1F\x77\x28\x44\x4C\x43"
  "\x29\x63\x6E\x20\x37\x37\x30\x33\x30\x38\x33\x31\x1E\x30\x35\x1F"
  "\x74\x49\x2E\x54\x2E\x20\x6D\x61\x67\x61\x7A\x69\x6E\x65\x20\x28"
  "\x54\x6F\x72\x6F\x6E\x74\x6F\x2C\x20\x4F\x6E\x74\x2E\x29\x1F\x77"
  "\x28\x4F\x43\x6F\x4C\x43\x29\x32\x37\x36\x39\x39\x30\x36\x36\x1E"
  "\x30\x31\x1F\x74\x4E\x65\x74\x77\x6F\x72\x6B\x20\x77\x6F\x72\x6C"
  "\x64\x20\x43\x61\x6E\x61\x64\x61\x1F\x67\x46\x65\x62\x2E\x20\x31"
  "\x39\x39\x32\x1F\x78\x31\x31\x38\x37\x2D\x32\x39\x38\x35\x1F\x77"
  "\x28\x4F\x43\x6F\x4C\x43\x29\x32\x35\x33\x31\x34\x30\x31\x32\x1F"
  "\x77\x28\x43\x61\x4F\x4F\x4E\x4C\x29\x39\x32\x30\x33\x30\x35\x37"
  "\x32\x35\x1E\x31\x20\x1F\x74\x4E\x65\x74\x77\x6F\x72\x6B\x20\x77"
  "\x6F\x72\x6C\x64\x20\x43\x61\x6E\x61\x64\x61\x1F\x67\x53\x65\x70"
  "\x74\x2E\x20\x31\x39\x39\x31\x2D\x4A\x61\x6E\x2E\x20\x31\x39\x39"
  "\x32\x1F\x78\x31\x31\x38\x37\x2D\x32\x39\x38\x35\x1F\x77\x28\x4F"
  "\x43\x6F\x4C\x43\x29\x32\x35\x33\x31\x34\x30\x31\x32\x1F\x77\x28"
  "\x43\x61\x4F\x4F\x4E\x4C\x29\x39\x32\x30\x33\x30\x35\x37\x32\x35"
  "\x1E\x1D"
,
  "\x30\x30\x38\x30\x33\x6E\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x38"
  "\x39\x38\x61\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x30\x39\x30"
  "\x30\x30\x30\x30\x30\x30\x33\x30\x30\x30\x34\x30\x30\x30\x30\x39"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x31\x33\x30\x30\x38\x30"
  "\x30\x34\x31\x30\x30\x30\x33\x30\x30\x31\x30\x30\x30\x31\x37\x30"
  "\x30\x30\x37\x31\x30\x32\x30\x30\x30\x31\x35\x30\x30\x30\x38\x38"
  "\x30\x33\x35\x30\x30\x32\x37\x30\x30\x31\x30\x33\x30\x34\x30\x30"
  "\x30\x31\x33\x30\x30\x31\x33\x30\x30\x34\x33\x30\x30\x31\x32\x30"
  "\x30\x31\x34\x33\x30\x35\x30\x30\x30\x32\x38\x30\x30\x31\x35\x35"
  "\x30\x38\x32\x30\x30\x31\x38\x30\x30\x31\x38\x33\x31\x30\x30\x30"
  "\x30\x32\x35\x30\x30\x32\x30\x31\x32\x34\x35\x30\x30\x39\x35\x30"
  "\x30\x32\x32\x36\x32\x35\x30\x30\x30\x31\x32\x30\x30\x33\x32\x31"
  "\x32\x36\x30\x30\x30\x33\x34\x30\x30\x33\x33\x33\x32\x36\x33\x30"
  "\x30\x30\x39\x30\x30\x33\x36\x37\x33\x30\x30\x30\x30\x31\x31\x30"
  "\x30\x33\x37\x36\x35\x30\x30\x30\x30\x32\x30\x30\x30\x33\x38\x37"
  "\x36\x33\x30\x30\x30\x33\x38\x30\x30\x34\x30\x37\x36\x30\x30\x30"
  "\x30\x32\x32\x30\x30\x34\x34\x35\x36\x30\x30\x30\x30\x31\x35\x30"
  "\x30\x34\x36\x37\x36\x35\x30\x30\x30\x33\x31\x30\x30\x34\x38\x32"
  "\x1E\x41\x43\x44\x2D\x33\x37\x39\x32\x1E\x44\x4C\x43\x1E\x31\x39"
  "\x39\x33\x31\x32\x31\x35\x30\x38\x34\x36\x30\x35\x2E\x37\x1E\x39"
  "\x33\x31\x32\x30\x36\x73\x31\x39\x39\x33\x20\x20\x20\x20\x6E\x79"
  "\x75\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x30\x30\x31\x20"
  "\x30\x20\x65\x6E\x67\x20\x20\x1E\x20\x20\x1F\x61\x20\x20\x20\x39"
  "\x33\x30\x34\x37\x39\x39\x32\x20\x1E\x20\x20\x1F\x61\x31\x35\x36"
  "\x32\x38\x32\x37\x35\x34\x35\x1E\x30\x30\x1F\x69\x6C\x63\x6D\x61"
  "\x72\x63\x2F\x41\x52\x55\x2D\x32\x33\x36\x34\x2F\x53\x54\x45\x56"
  "\x45\x53\x1E\x20\x20\x1F\x61\x44\x4C\x43\x1F\x63\x44\x4C\x43\x1E"
  "\x20\x20\x1F\x61\x6E\x2D\x75\x73\x2D\x2D\x2D\x1E\x30\x30\x1F\x61"
  "\x50\x4E\x31\x39\x39\x32\x2E\x37\x37\x2E\x54\x36\x33\x1F\x62\x43"
  "\x33\x37\x20\x31\x39\x39\x33\x1E\x30\x30\x1F\x61\x37\x39\x31\x2E"
  "\x34\x35\x2F\x37\x32\x1F\x32\x32\x30\x1E\x31\x20\x1F\x61\x43\x61"
  "\x72\x74\x65\x72\x2C\x20\x42\x69\x6C\x6C\x2C\x1F\x64\x31\x39\x34"
  "\x39\x2D\x1E\x31\x34\x1F\x61\x54\x68\x65\x20\x6C\x61\x74\x65\x20"
  "\x73\x68\x69\x66\x74\x20\x3A\x1F\x62\x4C\x65\x74\x74\x65\x72\x6D"
  "\x61\x6E\x2C\x20\x4C\x65\x6E\x6F\x2C\x20\x61\x6E\x64\x20\x74\x68"
  "\x65\x20\x6E\x65\x74\x77\x6F\x72\x6B\x20\x62\x61\x74\x74\x6C\x65"
  "\x20\x66\x6F\x72\x20\x74\x68\x65\x20\x6E\x69\x67\x68\x74\x20\x2F"
  "\x1F\x63\x62\x79\x20\x42\x69\x6C\x6C\x20\x43\x61\x72\x74\x65\x72"
  "\x2E\x1E\x20\x20\x1F\x61\x31\x73\x74\x20\x65\x64\x2E\x1E\x20\x20"
  "\x1F\x61\x4E\x65\x77\x20\x59\x6F\x72\x6B\x20\x3A\x1F\x62\x48\x79"
  "\x70\x65\x72\x69\x6F\x6E\x2C\x1F\x63\x63\x31\x39\x39\x33\x2E\x1E"
  "\x20\x20\x1F\x61\x39\x34\x30\x32\x1E\x20\x20\x1F\x61\x70\x2E\x20"
  "\x63\x6D\x2E\x1E\x20\x20\x1F\x61\x49\x6E\x63\x6C\x75\x64\x65\x73"
  "\x20\x69\x6E\x64\x65\x78\x2E\x1E\x30\x30\x1F\x61\x54\x6F\x6E\x69"
  "\x67\x68\x74\x20\x73\x68\x6F\x77\x20\x28\x54\x65\x6C\x65\x76\x69"
  "\x73\x69\x6F\x6E\x20\x70\x72\x6F\x67\x72\x61\x6D\x29\x1E\x31\x30"
  "\x1F\x61\x4C\x65\x74\x74\x65\x72\x6D\x61\x6E\x2C\x20\x44\x61\x76"
  "\x69\x64\x2E\x1E\x31\x30\x1F\x61\x4C\x65\x6E\x6F\x2C\x20\x4A\x61"
  "\x79\x2E\x1E\x20\x30\x1F\x61\x54\x61\x6C\x6B\x20\x73\x68\x6F\x77"
  "\x73\x1F\x7A\x55\x6E\x69\x74\x65\x64\x20\x53\x74\x61\x74\x65\x73"
  "\x2E\x1E\x1D"
,
  "\x30\x30\x37\x36\x36\x6E\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x36"
  "\x35\x38\x61\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x30\x39\x30"
  "\x30\x30\x30\x30\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x30\x39"
  "\x30\x30\x38\x30\x30\x34\x31\x30\x30\x30\x32\x36\x30\x31\x30\x30"
  "\x30\x31\x37\x30\x30\x30\x36\x37\x30\x32\x30\x30\x30\x31\x35\x30"
  "\x30\x30\x38\x34\x30\x33\x35\x30\x30\x32\x39\x30\x30\x30\x39\x39"
  "\x30\x34\x30\x30\x30\x31\x33\x30\x30\x31\x32\x38\x30\x35\x30\x30"
  "\x30\x32\x39\x30\x30\x31\x34\x31\x30\x38\x32\x30\x30\x31\x36\x30"
  "\x30\x31\x37\x30\x32\x34\x35\x30\x30\x37\x36\x30\x30\x31\x38\x36"
  "\x32\x35\x30\x30\x30\x31\x36\x30\x30\x32\x36\x32\x32\x36\x30\x30"
  "\x30\x35\x36\x30\x30\x32\x37\x38\x32\x36\x33\x30\x30\x30\x39\x30"
  "\x30\x33\x33\x34\x33\x30\x30\x30\x30\x31\x31\x30\x30\x33\x34\x33"
  "\x34\x34\x30\x30\x30\x33\x32\x30\x30\x33\x35\x34\x35\x30\x30\x30"
  "\x30\x32\x30\x30\x30\x33\x38\x36\x36\x35\x30\x30\x30\x33\x32\x30"
  "\x30\x34\x30\x36\x36\x35\x30\x30\x30\x31\x39\x30\x30\x34\x33\x38"
  "\x37\x30\x30\x30\x30\x32\x35\x30\x30\x34\x35\x37\x37\x30\x30\x30"
  "\x30\x31\x38\x30\x30\x34\x38\x32\x1E\x41\x43\x44\x2D\x33\x36\x36"
  "\x35\x1E\x31\x39\x39\x33\x30\x37\x33\x30\x30\x39\x32\x30\x30\x34"
  "\x2E\x31\x1E\x39\x33\x30\x37\x32\x31\x73\x31\x39\x39\x33\x20\x20"
  "\x20\x20\x6E\x6A\x75\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
  "\x30\x30\x31\x20\x30\x20\x65\x6E\x67\x20\x20\x1E\x20\x20\x1F\x61"
  "\x20\x20\x20\x39\x33\x30\x33\x30\x37\x37\x35\x20\x1E\x20\x20\x1F"
  "\x61\x30\x31\x33\x32\x38\x39\x36\x36\x31\x33\x1E\x30\x30\x1F\x69"
  "\x6C\x63\x6D\x61\x72\x63\x2F\x41\x52\x49\x2D\x33\x38\x30\x34\x2F"
  "\x4A\x55\x4C\x49\x41\x4E\x4E\x45\x1E\x20\x20\x1F\x61\x44\x4C\x43"
  "\x1F\x63\x44\x4C\x43\x1E\x30\x30\x1F\x61\x54\x4B\x35\x31\x30\x35"
  "\x2E\x38\x37\x35\x2E\x49\x35\x37\x1F\x62\x49\x35\x36\x20\x31\x39"
  "\x39\x33\x1E\x30\x30\x1F\x61\x33\x38\x34\x2E\x33\x2F\x34\x1F\x32"
  "\x32\x30\x1E\x30\x30\x1F\x61\x49\x6E\x74\x65\x72\x6E\x65\x74\x20"
  "\x3A\x1F\x62\x6D\x61\x69\x6C\x69\x6E\x67\x20\x6C\x69\x73\x74\x73"
  "\x20\x2F\x1F\x63\x65\x64\x69\x74\x65\x64\x20\x62\x79\x20\x45\x64"
  "\x77\x61\x72\x64\x20\x54\x2E\x4C\x2E\x20\x48\x61\x72\x64\x69\x65"
  "\x2C\x20\x56\x69\x76\x69\x61\x6E\x20\x4E\x65\x6F\x75\x2E\x1E\x20"
  "\x20\x1F\x61\x55\x70\x64\x61\x74\x65\x64\x20\x65\x64\x2E\x1E\x20"
  "\x20\x1F\x61\x45\x6E\x67\x6C\x65\x77\x6F\x6F\x64\x20\x43\x6C\x69"
  "\x66\x66\x73\x2C\x20\x4E\x2E\x4A\x2E\x20\x3A\x1F\x62\x50\x54\x52"
  "\x20\x50\x72\x65\x6E\x74\x69\x63\x65\x20\x48\x61\x6C\x6C\x2C\x1F"
  "\x63\x31\x39\x39\x33\x2E\x1E\x20\x20\x1F\x61\x39\x33\x30\x38\x1E"
  "\x20\x20\x1F\x61\x70\x2E\x20\x63\x6D\x2E\x1E\x20\x30\x1F\x61\x49"
  "\x6E\x74\x65\x72\x6E\x65\x74\x20\x69\x6E\x66\x6F\x72\x6D\x61\x74"
  "\x69\x6F\x6E\x20\x73\x65\x72\x69\x65\x73\x1E\x20\x20\x1F\x61\x49"
  "\x6E\x63\x6C\x75\x64\x65\x73\x20\x69\x6E\x64\x65\x78\x2E\x1E\x20"
  "\x30\x1F\x61\x49\x6E\x74\x65\x72\x6E\x65\x74\x20\x28\x43\x6F\x6D"
  "\x70\x75\x74\x65\x72\x20\x6E\x65\x74\x77\x6F\x72\x6B\x29\x1E\x20"
  "\x30\x1F\x61\x4D\x61\x69\x6C\x69\x6E\x67\x20\x6C\x69\x73\x74\x73"
  "\x2E\x1E\x31\x30\x1F\x61\x48\x61\x72\x64\x69\x65\x2C\x20\x45\x64"
  "\x77\x61\x72\x64\x20\x54\x2E\x20\x4C\x2E\x1E\x31\x30\x1F\x61\x4E"
  "\x65\x6F\x75\x2C\x20\x56\x69\x76\x69\x61\x6E\x2E\x1E\x1D"
,
  "\x30\x31\x33\x32\x34\x6E\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x38"
  "\x39\x49\x61\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x30\x39\x30"
  "\x30\x30\x30\x30\x30\x30\x38\x30\x30\x34\x31\x30\x30\x30\x30\x39"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x35\x30\x30\x31\x30\x30"
  "\x30\x31\x33\x30\x30\x30\x36\x37\x30\x33\x37\x30\x30\x32\x33\x30"
  "\x30\x30\x38\x30\x30\x34\x33\x30\x30\x31\x32\x30\x30\x31\x30\x33"
  "\x30\x37\x34\x30\x30\x31\x39\x30\x30\x31\x31\x35\x30\x38\x36\x30"
  "\x30\x32\x32\x30\x30\x31\x33\x34\x30\x34\x39\x30\x30\x30\x39\x30"
  "\x30\x31\x35\x36\x32\x34\x35\x30\x30\x36\x32\x30\x30\x31\x36\x35"
  "\x32\x36\x30\x30\x31\x34\x35\x30\x30\x32\x32\x37\x33\x30\x30\x30"
  "\x30\x32\x35\x30\x30\x33\x37\x32\x35\x30\x30\x30\x30\x38\x30\x30"
  "\x30\x33\x39\x37\x35\x30\x30\x30\x32\x32\x31\x30\x30\x34\x37\x37"
  "\x35\x30\x30\x30\x30\x35\x35\x30\x30\x36\x39\x38\x35\x30\x30\x30"
  "\x30\x32\x31\x30\x30\x37\x35\x33\x35\x30\x30\x30\x30\x32\x32\x30"
  "\x30\x37\x37\x34\x36\x31\x30\x30\x30\x36\x31\x30\x30\x37\x39\x36"
  "\x36\x35\x30\x30\x30\x34\x33\x30\x30\x38\x35\x37\x36\x35\x30\x30"
  "\x30\x34\x35\x30\x30\x39\x30\x30\x37\x30\x30\x30\x30\x32\x31\x30"
  "\x30\x39\x34\x35\x37\x31\x30\x30\x30\x36\x38\x30\x30\x39\x36\x36"
  "\x1E\x41\x43\x44\x2D\x32\x37\x32\x38\x1E\x39\x31\x30\x35\x31\x34"
  "\x73\x31\x39\x38\x34\x20\x20\x20\x20\x6E\x79\x75\x20\x20\x20\x20"
  "\x20\x20\x72\x20\x20\x20\x66\x30\x30\x31\x30\x30\x20\x65\x6E\x67"
  "\x20\x64\x1E\x31\x39\x39\x31\x30\x35\x31\x39\x31\x34\x34\x35\x35"
  "\x31\x2E\x30\x1E\x20\x20\x1F\x6F\x32\x33\x37\x34\x30\x30\x30\x32"
  "\x1E\x20\x20\x1F\x61\x45\x44\x20\x45\x44\x20\x32\x38\x39\x34\x35"
  "\x39\x1F\x62\x45\x52\x49\x43\x1E\x20\x20\x1F\x61\x6E\x2D\x75\x73"
  "\x2D\x2D\x2D\x1E\x20\x20\x1F\x61\x30\x34\x36\x36\x2D\x41\x2D\x30"
  "\x33\x20\x28\x4D\x46\x29\x1E\x30\x20\x1F\x61\x45\x44\x20\x31\x2E"
  "\x33\x31\x30\x2F\x32\x3A\x32\x38\x39\x34\x35\x39\x1E\x20\x20\x1F"
  "\x61\x44\x52\x55\x47\x1E\x30\x30\x1F\x61\x54\x65\x63\x68\x6E\x6F"
  "\x6C\x6F\x67\x79\x20\x70\x72\x6F\x67\x72\x61\x6D\x73\x20\x74\x68"
  "\x61\x74\x20\x77\x6F\x72\x6B\x20\x2F\x1F\x63\x4D\x69\x63\x68\x61"
  "\x65\x6C\x20\x42\x2E\x20\x57\x65\x62\x62\x2C\x20\x65\x64\x69\x74"
  "\x6F\x72\x2E\x1E\x30\x20\x1F\x61\x4E\x65\x77\x20\x59\x6F\x72\x6B"
  "\x2C\x20\x4E\x2E\x59\x2E\x20\x3A\x1F\x62\x54\x65\x63\x68\x6E\x6F"
  "\x6C\x6F\x67\x79\x20\x66\x6F\x72\x20\x74\x68\x65\x20\x4E\x44\x4E"
  "\x20\x50\x72\x6F\x6A\x65\x63\x74\x2C\x20\x49\x6E\x73\x74\x69\x74"
  "\x75\x74\x65\x20\x66\x6F\x72\x20\x55\x72\x62\x61\x6E\x20\x61\x6E"
  "\x64\x20\x4D\x69\x6E\x6F\x72\x69\x74\x79\x20\x45\x64\x75\x63\x61"
  "\x74\x69\x6F\x6E\x2C\x20\x54\x65\x61\x63\x68\x65\x72\x73\x20\x43"
  "\x6F\x6C\x6C\x65\x67\x65\x2C\x20\x43\x6F\x6C\x75\x6D\x62\x69\x61"
  "\x20\x55\x6E\x69\x76\x65\x72\x73\x69\x74\x79\x2C\x1F\x63\x5B\x31"
  "\x39\x38\x34\x5D\x1E\x20\x20\x1F\x61\x37\x32\x2C\x20\x5B\x31\x5D"
  "\x20\x70\x2E\x20\x3B\x1F\x63\x32\x38\x20\x63\x6D\x2E\x1E\x20\x20"
  "\x1F\x61\x22\x53\x70\x6F\x6E\x73\x20\x61\x67\x65\x6E\x63\x79\x20"
  "\x4F\x66\x66\x69\x63\x65\x20\x6F\x66\x20\x45\x64\x75\x63\x61\x74"
  "\x69\x6F\x6E\x61\x6C\x20\x52\x65\x73\x65\x61\x72\x63\x68\x20\x61"
  "\x6E\x64\x20\x49\x6D\x70\x72\x6F\x76\x65\x6D\x65\x6E\x74\x22\x2D"
  "\x2D\x44\x6F\x63\x2E\x20\x72\x65\x73\x75\x6D\x65\x2E\x1E\x20\x20"
  "\x1F\x61\x22\x54\x68\x69\x73\x20\x64\x69\x72\x65\x63\x74\x6F\x72"
  "\x79\x20\x77\x61\x73\x20\x64\x65\x76\x65\x6C\x6F\x70\x65\x64\x20"
  "\x62\x79\x20\x74\x68\x65\x20\x54\x65\x63\x68\x6E\x6F\x6C\x6F\x67"
  "\x79\x20\x66\x6F\x72\x20\x74\x68\x65\x20\x4E\x61\x74\x69\x6F\x6E"
  "\x61\x6C\x20\x44\x69\x66\x66\x75\x73\x69\x6F\x6E\x20\x4E\x65\x74"
  "\x77\x6F\x72\x6B\x20\x50\x72\x6F\x6A\x65\x63\x74\x2C\x20\x54\x65"
  "\x61\x63\x68\x65\x72\x73\x20\x43\x6F\x6C\x6C\x65\x67\x65\x2C\x20"
  "\x43\x6F\x6C\x75\x6D\x62\x69\x61\x20\x55\x6E\x69\x76\x65\x72\x73"
  "\x69\x74\x79\x20\x70\x75\x72\x73\x75\x61\x6E\x74\x20\x74\x6F\x20"
  "\x63\x6F\x6E\x74\x72\x61\x63\x74\x20\x6E\x75\x6D\x62\x65\x72\x20"
  "\x4F\x45\x2D\x33\x30\x30\x2D\x38\x33\x2D\x30\x32\x35\x33\x2C\x20"
  "\x55\x2E\x53\x2E\x20\x44\x65\x70\x61\x72\x74\x6D\x65\x6E\x74\x20"
  "\x6F\x66\x20\x45\x64\x75\x63\x61\x74\x69\x6F\x6E\x22\x2D\x2D\x54"
  "\x2E\x70\x2E\x20\x76\x65\x72\x73\x6F\x2E\x1E\x20\x20\x1F\x61\x44"
  "\x69\x73\x74\x72\x69\x62\x75\x74\x65\x64\x20\x74\x6F\x20\x64\x65"
  "\x70\x6F\x73\x69\x74\x6F\x72\x79\x20\x6C\x69\x62\x72\x61\x72\x69"
  "\x65\x73\x20\x69\x6E\x20\x6D\x69\x63\x72\x6F\x66\x69\x63\x68\x65"
  "\x2E\x1E\x20\x20\x1F\x61\x22\x44\x65\x63\x65\x6D\x62\x65\x72\x20"
  "\x31\x39\x38\x34\x2E\x22\x1E\x20\x20\x1F\x61\x49\x6E\x63\x6C\x75"
  "\x64\x65\x73\x20\x69\x6E\x64\x65\x78\x65\x73\x2E\x1E\x31\x30\x1F"
  "\x61\x55\x6E\x69\x74\x65\x64\x20\x53\x74\x61\x74\x65\x73\x2E\x1F"
  "\x62\x4E\x61\x74\x69\x6F\x6E\x61\x6C\x20\x44\x69\x66\x66\x75\x73"
  "\x69\x6F\x6E\x20\x4E\x65\x74\x77\x6F\x72\x6B\x1F\x78\x44\x69\x72"
  "\x65\x63\x74\x6F\x72\x69\x65\x73\x2E\x1E\x20\x30\x1F\x61\x45\x64"
  "\x75\x63\x61\x74\x69\x6F\x6E\x61\x6C\x20\x74\x65\x63\x68\x6E\x6F"
  "\x6C\x6F\x67\x79\x1F\x7A\x55\x6E\x69\x74\x65\x64\x20\x53\x74\x61"
  "\x74\x65\x73\x2E\x1E\x20\x30\x1F\x61\x46\x65\x64\x65\x72\x61\x6C"
  "\x20\x61\x69\x64\x20\x74\x6F\x20\x65\x64\x75\x63\x61\x74\x69\x6F"
  "\x6E\x1F\x7A\x55\x6E\x69\x74\x65\x64\x20\x53\x74\x61\x74\x65\x73"
  "\x2E\x1E\x31\x30\x1F\x61\x57\x65\x62\x62\x2C\x20\x4D\x69\x63\x68"
  "\x61\x65\x6C\x20\x42\x2E\x1E\x31\x30\x1F\x61\x55\x6E\x69\x74\x65"
  "\x64\x20\x53\x74\x61\x74\x65\x73\x2E\x1F\x62\x4F\x66\x66\x69\x63"
  "\x65\x20\x6F\x66\x20\x45\x64\x75\x63\x61\x74\x69\x6F\x6E\x61\x6C"
  "\x20\x52\x65\x73\x65\x61\x72\x63\x68\x20\x61\x6E\x64\x20\x49\x6D"
  "\x70\x72\x6F\x76\x65\x6D\x65\x6E\x74\x2E\x1E\x1D"
,
  "\x30\x31\x35\x35\x39\x6E\x61\x6D\x20\x20\x32\x32\x30\x30\x33\x37"
  "\x33\x49\x61\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x30\x39\x30"
  "\x30\x30\x30\x30\x30\x30\x38\x30\x30\x34\x31\x30\x30\x30\x30\x39"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x35\x30\x30\x31\x30\x30"
  "\x30\x31\x33\x30\x30\x30\x36\x37\x30\x33\x37\x30\x30\x32\x30\x30"
  "\x30\x30\x38\x30\x30\x34\x33\x30\x30\x31\x32\x30\x30\x31\x30\x30"
  "\x30\x37\x34\x30\x30\x31\x39\x30\x30\x31\x31\x32\x30\x38\x36\x30"
  "\x30\x32\x32\x30\x30\x31\x33\x31\x30\x38\x38\x30\x30\x31\x36\x30"
  "\x30\x31\x35\x33\x30\x34\x39\x30\x30\x30\x39\x30\x30\x31\x36\x39"
  "\x31\x30\x30\x30\x30\x32\x32\x30\x30\x31\x37\x38\x32\x34\x35\x30"
  "\x32\x35\x39\x30\x30\x32\x30\x30\x32\x36\x30\x30\x31\x30\x35\x30"
  "\x30\x34\x35\x39\x33\x30\x30\x30\x30\x33\x33\x30\x30\x35\x36\x34"
  "\x35\x30\x30\x30\x30\x35\x35\x30\x30\x35\x39\x37\x35\x30\x30\x30"
  "\x30\x31\x37\x30\x30\x36\x35\x32\x35\x30\x34\x30\x30\x34\x31\x30"
  "\x30\x36\x36\x39\x35\x30\x30\x30\x30\x31\x38\x30\x30\x37\x31\x30"
  "\x36\x35\x30\x30\x30\x34\x34\x30\x30\x37\x32\x38\x36\x35\x30\x30"
  "\x30\x34\x34\x30\x30\x37\x37\x32\x36\x35\x30\x30\x30\x33\x37\x30"
  "\x30\x38\x31\x36\x36\x35\x30\x30\x30\x35\x32\x30\x30\x38\x35\x33"
  "\x36\x35\x30\x30\x30\x33\x37\x30\x30\x39\x30\x35\x37\x30\x30\x30"
  "\x30\x34\x34\x30\x30\x39\x34\x32\x37\x30\x30\x30\x30\x32\x35\x30"
  "\x30\x39\x38\x36\x37\x31\x30\x30\x30\x34\x38\x30\x31\x30\x31\x31"
  "\x37\x31\x30\x30\x30\x33\x30\x30\x31\x30\x35\x39\x37\x31\x30\x30"
  "\x30\x36\x38\x30\x31\x30\x38\x39\x37\x34\x30\x30\x30\x32\x38\x30"
  "\x31\x31\x35\x37\x1E\x41\x43\x44\x2D\x32\x34\x37\x36\x1E\x39\x31"
  "\x30\x34\x32\x35\x73\x31\x39\x38\x37\x20\x20\x20\x20\x64\x63\x75"
  "\x61\x20\x20\x20\x20\x20\x62\x20\x20\x20\x66\x30\x30\x30\x31\x30"
  "\x20\x65\x6E\x67\x20\x64\x1E\x31\x39\x39\x31\x30\x35\x31\x39\x31"
  "\x34\x34\x35\x35\x31\x2E\x30\x1E\x20\x20\x1F\x6F\x32\x33\x36\x30"
  "\x32\x33\x38\x39\x1E\x20\x20\x1F\x61\x45\x44\x20\x32\x38\x38\x35"
  "\x32\x39\x1F\x62\x45\x52\x49\x43\x1E\x20\x20\x1F\x61\x6E\x2D\x75"
  "\x73\x2D\x2D\x2D\x1E\x20\x20\x1F\x61\x30\x34\x36\x36\x2D\x41\x2D"
  "\x30\x33\x20\x28\x4D\x46\x29\x1E\x30\x20\x1F\x61\x45\x44\x20\x31"
  "\x2E\x33\x31\x30\x2F\x32\x3A\x32\x38\x38\x35\x32\x39\x1E\x20\x20"
  "\x1F\x61\x4C\x50\x20\x38\x37\x2D\x34\x30\x33\x20\x63\x1E\x20\x20"
  "\x1F\x61\x44\x52\x55\x47\x1E\x31\x30\x1F\x61\x53\x65\x61\x67\x65"
  "\x72\x2C\x20\x41\x6E\x64\x72\x65\x77\x20\x4A\x2E\x1E\x31\x30\x1F"
  "\x61\x43\x68\x65\x63\x6B\x20\x74\x68\x69\x73\x20\x6F\x75\x74\x20"
  "\x3A\x1F\x62\x6C\x69\x62\x72\x61\x72\x79\x20\x70\x72\x6F\x67\x72"
  "\x61\x6D\x20\x6D\x6F\x64\x65\x6C\x73\x20\x2F\x1F\x63\x70\x72\x65"
  "\x70\x61\x72\x65\x64\x20\x62\x79\x20\x41\x6E\x64\x72\x65\x77\x20"
  "\x4A\x2E\x20\x53\x65\x61\x67\x65\x72\x2C\x20\x53\x61\x72\x61\x68"
  "\x20\x4A\x2E\x20\x52\x6F\x62\x65\x72\x74\x73\x2C\x20\x43\x61\x72"
  "\x6F\x6C\x20\x5A\x2E\x20\x4C\x69\x6E\x63\x6F\x6C\x6E\x20\x3B\x20"
  "\x70\x72\x65\x70\x61\x72\x65\x64\x20\x66\x6F\x72\x20\x4E\x61\x74"
  "\x69\x6F\x6E\x61\x6C\x20\x44\x69\x66\x66\x75\x73\x69\x6F\x6E\x20"
  "\x4E\x65\x74\x77\x6F\x72\x6B\x20\x75\x6E\x64\x65\x72\x20\x63\x6F"
  "\x6E\x74\x72\x61\x63\x74\x20\x74\x6F\x20\x52\x4D\x43\x20\x43\x6F"
  "\x72\x70\x6F\x72\x61\x74\x69\x6F\x6E\x2C\x20\x63\x6F\x6E\x74\x72"
  "\x61\x63\x74\x20\x33\x30\x30\x2D\x38\x34\x2D\x30\x32\x35\x31\x20"
  "\x77\x69\x74\x68\x20\x74\x68\x65\x20\x55\x6E\x69\x74\x65\x64\x20"
  "\x53\x74\x61\x74\x65\x73\x20\x44\x65\x70\x61\x72\x74\x6D\x65\x6E"
  "\x74\x20\x6F\x66\x20\x45\x64\x75\x63\x61\x74\x69\x6F\x6E\x2E\x1E"
  "\x30\x20\x1F\x61\x57\x61\x73\x68\x69\x6E\x67\x74\x6F\x6E\x2C\x20"
  "\x44\x2E\x43\x2E\x20\x3A\x1F\x62\x4F\x66\x66\x69\x63\x65\x20\x6F"
  "\x66\x20\x45\x64\x75\x63\x61\x74\x69\x6F\x6E\x61\x6C\x20\x52\x65"
  "\x73\x65\x61\x72\x63\x68\x20\x61\x6E\x64\x20\x49\x6D\x70\x72\x6F"
  "\x76\x65\x6D\x65\x6E\x74\x2C\x20\x55\x2E\x53\x2E\x20\x44\x65\x70"
  "\x74\x2E\x20\x6F\x66\x20\x45\x64\x75\x63\x61\x74\x69\x6F\x6E\x2C"
  "\x1F\x63\x5B\x31\x39\x38\x37\x5D\x1E\x20\x20\x1F\x61\x69\x78\x2C"
  "\x20\x33\x31\x39\x20\x70\x2E\x20\x3A\x1F\x62\x69\x6C\x6C\x2E\x20"
  "\x3B\x1F\x63\x32\x38\x20\x63\x6D\x2E\x1E\x20\x20\x1F\x61\x44\x69"
  "\x73\x74\x72\x69\x62\x75\x74\x65\x64\x20\x74\x6F\x20\x64\x65\x70"
  "\x6F\x73\x69\x74\x6F\x72\x79\x20\x6C\x69\x62\x72\x61\x72\x69\x65"
  "\x73\x20\x69\x6E\x20\x6D\x69\x63\x72\x6F\x66\x69\x63\x68\x65\x2E"
  "\x1E\x20\x20\x1F\x61\x22\x4A\x75\x6C\x79\x20\x31\x39\x38\x37\x2E"
  "\x22\x1E\x20\x20\x1F\x61\x49\x6E\x63\x6C\x75\x64\x65\x73\x20\x62"
  "\x69\x62\x6C\x69\x6F\x67\x72\x61\x70\x68\x69\x63\x61\x6C\x20\x72"
  "\x65\x66\x65\x72\x65\x6E\x63\x65\x73\x2E\x1E\x20\x20\x1F\x61\x22"
  "\x4C\x50\x20\x38\x37\x2D\x34\x30\x33\x63\x2E\x22\x1E\x20\x30\x1F"
  "\x61\x4C\x69\x62\x72\x61\x72\x69\x65\x73\x20\x61\x6E\x64\x20\x63"
  "\x6F\x6D\x6D\x75\x6E\x69\x74\x79\x1F\x7A\x55\x6E\x69\x74\x65\x64"
  "\x20\x53\x74\x61\x74\x65\x73\x2E\x1E\x20\x30\x1F\x61\x4C\x69\x62"
  "\x72\x61\x72\x69\x65\x73\x20\x61\x6E\x64\x20\x65\x64\x75\x63\x61"
  "\x74\x69\x6F\x6E\x1F\x7A\x55\x6E\x69\x74\x65\x64\x20\x53\x74\x61"
  "\x74\x65\x73\x2E\x1E\x20\x30\x1F\x61\x53\x63\x68\x6F\x6F\x6C\x20"
  "\x6C\x69\x62\x72\x61\x72\x69\x65\x73\x1F\x7A\x55\x6E\x69\x74\x65"
  "\x64\x20\x53\x74\x61\x74\x65\x73\x2E\x1E\x20\x30\x1F\x61\x49\x6E"
  "\x73\x74\x72\x75\x63\x74\x69\x6F\x6E\x61\x6C\x20\x6D\x61\x74\x65"
  "\x72\x69\x61\x6C\x73\x20\x63\x65\x6E\x74\x65\x72\x73\x1F\x7A\x55"
  "\x6E\x69\x74\x65\x64\x20\x53\x74\x61\x74\x65\x73\x2E\x1E\x20\x30"
  "\x1F\x61\x50\x75\x62\x6C\x69\x63\x20\x6C\x69\x62\x72\x61\x72\x69"
  "\x65\x73\x1F\x7A\x55\x6E\x69\x74\x65\x64\x20\x53\x74\x61\x74\x65"
  "\x73\x2E\x1E\x31\x30\x1F\x61\x52\x6F\x62\x65\x72\x74\x73\x2C\x20"
  "\x53\x61\x72\x61\x68\x20\x4A\x2E\x1F\x71\x28\x53\x61\x72\x61\x68"
  "\x20\x4A\x61\x6E\x65\x29\x2C\x1F\x64\x31\x39\x34\x36\x2D\x1E\x31"
  "\x30\x1F\x61\x4C\x69\x6E\x63\x6F\x6C\x6E\x2C\x20\x43\x61\x72\x6F"
  "\x6C\x20\x5A\x61\x6C\x6C\x2E\x1E\x31\x30\x1F\x61\x55\x6E\x69\x74"
  "\x65\x64\x20\x53\x74\x61\x74\x65\x73\x2E\x1F\x62\x4E\x61\x74\x69"
  "\x6F\x6E\x61\x6C\x20\x44\x69\x66\x66\x75\x73\x69\x6F\x6E\x20\x4E"
  "\x65\x74\x77\x6F\x72\x6B\x2E\x1E\x32\x30\x1F\x61\x52\x4D\x43\x20"
  "\x52\x65\x73\x65\x61\x72\x63\x68\x20\x43\x6F\x72\x70\x6F\x72\x61"
  "\x74\x69\x6F\x6E\x2E\x1E\x31\x30\x1F\x61\x55\x6E\x69\x74\x65\x64"
  "\x20\x53\x74\x61\x74\x65\x73\x2E\x1F\x62\x4F\x66\x66\x69\x63\x65"
  "\x20\x6F\x66\x20\x45\x64\x75\x63\x61\x74\x69\x6F\x6E\x61\x6C\x20"
  "\x52\x65\x73\x65\x61\x72\x63\x68\x20\x61\x6E\x64\x20\x49\x6D\x70"
  "\x72\x6F\x76\x65\x6D\x65\x6E\x74\x2E\x1E\x30\x31\x1F\x61\x4C\x69"
  "\x62\x72\x61\x72\x79\x20\x70\x72\x6F\x67\x72\x61\x6D\x20\x6D\x6F"
  "\x64\x65\x6C\x73\x2E\x1E\x1D"
,
  "\x30\x31\x31\x35\x35\x6E\x61\x73\x20\x20\x32\x32\x30\x30\x33\x31"
  "\x33\x35\x61\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x30\x39\x30"
  "\x30\x30\x30\x30\x30\x30\x38\x30\x30\x34\x31\x30\x30\x30\x30\x39"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x35\x30\x30\x31\x30\x30"
  "\x30\x32\x37\x30\x30\x30\x36\x37\x30\x34\x30\x30\x30\x30\x38\x30"
  "\x30\x30\x39\x34\x30\x31\x32\x30\x30\x31\x32\x30\x30\x31\x30\x32"
  "\x30\x34\x32\x30\x30\x30\x37\x30\x30\x31\x31\x34\x30\x35\x30\x30"
  "\x30\x31\x35\x30\x30\x31\x32\x31\x30\x37\x34\x30\x30\x31\x31\x30"
  "\x30\x31\x33\x36\x30\x38\x36\x30\x30\x32\x30\x30\x30\x31\x34\x37"
  "\x30\x34\x39\x30\x30\x30\x39\x30\x30\x31\x36\x37\x32\x31\x32\x30"
  "\x30\x38\x33\x30\x30\x31\x37\x36\x32\x34\x35\x30\x30\x36\x39\x30"
  "\x30\x32\x35\x39\x32\x36\x30\x30\x31\x31\x35\x30\x30\x33\x32\x38"
  "\x32\x36\x35\x30\x30\x37\x31\x30\x30\x34\x34\x33\x33\x30\x30\x30"
  "\x30\x31\x37\x30\x30\x35\x31\x34\x33\x31\x30\x30\x30\x31\x31\x30"
  "\x30\x35\x33\x31\x35\x30\x30\x30\x30\x33\x32\x30\x30\x35\x34\x32"
  "\x36\x31\x30\x30\x30\x33\x36\x30\x30\x35\x37\x34\x36\x35\x30\x30"
  "\x30\x36\x32\x30\x30\x36\x31\x30\x36\x35\x30\x30\x30\x36\x34\x30"
  "\x30\x36\x37\x32\x37\x31\x30\x30\x30\x32\x32\x30\x30\x37\x33\x36"
  "\x37\x31\x30\x30\x30\x37\x30\x30\x30\x37\x35\x38\x39\x33\x36\x30"
  "\x30\x31\x33\x30\x30\x38\x32\x38\x1E\x41\x43\x44\x2D\x32\x33\x37"
  "\x36\x1E\x39\x31\x30\x32\x32\x35\x63\x31\x39\x75\x75\x39\x39\x39"
  "\x39\x64\x63\x75\x61\x72\x20\x20\x20\x20\x20\x20\x20\x20\x66\x30"
  "\x75\x75\x75\x20\x30\x65\x6E\x67\x20\x20\x1E\x31\x39\x39\x31\x30"
  "\x35\x31\x39\x31\x34\x34\x35\x35\x31\x2E\x30\x1E\x20\x20\x1F\x61"
  "\x20\x20\x20\x39\x31\x36\x35\x36\x30\x36\x30\x20\x1F\x6F\x32\x33"
  "\x31\x35\x30\x38\x34\x37\x1E\x20\x20\x1F\x64\x47\x50\x4F\x1E\x20"
  "\x20\x1F\x61\x32\x1F\x69\x39\x31\x30\x33\x1E\x20\x20\x1F\x61\x6C"
  "\x63\x1E\x30\x30\x1F\x61\x49\x4E\x20\x50\x52\x4F\x43\x45\x53\x53"
  "\x1E\x20\x20\x1F\x61\x30\x37\x38\x35\x2D\x48\x1E\x30\x20\x1F\x61"
  "\x4C\x43\x20\x31\x2E\x34\x30\x2F\x32\x3A\x46\x20\x33\x31\x2F\x1E"
  "\x20\x20\x1F\x61\x44\x52\x55\x47\x1E\x30\x20\x1F\x61\x46\x65\x64"
  "\x65\x72\x61\x6C\x20\x4C\x69\x62\x72\x61\x72\x79\x20\x61\x6E\x64"
  "\x20\x49\x6E\x66\x6F\x72\x6D\x61\x74\x69\x6F\x6E\x20\x4E\x65\x74"
  "\x77\x6F\x72\x6B\x20\x73\x65\x72\x76\x69\x63\x65\x73\x20\x64\x69"
  "\x72\x65\x63\x74\x6F\x72\x79\x20\x66\x6F\x72\x20\x66\x69\x73\x63"
  "\x61\x6C\x20\x79\x65\x61\x72\x20\x2E\x2E\x2E\x1E\x30\x30\x1F\x61"
  "\x46\x45\x44\x4C\x49\x4E\x4B\x20\x73\x65\x72\x76\x69\x63\x65\x73"
  "\x20\x64\x69\x72\x65\x63\x74\x6F\x72\x79\x20\x66\x6F\x72\x20\x66"
  "\x69\x73\x63\x61\x6C\x20\x79\x65\x61\x72\x20\x2E\x2E\x2E\x20\x2F"
  "\x1F\x63\x46\x4C\x49\x43\x43\x2F\x46\x45\x44\x4C\x49\x4E\x4B\x2E"
  "\x1E\x30\x30\x1F\x61\x57\x61\x73\x68\x69\x6E\x67\x74\x6F\x6E\x2C"
  "\x20\x44\x2E\x43\x2E\x20\x3A\x1F\x62\x46\x65\x64\x65\x72\x61\x6C"
  "\x20\x4C\x69\x62\x72\x61\x72\x79\x20\x61\x6E\x64\x20\x49\x6E\x66"
  "\x6F\x72\x6D\x61\x74\x69\x6F\x6E\x20\x4E\x65\x74\x77\x6F\x72\x6B"
  "\x2C\x20\x46\x65\x64\x65\x72\x61\x6C\x20\x4C\x69\x62\x72\x61\x72"
  "\x79\x20\x61\x6E\x64\x20\x49\x6E\x66\x6F\x72\x6D\x61\x74\x69\x6F"
  "\x6E\x20\x43\x65\x6E\x74\x65\x72\x20\x43\x6F\x6D\x6D\x69\x74\x74"
  "\x65\x65\x2C\x1E\x20\x20\x1F\x61\x46\x45\x44\x4C\x49\x4E\x4B\x2C"
  "\x20\x52\x6F\x6F\x6D\x20\x4C\x41\x20\x31\x30\x32\x36\x43\x2C\x20"
  "\x4C\x69\x62\x72\x61\x72\x79\x20\x6F\x66\x20\x43\x6F\x6E\x67\x72"
  "\x65\x73\x73\x2C\x20\x57\x61\x73\x68\x69\x6E\x67\x74\x6F\x6E\x20"
  "\x44\x2E\x43\x2E\x20\x32\x30\x35\x34\x30\x1E\x20\x20\x1F\x61\x76"
  "\x2E\x20\x3B\x1F\x63\x32\x38\x20\x63\x6D\x2E\x1E\x20\x20\x1F\x61"
  "\x41\x6E\x6E\x75\x61\x6C\x1E\x20\x20\x1F\x61\x44\x65\x73\x63\x72"
  "\x69\x70\x74\x69\x6F\x6E\x20\x62\x61\x73\x65\x64\x20\x6F\x6E\x3A"
  "\x20\x31\x39\x39\x30\x2E\x1E\x32\x30\x1F\x61\x46\x45\x44\x4C\x49"
  "\x4E\x4B\x20\x28\x4E\x65\x74\x77\x6F\x72\x6B\x29\x1F\x78\x44\x69"
  "\x72\x65\x63\x74\x6F\x72\x69\x65\x73\x2E\x1E\x20\x30\x1F\x61\x4C"
  "\x69\x62\x72\x61\x72\x79\x20\x69\x6E\x66\x6F\x72\x6D\x61\x74\x69"
  "\x6F\x6E\x20\x6E\x65\x74\x77\x6F\x72\x6B\x73\x1F\x7A\x55\x6E\x69"
  "\x74\x65\x64\x20\x53\x74\x61\x74\x65\x73\x1F\x78\x44\x69\x72\x65"
  "\x63\x74\x6F\x72\x69\x65\x73\x2E\x1E\x20\x30\x1F\x61\x4C\x69\x62"
  "\x72\x61\x72\x69\x65\x73\x2C\x20\x47\x6F\x76\x65\x72\x6E\x6D\x65"
  "\x6E\x74\x61\x6C\x2C\x20\x61\x64\x6D\x69\x6E\x69\x73\x74\x72\x61"
  "\x74\x69\x76\x65\x2C\x20\x65\x74\x63\x2E\x1F\x78\x50\x65\x72\x69"
  "\x6F\x64\x69\x63\x61\x6C\x73\x2E\x1E\x32\x30\x1F\x61\x46\x45\x44"
  "\x4C\x49\x4E\x4B\x20\x28\x4E\x65\x74\x77\x6F\x72\x6B\x29\x1E\x32"
  "\x30\x1F\x61\x55\x6E\x69\x74\x65\x64\x20\x53\x74\x61\x74\x65\x73"
  "\x2E\x1F\x62\x46\x65\x64\x65\x72\x61\x6C\x20\x4C\x69\x62\x72\x61"
  "\x72\x79\x20\x61\x6E\x64\x20\x49\x6E\x66\x6F\x72\x6D\x61\x74\x69"
  "\x6F\x6E\x20\x43\x65\x6E\x74\x65\x72\x20\x43\x6F\x6D\x6D\x69\x74"
  "\x74\x65\x65\x2E\x1E\x20\x20\x1F\x61\x31\x39\x39\x31\x20\x4C\x49"
  "\x43\x1E\x1D"
,
  "\x30\x30\x39\x31\x35\x6E\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x32"
  "\x39\x4B\x61\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x30\x39\x30"
  "\x30\x30\x30\x30\x30\x30\x38\x30\x30\x34\x31\x30\x30\x30\x30\x39"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x35\x30\x30\x31\x30\x30"
  "\x30\x31\x33\x30\x30\x30\x36\x37\x30\x34\x30\x30\x30\x31\x33\x30"
  "\x30\x30\x38\x30\x30\x33\x37\x30\x30\x32\x30\x30\x30\x30\x39\x33"
  "\x30\x37\x34\x30\x30\x31\x39\x30\x30\x31\x31\x33\x30\x38\x36\x30"
  "\x30\x32\x32\x30\x30\x31\x33\x32\x30\x34\x39\x30\x30\x30\x39\x30"
  "\x30\x31\x35\x34\x31\x30\x30\x30\x30\x31\x38\x30\x30\x31\x36\x33"
  "\x32\x34\x35\x30\x31\x35\x37\x30\x30\x31\x38\x31\x32\x36\x30\x30"
  "\x31\x32\x34\x30\x30\x33\x33\x38\x33\x30\x30\x30\x30\x30\x39\x30"
  "\x30\x34\x36\x32\x35\x33\x33\x30\x30\x39\x33\x30\x30\x34\x37\x31"
  "\x35\x30\x30\x30\x30\x35\x35\x30\x30\x35\x36\x34\x36\x35\x30\x30"
  "\x30\x31\x34\x30\x30\x36\x31\x39\x37\x31\x30\x30\x30\x35\x32\x30"
  "\x30\x36\x33\x33\x1E\x41\x43\x44\x2D\x31\x39\x34\x39\x1E\x39\x31"
  "\x30\x34\x31\x35\x72\x31\x39\x39\x30\x31\x30\x38\x37\x64\x63\x75"
  "\x20\x20\x20\x20\x20\x62\x20\x20\x20\x20\x66\x30\x30\x30\x31\x30"
  "\x20\x65\x6E\x67\x20\x64\x1E\x31\x39\x39\x31\x30\x34\x32\x31\x31"
  "\x32\x32\x35\x34\x31\x2E\x30\x1E\x20\x20\x1F\x6F\x32\x33\x34\x36"
  "\x39\x32\x36\x31\x1E\x20\x20\x1F\x61\x47\x50\x4F\x1F\x63\x47\x50"
  "\x4F\x1E\x20\x20\x1F\x61\x45\x44\x20\x32\x38\x36\x39\x39\x32\x1F"
  "\x62\x45\x52\x49\x43\x1E\x20\x20\x1F\x61\x30\x34\x36\x36\x2D\x41"
  "\x2D\x30\x33\x20\x28\x4D\x46\x29\x1E\x30\x20\x1F\x61\x45\x44\x20"
  "\x31\x2E\x33\x31\x30\x2F\x32\x3A\x32\x38\x36\x39\x39\x32\x1E\x20"
  "\x20\x1F\x61\x44\x52\x55\x47\x1E\x31\x30\x1F\x61\x50\x61\x75\x6C"
  "\x75\x2C\x20\x4E\x61\x6E\x63\x79\x2E\x1E\x31\x30\x1F\x61\x44\x65"
  "\x61\x6C\x69\x6E\x67\x20\x77\x69\x74\x68\x20\x64\x72\x6F\x70\x6F"
  "\x75\x74\x73\x1F\x68\x6D\x69\x63\x72\x6F\x66\x6F\x72\x6D\x20\x3A"
  "\x1F\x62\x74\x68\x65\x20\x75\x72\x62\x61\x6E\x20\x73\x75\x70\x65"
  "\x72\x69\x6E\x74\x65\x6E\x64\x65\x6E\x74\x73\x27\x20\x63\x61\x6C"
  "\x6C\x20\x74\x6F\x20\x61\x63\x74\x69\x6F\x6E\x20\x2F\x1F\x63\x62"
  "\x79\x20\x74\x68\x65\x20\x4F\x45\x52\x49\x20\x55\x72\x62\x61\x6E"
  "\x20\x53\x75\x70\x65\x72\x69\x6E\x74\x65\x6E\x64\x65\x6E\x74\x73"
  "\x20\x4E\x65\x74\x77\x6F\x72\x6B\x20\x3B\x20\x4E\x61\x6E\x63\x79"
  "\x20\x50\x61\x75\x6C\x75\x2C\x20\x77\x72\x69\x74\x65\x72\x2D\x65"
  "\x64\x69\x74\x6F\x72\x2E\x1E\x30\x20\x1F\x61\x5B\x57\x61\x73\x68"
  "\x69\x6E\x67\x74\x6F\x6E\x2C\x20\x44\x2E\x43\x5D\x2E\x20\x3A\x1F"
  "\x62\x4F\x66\x66\x69\x63\x65\x20\x6F\x66\x20\x45\x64\x75\x63\x61"
  "\x74\x69\x6F\x6E\x61\x6C\x20\x52\x65\x73\x65\x61\x72\x63\x68\x20"
  "\x61\x6E\x64\x20\x49\x6D\x70\x72\x6F\x76\x65\x6D\x65\x6E\x74\x2C"
  "\x20\x45\x64\x75\x63\x61\x74\x69\x6F\x6E\x61\x6C\x20\x52\x65\x73"
  "\x6F\x75\x72\x63\x65\x73\x20\x49\x6E\x66\x6F\x72\x6D\x61\x74\x69"
  "\x6F\x6E\x20\x43\x65\x6E\x74\x65\x72\x2C\x1F\x63\x5B\x31\x39\x38"
  "\x37\x5D\x1E\x20\x20\x1F\x61\x31\x20\x76\x2E\x1E\x20\x20\x1F\x61"
  "\x4D\x69\x63\x72\x6F\x66\x69\x63\x68\x65\x2E\x1F\x62\x5B\x57\x61"
  "\x73\x68\x69\x6E\x67\x74\x6F\x6E\x2C\x20\x44\x2E\x43\x2E\x3F\x5D"
  "\x20\x3A\x1F\x63\x53\x75\x70\x74\x2E\x20\x6F\x66\x20\x44\x6F\x63"
  "\x73\x2E\x2C\x20\x55\x2E\x53\x2E\x20\x47\x2E\x50\x2E\x4F\x2E\x2C"
  "\x1F\x64\x5B\x31\x39\x39\x30\x5D\x2E\x1F\x65\x31\x20\x6D\x69\x63"
  "\x72\x6F\x66\x69\x63\x68\x65\x2E\x1E\x20\x20\x1F\x61\x44\x69\x73"
  "\x74\x72\x69\x62\x75\x74\x65\x64\x20\x74\x6F\x20\x64\x65\x70\x6F"
  "\x73\x69\x74\x6F\x72\x79\x20\x6C\x69\x62\x72\x61\x72\x69\x65\x73"
  "\x20\x69\x6E\x20\x6D\x69\x63\x72\x6F\x66\x69\x63\x68\x65\x2E\x1E"
  "\x20\x30\x1F\x61\x44\x72\x6F\x70\x6F\x75\x74\x73\x2E\x1E\x32\x30"
  "\x1F\x61\x45\x64\x75\x63\x61\x74\x69\x6F\x6E\x61\x6C\x20\x52\x65"
  "\x73\x6F\x75\x72\x63\x65\x73\x20\x49\x6E\x66\x6F\x72\x6D\x61\x74"
  "\x69\x6F\x6E\x20\x43\x65\x6E\x74\x65\x72\x20\x28\x55\x2E\x53\x2E"
  "\x29\x1E\x1D"
,
  "\x30\x31\x30\x35\x33\x6E\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x31"
  "\x37\x4B\x61\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x30\x39\x30"
  "\x30\x30\x30\x30\x30\x30\x38\x30\x30\x34\x31\x30\x30\x30\x30\x39"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x35\x30\x30\x31\x30\x30"
  "\x30\x31\x33\x30\x30\x30\x36\x37\x30\x33\x37\x30\x30\x32\x30\x30"
  "\x30\x30\x38\x30\x30\x37\x34\x30\x30\x31\x39\x30\x30\x31\x30\x30"
  "\x30\x38\x36\x30\x30\x32\x32\x30\x30\x31\x31\x39\x30\x34\x39\x30"
  "\x30\x30\x39\x30\x30\x31\x34\x31\x32\x34\x35\x30\x31\x36\x33\x30"
  "\x30\x31\x35\x30\x32\x36\x30\x30\x32\x35\x31\x30\x30\x33\x31\x33"
  "\x33\x30\x30\x30\x30\x30\x39\x30\x30\x35\x36\x34\x35\x33\x33\x30"
  "\x30\x39\x34\x30\x30\x35\x37\x33\x35\x30\x30\x30\x30\x35\x35\x30"
  "\x30\x36\x36\x37\x36\x35\x30\x30\x30\x32\x34\x30\x30\x37\x32\x32"
  "\x36\x35\x30\x30\x30\x33\x37\x30\x30\x37\x34\x36\x37\x31\x30\x30"
  "\x30\x35\x32\x30\x30\x37\x38\x33\x1E\x41\x43\x44\x2D\x31\x39\x34"
  "\x37\x1E\x39\x31\x30\x34\x31\x35\x72\x31\x39\x39\x30\x31\x39\x38"
  "\x36\x64\x63\x75\x20\x20\x20\x20\x20\x62\x20\x20\x20\x20\x66\x30"
  "\x30\x30\x31\x30\x20\x65\x6E\x67\x20\x64\x1E\x31\x39\x39\x31\x30"
  "\x34\x32\x31\x31\x32\x32\x35\x34\x31\x2E\x30\x1E\x20\x20\x1F\x6F"
  "\x32\x33\x34\x36\x39\x30\x39\x38\x1E\x20\x20\x1F\x61\x45\x44\x20"
  "\x32\x38\x36\x33\x33\x33\x1F\x62\x45\x52\x49\x43\x1E\x20\x20\x1F"
  "\x61\x30\x34\x36\x36\x2D\x41\x2D\x30\x33\x20\x28\x4D\x46\x29\x1E"
  "\x30\x20\x1F\x61\x45\x44\x20\x31\x2E\x33\x31\x30\x2F\x32\x3A\x32"
  "\x38\x36\x33\x33\x33\x1E\x20\x20\x1F\x61\x44\x52\x55\x47\x1E\x30"
  "\x30\x1F\x61\x4E\x61\x74\x69\x6F\x6E\x61\x6C\x20\x64\x69\x73\x73"
  "\x65\x6D\x69\x6E\x61\x74\x69\x6F\x6E\x20\x6D\x6F\x64\x65\x6C\x20"
  "\x66\x6F\x72\x20\x74\x68\x65\x20\x49\x27\x4D\x20\x53\x50\x45\x43"
  "\x49\x41\x4C\x20\x50\x72\x6F\x67\x72\x61\x6D\x20\x6F\x66\x20\x50"
  "\x68\x79\x73\x69\x63\x61\x6C\x20\x45\x64\x75\x63\x61\x74\x69\x6F"
  "\x6E\x20\x66\x6F\x72\x20\x74\x68\x65\x20\x48\x61\x6E\x64\x69\x63"
  "\x61\x70\x70\x65\x64\x2C\x20\x31\x39\x38\x33\x2D\x31\x39\x38\x36"
  "\x1F\x68\x6D\x69\x63\x72\x6F\x66\x6F\x72\x6D\x20\x3A\x1F\x62\x66"
  "\x69\x6E\x61\x6C\x20\x72\x65\x70\x6F\x72\x74\x2C\x20\x49\x27\x4D"
  "\x20\x53\x50\x45\x43\x49\x41\x4C\x20\x6E\x65\x74\x77\x6F\x72\x6B"
  "\x2E\x1E\x30\x20\x1F\x61\x54\x61\x6D\x70\x61\x2C\x20\x46\x6C\x61"
  "\x2E\x20\x3A\x1F\x62\x44\x65\x70\x61\x72\x74\x6D\x65\x6E\x74\x20"
  "\x6F\x66\x20\x50\x68\x79\x73\x69\x63\x61\x6C\x20\x45\x64\x75\x63"
  "\x61\x74\x69\x6F\x6E\x2C\x20\x43\x6F\x6C\x6C\x65\x67\x65\x20\x6F"
  "\x66\x20\x45\x64\x75\x63\x61\x74\x69\x6F\x6E\x2C\x20\x55\x6E\x69"
  "\x76\x65\x72\x73\x69\x74\x79\x20\x6F\x66\x20\x53\x6F\x75\x74\x68"
  "\x20\x46\x6C\x6F\x72\x69\x64\x61\x20\x3B\x1F\x61\x5B\x57\x61\x73"
  "\x68\x69\x6E\x67\x74\x6F\x6E\x2C\x20\x44\x2E\x43\x2E\x5D\x20\x3A"
  "\x1F\x62\x55\x2E\x53\x2E\x20\x44\x65\x70\x74\x2E\x20\x6F\x66\x20"
  "\x45\x64\x75\x63\x61\x74\x69\x6F\x6E\x2C\x20\x4F\x66\x66\x69\x63"
  "\x65\x20\x6F\x66\x20\x45\x64\x75\x63\x61\x74\x69\x6F\x6E\x61\x6C"
  "\x20\x52\x65\x73\x65\x61\x72\x63\x68\x20\x61\x6E\x64\x20\x49\x6D"
  "\x70\x72\x6F\x76\x65\x6D\x65\x6E\x74\x2C\x20\x45\x64\x75\x63\x61"
  "\x74\x69\x6F\x6E\x61\x6C\x20\x52\x65\x73\x6F\x75\x72\x63\x65\x73"
  "\x20\x49\x6E\x66\x6F\x72\x6D\x61\x74\x69\x6F\x6E\x20\x43\x65\x6E"
  "\x74\x65\x72\x2C\x1F\x63\x5B\x31\x39\x38\x36\x5D\x1E\x20\x20\x1F"
  "\x61\x31\x20\x76\x2E\x1E\x20\x20\x1F\x61\x4D\x69\x63\x72\x6F\x66"
  "\x69\x63\x68\x65\x2E\x1F\x62\x5B\x57\x61\x73\x68\x69\x6E\x67\x74"
  "\x6F\x6E\x2C\x20\x44\x2E\x43\x2E\x3F\x5D\x20\x3A\x1F\x63\x53\x75"
  "\x70\x74\x2E\x20\x6F\x66\x20\x44\x6F\x63\x73\x2E\x2C\x20\x55\x2E"
  "\x53\x2E\x20\x47\x2E\x50\x2E\x4F\x2E\x2C\x1F\x64\x5B\x31\x39\x39"
  "\x30\x5D\x2E\x1F\x65\x32\x20\x6D\x69\x63\x72\x6F\x66\x69\x63\x68"
  "\x65\x73\x2E\x1E\x20\x20\x1F\x61\x44\x69\x73\x74\x72\x69\x62\x75"
  "\x74\x65\x64\x20\x74\x6F\x20\x64\x65\x70\x6F\x73\x69\x74\x6F\x72"
  "\x79\x20\x6C\x69\x62\x72\x61\x72\x69\x65\x73\x20\x69\x6E\x20\x6D"
  "\x69\x63\x72\x6F\x66\x69\x63\x68\x65\x2E\x1E\x20\x30\x1F\x61\x50"
  "\x68\x79\x73\x69\x63\x61\x6C\x20\x65\x64\x75\x63\x61\x74\x69\x6F"
  "\x6E\x2E\x1E\x20\x30\x1F\x61\x48\x61\x6E\x64\x69\x63\x61\x70\x70"
  "\x65\x64\x20\x63\x68\x69\x6C\x64\x72\x65\x6E\x1F\x78\x45\x64\x75"
  "\x63\x61\x74\x69\x6F\x6E\x2E\x1E\x32\x30\x1F\x61\x45\x64\x75\x63"
  "\x61\x74\x69\x6F\x6E\x61\x6C\x20\x52\x65\x73\x6F\x75\x72\x63\x65"
  "\x73\x20\x49\x6E\x66\x6F\x72\x6D\x61\x74\x69\x6F\x6E\x20\x43\x65"
  "\x6E\x74\x65\x72\x20\x28\x55\x2E\x53\x2E\x29\x1E\x1D"
,
  "\x30\x31\x30\x33\x36\x6E\x61\x6D\x20\x20\x32\x32\x30\x30\x32\x38"
  "\x39\x49\x61\x20\x34\x35\x30\x30\x30\x30\x31\x30\x30\x30\x39\x30"
  "\x30\x30\x30\x30\x30\x30\x38\x30\x30\x34\x31\x30\x30\x30\x30\x39"
  "\x30\x30\x35\x30\x30\x31\x37\x30\x30\x30\x35\x30\x30\x31\x30\x30"
  "\x30\x31\x33\x30\x30\x30\x36\x37\x30\x34\x30\x30\x30\x31\x33\x30"
  "\x30\x30\x38\x30\x30\x34\x33\x30\x30\x31\x32\x30\x30\x30\x39\x33"
  "\x30\x37\x34\x30\x30\x31\x34\x30\x30\x31\x30\x35\x30\x38\x36\x30"
  "\x30\x31\x38\x30\x30\x31\x31\x39\x30\x38\x38\x30\x30\x31\x35\x30"
  "\x30\x31\x33\x37\x30\x34\x39\x30\x30\x30\x39\x30\x30\x31\x35\x32"
  "\x32\x34\x35\x30\x30\x34\x35\x30\x30\x31\x36\x31\x32\x36\x30\x30"
  "\x31\x30\x35\x30\x30\x32\x30\x36\x33\x30\x30\x30\x30\x34\x31\x30"
  "\x30\x33\x31\x31\x35\x30\x30\x30\x30\x35\x35\x30\x30\x33\x35\x32"
  "\x35\x30\x30\x30\x30\x33\x33\x30\x30\x34\x30\x37\x35\x30\x30\x30"
  "\x30\x32\x38\x30\x30\x34\x34\x30\x35\x30\x30\x30\x30\x32\x36\x30"
  "\x30\x34\x36\x38\x36\x31\x30\x30\x30\x34\x38\x30\x30\x34\x39\x34"
  "\x36\x35\x30\x30\x30\x35\x35\x30\x30\x35\x34\x32\x36\x35\x30\x30"
  "\x30\x34\x34\x30\x30\x35\x39\x37\x37\x31\x30\x30\x30\x36\x38\x30"
  "\x30\x36\x34\x31\x37\x34\x30\x30\x30\x33\x37\x30\x30\x37\x30\x39"
  "\x1E\x41\x43\x44\x2D\x31\x39\x33\x38\x1E\x39\x31\x30\x34\x31\x35"
  "\x73\x31\x39\x39\x31\x20\x20\x20\x20\x64\x63\x75\x20\x20\x20\x20"
  "\x20\x20\x20\x20\x20\x20\x66\x30\x30\x30\x30\x30\x20\x65\x6E\x67"
  "\x20\x64\x1E\x31\x39\x39\x31\x30\x34\x32\x31\x31\x32\x32\x35\x34"
  "\x31\x2E\x30\x1E\x20\x20\x1F\x6F\x32\x33\x34\x36\x38\x32\x37\x32"
  "\x1E\x20\x20\x1F\x61\x47\x50\x4F\x1F\x63\x47\x50\x4F\x1E\x20\x20"
  "\x1F\x61\x6E\x2D\x75\x73\x2D\x2D\x2D\x1E\x20\x20\x1F\x61\x30\x34"
  "\x36\x31\x2D\x44\x2D\x30\x35\x1E\x30\x20\x1F\x61\x45\x44\x20\x31"
  "\x2E\x33\x30\x32\x3A\x53\x68\x20\x32\x1E\x20\x20\x1F\x61\x50\x49"
  "\x50\x20\x39\x31\x2D\x38\x33\x36\x1E\x20\x20\x1F\x61\x44\x52\x55"
  "\x47\x1E\x30\x30\x1F\x61\x4E\x44\x4E\x2C\x20\x73\x68\x61\x72\x69"
  "\x6E\x67\x20\x73\x75\x63\x63\x65\x73\x73\x20\x74\x6F\x20\x69\x6D"
  "\x70\x72\x6F\x76\x65\x20\x73\x63\x68\x6F\x6F\x6C\x73\x2E\x1E\x30"
  "\x20\x1F\x61\x5B\x57\x61\x73\x68\x69\x6E\x67\x74\x6F\x6E\x2C\x20"
  "\x44\x43\x5D\x20\x3A\x1F\x62\x55\x2E\x53\x2E\x20\x44\x65\x70\x74"
  "\x2E\x20\x6F\x66\x20\x45\x64\x75\x63\x61\x74\x69\x6F\x6E\x2C\x20"
  "\x4F\x66\x66\x69\x63\x65\x20\x6F\x66\x20\x45\x64\x75\x63\x61\x74"
  "\x69\x6F\x6E\x61\x6C\x20\x52\x65\x73\x65\x61\x72\x63\x68\x20\x61"
  "\x6E\x64\x20\x49\x6D\x70\x72\x6F\x76\x65\x6D\x65\x6E\x74\x2C\x1F"
  "\x63\x5B\x31\x39\x39\x31\x5D\x1E\x20\x20\x1F\x61\x31\x20\x66\x6F"
  "\x6C\x64\x65\x64\x20\x73\x68\x65\x65\x74\x20\x28\x36\x20\x70\x2E"
  "\x29\x20\x3B\x1F\x63\x32\x32\x20\x78\x20\x31\x30\x20\x63\x6D\x2E"
  "\x1E\x20\x20\x1F\x61\x41\x74\x20\x68\x65\x61\x64\x20\x6F\x66\x20"
  "\x74\x69\x74\x6C\x65\x3A\x20\x4E\x61\x74\x69\x6F\x6E\x61\x6C\x20"
  "\x44\x69\x66\x66\x75\x73\x69\x6F\x6E\x20\x4E\x65\x74\x77\x6F\x72"
  "\x6B\x2C\x20\x4E\x44\x4E\x2E\x1E\x20\x20\x1F\x61\x53\x68\x69\x70"
  "\x70\x69\x6E\x67\x20\x6C\x69\x73\x74\x20\x6E\x6F\x2E\x3A\x20\x39"
  "\x31\x2D\x31\x39\x38\x2D\x50\x2E\x1E\x20\x20\x1F\x61\x22\x4A\x61"
  "\x6E\x75\x61\x72\x79\x20\x31\x39\x39\x31\x22\x2D\x2D\x50\x2E\x20"
  "\x5B\x35\x5D\x2E\x1E\x20\x20\x1F\x61\x22\x50\x49\x50\x20\x39\x31"
  "\x2D\x38\x33\x36\x22\x2D\x2D\x50\x2E\x20\x5B\x35\x5D\x2E\x1E\x31"
  "\x30\x1F\x61\x55\x6E\x69\x74\x65\x64\x20\x53\x74\x61\x74\x65\x73"
  "\x2E\x1F\x62\x4E\x61\x74\x69\x6F\x6E\x61\x6C\x20\x44\x69\x66\x66"
  "\x75\x73\x69\x6F\x6E\x20\x4E\x65\x74\x77\x6F\x72\x6B\x2E\x1E\x20"
  "\x30\x1F\x61\x44\x65\x6D\x6F\x6E\x73\x74\x72\x61\x74\x69\x6F\x6E"
  "\x20\x63\x65\x6E\x74\x65\x72\x73\x20\x69\x6E\x20\x65\x64\x75\x63"
  "\x61\x74\x69\x6F\x6E\x1F\x7A\x55\x6E\x69\x74\x65\x64\x20\x53\x74"
  "\x61\x74\x65\x73\x2E\x1E\x20\x30\x1F\x61\x45\x64\x75\x63\x61\x74"
  "\x69\x6F\x6E\x61\x6C\x20\x69\x6E\x6E\x6F\x76\x61\x74\x69\x6F\x6E"
  "\x73\x1F\x7A\x55\x6E\x69\x74\x65\x64\x20\x53\x74\x61\x74\x65\x73"
  "\x2E\x1E\x31\x30\x1F\x61\x55\x6E\x69\x74\x65\x64\x20\x53\x74\x61"
  "\x74\x65\x73\x2E\x1F\x62\x4F\x66\x66\x69\x63\x65\x20\x6F\x66\x20"
  "\x45\x64\x75\x63\x61\x74\x69\x6F\x6E\x61\x6C\x20\x52\x65\x73\x65"
  "\x61\x72\x63\x68\x20\x61\x6E\x64\x20\x49\x6D\x70\x72\x6F\x76\x65"
  "\x6D\x65\x6E\x74\x2E\x1E\x30\x31\x1F\x61\x4E\x61\x74\x69\x6F\x6E"
  "\x61\x6C\x20\x44\x69\x66\x66\x75\x73\x69\x6F\x6E\x20\x4E\x65\x74"
  "\x77\x6F\x72\x6B\x2C\x20\x4E\x44\x4E\x2E\x1E\x1D"
,
  "\x30\x30\x37\x32\x35\x6E\x61\x6D\x30\x20\x32\x32\x30\x30\x32\x35"
  "\x33\x20\x20\x20\x34\x35\x20\x20\x30\x30\x31\x30\x30\x31\x35\x30"
  "\x30\x30\x30\x30\x30\x30\x34\x30\x30\x31\x35\x30\x30\x30\x31\x35"
  "\x30\x30\x38\x30\x30\x32\x33\x30\x30\x30\x33\x30\x30\x32\x31\x30"
  "\x30\x33\x34\x30\x30\x30\x35\x33\x30\x34\x31\x30\x30\x31\x33\x30"
  "\x30\x30\x38\x37\x31\x30\x30\x30\x30\x31\x38\x30\x30\x31\x30\x30"
  "\x32\x34\x31\x30\x30\x31\x35\x30\x30\x31\x31\x38\x32\x34\x35\x30"
  "\x31\x32\x33\x30\x30\x31\x33\x33\x32\x35\x30\x30\x30\x32\x34\x30"
  "\x30\x32\x35\x36\x32\x36\x30\x30\x30\x33\x32\x30\x30\x32\x38\x30"
  "\x33\x30\x30\x30\x30\x32\x37\x30\x30\x33\x31\x32\x35\x32\x30\x30"
  "\x30\x33\x31\x30\x30\x33\x33\x39\x36\x35\x32\x30\x30\x31\x31\x30"
  "\x30\x33\x37\x30\x30\x31\x30\x30\x30\x32\x31\x30\x30\x33\x38\x31"
  "\x30\x39\x36\x30\x30\x31\x31\x30\x30\x34\x30\x32\x32\x35\x31\x30"
  "\x30\x32\x34\x30\x30\x34\x31\x33\x32\x36\x31\x30\x30\x30\x39\x30"
  "\x30\x34\x33\x37\x39\x37\x30\x30\x30\x31\x33\x30\x30\x34\x34\x36"
  "\x39\x37\x30\x30\x30\x31\x32\x30\x30\x34\x35\x39\x1E\x30\x30\x1F"
  "\x61\x44\x30\x30\x30\x30\x31\x35\x39\x33\x37\x1E\x30\x30\x1F\x73"
  "\x61\x1F\x74\x6D\x1F\x72\x6E\x1F\x75\x30\x1E\x30\x30\x1F\x61\x72"
  "\x31\x39\x38\x38\x31\x39\x38\x31\x1F\x62\x64\x6B\x1F\x6C\x64\x61"
  "\x6E\x1E\x30\x30\x1F\x61\x38\x37\x2D\x31\x31\x2D\x30\x34\x30\x31"
  "\x30\x2D\x36\x1F\x63\x68\x66\x2E\x1F\x64\x6B\x72\x2E\x20\x39\x32"
  "\x2C\x30\x30\x1E\x30\x30\x1F\x61\x64\x61\x6E\x1F\x63\x65\x6E\x67"
  "\x1E\x30\x30\x1F\x61\x41\x6E\x64\x65\x72\x73\x6F\x6E\x1F\x68\x42"
  "\x6F\x62\x1E\x30\x30\x1F\x61\x53\x74\x72\x65\x74\x63\x68\x69\x6E"
  "\x67\x1E\x30\x30\x1F\x61\x53\x74\x72\xE6\x6B\xF8\x76\x65\x6C\x73"
  "\x65\x72\x1F\x64\x42\x6F\x62\x20\x41\x6E\x64\x65\x72\x73\x6F\x6E"
  "\x1F\x66\x69\x6C\x6C\x75\x73\x74\x72\x65\x72\x65\x74\x20\x61\x66"
  "\x20\x4A\x65\x61\x6E\x20\x41\x6E\x64\x65\x72\x73\x6F\x6E\x1F\x66"
  "\x64\x61\x6E\x73\x6B\x20\x75\x64\x67\x61\x76\x65\x20\x76\x65\x64"
  "\x20\x4C\x69\x73\x20\x45\x6E\x67\x65\x6C\x1F\x66\x5B\x6F\x76\x65"
  "\x72\x73\xE6\x74\x74\x65\x6C\x73\x65\x20\x76\x65\x64\x20\x4A\x65"
  "\x73\x70\x65\x72\x20\x4C\x61\x6E\x67\x65\x72\x5D\x1E\x30\x30\x1F"
  "\x61\x31\x2E\x20\x75\x64\x67\x61\x76\x65\x2C\x20\x34\x2E\x20\x6F"
  "\x70\x6C\x61\x67\x1E\x30\x30\x1F\x61\x5B\x4B\x62\x68\x2E\x5D\x1F"
  "\x62\x43\x6C\x61\x75\x73\x65\x6E\x20\x62\xF8\x67\x65\x72\x1F\x63"
  "\x31\x39\x38\x38\x1E\x30\x30\x1F\x61\x31\x39\x32\x20\x73\x69\x64"
  "\x65\x72\x1F\x62\x69\x6C\x6C\x2E\x1F\x63\x32\x36\x20\x63\x6D\x1E"
  "\x30\x30\x1F\x61\x54\x69\x64\x6C\x69\x67\x65\x72\x65\x3A\x20\x31"
  "\x2E\x20\x75\x64\x67\x61\x76\x65\x2E\x20\x31\x39\x38\x31\x1E\x30"
  "\x30\x1F\x61\x37\x39\x2E\x36\x30\x31\x1E\x30\x30\x1F\x61\x38\x37"
  "\x30\x39\x37\x30\x1F\x62\x30\x35\x36\x37\x35\x30\x33\x30\x1E\x30"
  "\x30\x1F\x7A\x38\x37\x30\x39\x37\x30\x1E\x30\x30\x1F\x61\x31\x2E"
  "\x20\x75\x64\x67\x61\x76\x65\x2C\x20\x34\x2E\x20\x6F\x70\x6C\x61"
  "\x67\x1E\x30\x30\x1F\x63\x31\x39\x38\x38\x1E\x30\x30\x1F\x62\x30"
  "\x35\x36\x37\x35\x30\x33\x30\x1E\x30\x30\x1F\x63\x44\x42\x46\x38"
  "\x38\x34\x32\x1E\x1D"
};

static int atoin (const char *buf, int n)
{
    int val = 0;
    while (--n >= 0)
    {
        if (isdigit(*(const unsigned char *) buf))
            val = val*10 + (*buf - '0');
        buf++;
    }
    return val;
}

/* read one MARC record from a file */
char *marc_read(FILE *inf, ODR odr)
{
    char length_str[5];
    size_t size;
    char *buf;

    if (fread (length_str, 1, 5, inf) != 5)
        return NULL;
    size = atoin (length_str, 5);
    if (size <= 6)
        return NULL;
    if (!(buf = (char*) odr_malloc (odr, size+1)))
        return NULL;
    if (fread (buf+5, 1, size-5, inf) != (size-5))
    {
        xfree (buf);
        return NULL;
    }
    memcpy (buf, length_str, 5);
    buf[size] = '\0';
    return buf;
}

/* read MARC record from offset 'num' */
char *dummy_marc_record (int num, ODR odr)
{
    FILE *inf;
    char *buf = 0;

    if (num == 98) 
    {   /* this will generate a very bad MARC record (testing only) */
        buf = (char*) odr_malloc(odr, 2101);
        memset(buf, '7', 2100);
        buf[2100] = '\0';
    }
    inf = fopen ("dummy-records", "r");
    if (!inf) 
    { /* file not there. Get them from fixed array */
        if (num < 1 || num > 24)
            return 0;
        return marc_records[num-1];
    }
    /* OK, try to get proper MARC records from the file */
    while (--num >= 0)
    {
        buf = marc_read (inf, odr);
        if (!buf)
            break;
    }
    fclose(inf);
    return buf;
}

/* read MARC record and convert to XML */
char *dummy_xml_record (int num, ODR odr)
{
    yaz_marc_t mt = yaz_marc_create();
    char *result;
    int rlen;
    char *rec = dummy_marc_record (num, odr);
    int len;

    if (!rec)
        return 0;

    yaz_marc_xml(mt, YAZ_MARC_MARCXML);
    len = yaz_marc_decode_buf (mt, rec, -1, &result, &rlen);
    if (len > 1)
        rec = (char *) odr_strdup(odr, result);
    yaz_marc_destroy(mt);
    return rec;
}
