###########################################################################
#
# win32 makefile -- src/recpt
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999-2008  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

GSDL_DIR = ..\..\..
COMMON_DIR = $(GSDL_DIR)\common-src
RUNTIME_DIR = $(GSDL_DIR)\runtime-src

INDEXERS_DIR = $(COMMON_DIR)\indexers
COMMON_PACKAGES_DIR = $(COMMON_DIR)\packages
PACKAGES_DIR = $(RUNTIME_DIR)\packages
COLSERVR_DIR = $(RUNTIME_DIR)\src\colservr
PROTOCOL_DIR = $(RUNTIME_DIR)\src\protocol
Z3950_DIR    = $(RUNTIME_DIR)\src\z3950


GSDL_VC4 = 0
LOCAL_LIBRARY = 0
USE_Z3950 = 0
USE_GSDL_MOD = 0
DEBUG = 0
DLL = 0
DLLDEBUG = 0
ENABLE_ACCENTFOLD = 1
USE_RSS = 1
USE_GDBM = 1
USE_JDBM = 1
USE_SQLITE = 1
USE_MSSQL = 0
ENABLE_MG = 1
ENABLE_MGPP = 1
ENABLE_LUCENE = 1

!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
LDFLAGS = -DEBUG -Z7 /errorReport:prompt
!ELSE
CXXFLAGS =
LDFLAGS =
!ENDIF

!IF $(GSDL_VC4)
CXXFLAGS = $(CXXFLAGS) -GX
!ELSE
CXXFLAGS = $(CXXFLAGS) -EHsc
!ENDIF

!IF $(DLL)
CXXFLAGS = $(CXXFLAGS) -MD
!ELSE
!IF ($(DLLDEBUG))
CXXFLAGS = $(CXXFLAGS) -MDd
!ENDIF
!ENDIF

!IF $(ENABLE_ACCENTFOLD)
ACCENTFOLD_LIBS = "$(INDEXERS_DIR)\packages\unac\libunac.lib" "$(INDEXERS_DIR)\packages\windows\iconv\iconv\lib\iconv.lib"
!ELSE
ACCENTFOLD_LIBS = 
!ENDIF

!IF $(USE_RSS)
RSS_DEFINES = -DUSE_RSS
RSS_SOURCES = rssaction.cpp
RSS_OBJECTS = rssaction.obj
!ELSE
RSS_DEFINES =
RSS_SOURCES =
RSS_OBJECTS =
!ENDIF

!IF $(USE_GDBM)
GDBM_DEFINES = -DUSE_GDBM
GDBM_LIBS = "$(COMMON_PACKAGES_DIR)\gdbm\gdbm-1.8.3\gdbm.lib"
GDBM_INCLUDES = -I"$(COMMON_PACKAGES_DIR)\gdbm\gdbm-1.8.3" -I"$(COMMON_PACKAGES_DIR)\gdbm\gdbm-1.8.3\windows"
!ELSE
GDBM_DEFINES = 
GDBM_LIBS = 
GDBM_INCLUDES = 
!ENDIF

!IF $(USE_JDBM)
JDBM_DEFINES = -DUSE_JDBM
!ELSE
JDBM_DEFINES = 
!ENDIF

!IF $(USE_SQLITE)
SQLITE_DEFINES = -DUSE_SQLITE
SQL_SOURCES = sqlqueryaction.cpp
SQL_OBJECTS = sqlqueryaction.obj
SQLITE_LIBS = "$(COMMON_PACKAGES_DIR)\sqlite\lib\sqlite3.lib"
!ELSE
SQLITE_DEFINES =
SQL_SOURCES =
SQL_OBJECTS =
SQLITE_LIBS = 
!ENDIF

!IF $(USE_MSSQL)
MSSQL_DEFINES = -DUSE_MSSQL
!ELSE
MSSQL_DEFINES = 
!ENDIF

!IF $(USE_Z3950)
Z3950_DEFS = -DUSE_Z3950
Z3950_INCLUDES = -I$(Z3950_DIR)
Z3950_LIBS = $(Z3950_DIR)\gsdlz3950.lib $(PACKAGES_DIR)\yaz\yaz-2.1.56\lib\yaz.lib
!ELSE
Z3950_DEFS = 
Z3950_INCLUDES = 
Z3950_LIBS = 
!ENDIF

!IF $(USE_GSDL_MOD)
APACHE_OBJS = string_pool.obj mod_gsdl.obj

APACHE_INSTDIR=$(GSDL_DIR)\apache-httpd\windows
APACHE_SRCLIBDIR=..\..\packages\apache-httpd\httpd-2.2.11\srclib

APXS_CFLAGS=-I$(APACHE_INSTDIR)\include \
  -I$(APACHE_SRCLIBDIR)\apr\include -I$(APACHE_SRCLIBDIR)\apr-util\include

APXS_LINKFLAGS= /libpath:$(APACHE_INSTDIR)\lib \
  /libpath:$(APACHE_SRCLIBDIR)\apr\include \
  /libpath:$(APACHE_SRCLIBDIR)\apr-util\include

APXS_LDFLAGS= -L$(APACHE_INSTDIR)\lib \
  -L$(APACHE_SRCLIBDIR)\apr\include \
  -L$(APACHE_SRCLIBDIR)\apr-util\include

APXS_LIBS = libaprutil-1.lib libapr-1.lib libhttpd.lib

APACHE_MODULE = mod_gsdl.so
!ELSE
APACHE_OBJS =
APACHE_MODULE =
!ENDIF


!IF $(ENABLE_MG)
MG_DEFS = -DENABLE_MG
MG_LIBS = "$(INDEXERS_DIR)\mg\src\text\libmgtext.lib" \
	"$(INDEXERS_DIR)\mg\lib\libmglib.lib"
MG_INCLUDES = -I"$(INDEXERS_DIR)\mg" -I"$(INDEXERS_DIR)\mg\lib" 
!ELSE
MG_DEFS =
MG_LIBS =
MG_INCLUDES =
!ENDIF

!IF $(ENABLE_MGPP)
MGPP_DEFS = -DENABLE_MGPP
MGPP_SOURCES = phindaction.cpp
MGPP_OBJECTS = phindaction.obj
MGPP_LIBS = "$(INDEXERS_DIR)\mgpp\text\libmgpptext.lib" \
	"$(INDEXERS_DIR)\mgpp\lib\libmgpplib.lib"
MGPP_INCLUDES = -I"$(INDEXERS_DIR)\mgpp\text" \
	-I"$(INDEXERS_DIR)\mgpp\lib"
!ELSE
MGPP_DEFS =
MGPP_SOURCES = 
MGPP_OBJECTS = 
MGPP_LIBS =
MGPP_INCLUDES =
!ENDIF

!IF $(ENABLE_LUCENE)
LUCENE_DEFS = -DENABLE_LUCENE
!ELSE
LUCENE_DEFS=
!ENDIF

AR = lib
CC = cl
DEFS = -D__WIN32__ -DHAVE_CONFIG_H -DPARADOCNUM -D_LITTLE_ENDIAN -DSHORT_SUFFIX -D_CRT_SECURE_NO_DEPRECATE \
	-DGSDL_NOCACHE $(RSS_DEFINES) $(GDBM_DEFINES) $(JDBM_DEFINES) $(SQLITE_DEFINES) $(MSSQL_DEFINES) \
	$(Z3950_DEFS) $(MG_DEFS) $(MGPP_DEFS) $(LUCENE_DEFS)
INCLUDES = -I. -I"$(GSDL_DIR)" -I"$(COMMON_DIR)\src\lib" -I"$(COLSERVR_DIR)" -I"$(PROTOCOL_DIR)" \
	$(MG_INCLUDES) $(MGPP_INCLUDES) \
	-I"$(COMMON_PACKAGES_DIR)\windows\crypt\crypt" -I"$(COMMON_PACKAGES_DIR)\expat\include" \
	$(GDBM_INCLUDES) \
	$(Z3950_INCLUDES)
LIBS = "$(COMMON_PACKAGES_DIR)\windows\crypt\crypt\crypt.lib" "$(COMMON_PACKAGES_DIR)\expat\lib\libexpat.lib" \
       $(GDBM_LIBS) $(ACCENTFOLD_LIBS) $(SQLITE_LIBS) $(Z3950_LIBS)

!IF $(GSDL_VC4)
DEFS = $(DEFS) -DGSDL_NAMESPACE_BROKEN -DGSDL_USE_IOS_H -D__STL_NO_NEW_IOSTREAMS
INCLUDES = $(INCLUDES) -I"$(COMMON_PACKAGES_DIR)\windows\stlport\stlport"
!ENDIF
!IF $(LOCAL_LIBRARY)
DEFS = $(DEFS) -DGSDL_LOCAL_LIBRARY
!ENDIF

CXXFLAGS = $(CXXFLAGS)

COMPILE = $(CC) -nologo -c $(CXXFLAGS) $(DEFS) $(INCLUDES)
LINK = $(CC) -nologo $(LDFLAGS) -Fe"$@"


.SUFFIXES:
.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $< 

OSPROCESS_SOURCES = \
	os_process.cpp \
	os_process_windows.cpp \

OSPROCESS_OBJECTS = \
	os_process.obj \
	os_process_windows.obj \


SOURCES = \
	action.cpp \
	argdb.cpp \
	authenaction.cpp \
	basequeryaction.cpp \
	browseaction.cpp \
	browseactiontools.cpp \
	browserclass.cpp \
	browsetoolsclass.cpp \
	cgiargs.cpp \
	cgiutils.cpp \
	cgiwrapper.cpp \
	collectoraction.cpp \
	configaction.cpp \
        converter.cpp \
	datelistbrowserclass.cpp \
	depositoraction.cpp \
	documentaction.cpp \
	dynamicclassifieraction.cpp \
	extlinkaction.cpp \
	formatconverter.cpp \
	formattools.cpp \
	gtiaction.cpp \
	highlighttext.cpp \
	historydb.cpp \
	hlistbrowserclass.cpp \
	htmlbrowserclass.cpp \
	htmlutils.cpp \
	invbrowserclass.cpp \
	librarymain.cpp \
	maincfg.cpp \
	$(OSPROCESS_SOURCES) \
	pageaction.cpp \
	pagedbrowserclass.cpp \
	$(MGPP_SOURCES) \
	phindbrowserclass.cpp \
	pingaction.cpp \
	ispersistentaction.cpp \
	queryaction.cpp \
	querytools.cpp \
	receptionist.cpp \
	$(RSS_SOURCES) \
	statusaction.cpp \
	$(SQL_SOURCES) \
	securitytools.cpp \
	summarise.cpp \
	tipaction.cpp \
	userdb.cpp \
	usersaction.cpp \
	vlistbrowserclass.cpp \
	wizardaction.cpp

OBJECTS = \
	action.obj \
	argdb.obj \
	authenaction.obj \
	basequeryaction.obj \
	browseaction.obj \
	browseactiontools.obj \
	browserclass.obj \
	browsetoolsclass.obj \
	cgiargs.obj \
	cgiutils.obj \
	cgiwrapper.obj \
	collectoraction.obj \
	configaction.obj \
        converter.obj \
	datelistbrowserclass.obj \
	depositoraction.obj \
	documentaction.obj \
	dynamicclassifieraction.obj \
	extlinkaction.obj \
	formattools.obj \
	gtiaction.obj \
	highlighttext.obj \
	historydb.obj \
	hlistbrowserclass.obj \
	htmlbrowserclass.obj \
	htmlutils.obj \
	invbrowserclass.obj \
	librarymain.obj \
	maincfg.obj \
	$(OSPROCESS_OBJECTS) \
	pageaction.obj \
	pagedbrowserclass.obj \
	$(MGPP_OBJECTS) \
	phindbrowserclass.obj \
	pingaction.obj \
	ispersistentaction.obj \
	queryaction.obj \
	querytools.obj \
	receptionist.obj \
	$(RSS_OBJECTS) \
	statusaction.obj \
	$(SQL_OBJECTS) \
	securitytools.obj \
	summarise.obj \
	tipaction.obj \
	userdb.obj \
	usersaction.obj \
	vlistbrowserclass.obj \
	wizardaction.obj

LIBRARY = gsdlrecpt.lib

GSDL_LIBS = \
	"$(PROTOCOL_DIR)\gsdlprotocol.lib" \
	"$(COLSERVR_DIR)\gsdlcolservr.lib" \
	$(MG_LIBS) \
	$(MGPP_LIBS) \
	"$(COMMON_DIR)\src\lib\gsdllib.lib"

CONVERTER_OBJECTS = \
	cgiargs.obj \
	cgiutils.obj \
	formattools.obj \
	formatconverter.obj \
	summarise.obj	
	
EXECUTABLE_OBJECTS = \
	$(OBJECTS) \
	$(GSDL_LIBS)

EXECUTABLE = library.cgi

# Default target: make gsdlrecpt.lib if LOCAL_LIBRARY is set, otherwise both gsdlrecpt.lib and library.exe
!IF $(LOCAL_LIBRARY)
all: $(LIBRARY) $(APACHE_MODULE) formatconverter.exe
!ELSE
all: $(LIBRARY) $(EXECUTABLE) $(APACHE_MODULE) formatconverter.exe
!ENDIF

gsdlrecpt.lib: $(OBJECTS) 
	if EXIST $(LIBRARY) del $(LIBRARY)
	$(AR) -nologo /out:$(LIBRARY) $(OBJECTS)

library.cgi: $(EXECUTABLE_OBJECTS)
	$(LINK) $(EXECUTABLE_OBJECTS) $(LIBS)

formatconverter.exe: $(CONVERTER_OBJECTS)
	$(LINK) $(CONVERTER_OBJECTS) "$(COMMON_DIR)\src\lib\gsdllib.lib" "$(PROTOCOL_DIR)\gsdlprotocol.lib" "$(COLSERVR_DIR)\gsdlcolservr.lib"
	
mod_gsdl.obj: mod_gsdl.cpp
	$(CC) -nologo /MD /W3 /D WIN32 /D _WINDOWS /D NDEBUG -c  $(CXXFLAGS) $(DEFS) $(INCLUDES) -D_APACHE_MOD=2 $(APXS_CFLAGS) mod_gsdl.cpp
##	cl.exe /nologo /MT /W3 /O2 /D WIN32 /D _WINDOWS /D NDEBUG -I"C:\Program Files\xampp\apache\include" -c mod_gsdl.c

mod_gsdl.so: $(APACHE_OBJS) $(LIBRARY)
	$(CC) /nologo -Fe"mod_gsdl.dll"  $(APACHE_OBJS) gsdlrecpt.lib $(GSDL_LIBS) $(LIBS) $(APXS_LDFLAGS) $(APXS_LIBS)

#	link /nologo /dll  $(APACHE_OBJS) gsdlrecpt.lib $(GSDL_LIBS) $(LIBS) $(APXS_LDFLAGS) $(APXS_LIBS)
	rename mod_gsdl.dll mod_gsdl.so

##	$(CC) -nologo /dll -Fe"$@" $(APACHE_OBJS) $(LIBRARY) $(GSDL_LIBS) $(LIBS)


## link.exe  kernel32.lib /nologo /subsystem:windows /dll /machine:I386 /libpath:"C:\Program Files\xampp\apache\lib" libaprutil-1.lib libapr-1.lib libhttpd.lib mod_gsdl.obj

##	rename mod_gsdl.dll mod_gsdl.so


# COMPILE = $(CC) -nologo -c $(CXXFLAGS) $(DEFS) $(INCLUDES)
# LINK = $(CC) -nologo -Fe"$@" $(LDFLAGS)






osprocess-test.cgi: $(OSPROCESS_OBJECTS) os_process_test.obj
	$(LINK) $(OSPROCESS_OBJECTS) os_process_test.obj ..\..\..\common-src\src\lib\gsdllib.lib

!IF $(LOCAL_LIBRARY)
install:
	if exist "formatconverter.exe" copy formatconverter.exe "$(GSDL_DIR)\bin\windows"
!ELSE
install: $(EXECUTABLE)
	if exist "formatconverter.exe" copy formatconverter.exe "$(GSDL_DIR)\bin\windows"
!IF "$(PROCESSOR_ARCHITECTURE)"==""	
	copy $(EXECUTABLE) "$(GSDL_DIR)\cgi-bin\windows"
!ELSE IF EXIST ("$(GSDL_DIR)\bin\windows")
	copy $(EXECUTABLE) "$(GSDL_DIR)\cgi-bin\windows"	
!ELSE IF "$(PROCESSOR_ARCHITECTURE)"=="x86"	
	copy $(EXECUTABLE) "$(GSDL_DIR)\cgi-bin\windows32"
!ELSE
	copy $(EXECUTABLE) "$(GSDL_DIR)\cgi-bin\windows64"
!ENDIF	
!ENDIF

clean:
	del *.obj
	del $(LIBRARY)
	del $(EXECUTABLE)


# Always recompile configaction and statusaction in case GSDL_LOCAL_LIBRARY has changed
statusaction.obj: FORCE
configaction.obj: FORCE

FORCE:
