/**********************************************************************
 *
 * browseaction.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "gsdl_modules_cfg.h"
#ifdef GSDL_USE_BROWSE_ACTION

#ifndef BROWSEACTION_H
#define BROWSEACTION_H

#include "action.h"
#include "receptionist.h"

class browseaction : public action{
 protected:
  receptionist* recpt;
  bool get_document_list(cgiargsclass &args, recptprotolistclass *protos, 
		  browsermapclass *browsers, displayclass &disp, 
		  outconvertclass &outconvert, ostream &textout, 
		  ostream &logout);
 public:
  browseaction();
  virtual ~browseaction();

  bool init (ostream &logout);

  void configure (const text_t &key, const text_tarray &cfgline);

  text_t get_action_name() {return "br";}
  
  void set_receptionist (receptionist *therecpt) {recpt=therecpt;}

  bool check_cgiargs (cgiargsinfoclass &argsinfo, cgiargsclass &args, 
		      recptprotolistclass *protos, ostream &logout);

  
  void get_cgihead_info (cgiargsclass &args, recptprotolistclass *protos,
				 response_t &response, text_t &response_data, 
				 ostream &logout);

  void define_internal_macros (displayclass &disp, cgiargsclass &args, 
			       recptprotolistclass *protos, ostream &logout);
  
  void define_external_macros (displayclass &disp, cgiargsclass &args, 
			       recptprotolistclass *protos, ostream &logout);

  bool do_action (cgiargsclass &args, recptprotolistclass *protos, 
		  browsermapclass *browsers, displayclass &disp, 
		  outconvertclass &outconvert, ostream &textout, 
		  ostream &logout);

  const cgiargsinfoclass& getargsinfo() const {return argsinfo;};
};

#endif //!BROWSEACTION_H
#endif //GSDL_USE_BROWSE_ACTION
