/**********************************************************************
 *
 * oaitools.h --
 *
 * Copyright (C) 2004-2010  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef _OAITOOLS_H_
#define _OAITOOLS_H_

#include "text_t.h"
#include "receptionist.h"

class oaiclassifier {
 public:
  static text_t getGSDL_OID(const text_t &collection, const text_t& oai_id, recptproto *protocol, 
			    ostream &logout);
  static void   toOAI(const text_t &collection, text_t &classifier);
  static void   toOAI(const text_t repos_id, const text_t &collection, text_t &classifier);
  static void   toGSDL(text_t &collection, text_t &classifier);
  static void  getCollectionFromOAIID(const text_t oai_id, text_t &collection_id);
 private:
  static void   swapColonsAndPeriods(text_t &classifier);
};
#endif
