/**********************************************************************
 *
 * maptools.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef MAPTOOLS_H
#define MAPTOOLS_H


#include "gsdlconf.h"
#include "text_t.h"

// stringmap is a mapping which remembers the original order 
// of the map, but is very fast to look up.
class stringmap {
protected:
  text_tarray fromorder;
  text_tmap mapfrom;

public:
  void clear ();

  void importmap (const text_tarray &maparray);
  void importmap (const text_tarray &maparray, bool keepold);
  void exportmap (text_tarray &maparray) const;

  void getfromarray (text_tarray &fromarray) const;
  void gettoarray (text_tarray &toarray) const;
  
  bool fromexists (const text_t &from) const;
  bool toexists (const text_t &to) const;

  // from2to and to2from return false if the key (the "from"
  // field or the "to" field) cannot be found
  bool from2to (const text_t &from, text_t &to) const;
  bool to2from (const text_t &to, text_t &from) const;
};


// a few useful functions used by stringmap
void splitmapentry (const text_t &mapentry, text_t &from, text_t &to);
void joinmapentry (const text_t &from, const text_t &to, text_t &mapentry);


#endif
