/**********************************************************************
 *
 * tools.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "colservertools.h"
#include "fileutil.h"


text_t getcollectionpath(const text_t& gsdlhome, const text_t& dbhome,
			 const text_t& collecthome, const text_t& collection)
{
  text_t resolved_filename;
  
  if (gsdlhome==dbhome) {
    // dbhome has defaulted to gsdlhome which we take to means the 
    // database has been specifically moved out of gsdlhome area.
    // => it should be whereever collecthome is set to
    resolved_filename = filename_cat(collecthome, collection);
  }
  else {
    // dbhome is explicitly set to something other than gsdlhome
    // => use dbhome
    resolved_filename = filename_cat(dbhome, "collect", collection);
  }

  return resolved_filename;
}

text_t resolve_db_filename(const text_t& gsdlhome, const text_t& dbhome,
			   const text_t& collecthome, const text_t& collection,
			   const text_t& idx, const text_t& file_ext)
{
  text_t collection_path = getcollectionpath(gsdlhome, dbhome, collecthome, collection);
  text_t resolved_filename = filename_cat(collection_path, "index", "text", idx);

  resolved_filename += file_ext;
  
  return resolved_filename;
}

text_t resolve_oaidb_filename(const text_t& gsdlhome, const text_t& dbhome,
			      const text_t& collecthome, const text_t& collection,
			      const text_t& file_ext)
{
  text_t collection_path = getcollectionpath(gsdlhome, dbhome, collecthome, collection);
  text_t resolved_filename = filename_cat(collection_path, "etc", "oai-inf");

  resolved_filename += file_ext;

  return resolved_filename;
}
