# mapping to and from iso 639 two letter language symbols

package iso639;

use strict;

%iso639::fromiso639 = (
	       'aa' => 'Afar',
	       'ab' => 'Abkhazian',
	       'af' => 'Afrikaans',
	       'am' => 'Amharic',
	       'ar' => 'Arabic',
	       'as' => 'Assamese',
	       'ay' => 'Aymara',
	       'az' => 'Azerbaijani',

	       'ba' => 'Bashkir',
	       'be' => 'Byelorussian',
	       'bg' => 'Bulgarian',
	       'bh' => 'Bihari',
	       'bi' => 'Bislama',
	       'bn' => 'Bengali; Bangla',
	       'bo' => 'Tibetan',
	       'br' => 'Breton',

	       'ca' => 'Catalan',
	       'co' => 'Corsican',
	       'cs' => 'Czech',
	       'cy' => 'Welsh',

	       'da' => 'Danish',
	       'de' => 'German',
	       'dz' => 'Bhutani',	       
	       'dv' => 'Dhivehi',

	       'el' => 'Greek',
	       'en' => 'English',
	       'eo' => 'Esperanto',
	       'es' => 'Spanish',
	       'et' => 'Estonian',
	       'eu' => 'Basque',

	       'fa' => 'Persian',
	       'fi' => 'Finnish',
	       'fj' => 'Fiji',
	       'fo' => 'Faroese',
	       'fr' => 'French',
	       'fy' => 'Frisian',

	       'ga' => 'Irish',
	       'gd' => 'Scots Gaelic',
	       'gl' => 'Galician',
	       'gn' => 'Guarani',
	       'gu' => 'Gujarati',

	       'ha' => 'Hausa',
	       'he' => 'Hebrew',
	       'hi' => 'Hindi',
	       'hr' => 'Croatian',
	       'hu' => 'Hungarian',
	       'hy' => 'Armenian',

	       'ia' => 'Interlingua',
	       'id' => 'Indonesian',
	       'ie' => 'Interlingue',
	       'ig' => 'Igbo', # igbo, en.wiktionary.org/wiki/Category:Igbo_language, spoken by 25 millions people especially in Nigeria
	       'ik' => 'Inupiak',
	       'is' => 'Icelandic',
	       'it' => 'Italian',
	       'iu' => 'Inuktitut',

	       'ja' => 'Japanese',
	       'jv' => 'Javanese',

	       'ka' => 'Georgian',
	       'kk' => 'Kazakh',
	       'kl' => 'Greenlandic',
	       'km' => 'Cambodian',
	       'kn' => 'Kannada',
	       'ko' => 'Korean',
	       'ks' => 'Kashmiri',
	       'ku' => 'Kurdish',
	       'ky' => 'Kirghiz',

	       'la' => 'Latin',
	       'ln' => 'Lingala',
	       'lo' => 'Laotian',
	       'lt' => 'Lithuanian',
	       'lv' => 'Latvian, Lettish',

	       'mg' => 'Malagasy',
	       'mi' => 'Maori',
	       'mk' => 'Macedonian',
	       'ml' => 'Malayalam',
	       'mn' => 'Mongolian',
	       'mo' => 'Moldavian',
	       'mr' => 'Marathi',
	       'ms' => 'Malay',
	       'mt' => 'Maltese',
	       'my' => 'Burmese',

	       'na' => 'Nauru',
	       'ne' => 'Nepali',
	       'nl' => 'Dutch',
	       'no' => 'Norwegian',

	       'oc' => 'Occitan',
	       'om' => '(Afan) Oromo',
	       'or' => 'Oriya',

	       'pa' => 'Punjabi',
	       'pl' => 'Polish',

	       'prs'=> 'Dari',
	       'ps' => 'Pushto',

	       'pt' => 'Portuguese',

	       'qu' => 'Quechua',
	       'rm' => 'Rhaeto-Romance',
	       'rn' => 'Kirundi',
	       'ro' => 'Romanian',
	       'ru' => 'Russian',
	       'rw' => 'Kinyarwanda',

	       'sa' => 'Sanskrit',
	       'sd' => 'Sindhi',
	       'sg' => 'Sangro',
	       'sh' => 'Serbo-Croatian',
	       'si' => 'Sinhalese',
	       'sk' => 'Slovak',
	       'sl' => 'Slovenian',
	       'sm' => 'Samoan',
	       'sn' => 'Shona',
	       'so' => 'Somali',
	       'sq' => 'Albanian',
	       'sr' => 'Serbian',
	       'ss' => 'Siswati',
	       'st' => 'Sesotho',
	       'su' => 'Sudanese',
	       'sv' => 'Swedish',
	       'sw' => 'Swahili',

	       'ta' => 'Tamil',
	       'te' => 'Telugu',
	       'tg' => 'Tajik',
	       'th' => 'Thai',
	       'ti' => 'Tigrinya',
	       'tk' => 'Turkmen',
	       'tl' => 'Tagalog',
	       'tn' => 'Setswana',
	       'to' => 'Tonga',
	       'tr' => 'Turkish',
	       'ts' => 'Tsonga',
	       'tt' => 'Tatar',
	       'tw' => 'Twi',

	       'ug' => 'Uigur',
	       'uk' => 'Ukrainian',
	       'ur' => 'Urdu',
	       'uz' => 'Uzbek',

	       'vi' => 'Vietnamese',
	       'vo' => 'Volapuk',

	       'wo' => 'Wolof',

	       'xh' => 'Xhosa',

	       'yi' => 'Yiddish',
	       'yo' => 'Yoruba',

	       'za' => 'Zhuang',
	       'zh' => 'Chinese',
	       'zu' => 'Zulu',
    
    'zz' => 'TestLang'
	       );

%iso639::toiso639 = (
	     'afar' => 'aa',
	     'abkhazian' => 'ab',
	     'afrikaans' => 'af',
	     'amharic' => 'am',
	     'arabic' => 'ar',
	     'assamese' => 'as',
	     'aymara' => 'ay',
	     'azerbaijani' => 'az',

	     'bashkir' => 'ba',
	     'byelorussian' => 'be',
	     'bulgarian' => 'bg',
	     'bihari' => 'bh',
	     'bislama' => 'bi',
	     'bengali' => 'bn',
	     'bangla' => 'bn',
	     'tibetan' => 'bo',
	     'breton' => 'br',

	     'catalan' => 'ca',
	     'corsican' => 'co',
	     'czech' => 'cs',
	     'welsh' => 'cy',

	     'danish' => 'da',
	     'german' => 'de',
	     'dhivehi' => 'dv',
	     'bhutani' => 'dz',

	     'greek' => 'el',
	     'english' => 'en',
	     'esperanto' => 'eo',
	     'spanish' => 'es',
	     'estonian' => 'et',
	     'basque' => 'eu',

	     'persian' => 'fa',
	     'finnish' => 'fi',
	     'fiji' => 'fj',
	     'faroese' => 'fo',
	     'french' => 'fr',
	     'frisian' => 'fy',

	     'irish' => 'ga',
	     'scots_gaelic' => 'gd',
	     'galician' => 'gl',
	     'guarani' => 'gn',
	     'gujarati' => 'gu',

	     'hausa' => 'ha',
	     'hebrew' => 'he',
	     'hindi' => 'hi',
	     'croatian' => 'hr',
	     'hungarian' => 'hu',
	     'armenian' => 'hy',

	     'interlingua' => 'ia',
	     'indonesian' => 'id',
	     'interlingue' => 'ie',
	     'inupiak' => 'ik',
	     'igbo' => 'ig',
	     'icelandic' => 'is',
	     'italian' => 'it',
	     'inuktitut' => 'iu',

	     'japanese' => 'ja',
	     'javanese' => 'jv',

	     'georgian' => 'ka',
	     'kazakh' => 'kk',
	     'greenlandic' => 'kl',
	     'cambodian' => 'km',
	     'kannada' => 'kn',
	     'korean' => 'ko',
	     'kashmiri' => 'ks',
	     'kurdish' => 'ku',
	     'kirghiz' => 'ky',

	     'latin' => 'la',
	     'lingala' => 'ln',
	     'laotian' => 'lo',
	     'lithuanian' => 'lt',
	     'latvian' => 'lv',
	     'lettish' => 'lv',

	     'malagasy' => 'mg',
	     'maori' => 'mi',
	     'macedonian' => 'mk',
	     'malayalam' => 'ml',
	     'mongolian' => 'mn',
	     'moldavian' => 'mo',
	     'marathi' => 'mr',
	     'malay' => 'ms',
	     'maltese' => 'mt',
	     'burmese' => 'my',

	     'nauru' => 'na',
	     'nepali' => 'ne',
	     'dutch' => 'nl',
	     'norwegian' => 'no',

	     'occitan' => 'oc',
	     '(afan)_oromo' => 'om',
	     'oriya' => 'or',

	     'punjabi' => 'pa',
	     'polish' => 'pl',
	     'pashto' => 'ps',
	     'pushto' => 'ps',
	     'dari'	  => 'prs',
	     'portuguese' => 'pt',

	     'quechua' => 'qu',

	     'rhaeto-romance' => 'rm',
	     'kirundi' => 'rn',
	     'romanian' => 'ro',
	     'russian' => 'ru',
	     'kinyarwanda' => 'rw',
	     
	     'sanskrit' => 'sa',
	     'sindhi' => 'sd',
	     'sangro' => 'sg',
	     'serbo-croatian' => 'sh',
	     'sinhalese' => 'si',
	     'slovak' => 'sk',
	     'slovenian' => 'sl',
	     'samoan' => 'sm',
	     'shona' => 'sn',
	     'somali' => 'so',
	     'albanian' => 'sq',
	     'serbian' => 'sr',
	     'siswati' => 'ss',
	     'sesotho' => 'st',
	     'sudanese' => 'su',
	     'swedish' => 'sv',
	     'swahili' => 'sw',

	     'tamil' => 'ta',
	     'telugu' => 'te',
	     'tajik' => 'tg',
	     'thai' => 'th',
	     'tigrinya' => 'ti',
	     'turkmen' => 'tk',
	     'tagalog' => 'tl',
	     'setswana' => 'tn',
	     'tonga' => 'to',
	     'turkish' => 'tr',
	     'tsonga' => 'ts',
	     'tatar' => 'tt',
	     'twi' => 'tw',

	     'uigur' => 'ug',
	     'ukrainian' => 'uk',
	     'urdu' => 'ur',
	     'uzbek' => 'uz',

	     'vietnamese' => 'vi',
	     'volapuk' => 'vo',

	     'wolof' => 'wo',
	     
	     'xhosa' => 'xh',

	     'yiddish' => 'yi',
	     'yoruba' => 'yo',

	     'zhuang' => 'za',
	     'chinese' => 'zh',
	     'zul' => 'zu',
              
             'testlang' => 'zz',
	     );
