# this file must be UTF-8 encoded
######################################################################
#
# Czech Language text and icon macros 
# Many thanks to Roman Chyla and Jakub Rehan (translated 2003 & 2004)
#
######################################################################



######################################################################
# 'home' page
package home
######################################################################

#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_documents_ [l=cs] {dokumentů.}
_lastupdate_ [l=cs] {Naposledy aktualizováno}
_ago_ [l=cs] {dny.}
_colnotbuilt_ [l=cs] {Kolekce nebyla vytvořena.}

_textpoem_ [l=cs] {<br>
<h2>Kia papapounamu te moana</h2>

<p>kia hora te marino, 
<br>kia tere te karohirohi, 
<br>kia papapounamu te moana

<p>kéž mír a vánek tě provází,
<br>kéž zůstáváš ve slunci letního oparu,
<br>a oceán tvých poutí ať je hladký jako greenstone.}

_textgreenstone_ [l=cs] {<p>
Greenstone je polodrahokam, který (stejně jako tento program) pochází z Nového Zélandu.
V tradiční maorské společnosti je považován za najcennější latku. Může do sebe přijmout
a podržet <i>wairua</i>, což je "duch" a nebo taky "životní síla". Greenstone je opředen
tradičními ctnostmi, které z něj dělají vhodný emblém pro věřejně-přístupný projekt digitální knihovny
. Jeho lesk je dobrotivý; jeho průsvitnost je vznešená; jeho pevnost odvážná a jeho ostré hrany spravedlivé. 
Vyřezávaný kámen, který vidíte v logu Greenstone, je <i>patu</i> - bojová zbraň. Je to rodinné dědictví jednoho
ze zakládajících členů Greenstone. V boji může proti muži jsou argumenty <i>patu</i>  velmi rychlé, pádné a zdrcující. 
Rádi bychom si mysleli, že tyto kvality se přenášejí i na náš program; ostří <i>patu</i> je rozhraním naší technologie.}

_textaboutgreenstone_ [l=cs] {<p>
Greenstone je balíkem programů pro vytváření a distribuci digitální kolekcí. Nabízí nový způsob organizace
a publikování informací na internetu a na discích CD-ROM.

<p>Greenstone je vyvíjen v rámci projektu <b>New Zealand Digital Library</b> a distribuován v kooperaci
s <b>UNESCO</b> a s nevládní organizací <b>Human Info NGO</b>. 

Je to program s otevřeným kódem a distribuuje se pod licencí GNU General Public License
z <a href"http://greenstone.org">http://greenstone.org</a>.
<p>
Tento projekt chce dát uživatelům nástroje pro vytváření vlastních digitálních kolekcí (a to zejména uživatelů z univerzit,
knihoven a dalších veřejně prospěšných institucí). V členských zemích UNESCO, ale také v rozvojových zemích hrají
digitální knihovny důležitou roli při rozšiřování iformací v oblastech vzdělávání, vědy a kultury. Věříme, že tento projekt
podpoří efektivní využití digitální knihoven v jejich úkolu sdílet a rozšiřovat informace ve společnosti.<p>Tento software
je vyvíjen a distribuován od srpna 2000 v rámci mezinárodní spolupráce mezi:
<table border="0">
<tr valign="top">
<td>
<a href="http://nzdl.org"><b>projekt New Zealand Digital Library na Universitě Waikato</b></a> 
<br>
Zde Greenstone vznikl. Byl podporován Komisí pro komunikaci, která je součástí novozélandského Národního sekretariátu pro UNESCO (jako součást příspěvku Nového Zélandu do programu UNESCO).
</td>
<td></td>
</tr>
<tr valign="top">
<td>
<a href="http://www.unesco.org"><b>United Nations Educational, Scientific and Cultural Organization</b></a> 

Klíčovým cílem UNESCO je rozšiřování informací pro vědu, vzdělávání a kulturní rozvoj. Zvláště dostupnost těchto informací v rozvojových zemích, je centrálním bodem mezivládního programu "Informace pro všechny"; kvalitní a dostupná informační a komunikační technologie se v tomto kontextu jeví jako důležitý nástroj.
</td>
<td><a href="http://www.unesco.org"><img alt="UNESCO logo" src="_httpimg_/unesco.gif"
border="0"></a></td>
</tr>
<tr valign="top">
<td>
<a href="http://humaninfo.org"><b>Nevládní organizace Human Info, se sídlem v Antverpách, Belgie</b></a> 

Tento projekt, spolupracující s agenturami Spojených národů (UN) a s dalšími nevládními organizacemi, si získal světové uznání díky digitalizaci a zpřístupnění dokumentů pro rozvoj zemí třetího světa. Sbírky jsou distribuovány rozvojovým zemím zdarma, ostatním za úhradu nákladů na výrobu.
</td>
<td><a href="http://humaninfo.org"><img alt="Human Info logo" src="_httpimg_/ghproj2.jpg" border="0"></a></td>
</tr>
</table> 
}


_textdescrselcol_ [l=cs] {zvolit kolekci}

######################################################################
# home help page
package homehelp
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_text4buts_ [l=cs] {Na domovské stránce jsou další čtyři tlačítka}

_textnocollections_ [l=cs] {<p>V současné době nejsou v rámci této instalace Greenstone k dispozici žádné kolekce.
Pro přídání kolekcí můžete
<ul>
 <li>použít <a href="_httppagecollector_">Collector</a> pro vytvoření nových kolekcí</li>
 <li>pokud máte CD-ROM Greenstone, můžete naisntalovat kolekce z CD-ROM
</ul>}

_text1coll_ [l=cs] {Tato instalace Greenstone obsahuje 1 kolekci}

_textmorecolls_ [l=cs] {Počet kolekcí v rámci této instalace Greenstone: _1_}

######################################################################
# external link package
package extlink
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textextlink_ [l=cs] {Externí odkaz}
_textlinknotfound_ [l=cs] {Interní odkaz nenalezen}

_textextlinkcontent_ [l=cs] {Zvolený odkaz vede k externímu dokumentu (vzhledem k vašim současným kolekcím).
Přejete-li si zobrazit odkazovanou stránku a váš prohlížeč má přístup k internetu, můžete
<a href"_nexturl_">použít tento odkaz</a>; v opačném případě se vraťte pomocí tlačítka "zpět" ve vašem prohlížeči.}

_textlinknotfoundcontent_ [l=cs] {Interní odkaz, který jste zvolili, neexistuje. Příčiny této chyby jsou mimo naše pole působností.
Nejpravděpodobnější příčinou je chyba ve zdrojových dokumentech kolekce.
Pro návrat k poslednímu dokumentu použijte ve vašem prohlížeči tlačítko "zpět".}

# should have arguments of collection, collectionname and link
_foundintcontent_ [l=cs] {<h3>Odkaz ke kolekci "_2_" </h3>

<p>
Odkaz, který jste zvolili je externí. Odkazuje na kolekci "_2_". Přejete-li si zobrazit dokument z kolece "_2_" můžete použít <a href"_httpdoc_&c_1_&cl_cgiargclUrlsafe_&d_3_">tento odkaz</a>; v opačném případě použijte tlačítka "zpět" ve vašem prohlížeči.}


######################################################################
# authentication page
package authen
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textGSDLtitle_ [l=cs] {Digitální knihovna Greenstone}

_textusername_ [l=cs] {přihlašovací jméno}
_textpassword_ [l=cs] {heslo}

_textmustbelongtogroup_ [l=cs] {Pozn. Musíte patřit do skupiny "_cgiargugHtmlsafe_"}

_textmessageinvalid_ [l=cs] {Požadovaná stránka vyžaduje autentifikaci.<br> 
_If_(_cgiargug_, [_textmustbelongtogroup_])<br>
Prosím zadejte přihlašovací jmého a heslo. }

_textmessagefailed_ [l=cs] {Buď Vaše přihlašovací jméno, nebo heslo jsou neplatné.}

_textmessagedisabled_ [l=cs] {Promiňte, Váš účet byl zablokován. Prosím kontaktujte správce této sítě.}

_textmessagepermissiondenied_ [l=cs] {Promiňte, nemáte oprávnění přistupovat k této stránce.}

_textmessagestalekey_ [l=cs] {Odkaz je zastaralý, prosím zadejte Vaše heslo.}


######################################################################
# 'docs' page 
package docs
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textnodocumentation_ [l=cs] {<p>
Tato instalace Greenstone neobsahuje žádnou dokumentaci. 
Možné příčiny:
<ol>
 <li>Greenstone byl nainstalován v kompaktní verzi (z disku CD-ROM ).
 <li>Greenstone byl nainstalován z internetu.
</ol>
V obou případech můžete získat dokumentaci buď z adresáře <i>docs</i> na disku
Greenstone CD-ROM, a nebo z <a href"http://www.greenstone.org">http://www.greenstone.org</a>. }

_textuserguide_ [l=cs] {Příručka uživatele}
_textinstallerguide_ [l=cs] {Instalační příručka}
_textdeveloperguide_ [l=cs] {"Příručka administrátora"}
_textpaperguide_ [l=cs] {Příručka 'Od papíru ke kolekci'}
_textorganizerguide_ [l=cs] {Používání nástroje 'Organizer'}

_textgsdocstitle_ [l=cs] {Dokumentace Greenstone}

######################################################################
# collectoraction
package collector
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdefaultstructure_ [l=cs] {výchozí nastavení}
_textmore_ [l=cs] {více}
_textinfo_ [l=cs] {Informace o kolekci}
_textsrce_ [l=cs] {Zdrojová data}
_textconf_ [l=cs] {Konfigurovat kolekci}
_textbild_ [l=cs] {Vytvořit kolekci}
_textview_ [l=cs] {Ukázat kolekci}
_textdel_ [l=cs] {Smazat kolekci}
_textexpt_ [l=cs] {Exportovat kolekci}

_textdownloadingfiles_ [l=cs] {Stahuji soubory...}
_textimportingcollection_ [l=cs] {Importuji kolekci...}
_textbuildingcollection_ [l=cs] {Vytvářím kolekci...}
_textcreatingcollection_ [l=cs] {vytváření kolekce...}

_textcollectorblurb_ [l=cs] {<i>Pero je mocnější než meč!
<br>
Tvorba a distrubuce informací s sebou přináší zodpovědnost, kterou byste si měli uvědomit ještě před tím,
než začnete. Nejsou to pouze právní problémy kolem autorských práv (to, že máte přístup k dokumentům
ještě neznamená, že je můžete dát druhým); existují i další otázky sociální a etické povahy. Zohledňuje
kolekce zvyky komunity, která vytvořila dokumenty? Jsou všechny texty vhodné k tomu, aby byly dány
k dispozici druhým? 
<br> 
Buďte vnímaví k síle informací a používejte ji moudře.</i>}

_textcb1_ [l=cs] {Collector Vám pomůže vytvořit nové nebo změnit či smazat  existující kolekce.
Celým procesem Vás provedede soubor stránek, které budou postupně vyžadovat zadání potřebných informací.}

_textcb2_ [l=cs] {Nejdříve musíte rozhodnout jestli}
_textcnc_ [l=cs] {vytvořit novou kolekci}
_textwec_ [l=cs] {pracovat s existujícími kolekcemi, přidávat do nich data nebo kolekci smazat.}

_textcb3_ [l=cs] {Chcete-li vytvářet nebo měnit digitální kolekce, musíte se přihlásit. Tímto zabráníme ostatním, aby se přihlásili k vašemu počítači a změnili vaše sbírky.
Upozornění: kvůli bezpečnostním důvodům budete každých 30 minut požádání o znovu-zadání hesla. Po přihlášení budete moci pokračovat právě z
toho místa, kde byla vaše práce přerušena.}

_textcb4_ [l=cs] {Prosím zadejte přihlašovací jméno a heslo pro Greenstone a stiskněte tlačítko pro přihlášení.}

_textfsc_ [l=cs] {Nejdříve vyberte kolekci, se kterou chcete pracovat (kolekce se zapnutou ochranou proti zápisu se v tomto seznamu neobjeví).}

_textwtc_ [l=cs] {S kolekcí, kterou jste zvolili, můžete}
_textamd_ [l=cs] {Přidat další data a znovu vytvořit kolekci}
_textetc_ [l=cs] {Upravit konfigurační soubor a znovu vytvořit kolekci}
_textdtc_ [l=cs] {Úplně smazat kolekci}
_textetcfcd_ [l=cs] {Exportovat kolekci a vytvořit instalační CD-ROM pro Windows}
_textcaec_ [l=cs] {Měním existující kolekci}
_textnwec_ [l=cs] {Není k dispozici žádná kolekce, do níž je povolen zápis.}
_textcianc_ [l=cs] {Vytvářím novou kolekci}
_texttsosn_ [l=cs] {Pořadí kroků potřebných pro vytvoření nové kolekce digitální knihovny je následující:}
_textsin_ [l=cs] {Zadejte její jméno (a doplňující informace)}
_textswts_ [l=cs] {Určit odkud pocházejí zdrojová data}
_textatco_ [l=cs] {Upravit konfigurační nastavení (pouze pro zkušenéh uživatele)}
_textbtc_ [l=cs] {"Vytvořit" kolekci (viz. níže)}
_textpvyh_ [l=cs] {Zobrazit výsledek }

_texttfsiw_ [l=cs] {Ve čtvrtém kroku už bude pracovat jenom počítač.
Při budování jsou vytvořeny indexy a shromážděny
všechny informace potřebné pro fungování kolekce.
Nejprve ale musíte určit, které informace to budou.}

_textadab_ [l=cs] {Diagram ve spodní části stránky Vám pomůže určit místo, kde se právě nacházíte. Zelené tlačítko Vás posunuje do následující fáze, žluté tlačítko zase do fáze předchozí.
Zároveň s tím, jak postupujete jednotlivými fázemi, se tlačítka obarvovují žlutě.}

_textwyar_ [l=cs] {Až budete hotovi, zmáčkněte zelené tlačítko "informace o kolekci". Proces tvorby začne.}

_textcnmbs_ [l=cs] {Jméno kolekce musí být specifikováno}
_texteambs_ [l=cs] {Emailová adresa musí být vyplněna}
_textpsea_ [l=cs] {Prosím specifikujte emailovou adresu ve tvaru: jmenouzivatele@domena}
_textdocmbs_ [l=cs] {Popis kolekce mustí být doplněn}

_textwcanc_ [l=cs] {Při vytváření nové kolekce musíte zadat některé důležité informace o zdrojových datech.
Tento proces je strukturován do série stránek, nad nimiž má dohled Collector.
Lišta ve spodní části stránky vám ukáže, ve které fázi se právě nacházíte.}

_texttfc_ [l=cs] {Název kolekce:}

_texttctiasp_ [l=cs] {Každá kolekce má název; je to krátká fráze, která identifikuje obsah kolekce.
Např. "Computer Science Technical Reports" nebo "Humanity Development Library".}

_textcea_ [l=cs] {Kontaktní emailová adresa:}

_textteas_ [l=cs] {Tato emailová adresa určuje, kdo je kontaktní osobou pro danou sbírku.
Jestli Greenstone objeví nějaký problém, zašle diagnostickou zprávu na tuto adresu.
Zadejte emailovou adresu v plném tvaru: <tt>jmeno@domena</tt>.}

_textatc_ [l=cs] {O této kolekci:}

_texttiasd_ [l=cs] {Toto je prohlášení, které popisuje celou kolekci. Při zobrazení kolekce je zobrazeno na úvodní stránce.}

_textypits_ [l=cs] {Vaše aktuální pozice je naznačena pomocí šipky -- v tomto případě je to fáze "informace o kolekci".
Chcete-li pokračovat, zmáčkněte zelené tlačítko "zdrojová data"}

_srcebadsources_ [l=cs] {<p>
Jeden nebo i několik zdrojů, které jste zadali, jsou nedosažitelné (značeny _iconcross_ ).<p>Možné příčiny <u><li>Soubor, FTP server nebo URL adresa neexistují. <li>Nejste připojeni na internet. <li>Pokoušíte se přistoupit ke stránce zpoza firewallu (když musíte zadávat přihlašovací jméno a heslo, abyste se dostali do internetu). </ul><p>Pokud vidíte stránku s touto URL adresou ve Vašem prohlížeči, může pocházet i z dočasné lokálně uložené kopie. Lokální kopie (cache) jsou bohužel pro náš importovací program neviditelné. Doporučujeme stránky stáhnout a uložit pomocí Vašeho prohlížeče.}

_textymbyco_ [l=cs] {<p>
Můžete založit svoji kolekci buď
<ul>
<li> na standardním nastavení
<dl><dd>Nová kolekce může obsahovat html dokumenty (.htm, .html), jednoduchý text(.txt, .text),
dokumenty MS Word (.doc), PDF dokumenty (.pdf) nebo formát "m-box" emailových souborů (.mbx)</dd></dl>
<li>na některé z existujících sbírek
<dl><dd> Soubory ve vaší nové kolekci musejí být stejného typu jako ty, které byly použity v existující sbírce.</dd></dl>
</ul> }

_textbtco_ [l=cs] {Založit kolekci na}
_textand_ [l=cs] {Přidat nová data}
_textad_ [l=cs] {Přidávat data:}

_texttftysb_ [l=cs] {Soubory, které určíte niže na této stránce, budou přidány do kolekce. Ujistěte se, že existují v kolekci pouze
jednou; v opačném případě se v kolekci objeví duplikáty. Soubory jsou identifikovány podle své
plné cesty, webové stránky podle své absolutní adresy.}

_textis_ [l=cs] {Zdroje pro import:}

_textddd1_ [l=cs] {<p>
Pokud použijete <b>file://</b> nebo <b>ftp://</b>, abyste určili jeden soubor, potom bude stažen pouze ten jediný soubor.

<p>Pokud použijete  <b>http://</b>, výsledek bude záviset na tom, jestli zadaná URL adresa odkazuje na normální web. stránku,
jak ji vidíte v prohlížeči, a nebo na adresář stránek. Jestliže je to normální stránka, bude importována a spolu s ní také dokumenty,
na které odkazuje (stahování se nezastaví u prvních odkazů, ale bude sledovat další odkazy a stáhne všechny odkazované dokumenty
z <b>daného</b> serveru (URL).
<p>Jestliže použijete URL, které odkazuje na adresář <b>http://</b>  (<b>ftp://</b>, <b>file://</b>), tak potom bude importován veškerý
obsah dané složky (včetně podsložek).<p>
Chcete-li více políček pro zadání adresy, zmáčkněte tlačítko "více zdrojů".}

_textddd2_ [l=cs] {<p>
Zmáčkněte jedno ze zelených tlačítek. Nejste-li zkušenými uživateli, pokračujte do dalšího kroku.
Zapamatujte si, že se můžete vždy do předchozího kroku tím, že zmáčknete žluté tlačítko.}

_textconf1_ [l=cs] {<p>
Tvorba a způsob zobrazení vaší kolekce je kontrolován nastavením
ve speciálním konfiguračním souboru. Zkušení uživatelé jej pravděpodobně
budou chtít změnit.
<center><p>
<b>Pokud nejste zkušenými uživateli, jednoduše přejděte na další stránku.</b></center>
<p>Chcete-li změnit nastavení, upravte řádky, které jsou zobrazeny níže.
Pokud uděláte chybu, můžete použít tlačítka "Reset" - objeví se původní konfigurační soubor.}

_textreset_ [l=cs] {Reset}

_textbild1_ [l=cs] {Kolekce se nyní vytváří: může to chvíli trvat. Řádek ve spodní části obrazovky naznačuje právě probíhající operace.}

_textbild2_ [l=cs] {Pokud chcete ukončit proces tvorby, můžete kdykoli kliknout zde. <br> 
Kolekce na které se právě pracuje zůstane nezměněna.}

_textstopbuild_ [l=cs] {zastavit tvorbu}

_textbild3_ [l=cs] {Pokud tuto stránku opustíte (a nezrušíte tvorbu kolekce pomocí tlačítka "stop"), proces bude pokračovat a po úspěšném dokončení bude kolekce automaticky nainstalována.}

_textbuildcancelled_ [l=cs] {Tvorba zrušena}

_textbildcancel1_ [l=cs] {Tvorba kolekce byla zrušena. Použijte žlutého tlačítka vespodu, pokud chcete změnit konfiguraci, a nebo spusťte tvorbu znovu.}

_textbsupdate1_ [l=cs] {Indikátor tvorby se akturalizuje za 1 sekundu}
_textbsupdate2_ [l=cs] {Indikátor tvorby aktualizován v }
_textseconds_ [l=cs] {sekund}
_textbildsuc_ [l=cs] {Kolekce byla úspěšně vytvořena.}

_textviewbildsummary_ [l=cs] {Můžete zobrazit<a href"_httppagex_(bsummary)&c_cgiargbc1dirnameHtmlsafe_" target_top>detailní zprávu</a> o tvorbě kolekce.}

_textfailmsg11_ [l=cs] {Kolekce nemohla být vytvořena, protože neobsahuje žádná data. Ujistěte se, že alespoň
jeden adresář nebo soubor, který jste zadali na stránce <i>zdrojová data</i>, existuje
a obsahuje typ informací, které Greenstone dokáže zpracovat.}

_textfailmsg21_ [l=cs] {Kolekce nemohla být vytvořena (chyba import.pl).}
_textblcont_ [l=cs] {Zpráva obsahuje následující informace:}

_texttryagain_ [l=cs] {Prosím <a href"_httppagecollector_" target_top>znovu spusťte Collector</a> a zkuste vše znovu.}

_textfailmsg31_ [l=cs] {Kolekce nemohla být vytvořena (chyba buildcol.pl).}
_textfailmsg41_ [l=cs] {Kolekce byla úspěšně vytvořena, ale nemohla být nainstalována.}
_textfailmsg71_ [l=cs] {Během pokusu o vytvoření kolekce nastala neočekávaná chyba.}
_textretcoll_ [l=cs] {Vrátit se do Collector}

_textdelperm_ [l=cs] {Některé z _cgiargbc1dirnameHtmlsafe_ kolekcí nemohly být smazány. Možné příčiny jsou:<ul>
<li>Greenstone nemá oprávnění mazat adresář _gsdlhome_/collect/_cgiargbc1dirnameHtmlsafe_.<br>
Budete muset odstranit tuto kolekci ručně, aby zmizela úplně z tohoto počítače.</li>
<li>Greenstone nemůže spustit program _gsdlhome_/bin/script/delcol.pl Ujistěte se,
že soubor má nastaveny atributy "ke čtení" a "spustitelný".</li></ul>}

_textdelinv_ [l=cs] {Kolekce _cgiargbc1dirnameHtmlsafe_ je uzamčena, a nebo je naplatná. Smazání bylo zrušeno.}

_textdelsuc_ [l=cs] {Kolekce _cgiargbc1dirnameHtmlsafe_ byla úspěšně smazána.}

_textclonefail_ [l=cs] {_cgiargclonecolHtmlsafe_ kolekce nemohla být zkopírována. Možné příčiny jsou:
<ul>
<li>Kolekce _cgiargclonecolHtmlsafe_ neexistuje</li>
<li>Kolekce _cgiargclonecolHtmlsafe_ postrádá konfigurační soubor (collect.cfg)</li>
<li>Greenstone nemá oprávnění číst z collect.cfg</li>
</ul>}

_textcolerr_ [l=cs] {Chyba Collector}

_texttmpfail_ [l=cs] {Collector hlásí, že nemohl číst nebo zapisovat dovnitř dočasného adresáře (souboru).
Možné příčiny jsou:
<ul>
<li>Greenstone nemá oprávnění zapisovat/číst do adressáře _gsdlhome_/tmp.<./li>
</ul>}

_textmkcolfail_ [l=cs] {Collector hlásí chybu při vytváření adresářové struktury (chyba mkcol.pl).
Možné příčiny jsou:
<ul>
<li>Greenstone nemá oprávnění zapisovat do adresáře _gsdlhome_/tmp</li>
<li>chyba v perl skriptu mkcol.pl</li>
</ul> 
}

_textnocontent_ [l=cs] {Chyba Collector: pro novou kolekci nebylo specifikováno žádné jméno. Restartujte Collector od začátku.}

_textrestart_ [l=cs] {Restartovat Collector}

_textreloaderror_ [l=cs] {Během tvorby nové kolekce se objevila chyba. Greenstone mohl být zmaten tím,
že jste ve Vašem prohlížeči použili tlačítka "aktualizuj" a nebo "zpět"i. Vyvarujte se prosím
používání těchto tlačítek během procesu tvorby kolekce. Doporučujeme
restartovat Collector od začátku.}

_textexptsuc_ [l=cs] {Kolekce _cgiargbc1dirnameHtmlsafe_ byla úspěšně exportována do adresáře _gsdlhome_/tmp/exported\__cgiargbc1dirnameHtmlsafe_ }

_textexptfail_ [l=cs] {<p>
Chyba při exportu kolekce _cgiargbc1dirnameHtmlsafe_ .<p>
Tato chyba je pravděpodobně způsobena tím, že Greenstone byl nainstalován bez komponent nezbytných
pro fungování funkce exportování kolekce.
<ul>
<li>Pokud jste instalovali Greenstone z disku CD-ROM, tyto balíčky nebyly přidány. Volba je dostupná pouze
při typu instalace "Custom". Můžete však spustit instalaci znovu a vybrat Custom - "Export Collection".</li>

<li>Jestli jste instalovali Greenstone z jiného zdroje, budete si muset stáhnout přídavný balíček. Prosím navštivte
<a href"http://www.greenstone.org">http://www.greenstone.org</a> a nebo napište na
<a href"mailto:greenstone@cs.waikato.ac.nz">greenstone@cs.waikato.ac.nz</a>, poskytneme vám další informace.</li>

</ul>}


######################################################################
# 'gsdl' page
package gsdl
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------


_textgreenstone1_ [l=cs] {Greenstone je balíkem programů, které mají schopnost vytvářet a prezentovat kolekce v rámci digitálních knihoven.
Nabízí nový způsob organizování a publikování informací na internetu i na CD-ROM. Greenstone je vyvíjen
v rámci projektu New Zealand Digital Library na universitě Waikato, a je distribuován ve spolupráci s UNESCO
a nevládní organizací Human Info. Je to otevřený systém (open-source), dostupný z <i>http://greenstone.org</i>
za podmínek GNU General Public License.}

_textgreenstone2_ [l=cs] {Internetové stránky projektu New Zealand Digital library (<a href"http://nzdl.org">http://nzdl.org</a>)
obsahují množství ukázek hotových kolekcí. Všechny byly vytvořeny v programu Greenstone
a předvádějí jeho možnosti vyhledávání a prohlížení. Naleznete tam kolekce arabské, čínské,
francouzské, v jazyce Maori nebo ve Španělštině či Angličtině a také několik kolekcí hudebních.}

_textplatformtitle_ [l=cs] {platforma}
_textgreenstone3_ [l=cs] {Greenstone funguje v operačních systémech Windows i Unix a Mac OS X. Distrubuční balíčky obsahují
hotové binární instalace pro Windows a pro Linux a Mac OS X. K dipozici je také kompletní zdrojový
kód, který lze kompilovat pomocí Microsoft C++ nebo gcc. Greenstone používá volně šiřitelné programy,
které jsou také k dispozici: webserver Apache a PERL. Rozhraní pro Greenstone využívá webový prohlížeč
(např. Netscape Navigator nebo Internet Explorer).}

_textgreenstone4_ [l=cs] {Mnoho kolekcí je distribuováno na CD-ROM discích s programem Greenstone. Např. <i>Humanity Development Library</i>,
která obsahuje 1 230 publikací sahající od oblasti účetnictví k hygieně pitné vody. 
Distribuce mají minimální nároky na výkon počítače a proto se hodí i do podmínek,
které jsou v rozvojových zemích. Dokumenty lze prohledávat, ale i prohlížet podle předmětových hesel,
názvů, organizací, seznamů "Jak na .." či náhodně podle knižních přebalů.}

_textcustomisationtitle_ [l=cs] {přizpůsobení}
_textgreenstone5_ [l=cs] {Greenstone je speciálně navržen tak, aby se dal rozšiřovat a upravovat. Nové formáty
dokumentů i metadat se připojují pomocí (Perl) "pluginů" a "klasifikátorů". Vzhled
uživatelského rozhraní lze měnit pomocí "maker" napsaných pomocí jednoduchého makrojazyka.
Protokol Corba dovoluje programům (agenti - napsaní například v programovacím jazyce Java),
aby využívali procedur připojených ke sbírkám. A konečně, zdrojový kód napsaný v C++ a v Perl je
k dispozici pro další úpravy.}

_textdocumentationtitle_ [l=cs] {dokumentace}
_textdocuments_ [l=cs] {K dispozici je rozsáhlá dokumentace software Greenstone.}

#_textthreedocs_ {There are three documents that explain the Greenstone system:}
#_textinstall_ {The Greenstone Digital Library Software Installer's Guide}
#_textuser_ {The Greenstone Digital Library Software User's Guide}
#_textdevelop_ {The Greenstone Digital Library Software Developer's Guide}

_textmailinglisttitle_ [l=cs] {e-mailová konference}
_textmailinglist_ [l=cs] {Pro diskuse o používání digitální knihovny Greenstone existují emailová konference.
K přihlášení použijte stránky <a href"https://list.scms.waikato.ac.nz/mailman/listinfo/greenstone-users">https://list.scms.waikato.ac.nz/mailman/listinfo/greenstone-users</a>.
Chcete-li odeslat zprávu, zašlete ji na <a href"mailto:greenstone-users@list.scms.waikato.ac.nz" >greenstone-users@list.scms.waikato.ac.nz</a>. }

_textbugstitle_ [l=cs] {chyby}
_textreport_ [l=cs] {Chceme se ujistit, že tento program dělá svou práci dobře. Prosíme hlaste jakoukoliv
chybu na <a href"mailto:greenstone@cs.waikato.ac.nz">greenstone@cs.waikato.ac.nz</a>.  }

_textgs3title_ [l=cs] {v pracích}
_textgs3_ [l=cs] {Greenstone 3 je kompletním přepracováním a novou implementací, která
zachovává všechny výhody Greenstone 2 (současná verze). Například je
vícejazyčný, multiplatformní a značně konfigurovatelný. Slučuje všechny
rysy existujícího systému a zachovává zpětnou kompatibilitu: to znamená,
že umožňuje vytvářet a provozovat existující kolekce bez nutnosti jejich úpravy.
Systém je naprogramován v jazyce Java a je strukturován jako sít nezávislých modulů
komunikujících za použití XML: díky tomu může fungovat v distribuované podobě a
v případě potřeby může být umístěn na několika různých serverech. Toto modulární
pojetí zvětšuje přizpůsobivost a rozšiřitelnost systému Greenstone. Nová verze
by měla být pro experimentální využití k dipozici od 23. prosince 2003.
Základní návrh systému je nestíněn v dokumentu "The design of Greenstone 3:
An agent based dynamic digital library" (nahrát  <a href="http://www.greenstone.org/manuals/gs3design.pdf">PDF</a>).}

_textcreditstitle_ [l=cs] {o autorech}

_textwhoswho_ [l=cs] {Greenstone je výsledkem týmové práce mnoha lidí. Hlavními architekty systému jsou Rodger McNab a Stefan Boddie.
Dalšími přispěvatali byli David Bainbridge, George Buchanan, Hong Chen, Michael Dewsnip, Katherine Don, Elke Duncker,
Carl Gutwin, Geoff Holmes, Dana McKay, John McPherson, Craig Nevill-Manning, Dynal Patel, Gordon Paynter, Bernhard Pfahringer,
Todd Reed, Bill Rogers, John Thompson, and Stuart Yeates. Ostatní členové projektu poskytovali rady a inspiraci pro design systému :
Mark Apperley, Sally Jo Cunningham, Matt Jones, Steve Jones, Te Taka Keegan, Michel Loots, Malika Mahoui, Gary Marsden, Dave Nichols
a Lloyd Smith. A chceme také upozornit na všechny ty, kteří přispěli do GNU programů zahrnutých v této distribuci:
MG, GDBM, PDFTOHTML, PERL, WGET, WVWARE a XLHTML.}

_textaboutgslong_ [l=cs] {o programu Greenstone}

######################################################################
# 'users' page
package userslistusers
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textlocu_ [l=cs] {Skupina aktuálních uživatelů}
_textuser_ [l=cs] {uživatel
}
_textas_ [l=cs] {stav účtu}
_textgroups_ [l=cs] {skupiny}
_textcomment_ [l=cs] {poznámky}
_textadduser_ [l=cs] {přidat nového uživatele}
_textedituser_ [l=cs] {editovat}
_textdeleteuser_ [l=cs] {smazat}


######################################################################
# 'users' page
package usersedituser
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------


_textedituser_ [l=cs] {Editovat informace o uživateli}
_textadduser_ [l=cs] {Přidat nového uživatele}

_textaboutusername_ [l=cs] {Uživatelské jméno musí mít délku 2-30 znaků. Může obsahovat alfanumerické znaky, tečku(.) a podtržítko ( _ ).}

_textaboutpassword_ [l=cs] {Heslo musí mít délku 3-8 znaků. Může obsahovat tisknutelné znaky ASCII.}

_textoldpass_ [l=cs] {Pokud je toto pole prázdné, bude zachováno staré heslo.}
_textenabled_ [l=cs] {povoleno}
_textdisabled_ [l=cs] {zakázáno}

_textaboutgroups_ [l=cs] {Členové skupiny se oddělují čárkou, prosím nevkládejte žádné mezery.}


######################################################################
# 'users' page
package usersdeleteuser
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textdeleteuser_ [l=cs] {smazat uživatele}
_textremwarn_ [l=cs] {Skutečně chcete zcela odstranit uživatele <b>_cgiargumunHtmlsafe_</b>?}


######################################################################
# 'users' page
package userschangepasswd
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textchangepw_ [l=cs] {Změnit heslo}
_textoldpw_ [l=cs] {staré heslo}
_textnewpw_ [l=cs] {nové heslo}
_textretype_ [l=cs] {zadejte heslo ještě jednou}


######################################################################
# 'users' page
package userschangepasswdok
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textsuccess_ [l=cs] {Vaše heslo bylo úspěšně změněno.}


######################################################################
# 'users' page
package users
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textinvalidusername_ [l=cs] {Uživatelské jméno není platné.}
_textinvalidpassword_ [l=cs] {Heslo není platné.}
_textemptypassword_ [l=cs] {Zadejte prosím výchozí heslo pro tohoto uživatele.}
_textuserexists_ [l=cs] {Tento uživatel už existuje, prosím zvolte jiné jméno.}

_textusernameempty_ [l=cs] {Prosím, vložte vaše uživatelské jmého.}
_textpasswordempty_ [l=cs] {Musíte zadat původní heslo.}
_textnewpass1empty_ [l=cs] {Zadejte vaše nové heslo a potvrďte jej ještě jednou.}
_textnewpassmismatch_ [l=cs] {Dvě verze vašeho hesla se od sebe liší.}
_textnewinvalidpassword_ [l=cs] {Zadali jste neplatné heslo.}
_textfailed_ [l=cs] {Uživatelské jméno nebo heslo nebylo správné.}


######################################################################
# 'status' pages
package status
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------


_textversion_ [l=cs] {Verze Greenstone}
_textframebrowser_ [l=cs] {Váš prohlížeč musí být schopen zobrazovat rámce (frames).}
_textusermanage_ [l=cs] {Správa uživatelů}
_textlistusers_ [l=cs] {seznam uživatelů}
_textaddusers_ [l=cs] {přidat nového uživatele}
_textchangepasswd_ [l=cs] {změnit heslo}
_textinfo_ [l=cs] {Technické informace}
_textgeneral_ [l=cs] {všeobecně}
_textarguments_ [l=cs] {argumenty}
_textactions_ [l=cs] {akce}
_textbrowsers_ [l=cs] {prohlížeč}
_textprotocols_ [l=cs] {protokoly}
_textconfigfiles_ [l=cs] {Soubory s konfigurací}
_textlogs_ [l=cs] {Protokol o aktivitách}
_textusagelog_ [l=cs] {protokol o použití}
_textinitlog_ [l=cs] {protokol o vstupech}
_texterrorlog_ [l=cs] {soubor o chybách}
_textadminhome_ [l=cs] {domov správce}
_textreturnhome_ [l=cs] {Greenstone home}
_titlewelcome_ [l=cs] {Administrace}
_textmaas_ [l=cs] {Dostupné služby pro administraci a údržbu zahrnují:}
_textvol_ [l=cs] {zobrazit on-line přístupy}
_textcmuc_ [l=cs] {vytvořit, udržovat a aktualizovat kolekce}
_textati_ [l=cs] {přístup k technickým informací, jako např. CGI argumenty}

_texttsaa_ [l=cs] {Tyto služby se aktivují použitím krajní navigační lišty na levé straně obrazovky.}

_textcolstat_ [l=cs] {Status kolekce}

_textcwoa_ [l=cs] {Kolekce budou mít atribut "spuštěná", pouze pokud jejich konfigurační soubory existují
(build.cfg), jsou čitelné, obsahují platná pole data vytvoření (tj. > 0) a jsou v adresáři index
(tzn. ne uvnitř adresáře building). }

_textcafi_ [l=cs] {klikněte na <i>abbrev.</i> pro informace o dané kolekci}
_textcctv_ [l=cs] {klikněte na <i>kolekci<i> pro zobrazení}
_textsubc_ [l=cs] {Uložit změny}
_texteom_ [l=cs] {Chyba při otevírání main.cfg}
_textftum_ [l=cs] {Změna main.cfg se nezdařila}
_textmus_ [l=cs] {main.cfg úspěšně aktualizován}


######################################################################
# 'bsummary' pages
package bsummary
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------

_textbsummary_ [l=cs] {Vytvořit souhrn o kolekci _collectionname_}
_textflog_ [l=cs] {Soubor se zprávou o ztracených souborech _collectionname_}


############################################################################
#
# This stuff is only used by the usability (I'd like to Complain) stuff
#
############################################################################
package Global

_greenstoneusabilitytext_ [l=cs] {Použitelnost Greenstone}

_textwhy_ [l=cs] {<p>
Tím, že odešlete tuto zprávu, nám dáte najevo, že prohlížená stránka byla složitá či odrazující.}
_textextraforform_ [l=cs] {Nemusíte vyplnit celý formulář -- jakékoliv informace pomohou.}
_textprivacybasic_ [l=cs] {<p>
Zpráva bude obsahovat pouze informace o webové stránce, kterou jste právě viděli a informace o technice, kterou jste k jejímu zobrazení používali (plus dodatečné informace, které nám napíšete).}
_textstillsend_ [l=cs] {Přejete si odeslat tuto zprávu?}

_texterror_ [l=cs] {chyba}
_textyes_ [l=cs] {Ano}
_textno_ [l=cs] {Ne}
_textclosewindow_ [l=cs] {Zavřít okno}
_textabout_ [l=cs] {O}
_textprivacy_ [l=cs] {Soukromé}
_textsend_ [l=cs] {Odeslat}
_textdontsend_ [l=cs] {Neodesílat}
_textoptionally_ [l=cs] {Volitelně}

_textunderdev_ [l=cs] {Detailní přehled bude k dispozici ve finální verzi.}

_textviewdetails_ [l=cs] {Ukázat detailní zprávu}
_textmoredetails_ [l=cs] {Více podrobností}
_texttrackreport_ [l=cs] {Sledovat tuto zprávu}
_textcharacterise_ [l=cs] {Co to je za problém}
_textseverity_ [l=cs] {Jak závažný je to problém}
 
_textbadrender_ [l=cs] {Stránka vypadá divně}
_textcontenterror_ [l=cs] {Chyba obsahu}
_textstrangebehaviour_ [l=cs] {Podivné chování}
_textunexpected_ [l=cs] {Stalo se něco neočekávaného}
_textfunctionality_ [l=cs] {Obtížné používání}
_textother_ [l=cs] {Jiné}

_textcritical_ [l=cs] {Krický}
_textmajor_ [l=cs] {Závažný}
_textmedium_ [l=cs] {Střední}
_textminor_ [l=cs] {Okrajový}
_texttrivial_ [l=cs] {Nicotný}

_textwhatdoing_ [l=cs] {Co jste chtěli udělat?}
_textwhatexpected_ [l=cs] {Co jste očekávali?}
_textwhathappened_ [l=cs] {Co se stalo?}

_cannotfindcgierror_ [l=cs] {<h2>Omlouváme se.</h2>Nelze najít příslušné programy na serveru (pro službu "Rád bych poznamenal...").}

_textusabbanner_ [l=cs] {koru-style baner pro Greenstone}


######################################################################
# GTI text strings
package gti
######################################################################


#------------------------------------------------------------
# text macros
#------------------------------------------------------------
	

############
# gli page
############
package gli

_textglilong_ [l=cs] {rohraní Greenstone Librarian}
_textglihelp_ [l=cs] {Rozhraní Librarian (zkracováno jako GLI polde <i>Greenstone Librarian Interface</i>) poskytuje
snadno použitelný přístup k funkcím systému Greenstone formou grafického uživatelského rozhraní.
To umožňuje shormažďovat skupiny dokumentů, importovat a přiřazovat metadata a vytvářet kolekce
digitální knihovny Greenstone.
<p>
GLI pracuje ve spojení s Greenstone a předpokládá se, že je nainstalován v podadresáři
instalace Greenstone. To platí pokud jste nahráli jednu z distirbucí Greenstone z internetu nebo
jste ji nainstalovali z CD-ROM.


<h4>Spuštění GLI ve Windows</h4>

Ve Windows spustíte Librarian přes hlavní menu (<i>Start</i>) a položky
 <i>Programy</i>, <i>Greenstone Digital Library</i> výběrem <i>Greenstone Librarian Interface</i>.

 
<h4>Spuštění GLI pod Unixem</h4>

Pro spuštění GLI pod Unixem otevřete podadresář <i>gli</i> adresáře instalace Greenstone 
a spusťte skript <i>gli.sh</i>.}

