/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gui;

/**************************************************************************************
 * Written:     04/07/03
 * Revised:     
 **************************************************************************************/
import javax.swing.*;
import javax.swing.text.*;
import org.greenstone.gatherer.Dictionary;

/** A JTextField that doesn't allow whitespace characters. 
 * @author John Thompson, Greenstone Digital Library, University of Waikato
 * @version 2.4
 */
public class NonWhitespaceField 
    extends JTextField {
 
    public NonWhitespaceField() {
	super();
        this.setComponentOrientation(Dictionary.getOrientation());
    }

    public NonWhitespaceField(String text) {
	super(text);
        this.setComponentOrientation(Dictionary.getOrientation());
    }
 
    protected Document createDefaultModel() {
	return new NonWhitespaceDocument();        
    }
 
    static class NonWhitespaceDocument 
	extends PlainDocument {
		  
	public void insertString(int offs, String str, AttributeSet a) 
	    throws BadLocationException {
				
	    if (str == null) {
		return;
	    }
	    char[] raw = str.toCharArray();
	    StringBuffer result = new StringBuffer("");
	    for (int i = 0; i < raw.length; i++) {
		if(!Character.isWhitespace(raw[i])) {
		    result.append(raw[i]);
		}
	    }
	    super.insertString(offs, result.toString(), a);
	}
    }
}
