@echo off
setlocal

set GSDL_DIR=..\..\..
echo GSDL_DIR is %GSDL_DIR%

set OBJECTS=JdbmAPI.class Jdb2Txt.class Txt2Jdb.class JdbGet.class JdbSet.class JdbDel.class JdbKeys.class

echo %OBJECTS%

set JDBM_JAR=..\..\packages\jdbm\jdbm-1.0\dist\jdbm-1.0.jar

rem ---- Where to put class files ----
set JDBMHOME=.

rem ---- Name and location of java programs ----
set JAVAC="%JAVA_HOME%\bin\javac"
set JAVAH="%JAVA_HOME%\bin\javah"
set JAVA="%JAVA_HOME%\bin\java"
set JAVADOC="%JAVA_HOME%\bin\javadoc"
set JAR="%JAVA_HOME%\bin\jar"

set JAVACOPTIONS=-deprecation -g -O


if "%DEBUG%" == "" (
  set MAKE_VARS=DEBUG=0
) else (
  set MAKE_VARS=DEBUG=%DEBUG%
)

if ""%1"" == """" goto all
if ""%1"" == ""all"" goto all
if ""%1"" == ""install"" goto install
if ""%1"" == ""clean"" goto clean

:unknown
	echo Error: Unrecognized argument %1.
	goto done

:all
	for %%G in (*.java) DO %JAVAC% -classpath %JDBM_JAR%;. "%%G"
	%JAR% cvf JDBMWrapper.jar %OBJECTS%
	@echo Done
	goto done

:install
	copy JDBMWrapper.jar "%GSDL_DIR%\bin\java"
	goto done

:clean
	for /f %%G in (*.class test.lg test.jdb) if exist %%G del /q %%G
	if exist JDBMWrapper.jar del JDBMWrapper.jar
	goto done

:test-api
	%JAVA% -classpath %JDBM_JAR%:JDBMWrapper.jar JdbmAPI test
	goto done

:done
:: http://ss64.com/nt/endlocal.html
:: If SETLOCAL is used without a corresponding ENDLOCAL then local
:: environment variables will be discarded when the batch file ends.
