###########################################################################
#
# win32 makefile -- txt2db
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

GSDLHOME = ..\..\..\..
COMMON_DIR = ..\..\..

GSDL_VC4 = 0
STLPATH = "$(COMMON_DIR)\packages\windows\stlport\stlport"

AR = lib
CC = cl
DEBUG = 0

!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
LDFLAGS = -DEBUG -Z7 /errorReport:prompt 
!ELSE
CXXFLAGS =
LDFLAGS =
!ENDIF

!IF $(GSDL_VC4)
CXXFLAGS = $(CXXFLAGS) -GX
!ELSE
CXXFLAGS = $(CXXFLAGS) -EHsc
!ENDIF


DEFS = -D__WIN32__ -DHAVE_CONFIG_H -D_CRT_SECURE_NO_DEPRECATE
INCLUDES = -I"$(COMMON_DIR)\src\gdbmedit\txt2db" -I"$(COMMON_DIR)\src\lib" \
	   -I"$(COMMON_DIR)\packages\gdbm\gdbm-1.8.3" -I"$(COMMON_DIR)\packages\gdbm\gdbm-1.8.3\windows"
!IF $(GSDL_VC4)
DEFS=$(DEFS) -DGSDL_NAMESPACE_BROKEN -DGSDL_USE_IOS_H -D__STL_NO_NEW_IOSTREAMS
INCLUDES = $(INCLUDES) -I$(STLPATH)
!ENDIF

LIBS = "$(COMMON_DIR)\src\lib\gsdllib.lib" \
       "$(COMMON_DIR)\packages\gdbm\gdbm-1.8.3\gdbm.lib"

COMPILE = $(CC) -nologo -c $(CXXFLAGS) $(DEFS) $(INCLUDES)
LINK = $(CC) -nologo $(LDFLAGS)

.SUFFIXES:
.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $<

ANSI2KNR = 
o = .obj
e = .exe
 
HEADERS = 

SOURCES = txt2db.cpp

OBJECTS = txt2db$o

EXEC = txt2db$e
 
all : $(EXEC)

install: $(EXEC)
	if NOT EXIST "$(GSDLHOME)\bin\windows" mkdir "$(GSDLHOME)\bin\windows"
	copy $(EXEC) "$(GSDLHOME)\bin\windows"

clean:
	del *.obj
	del $(EXEC)

txt2db$e: $(OBJECTS) $(LIBS)
	  $(LINK) $(OBJECTS) $(LIBS)
