###########################################################################
#
# win32 makefile -- search4j
# Copyright (C) 2008  DL Consulting Ltd
#
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

AR = lib
CC = cl
LINKER = link

DEBUG = 0
GSDL_VC4 = 0

!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
LDFLAGS = -DEBUG -Z7 /errorReport:prompt
!ELSE
CXXFLAGS =
LDFLAGS = 
!ENDIF

!IF $(GSDL_VC4)
CXXFLAGS = $(CXXFLAGS) -GX
!ELSE
CXXFLAGS = $(CXXFLAGS) -EHsc
!ENDIF

!IF !DEFINED(BINDIR)
BINDIR = bin
!ENDIF

!IF !DEFINED(LIBDIR)
LIBDIR = lib
!ENDIF


DEFS = -D_CRT_SECURE_NO_DEPRECATE
INCLUDES = 
LIBS = advapi32.lib

# ---- Name and location of java programs ----
JAVAC = javac
JAR   = jar

JAVACOPTIONS = -deprecation -g -O -source 1.8 -target 1.8


COMPILE = $(CC) -c /DWINDOWS $(CXXFLAGS) $(DEFS) $(INCLUDES)
LINK = $(LINKER) /OUT:$@ $(LDFLAGS)

.SUFFIXES:
.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $<

SOURCES = libsearch4j.cpp search4j.cpp
OBJECTS = libsearch4j.obj search4j.obj
EXECUTABLE_OBJECTS = $(OBJECTS)
EXECUTABLE = search4j.exe

all: $(EXECUTABLE) install compile-java install-java

search4j.exe: $(EXECUTABLE_OBJECTS) 
	$(LINK) $(LIBS) $(EXECUTABLE_OBJECTS)

clean:
	del $(OBJECTS)
	del $(EXECUTABLE)
	del DisplayJavaVersion.class
	del DisplayJavaBitness.class

install: $(EXECUTABLE)
	IF NOT EXIST "$(BINDIR)\.." mkdir "$(BINDIR)\.."
	IF NOT EXIST "$(BINDIR)" mkdir "$(BINDIR)"
	copy $(EXECUTABLE) "$(BINDIR)"

compile-java:
	$(JAVAC) $(JAVACOPTIONS) -cp jna.jar DisplayJavaVersion.java
	$(JAVAC) $(JAVACOPTIONS) -cp jna.jar DisplayJavaBitness.java
	$(JAR) cvfm display-java-version.jar Manifest-version.txt DisplayJavaVersion.class
	$(JAR) cvfm display-java-bitness.jar Manifest-bitness.txt DisplayJavaBitness.class

install-java:
	IF NOT EXIST "$(LIBDIR)\.." mkdir "$(LIBDIR)\.."
	IF NOT EXIST "$(LIBDIR)" mkdir "$(LIBDIR)"
	IF NOT EXIST "$(LIBDIR)\java" mkdir "$(LIBDIR)\java"
	copy display-java-version.jar "$(LIBDIR)\java"
	copy jna.jar "$(LIBDIR)\java"
	copy display-java-bitness.jar "$(LIBDIR)\java"
