###########################################################################
#
# win32 makefile -- mgpp\lib
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

MGPPHOME = ..

DEBUG = 0

AR = lib
CC = cl

!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
!ELSE
CXXFLAGS =
!ENDIF


DEFS = -DQUIET -DHAVE_CONFIG_H -D__WIN32__ -DSHORT_SUFFIX -D_CRT_SECURE_NO_DEPRECATE
INCLUDES = -I"." -I"$(MGPPHOME)"

COMPILE = $(CC) -c $(DEFS) $(INCLUDES) $(CXXFLAGS)

.SUFFIXES:
.SUFFIXES: .c .cpp .obj
.c.obj:
	$(COMPILE) $<
.cpp.obj:
	$(COMPILE) $<

ANSI2KNR = 
o = .obj

HEADERS = \
    bitio_m_random.h   local_strings.h    lovinstem.h \
    bitio_m_stdio.h    memlib.h           netorder.h \
    bitio_gen.h        mgheap.h           messages.h \
    bitio_m.h          huffman.h  \
    bitio_m_mem.h      perf_hash.h \
    bitio_m_mems.h      \
    pathmax.h          getpagesize.h      sysfuncs.h         bitio_m_abstract.h  \
    random.h           simplefrenchstem.h unitool.h	     longlong.h \
    non_ansi.h         getopt_old.h       win32in.h


SOURCES = \
    mgheap.cpp         \
    huffman.cpp       messages.cpp \
    bitio_gen.cpp     perf_hash.cpp \
    local_strings.cpp lovinstem.cpp \
    bitio_m_mem.cpp   bitio_m_stdio.cpp bitio_m_mems.cpp \
    alloca.c          xmalloc.c         strstr.cpp \
    ftruncate.cpp     strcasecmp.cpp    random.cpp \
    simplefrenchstem.cpp                unitool.cpp       bitio_m_random.cpp \
    bitio_m_abstract.cpp                getopt_old.c      win32in.c
# memlib.cpp removed


OBJECTS =  mgheap$o   \
    huffman$o         messages$o \
    bitio_gen$o       perf_hash$o \
     local_strings$o   lovinstem$o \
    bitio_m_mem$o     bitio_m_stdio$o   bitio_m_mems$o \
    xmalloc$o         bitio_m_random$o  bitio_m_abstract$o \
     random$o          simplefrenchstem$o \
    unitool$o         getopt_old$o      win32in$o

 
DISTFILES = Makefile.in $(HEADERS) $(SOURCES)
 
all : libmgpplib.lib

libmgpplib.lib : $(OBJECTS)
	if EXIST libmgpplib.lib del libmgpplib.lib
	$(AR) /out:libmgpplib.lib $(OBJECTS)

$(OBJECTS): "$(MGPPHOME)\win32cfg.h"

install: 
clean:
	del *$o 
	del libmgpplib.lib
