/**********************************************************************
 *
 * Checking.cpp
 * Copyright (C) 2003  UNESCO
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////
// Checking -- 
//               


#include "stdafx.h"
#include "File.h"
#include "Master.h"
#include "MFFile.h"
#include "Checking.h"

using namespace Checking;
//---------------------------------------------------------------------
// Checking::CheckMfHeader(const char *mfname, SMfHeader *mfh)
//
// Invariant to be respected by the mf header
//---------------------------------------------------------------------
void Checking::CheckMfHeader(const _TCHAR *mfname, SMfHeader &mfh)
{
	mg_s_long size = FileSystem::FileSize(mfname);
	TRACE(_T("\nsize=%ld "), size);
	mg_s_long mfSize = mfh.nxtmfb_ * MFBLKSIZE;
	//ASSERT(size == mfSize);
	ASSERT(mfh.nxtmfp_>0 && mfh.nxtmfp_<=MFBLKSIZE);
	ASSERT(mfh.mftype_ == USERMST);
	ASSERT(mfh.nxtmfn_>0);
	ASSERT(mfh.ctlmfn_ == 0);
	//assert(mfh.reccnt == 0);
	//assert(mfh.mfcxx1 == 0);
	//assert(mfh.mfcxx2 == 0);
	//assert(mfh.mfcxx3 == 0);
}

void Checking::CheckMfRecordHeader(mg_s_long addr)
{

}

using namespace std;
