/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.BitRasterImage;
import com.sun.jimi.core.raster.JimiRasterImageSupport;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;

public class MemoryBitRasterImage
extends JimiRasterImageSupport
implements BitRasterImage {
    protected byte[] imageData;
    protected byte[] pixelBuffer = new byte[1];
    protected byte[] rowBuffer;
    protected byte[] rowUnpackedBuffer;
    protected int rowByteWidth;

    protected void initStorage() throws JimiException {
        this.imageData = new byte[this.rowByteWidth * this.getHeight()];
        this.rowBuffer = new byte[this.rowByteWidth];
        this.rowUnpackedBuffer = new byte[this.rowByteWidth << 3];
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public void setRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        this.setModified();
        this.sendRectangle(n, n2, n3, n4, byArray, n5, n6);
        this.storeRectangle(n, n2, n3, n4, byArray, n5, n6);
    }

    public void sendRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        if (this.hasDirectConsumer()) {
            this.getDirectConsumer().setPixels(n, n2, n3, n4, this.getColorModel(), byArray, n5, n6);
        }
    }

    public void storeRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        int n7 = 0;
        while (n7 < n4) {
            JimiUtil.packOneBitPixels(byArray, n5 + n7 * n6, this.imageData, (n2 + n7) * this.rowByteWidth, n, n3);
            ++n7;
        }
    }

    public void setRow(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.setRectangle(0, n, this.getWidth(), 1, byArray, n2, 0);
    }

    public void setPixel(int n, int n2, byte by) throws ImageAccessException {
        this.setModified();
        this.storePixel(n, n2, by);
        this.sendPixel(n, n2, by);
    }

    protected synchronized void sendPixel(int n, int n2, byte by) {
        if (this.hasDirectConsumer()) {
            MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
            this.pixelBuffer[0] = by;
            multicastImageConsumer.setPixels(n, n2, 1, 1, this.getColorModel(), this.pixelBuffer, 0, 0);
        }
    }

    protected void storePixel(int n, int n2, byte by) throws ImageAccessException {
        int n3;
        byte by2 = (byte)(1 << 7 - n % 8);
        int n4 = n3 = (n >>> 3) + n2 * this.rowByteWidth;
        this.imageData[n4] = (byte)(this.imageData[n4] & ~by2);
        int n5 = n3;
        this.imageData[n5] = (byte)(this.imageData[n5] | by2);
    }

    public void getRectangleRGB(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws ImageAccessException {
        ColorModel colorModel = this.getColorModel();
        int n7 = 0;
        while (n7 < n4) {
            this.getRow(n2 + n7, this.rowUnpackedBuffer, 0);
            int n8 = 0;
            while (n8 < n3) {
                int n9 = n7 * n6 + n8;
                nArray[n9] = colorModel.getRGB(this.rowUnpackedBuffer[n8]);
                ++n8;
            }
            ++n7;
        }
    }

    public void getRowRGB(int n, int[] nArray, int n2) throws ImageAccessException {
        this.getRectangleRGB(0, n, this.getWidth(), 1, nArray, n2, this.getWidth());
    }

    public int getPixelRGB(int n, int n2) throws ImageAccessException {
        return this.getColorModel().getRGB(this.getPixel(n, n2));
    }

    public void getRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        int n7 = 0;
        while (n7 < n4) {
            JimiUtil.expandOneBitPixels(this.imageData, byArray, n3, (n2 + n7) * (this.rowByteWidth << 3) + n, n5 + n7 * n6);
            ++n7;
        }
    }

    public void getRow(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.getRectangle(0, n, this.getWidth(), 1, byArray, n2, 0);
    }

    public byte getPixel(int n, int n2) throws ImageAccessException {
        if ((this.imageData[(n >> 3) + n2 * this.rowByteWidth] & 7 - n % 8) == 0) {
            return 0;
        }
        return 1;
    }

    public void setRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        this.setModified();
        this.sendRectanglePacked(n, n2, n3, n4, byArray, n5, n6);
        this.storeRectanglePacked(n, n2, n3, n4, byArray, n5, n6);
    }

    public void storeRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        int n7 = 0;
        while (n7 < n4) {
            System.arraycopy(byArray, n5 + n7 * n6, this.imageData, (n >> 3) + (n2 + n7) * this.rowByteWidth, n3 >> 3);
            ++n7;
        }
    }

    protected void sendRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        if (this.hasDirectConsumer()) {
            MulticastImageConsumer multicastImageConsumer = this.getDirectConsumer();
            n5 <<= 3;
            int n7 = 0;
            while (n7 < n4) {
                JimiUtil.expandOneBitPixels(byArray, this.rowUnpackedBuffer, n5 + n3, n7 * n3 << 3, n7 * n3);
                ++n7;
            }
            multicastImageConsumer.setPixels(n, n2, n3, n4, this.getColorModel(), this.rowUnpackedBuffer, 0, n3);
        }
    }

    public void setRowPacked(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.setRectanglePacked(0, n, this.getWidth(), 1, byArray, n2, 0);
    }

    public void getRectanglePacked(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        int n7 = 0;
        while (n7 < n4) {
            System.arraycopy(this.imageData, (n >> 3) + (n2 + n7) * this.rowByteWidth, byArray, n5 + n7 * n6, n3 >> 3);
            ++n7;
        }
    }

    public void getRowPacked(int n, byte[] byArray, int n2) throws ImageAccessException {
        this.getRectanglePacked(0, n, this.getWidth(), 1, byArray, n2, 0);
    }

    protected void sendToConsumerFully(ImageConsumer imageConsumer) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = 0;
        while (n3 < n2) {
            JimiUtil.expandOneBitPixels(this.imageData, this.rowUnpackedBuffer, n, (this.rowByteWidth << 3) * n3, 0);
            imageConsumer.setPixels(0, n3, n, 1, this.getColorModel(), this.rowUnpackedBuffer, 0, 0);
            ++n3;
        }
    }

    protected void sendRegionToConsumerFully(ImageConsumer imageConsumer, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        ColorModel colorModel = this.getColorModel();
        int n4 = 0;
        while (n4 < rectangle.height) {
            JimiUtil.expandOneBitPixels(this.imageData, this.rowUnpackedBuffer, rectangle.width, (this.rowByteWidth << 3) * (n4 + n2) + n, 0);
            imageConsumer.setPixels(0, n4, n3, 1, colorModel, this.rowUnpackedBuffer, 0, 0);
            ++n4;
        }
    }

    public byte[] asByteArray() {
        return null;
    }

    public MemoryBitRasterImage(int n, int n2, ColorModel colorModel) {
        super(n, n2, colorModel);
        int n3 = colorModel.getRGB(0);
        int n4 = colorModel.getRGB(1);
        byte[] byArray = new byte[]{(byte)(n3 >> 24 & 0xFF), (byte)(n4 >> 24 & 0xFF)};
        byte[] byArray2 = new byte[]{(byte)(n3 >> 16 & 0xFF), (byte)(n4 >> 16 & 0xFF)};
        byte[] byArray3 = new byte[]{(byte)(n3 >> 8 & 0xFF), (byte)(n4 >> 8 & 0xFF)};
        byte[] byArray4 = new byte[]{(byte)(n3 & 0xFF), (byte)(n4 & 0xFF)};
        IndexColorModel indexColorModel = new IndexColorModel(8, 2, byArray2, byArray3, byArray4, byArray);
        this.setColorModel(indexColorModel);
        this.rowByteWidth = n + 7 >> 3;
        try {
            this.initStorage();
            return;
        }
        catch (JimiException jimiException) {
            this.setError();
            return;
        }
    }
}

