/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.ImageSeriesDecodingController;
import com.sun.jimi.core.ImageSeriesEnumerator;
import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiControl;
import com.sun.jimi.core.JimiDecoder;
import com.sun.jimi.core.JimiDecoderFactory;
import com.sun.jimi.core.JimiDecodingController;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.JimiReader$StreamCloseCommand;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.FreeFormat;
import com.sun.jimi.core.util.GraphicsUtils;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.ProgressListener;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;

public class JimiReader {
    public static final int UNKNOWN = -1;
    protected static final int STREAM_BUFFER_SIZE = 10240;
    protected JimiDecoderFactory decoderFactory;
    protected JimiDecoder decoder;
    protected JimiImageFactory imageFactory;
    protected InputStream input;
    protected JimiRasterImage cacheJimiImage;
    protected ImageProducer cacheImageProducer;
    protected Image cacheImage;
    protected int cacheIndex = -1;
    protected int seriesIndex = 0;
    protected ImageSeriesDecodingController series;
    protected boolean synchronous;
    protected boolean builtinJPEG;
    protected ImageProducer jpegProducer;
    protected URL location;
    protected String filename;
    protected ProgressListener listener;
    protected Runnable cleanupCommand;

    public int getNumberOfImages() {
        return -1;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.listener = progressListener;
        if (this.decoder != null) {
            this.decoder.setProgressListener(progressListener);
        }
    }

    public void setMimeType(String string) throws JimiException {
        JimiDecoderFactory jimiDecoderFactory = JimiControl.getDecoderByType(string);
        if (jimiDecoderFactory == null) {
            throw new JimiException("Cannot find decoder for type: " + string);
        }
        if (this.input != null) {
            JimiReader jimiReader = this;
            jimiReader.initReader(jimiReader.imageFactory, jimiDecoderFactory, this.input);
            return;
        }
        JimiReader jimiReader = this;
        jimiReader.initReader(jimiReader.imageFactory, jimiDecoderFactory);
    }

    protected void initReader(JimiImageFactory jimiImageFactory, JimiDecoderFactory jimiDecoderFactory, InputStream inputStream) {
        if (jimiDecoderFactory instanceof FreeFormat) {
            jimiImageFactory = JimiUtil.stripStamping(jimiImageFactory);
        }
        this.imageFactory = jimiImageFactory;
        this.decoderFactory = jimiDecoderFactory;
        this.decoder = jimiDecoderFactory.createDecoder();
        if (this.listener != null && this.decoder != null) {
            this.decoder.setProgressListener(this.listener);
        }
        this.input = inputStream;
        if (jimiDecoderFactory.getClass().getName().equals("com.sun.jimi.core.decoder.builtin.BuiltinDecoderFactory")) {
            this.builtinJPEG = true;
            return;
        }
        if (this.cleanupCommand != null) {
            this.decoder.addCleanupCommand(this.cleanupCommand);
        }
        this.series = this.decoder.initDecoding(jimiImageFactory, inputStream);
    }

    protected void initReader(JimiImageFactory jimiImageFactory, JimiDecoderFactory jimiDecoderFactory) {
        if (jimiDecoderFactory instanceof FreeFormat) {
            jimiImageFactory = JimiUtil.stripStamping(jimiImageFactory);
        }
        this.initReader(jimiImageFactory);
        this.decoderFactory = jimiDecoderFactory;
        this.decoder = jimiDecoderFactory.createDecoder();
        if (this.listener != null) {
            this.decoder.setProgressListener(this.listener);
        }
        if (jimiDecoderFactory.getClass().getName().equals("com.sun.jimi.core.decoder.builtin.BuiltinDecoderFactory")) {
            this.builtinJPEG = true;
            return;
        }
        if (this.cleanupCommand != null) {
            this.decoder.addCleanupCommand(this.cleanupCommand);
        }
    }

    protected void initReader(JimiImageFactory jimiImageFactory) {
        this.imageFactory = jimiImageFactory;
    }

    public void setSource(InputStream inputStream) throws JimiException {
        JimiReader jimiReader = this;
        jimiReader.initReader(jimiReader.imageFactory, this.decoderFactory, inputStream);
    }

    public void setSource(String string) throws JimiException {
        InputStream inputStream;
        try {
            inputStream = new FileInputStream(string);
            this.filename = string;
            inputStream = new BufferedInputStream(inputStream, 10240);
        }
        catch (Exception exception) {
            throw new JimiException("Unable to open source file.");
        }
        JimiReader jimiReader = this;
        jimiReader.initReader(jimiReader.imageFactory, this.decoderFactory, inputStream);
    }

    public void setSource(URL uRL) throws JimiException {
        try {
            InputStream inputStream = uRL.openStream();
            this.location = uRL;
            new BufferedInputStream(inputStream, 10240);
            return;
        }
        catch (IOException iOException) {
            throw new JimiException("Unable to open source URL.");
        }
    }

    public void setBlocking(boolean bl) {
        this.synchronous = bl;
    }

    public Dimension getSize() throws JimiException {
        JimiRasterImage jimiRasterImage = this.getRasterImage();
        jimiRasterImage.waitInfoAvailable();
        return new Dimension(jimiRasterImage.getWidth(), jimiRasterImage.getHeight());
    }

    public JimiRasterImage getRasterImage() throws JimiException {
        if (this.cacheIndex == 0) {
            if (this.cacheJimiImage != null) {
                return this.cacheJimiImage;
            }
            return Jimi.createRasterImage(this.cacheImageProducer);
        }
        if (this.seriesIndex == 0) {
            JimiRasterImage jimiRasterImage = this.getNextJimiImage();
            if (this.decoder != null) {
                this.decoder.setFinished();
            }
            return jimiRasterImage;
        }
        throw new JimiException();
    }

    public ImageProducer getImageProducer() {
        try {
            if (this.cacheIndex == 0) {
                return this.cacheImageProducer;
            }
            if (this.seriesIndex == 0) {
                ImageProducer imageProducer = this.getNextImageProducer();
                if (this.decoder != null) {
                    this.decoder.setFinished();
                }
                return imageProducer;
            }
        }
        catch (JimiException jimiException) {}
        return JimiUtil.getErrorImageProducer();
    }

    public Image getImage() {
        if (this.cacheIndex == 0) {
            if (this.cacheImage != null) {
                return this.cacheImage;
            }
            Image image = Toolkit.getDefaultToolkit().createImage(this.cacheImageProducer);
            GraphicsUtils.waitForImage(image);
            this.cacheImage = image;
            return image;
        }
        try {
            Image image = this.getNextImage();
            if (this.decoder != null) {
                this.decoder.setFinished();
            }
            return image;
        }
        catch (Exception exception) {
            return JimiUtil.getErrorImage();
        }
    }

    public Enumeration getRasterImageEnumeration() {
        return new ImageSeriesEnumerator(this, 1);
    }

    public Enumeration getImageEnumeration() {
        return new ImageSeriesEnumerator(this, 0);
    }

    public Enumeration getImageProducerEnumeration() {
        return new ImageSeriesEnumerator(this, 2);
    }

    public void skipNextImage() throws JimiException {
        if (!this.series.hasMoreImages()) {
            this.series.skipNextImage();
            ++this.seriesIndex;
            return;
        }
        throw new JimiException("Attemping to move beyond last image.");
    }

    /*
     * Unable to fully structure code
     */
    public ImageProducer getImageProducer(int var1_1) throws JimiException {
        if (var1_1 >= this.seriesIndex) ** GOTO lbl4
        throw new JimiException("Unable to access image number " + var1_1);
lbl-1000:
        // 1 sources

        {
            this.skipNextImage();
lbl4:
            // 2 sources

            ** while (this.seriesIndex < var1_1)
        }
lbl5:
        // 1 sources

        return this.getNextImageProducer();
    }

    public Image getImage(int n) throws JimiException {
        if (n == this.cacheIndex && this.cacheImage != null) {
            return this.cacheImage;
        }
        ImageProducer imageProducer = this.getImageProducer(n);
        Image image = Toolkit.getDefaultToolkit().createImage(imageProducer);
        if (this.synchronous) {
            GraphicsUtils.waitForImage(image);
        }
        return image;
    }

    public void close() {
        if (this.decoder != null) {
            this.decoder.setFinished();
        }
    }

    protected JimiRasterImage getNextJimiImage() throws JimiException {
        return this.getNextJimiImage(true);
    }

    protected JimiRasterImage getNextJimiImage(boolean bl) throws JimiException {
        JimiRasterImage jimiRasterImage;
        if (this.builtinJPEG) {
            if (this.cacheIndex == 0) {
                return this.cacheJimiImage;
            }
            if (this.seriesIndex == 0) {
                Image image;
                this.cacheImage = image = this.getBuiltinJPEG();
                this.cacheImageProducer = null;
                this.cacheJimiImage = null;
                this.cacheIndex = 0;
                ++this.seriesIndex;
                return Jimi.createRasterImage(image.getSource());
            }
            throw new JimiException();
        }
        JimiDecodingController jimiDecodingController = this.series.getNextController();
        JimiImage jimiImage = jimiDecodingController.getJimiImage();
        if (bl && this.synchronous) {
            jimiDecodingController.requestDecoding();
            jimiImage.waitFinished();
        }
        if ((jimiRasterImage = JimiUtil.asJimiRasterImage(jimiImage)) == null) {
            throw new JimiException();
        }
        this.cacheJimiImage = jimiRasterImage;
        this.cacheImageProducer = jimiRasterImage.getImageProducer();
        this.cacheImage = null;
        this.cacheIndex = this.seriesIndex++;
        return jimiRasterImage;
    }

    protected ImageProducer getNextImageProducer() throws JimiException {
        JimiRasterImage jimiRasterImage;
        if (this.builtinJPEG) {
            if (this.cacheIndex == 0) {
                return this.cacheImageProducer;
            }
            if (this.seriesIndex == 0) {
                Image image = this.getBuiltinJPEG();
                this.cacheIndex = 0;
                this.cacheImage = image;
                this.cacheImageProducer = image.getSource();
                ++this.seriesIndex;
                return image.getSource();
            }
            throw new JimiException();
        }
        this.cacheJimiImage = jimiRasterImage = this.getNextJimiImage(false);
        this.cacheImageProducer = jimiRasterImage.getImageProducer();
        this.cacheIndex = this.seriesIndex;
        return jimiRasterImage.getImageProducer();
    }

    protected Image getNextImage() throws JimiException {
        Image image;
        if (this.builtinJPEG) {
            if (this.cacheIndex == 0) {
                if (this.cacheImage != null) {
                    return this.cacheImage;
                }
                Image image2 = Toolkit.getDefaultToolkit().createImage(this.cacheImageProducer);
                GraphicsUtils.waitForImage(image2);
                return image2;
            }
            if (this.seriesIndex == 0) {
                Image image3 = this.getBuiltinJPEG();
                this.cacheIndex = 0;
                this.cacheImage = image3;
                this.cacheImageProducer = image3.getSource();
                ++this.seriesIndex;
                GraphicsUtils.waitForImage(image3);
                return image3;
            }
            throw new JimiException();
        }
        ImageProducer imageProducer = this.getNextImageProducer();
        this.cacheImage = image = Toolkit.getDefaultToolkit().createImage(imageProducer);
        GraphicsUtils.waitForImage(image);
        return image;
    }

    protected boolean hasMoreElements() {
        if (this.builtinJPEG) {
            return this.seriesIndex == 0;
        }
        return this.series.hasMoreImages();
    }

    protected JimiDecodingController getNextController() {
        return this.series.getNextController();
    }

    protected Image getBuiltinImage() {
        JimiRasterImage jimiRasterImage;
        try {
            jimiRasterImage = this.getBuiltinJimiImage();
        }
        catch (JimiException jimiException) {
            return JimiUtil.getErrorImage();
        }
        this.cacheJimiImage = jimiRasterImage;
        this.cacheImageProducer = jimiRasterImage.getImageProducer();
        return Toolkit.getDefaultToolkit().createImage(jimiRasterImage.getImageProducer());
    }

    protected JimiRasterImage getBuiltinJimiImage() throws JimiException {
        return Jimi.createRasterImage(this.getBuiltinJPEG().getSource(), this.imageFactory);
    }

    protected Image getBuiltinJPEG() {
        Image image;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (this.location != null) {
            image = toolkit.getImage(this.location);
        } else if (this.filename != null) {
            image = toolkit.getImage(this.filename);
        } else {
            try {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[10240];
                while ((n = this.input.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                this.input.close();
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                image = toolkit.createImage(byArray2);
            }
            catch (IOException iOException) {
                image = JimiUtil.getErrorImage();
            }
        }
        return image;
    }

    protected JimiReader(JimiImageFactory jimiImageFactory, JimiDecoderFactory jimiDecoderFactory, InputStream inputStream) throws JimiException {
        this.initReader(jimiImageFactory, jimiDecoderFactory, inputStream);
    }

    protected JimiReader(JimiImageFactory jimiImageFactory, InputStream inputStream, String string) throws JimiException {
        JimiDecoderFactory jimiDecoderFactory = JimiControl.getDecoderByType(string);
        if (jimiDecoderFactory == null) {
            throw new JimiException("No decoder available for " + string);
        }
        this.initReader(jimiImageFactory, jimiDecoderFactory, inputStream);
    }

    protected JimiReader(JimiImageFactory jimiImageFactory, String string, String string2) throws JimiException {
        JimiReader jimiReader = this;
        if (jimiReader == null) {
            throw null;
        }
        this.cleanupCommand = new JimiReader$StreamCloseCommand(jimiReader);
        JimiDecoderFactory jimiDecoderFactory = JimiControl.getDecoderByType(string2);
        if (jimiDecoderFactory == null) {
            throw new JimiException("No decoder available for " + string2);
        }
        try {
            InputStream inputStream = new FileInputStream(string);
            inputStream = new BufferedInputStream(inputStream, 10240);
            JimiReader jimiReader2 = this;
            jimiReader2.initReader(jimiReader2.imageFactory, jimiDecoderFactory, inputStream);
            return;
        }
        catch (IOException iOException) {
            throw new JimiException(iOException.getMessage());
        }
    }

    protected JimiReader(JimiImageFactory jimiImageFactory, URL uRL) throws JimiException {
        JimiReader jimiReader = this;
        if (jimiReader == null) {
            throw null;
        }
        this.cleanupCommand = new JimiReader$StreamCloseCommand(jimiReader);
        this.location = uRL;
        try {
            JimiDecoderFactory jimiDecoderFactory = JimiControl.getDecoderByFileExtension(uRL.toString());
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRL.openStream();
            if (jimiDecoderFactory == null) {
                jimiDecoderFactory = JimiControl.getDecoderByType(uRLConnection.getContentType());
            }
            if (jimiDecoderFactory == null) {
                PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 128);
                jimiDecoderFactory = JimiControl.getDecoderForInputStream(pushbackInputStream);
                inputStream = pushbackInputStream;
            }
            if (jimiDecoderFactory == null) {
                throw new JimiException("No decoder available for location: " + uRL);
            }
            inputStream = new BufferedInputStream(inputStream, 10240);
            this.initReader(jimiImageFactory, jimiDecoderFactory, inputStream);
            return;
        }
        catch (IOException iOException) {
            throw new JimiException(iOException.toString());
        }
    }

    protected JimiReader(JimiImageFactory jimiImageFactory, URL uRL, String string) throws JimiException {
        JimiReader jimiReader = this;
        if (jimiReader == null) {
            throw null;
        }
        this.cleanupCommand = new JimiReader$StreamCloseCommand(jimiReader);
        this.location = uRL;
        try {
            JimiDecoderFactory jimiDecoderFactory = JimiControl.getDecoderByType(string);
            if (jimiDecoderFactory == null) {
                throw new JimiException("No decoder available for file: " + uRL);
            }
            InputStream inputStream = uRL.openStream();
            inputStream = new BufferedInputStream(inputStream, 10240);
            this.initReader(jimiImageFactory, jimiDecoderFactory, inputStream);
            return;
        }
        catch (IOException iOException) {
            throw new JimiException(iOException.toString());
        }
    }

    protected JimiReader(JimiImageFactory jimiImageFactory, String string) throws JimiException {
        JimiReader jimiReader = this;
        if (jimiReader == null) {
            throw null;
        }
        this.cleanupCommand = new JimiReader$StreamCloseCommand(jimiReader);
        this.filename = string;
        try {
            JimiDecoderFactory jimiDecoderFactory = JimiControl.getDecoderByFileExtension(string);
            if (jimiDecoderFactory == null) {
                throw new JimiException("No decoder available for file: " + string);
            }
            InputStream inputStream = new FileInputStream(string);
            inputStream = new BufferedInputStream(inputStream, 10240);
            this.initReader(jimiImageFactory, jimiDecoderFactory, inputStream);
            return;
        }
        catch (IOException iOException) {
            throw new JimiException(iOException.toString());
        }
    }

    protected JimiReader(JimiImageFactory jimiImageFactory, InputStream inputStream) throws JimiException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 128);
        JimiDecoderFactory jimiDecoderFactory = JimiControl.getDecoderForInputStream(pushbackInputStream);
        if (jimiDecoderFactory == null) {
            throw new JimiException("Cannot find decoder for stream");
        }
        this.initReader(jimiImageFactory, jimiDecoderFactory, pushbackInputStream);
    }

    protected JimiReader(JimiImageFactory jimiImageFactory) throws JimiException {
        this.initReader(jimiImageFactory);
    }
}

