/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.util;

import org.apache.log4j.Logger;
import org.greenstone.util.Misc;
import org.greenstone.util.SafeProcess;

public class BrowserLauncher
extends Thread {
    private String url = "about:blank";
    static Logger logger = Logger.getLogger((String)BrowserLauncher.class.getName());
    private String[] default_browsers = new String[]{"firefox", "mozilla"};
    private String command = "";
    private int state = -1;
    public static final int LAUNCHSUCCESS = 0;
    public static final int LAUNCHFAILED = 1;
    private String browserPath = "";

    public BrowserLauncher(String browserPath, String url) {
        this.url = url;
        this.browserPath = browserPath;
        if (this.browserPath.equals("")) {
            this.setBrowserCommand();
        } else {
            this.command = this.browserPath + " " + this.url;
        }
    }

    public BrowserLauncher() {
    }

    protected void setBrowserCommand() {
        if (Misc.isWindows()) {
            this.command = Misc.isWindows9x() ? "command.com /c start %1" : "cmd.exe /c start \"\" %1";
        } else if (Misc.isMac()) {
            this.command = "open %1";
        } else {
            for (int i = 0; i < this.default_browsers.length; ++i) {
                if (!SafeProcess.isAvailable(this.default_browsers[i])) continue;
                this.command = this.default_browsers[i] + " %1";
                break;
            }
        }
        this.command = this.command.replaceAll("%1", this.url);
    }

    public int getBrowserState() {
        return this.state;
    }

    @Override
    public void run() {
        if (this.command.equals("")) {
            this.state = 1;
            logger.error((Object)"launching command is empty: no browser found.");
            return;
        }
        try {
            int exitCode = 0;
            String prog_name = this.command.substring(0, this.command.indexOf(" "));
            String lower_name = prog_name.toLowerCase();
            if (lower_name.indexOf("mozilla") != -1 || lower_name.indexOf("firefox") != -1) {
                logger.info((Object)"found mozilla or firefox, trying to remotely launch it");
                String new_command = prog_name + " -raise -remote openURL(" + this.url + ",new-tab)";
                if (lower_name.indexOf("firefox") != -1) {
                    new_command = prog_name + " --new-tab --url " + this.url;
                }
                logger.info((Object)new_command);
                Runtime rt = Runtime.getRuntime();
                this.state = 0;
                SafeProcess process = new SafeProcess(new_command);
                exitCode = process.runProcess();
                process = null;
                logger.info((Object)("ExitCode:" + exitCode));
                if (exitCode != 0) {
                    logger.info((Object)"couldn't do remote, trying original command");
                    logger.info((Object)this.command);
                    this.state = 0;
                    process = new SafeProcess(this.command);
                    exitCode = process.runProcess();
                    process = null;
                }
            } else {
                logger.info((Object)this.command);
                Runtime rt = Runtime.getRuntime();
                this.state = 0;
                SafeProcess process = new SafeProcess(this.command);
                exitCode = process.runProcess();
            }
            logger.info((Object)("ExitCode:" + exitCode));
            if (exitCode != 0) {
                this.state = 1;
                logger.error((Object)"Failed to launch web browser when running command:");
                logger.error((Object)("\t" + this.command));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.state = 1;
        }
    }
}

